/* pdp1_defs.h: 18b PDP simulator definitions

   Copyright (c) 1996-1997,
    Robert M Supnik, Digital Equipment Corporation
   All rights reserved

   The PDP-1 was Digital's first computer.  The system design evolved during
   its life, and as a result, specifications are sketchy or contradictory.
   This simulator is based on the 1963 maintenance manual.

   This simulator implements the following options:

   Automatic multiply/divide	Type 10
   Memory extension control	Type 15
   Line printer control		Type 62
*/

#include "sim_defs.h"

/* Memory and peripheral configuration */

#define ADDRSIZE	16				/* address bits */
#define MAXMEMSIZE	(1u << ADDRSIZE)		/* max mem size */
#define ADDRMASK	(MAXMEMSIZE - 1)		/* address mask */
#define DAMASK		007777				/* direct addr */
#define EPCMASK		(ADDRMASK & ~DAMASK)		/* extended addr */
#define IA		010000				/* indirect flag */
#define IO_WAIT		010000				/* I/O sync wait */
#define IO_CPLS		004000				/* cmopletion pulse */
#define GEN_CPLS(x)	(((x) ^ ((x) << 1)) & IO_WAIT)	/* completion pulse? */
#define MEMSIZE		(cpu_unit.capac)		/* actual memory size */
#define MEM_ADDR_OK(x)	(x < MEMSIZE)

/* Simulator stop codes */

#define STOP_RSRV	1				/* must be 1 */
#define STOP_HALT	2				/* HALT */
#define STOP_IBKPT	3				/* breakpoint */
#define STOP_XCT	4				/* nested XCT's */
#define STOP_IND	5				/* nested indirects */
#define STOP_WAIT	6				/* wait state */

/* IOT subroutine return codes */

#define IOT_V_REASON	18				/* reason */
#define IOT_REASON	(1 << IOT_V_REASON)
#define IORETURN(f,v)	((f)? (v): SCPE_OK)		/* stop on error */

/* I/O status flags */

#define IOS_V_LPN	17				/* light pen */
#define IOS_V_PTR	16				/* paper tape reader */
#define IOS_V_TTO	15				/* typewriter out */
#define IOS_V_TTI	14				/* typewriter in */
#define IOS_V_PTP	13				/* paper tape punch */
#define IOS_V_DRM	12				/* drum */
#define IOS_V_SQB	11				/* sequence break */
#define IOS_V_PNT	2				/* print done */
#define IOS_V_SPC	1				/* space done */

#define IOS_LPN		(1 << IOS_V_LPN)
#define IOS_PTR		(1 << IOS_V_PTR)
#define IOS_TTO		(1 << IOS_V_TTO)
#define IOS_TTI		(1 << IOS_V_TTI)
#define IOS_PTP		(1 << IOS_V_PTP)
#define IOS_DRM		(1 << IOS_V_DRM)
#define IOS_SQB		(1 << IOS_V_SQB)
#define IOS_PNT		(1 << IOS_V_PNT)
#define IOS_SPC		(1 << IOS_V_SPC)

/* Sequence break flags */

#define SB_V_IP		0				/* in progress */
#define SB_V_RQ		1				/* request */
#define SB_V_ON		2				/* enabled */

#define SB_IP		(1 << SB_V_IP)
#define SB_RQ		(1 << SB_V_RQ)
#define SB_ON		(1 << SB_V_ON)
