/*

Output consists of 10^-n in binary, for n from 1 through NDIG, with the binary
point assumed just to the left of the first output bit.

NDIG must match as11's MAXDDIG #define

NBITS must match as11's WORKBITS #define

*/

#define NDIG   (26) /* size of digit axis of generated table */
#define NBITS  (80) /* size of bit axis of generated table */
#define NB    (100) /* numbe of bits to compute with */

static char bits[NB];

void main()
{
 int b;
 int d;
 int n;

 for (b=0;b<NB;b++) bits[b] = 0;
 bits[0] = 1;
 for (d=1;d<=NDIG;d++)
  { n = 0;
    for (b=0;b<NB;b++)
     { n = n + n + bits[b];
       if (n >= 10)
	{ bits[b] = 1;
	  n -= 10;
	}
       else
	{ bits[b] = 0;
	}
     }
    printf("{ "/*}*/);
    for (b=1;b<=NBITS;b++)
     { printf("%d,",bits[b]);
     }
    printf(/*{*/" }, /* %d */\n",d);
  }
 exit(0);
}
