#include "defines.h"

char realfilename[500];		/* These 2 are used on filename translation */
char *rfn;			/* to the APOUT_ROOT */

#ifdef DEBUG
				/* Debugging flags */
int inst_debug= 0,		/* Print a line before each instruction */
    trap_debug= 0,		/* Print details of each trap */
    jsr_debug=	0,		/* Print out each jsr */
    fp_debug=	0;		/* Print out each floating-point instruction */
FILE *dbg_file = NULL;		/* Debugging output file */
char *progname = NULL;		/* The program's name - used in debugging */
#endif

int
main(int argc, char **argv)
{
    int i;

    if (argc < 2) {
	fprintf(stderr, "Usage: apout");
#ifdef DEBUG
	fprintf(stderr, " [-inst] [-trap] [-jsr] [-fp]");
#endif
	fprintf(stderr, " pdp11_binary\n");
	exit(1);
    }

#ifdef DEBUG
    while (1) {
      if (!strcmp(argv[1], "-inst"))
		{ inst_debug = 1; argc--; argv++; continue; }
      if (!strcmp(argv[1], "-trap"))
		{ trap_debug = 1; argc--; argv++; continue; }
      if (!strcmp(argv[1], "-jsr"))
		{ jsr_debug = 1; argc--; argv++; continue; }
      if (!strcmp(argv[1], "-fp"))
		{ fp_debug = 1; argc--; argv++; continue; }
      break;
    }

    if (inst_debug|trap_debug|jsr_debug|fp_debug)
				dbg_file = fopen("apout.dbg", "w");
#endif

				/* Prepare arg list for emulated environment */
    argc--; argv++;
    Argc= argc; Envp[0]=NULL;
    for (i=0; i<argc; i++) Argv[i]= argv[i];

                                /* Set the translation to a fictitious */
                                /* root filesystem */
    if ((rfn = getenv("APOUT_ROOT"))) {  
        strcpy(realfilename, rfn);      
        rfn = realfilename;
        rfn += strlen(realfilename);    
    } else {
        fprintf(stderr,                 
                "APOUT_ROOT env variable not set before running apout\n");
        exit(1);
    }   

				/* Try to load the binary as an a.out */
    if (load_a_out(argv[0],0) == -1) {
	fprintf(stderr, "Apout - couldn't load %s\n", argv[0]);
	exit(1);
    }

				/* Other emulated systems (RT-11) can go here */

    run();			/* Now run the binary */
    exit(0);
}

/* Translate from a filename to one which is 
 * possibly rooted in $APOUT_ROOT
 */
char * xlate_filename(char *name)
{

    if (name == NULL) return (NULL);
    if (name[0] == '\0') return(strdup("."));
    if (name[0] != '/') return (name);
    strcpy(rfn, name);
    return (strdup(realfilename));
}

