#include "defines.h"

/* Floating point status register */

#define FPS_ER		0100000	/* error */
#define FPS_ID		0040000	/* interrupt disable */
#define FPS_IUV		0004000	/* int on undef var */
#define FPS_IU		0002000	/* int on underflow */
#define FPS_IV		0001000	/* int on overflow */
#define FPS_IC		0000400	/* int on conv error */
#define FPS_D		0000200	/* single/double */
#define FPS_L		0000100	/* word/long */
#define FPS_T		0000040	/* round/truncate */
#define FPS_N		(1 << CC_N)
#define FPS_Z		(1 << CC_Z)
#define FPS_V		(1 << CC_V)
#define FPS_C		(1 << CC_C)
#define FPS_CC		(FPS_N + FPS_Z + FPS_V + FPS_C)
#define FPS_RW		(FPS_ER + FPS_ID + FPS_IUV + FPS_IU + FPS_IV + \
			FPS_IC + FPS_D + FPS_L + FPS_T + FPS_CC)


int FPS = 0;

void
fpset()
{
    switch (ir) {
        case 0170000:           /* CFCC */
	/* Until I do the FP properly, set status word to 0 */
	CLR_CC_ALL();
        return;
    case 0170001:               /* SETF */
        FPS = FPS & ~FPS_D;
        return;
    case 0170002:               /* SETI */
        FPS = FPS & ~FPS_L;
        return;
    case 0170011:               /* SETD */
        FPS = FPS | FPS_D;
        return;
    case 0170012:               /* SETL */
        FPS = FPS | FPS_L;
        return;
    default:
        not_impl();
    }
}
