.hpf hyphen.local
.P1
.de PT
.tl 'TTY01 - GENERAL TYPEWRITER SUBROUTINES'\*[CH]'PD-1C303-01'
.tl 'File: tty.c''Section 13'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B canon
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
canon(atp)
.br
struct tty *atp;
.sp 1n
.
.LP
.I RETURN
.
.LP
An indication of whether any characters have been transferred from an
teletype input queue to a teletype canonical queue is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
This is the Canonicalizer. It translates a line of input into a standard
Form (called Canonical Form) and performs erase-kill processing,
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Basically, a teletype may select one of two processing modes; line at a
time processing or character at a time processing (raw character I/O). The
difference between the two as far as the response seen by a user is that
for line at a time processing, a read of a teletype does not return until a
whole line of input is accumulated while for character at a time
processing, a read returns one character, regardless of whether a whole
line has been received or not. Erase-kill processing is performed for line
at a time processing but not for character at a time processing, and
special characters, such as
.I quit ,
.I interrupt
and
.I EOT
lose their meaning in raw mode
.
.LP
The input queue (or raw queue "t_rawq") contains delimiters to mark off the
amount of input that is to be examined by tty.c/canon. The delimiter used
is 0377 (octal). For character at a time processing, the delimiter is
placed after each character, while for line at a time processing the
delimiter is placed after each line feed or carriage return (by
tty.c/ttyinput). Tty.c/canon is called by tty.c/ttread to read a teletype
and put one delimited string of input in Canonical Form so that it can be
transferred to the user process. Processing of a delimited string is
handled as follows:
.IP 1. 4
A check is made to see if any delimited string has bee'h accumulated from
the teletype. If none has been accumulated, tty.c/canon roadblocks the
process that requested the Canonicalization of input. The process is
roadblocked at priority TTIPRI and remains roadblocked until a delimited
input string has been accumulated. The tty.c/ttyinput function awakens a
process when a delimited string has been received. Before roadblocking the
process, a check is made to see if carrier has been dropped on that
teletype by checking the "t_state" flag in the associated teletype
structure. The receive interrupt handler for the individual line interface
drivers can detect whether carrier has been dropped and will set an
indicator (CARRIER) in the teletype structure(in "t_state"). To prevent the
status of the teletype from changing while the check is made, interrupts
from character devices are locked out by setting the processors priority to
5.
.IP 2. 3
Characters are transferred one at a time to the Canonical Buffer "canonb"
until one of the following occurs,
.RS
.LP
a. There are no more characters on the input queue("t_rawq").
.LP
b. The first delimiter(0377) is reached.
.LP
c. The size of the Canonical Buffer has been exceeded (currently 256
characters).
.RE
.IP 3. 3
As the characters are transferred to the Canonical Buffer, they are put
into Canonical Form and erase-kill processing is performed. The following
transformations are made:
.RS
.LP
a. If a teletype is set for upper case only mapping, then the following
transformations are made
.LP
Input				Canonical Form
.br
(2 Characters)		(1 character)
.br
\\'				'
.br
\\!				|
.br
\\^				^
.br
\\\\				\\
.br
\\(				{
.br
\\)				}
.br
\\lower case			upper case
.br
alphabetic			alphabetic
.LP
b. The character '#' erases the previous character from the input stream.
No character before the first character on a line may be deleted.
.LP
c. The character '@' kills an entire line of input. All of the input up to
and including the @ is deleted from the input string. No lines before the
line in which the '@' appears can be deleted.
.RE
.IP 4. 3
As characters are placed in the Canonical Buffer ("canonb"), they are
deleted from the input queue ("t_rawq"). Once a string has been placed in
Canonical Form and erase-kill processing performed, the canonicalized
string is transferred to the canonical queue ("t_canq") associated with the
teletype and an indication that processing has been completed is returned
to the calling routine (tty.c/ttread).
.sp 1m
.ne 10
.
.LP
.LG
.B cinit
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
cinit()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The character buffers ("dist") are initialized.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The character buffering scheme used in the UNIX Operating System utilizes a
pool of six byte buffers that are available to all of the character devices
on the system. The buffers are organized as a linked list ("clist") and
each six byte buffer contains one extra word which is used as a pointer for
queuing a buffer on a device. One hundred buffers are normally allocated
for character storage. A globally known pointer ("cfreelist") contains a
pointer to the first free buffer. Each free buffer contains a pointer to
the next buffer and the last on the "cfreelist" queue contains a zero in
the pointer entry.
.
.LP
After UNIX is booted into memory the "dist" is initialized as part of the
startup procedure. (Main.c/main calls it.)
.
.LP
In order to simplify the work that must be done by the assembly language
functions mch.s/putc and mch.s/getc in allocating and deallocating
character buffers, a trick is used in initializing the storage that is used
for the "clist" buffers. The method forces the allocation of each character
buffer to occur on an eight byte memory address even though the buffer
definition may not occur on an eight byte boundary. This means that even
though the overall storage called for is defined as one hundred character
buffers, only ninety-nine may be present because of the boundary
adjustment.
.
.LP
Another function performed by tty.c/cinit is to determine how many
character devices there are on the system so that higher level functions
may check major device numbers to insure that they are within range when
accessing the Character Device Switch Table. The global variable "nchrdev"
is set to the number of character devices (i.e., effectively the maximum
value that the major device number may be for a character device).
.sp 1m
.ne 10
.
.LP
.LG
.B flushtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
flushtty(atp)
.br
struct tty *atp;
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The input queue, canonical queue and output queue associated with a
particular character device is emptied and the buffer storage returned to
the freelist.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
There are a number of reasons why the queues associated with a character
idevice should be flushed out. For character devices which are connected to
a computer over common carrier lines, the possibility exists that the
connection may be broken at any time so that outputting characteri to that
teletype is impossible. Characters accumulated in the input ("t_rawq"),
canonical ("t_canq") and output ("t_outq") queues would then be a stranded.
They would be queued on a character device which would no longer be able to
accept output or stimulate input processing and thus empty their queues.
The tty.c/flushtty ftinction allows the interrupt handlers associated with
each line interface driver to clean out the queues if they detect that the
connection has been broken (carrier dropped).
.
.LP
Flushing everything in the queues associated with one teletype is also done
when some process closes a teletype. This must be done so that if input is
accumulated before the close is issued, the characters in the input queue
will not be stranded. A teletype's queues are also flushed when either of
the special characters quit (delete) or interrupt (control FS) are received
from a teletype. These characters have a special meaning to the system when
the teletype is set up for line at a time processing. They indicate to the
system that processes which are controlled by the teletype issuing the quit
or interrupt should be terminated (unless they have made other arrangement
via the signal system call). In this case it is desirable to flush the
output to the controlling teletype as well as input from the teletype so
that output from the terminated program is not printed and any commands
that have not yet been acted upon can be dropped.
.
.LP
Flushing out of the three queues is a delicate operation. Both the
canonical ("t_canq") and output queues ("t_outq") may be flushed without
any precautions, however, all processes waiting for input from the teletype
or waiting to do output to the teletype must be awakened to insure that
there will be no processes hung in the system waiting for I/O that can
never occur. In order to flush the input queue, interrupts from character
teletypes must be locked out so that a race between flushing and
accumulating characters does not occur. Once the input queue is flushed,
the delimiter count ("t_delct") is zeroed to indicate that there are no
lines of input in the raw queue.
.sp 1m
.ne 10
.
.LP
.LG
.B gtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
gtty()
.sp 1n
.
.LP
.I RETURNS
.
.LP
The tty.c/gtty routine does not explicitly return a value however, a three
word array containing the speeds and mode of a teletype is returned as a
result of calling it.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Implements the gtty system call. Obtains the modes and line speed of a
teletype.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function performs the inverse operation of the tty.c/stty function,
that is, it returns to a process the line speed and modes for a given
character device. The three word array that is returned to the process
making the gtty system call is as described under tty.c/stty. Both
tty.c/gtty and tty.c/stty use the tty.c/sgtty function as a common
subroutine to interface to the sgtty function associated with a character
device.
.sp 1m
.ne 10
.
.LP
.LG
.B sgtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sgtty(vector)
.br
struct {
.br
    int v[3];
.br
} *vector;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No values are returned
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
interfaces tty.c/stty and tty.c/gtty to the appropriate character device
sgtty function (dh.c/dhsgtty, dc.c/dcsgtty, etc.).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Since the functions of the stty and gtty system calls are similar, a common
subroutine is used to interface them to the character device sgtty
functions (dh.c/dhsgtty, dc.c/dcsgtty, etc.). The argument "vector" is
either the address of a three word array within the system in the case of
tty.c/gtty (so that the device characteristics may be returned in the
array) or in the case of tty.c/stty, "vector" is zero. The pointer "vector"
is passed to the character device sgtty function and is used to determine
whether the existing characteristics are to be returned or whether new
characteristics are to be set up.
.
.LP
As part of the stty or gtty system call, the file descriptor and hence the
device number for the character device is passed. The calls have the
following form,
.
.LP
    stty(fildes, arg)
    int fildes;
    struct{
        char ispeed, ospeed;
        int unussd;
        int mode;
    } *arg;
.
.LP
and
.
.LP
    gtty(fildes, arg)
.
.LP
The file descriptor is passed in register R0 when the system call is made
and the tty.c/sgtty function must obtain it from the stack frame so that it
can be used to find the major and minor device number of the device. The
function fio.c/getf is used to get the i-node associated with this file
descriptor. In order to protect the devices on the system or the system
itself from a bad file descriptor passed in the system call, tty.c/sgtty
.bp
.1C
.CD
.I
(Page missing from the original material)
.DE
