.hpf hyphen.local
.P1
.de PT
.tl 'MEM01 - CORE MEMORY'\*[CH]'PD-1C303-01'
.tl 'File: mem.c''Section 3'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B mmread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mmread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read routine for the memory device driver.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because of the hardware enforced segmentation of physical memory into
virtual address spaces, it is not possible for a user process to directly
reference any memory locations outside its own address space. The memory
device driver mem.c, which consists of mmread and rnmwrite, provides the
capability to make such references. In particular, once entries for mmread
and mmwrite are placed in the configuration table conf.c (in the cdevswn
table, since these two routines emulate raw mode device driver routines)
and the appropriate special filei have been created, the user is free to
treat physical memory as if it were a regular file (read, write, seek,
open, close). Of course, the usual restrictions regarding file access
permissions (for the memory special files) still apply. The minor device
numbers recognized by this memory device driver are as follows.
.IP 0 4
All addresses (i.e., file offsets) are interpreted as physical memory
addresses.
.IP 1 4
All addresses (i.e., file offsets) are interpreted as kernel space
addresses.
.IP 2 4
All read requests result in a no bytes read condition; this emulates a zero
length file. Although all write requests appear to complete, no writing is
ever done; this is the personification of the "bit bucket".
.
.LP
On any request to read minor device two (low byte of "dev"), mmread does an
immediate return, thereby indicating to the I/O subsystem an unfulfilled
read request (end-of-file).
.
.LP
For minor devices zero and one it is first necessary to compute the memory
segment number (i.e., 64 byte boundary) of the segment containing the
physical or kernel address, respectively, to be read. When this value has
been placed into user space memory management register zero, a character
(byte) may be read (see mch.s/fubyte). After restoring the user space
memory management register to its original contents, the character is
passed to the user's I/O buffer. This algorithm continues until either
there is an error or the byte count of the read request is satisfied.
.sp 1m
.ne 10
.
.LP
.LG
.B mmwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mmwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write routine for the memory device driver..
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
See mem.c/mmread for an overview of the memory device driver, of which the
mmwrite routine is the write portion.
.
.LP
For all write requests to minor device two (low byte of "dev"), the user's
I/O request parameters (u_count, u_base, and u_offset) are modified to
reflect the completion of a write request, but no data is ever actually
written (i.e., the "bit bucket").
.
.LP
For minor devices zero and one, a character is retrieved from the user's
I/O buffer. The memory segment number (i.e., 64 byte boundary) of the
segment containing the physical or kernel address, respectively, to be
written is computed. After this value is placed in user space memory
managempnt register zero, the character may be written (see mch.s/subyte)
to the desired location in memory. The user's memory management register is
then restored to its original contents. This algorithm continues until
either there is an error or the byte count of the write request is
satisfied.
