.hpf hyphen.local
.P1
.de PT
.tl 'HP01 - RP04 MOVING HEAD DISK INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: hp.c''Section 9'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B hpstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hpstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O to an RP04 device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the RP04 queue (chained from d_actf in
hptab), hpstart marks the RP04 as active (hptab.d_active) and initiates I/O
for the first request in the queue.. The real work of activation is done by
rh.c/rhstart but hpstart must fill in an RP04 controller register that is
not filled in by rhstart. Although the physical block address has already
been computed by hp.c/hpstrategy, hpstart must complete the logical to
physical device mapping by selecting the actual physical drive.
.sp 1m
.ne 10
.
.LP
.LG
.B hpstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hpstrategy(bp)
.br
struct buf *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the RP04's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The strategy routines for disk and tape drivers provide two major services:
to place I/O requests on the device's queue of pending requests in an order
that is most efficient for that particular device, and, to verify that the
request's logical block address conforms to the logical (i.e., minor)
device policy of the device driver. In particular, disk and tape strategy
routines do the following specific things for each I/O request, which the
driver sees in terms of a pointer "bp" to a buffer header (struct buf):
.IP 1. 4
Verify that the block address given in the I/O request is a plausible
address for the logical device being read/written. That is, ensure
conformity to the logical device policy of the driver. Since there are 22
sectors per track and 19 tracks per cylinder, 418 blocks are on each
cylinder
.IP 2. 4
For devices that have several logical devices on a single physical device,
translate the block address on the logical (i.e., minor) device to a true
block address on a physical device. The remainder of the translation
(selecting the physical drive) is peformed elsewhere, usually in the
driver's start routine. Note that for drivers that map a logical device to
one or more physical devices this step is omitted and the address
translation is done elsewhere, usually in the driver's start routine.
.IP 3. 4
Place the I/O request in the device's queue of pending I/O requests (work
to do queue). The location within the queue where the request is placed
depends on the queuing strategy being employed for the device. The queue
itself is chained from d_actf in the device's devtab (e.g., hptab, hstab,
etc.) Immediately prior to rechaining the queue to insert the - request,
the processor's hardware priority must be raised to that of the device to
disable interrupts from the device.
.IP 4. 4
Cause physical I/O to be initiated if there are no previous requests
currently being serviced.
.
.LP
The strategy routine for the RP04 disk, hpstrategy, performs all of the
above functions. The logical to physical device mapping is accomplished by
dividing the logical (i.e., the minor) device number by eight. The quotient
of this division is interpreted as the controller drive number and the
remainder is the logical file system on that drive. For example, a minor
device number of 13 is construed to be logical file system five on physical
drive one. Each physical drive is divided into eight logical file systems
as follows:
.
.LP
file		cylinders	# of blocks
.br
	0	0 - 23		9614
.br
		24 - 43	UNUSED
.br
		(Can be swap area)
.br
	1	44 - 200	65535
.br
	2	201 - 357	65535
.br
	3	358 - 407	20900
.br
	4	0 - 99		40600
.br
	5	100 - 199	40600
.br
	6	200 - 299	40600
.br
	7	300 - 399	40600
.
.LP
The queuing strategy used is the "elevator" technique. That is, when a
request is made, if there are none or one other request on the queue, the
new request is placed at the end of the queue (First In First Out (FIFO)
strategy). If there are already two or more pending requests, the new
request is inserted so that all requests on the queue are in cylinder
number order. Whether this order is increasing or decreasing by cylinder
number is established when there are two requests on the queue. All
requests for the same cylinder are handled in a FIFO manner.
.sp 1m
.ne 10
.
.LP
.LG
.B hpwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hpwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RP04 driver for "raw" mode write requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The write routines for disk and tape drivers are the functions that handle
"raw" mode write requests for their respective devices. That is, they are
the interface between users making such requests and the I/O subsystem, and
are called whenever a write is done to the raw device. They usually do
little more than invoke bio.c/physio to do the real work involved with
"raw" I/O, but are vitally necessary, as they inform physio of such things
as the device strategy routine to invoke to make the I/O request. Hpwrite
merely verifies (see hp.c/hpphys) that the "raw" write request will remain
entirely within the bounds of the RP04 logical device in question before
calling physio.
