.hpf hyphen.local
.P1
.de PT
.tl 'DP01 - DP-11 201 SYNCHRONOUS INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: dp.c''Section 8'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dpclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpclose()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes a DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to logically close the DP11, dpclose must disable transmit and
receive interrupts from the device, indicate the device is no longer in use
by any process (dp_proc), and, relinquish the I/O buffer that was obtained
by dp.c/dpopen (dp_buf).
.sp 1m
.ne 10
.
.LP
.LG
.B dpopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens a DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Before logically opening the DP11 interface, dpopen must verify that it is
not already open for some other user (actually, process); in which case, an
error condition is indicated (u_error) and the open is not done. The user
process that first opens the DP11 may open it as many times as desired
without intervening closes. On the initial open, an I/O buffer is obtained
(see bio.c/getblk) and the driver's internal timer (dp_timer) is set for a
minute (see dp.c/dptimeout). Dpopen sets the sync character to octal 26 and
initializes the DP11 device's transmitter and receiver registers.
.
.LP
The arguments "dev" and "flag" are not used by this routine, but serve to
maintain syntax compatibility with other device open routines.
.sp 1m
.ne 10
.
.LP
.LG
.B dpread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpread()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read routine for the DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the read routine for the DP11 driver, dpread is invoked each time the
user reads from the device. An immediate return is done if a check of the
DP11 device's status reveals that it is no longer in a ready state (see
dp.c/dpwait). If any characters have been received and placed in the I/O
buffer (dp_buf; see dp.c/dprint), then they are moved to the user's I/O
buffer and the read request is considered complete. Note that the number of
characters actually given to the user is always the minimum of the number
requested and the number available.
.
.LP
However, it may be that no data has yet been received. In this case, dpread
checks to see if a timeout has occurred (see dp.c/dptimeout); a timeout
reveals that at least five seconds have passed without any data being
received. Rather than continue to wait for receipt of data, a return is
done with no characters returned to the user. Otherwise, the routine waits
for a device status change or timeout to awaken it (see dp.c/dpturnaround),
at which time it goes back through the algorithm just described.
.sp 1m
.ne 10
.
.LP
.LG
.B dprint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dprint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts on the receive side of the DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the receive interrupt handler for the DP11, dprint is given control
whenever a character (seven data bits plus one parity bit) is received by
the device. The character is retained only if the device is in a READ state
(dp state) (to prevent overwriting the I/O buffer if it contains data being
transmitted; see dp.c/dpwrite) and the I/O buffer is not already full (a
full buffer results if the user is lax or unable to read data that has been
received). Before the character is placed in the I/O buffer, it is
converted to odd parity if not already so.
.
.LP
Note that after synchronization has been achieved by receipt of the initial
two (consecutive) sync characters (octal 26), this DP11 driver causes any
further sync characters to be retained and treated as normal data
characters until the synchronization is broken (see dp.c/dpturnaround).
.sp 1m
.ne 10
.
.LP
.LG
.B dpstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Transmits a character on the DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Every character that is transmitted on the DP11 device must pass through
dpstart before actually being sent. This routine resets the driver's
internal timer (dp_timer) to five seconds; this allows ample time to do an
actual transmission. A failure to complete the transmission in this amount
of time results in a timeout and the flushing of any untransmitted
characters that are in the I/O buffer (see dp.c/dpturnaround). Dpstart then
checks to see if there are more characters to be sent (dp_nxmit). If there
are none, it switches the device state (dp_state) to READ to indicate that
the buffer is now free to be reused; otherwise, the first untransmitted
character in the buffer ("dp_buf") is converted to odd parity and placed in
the DP11's transmitter buffer.
.sp 1m
.ne 10
.
.LP
.LG
.B dptimeout
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dptimeout()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs timing function for the DP11 synchronous interface driver.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dptimeout routine is called once a second by the system (see
clock.c/clock and dock.c/timeout). It decrements the driver's internal
timer (dp_timer). If the timer goes to zero, the DP11 is turned around (see
dp.c/dpturnaround) and the timer is reset to one second to ensure that
dp.c/dpread knows that a timeout occurred. Its last responsibility to
request another wakeup by the system in one second.
.sp 1m
.ne 10
.
.LP
.LG
.B dpturnaround
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpturnaround()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Turns around the DP11 synchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dpturnaround routine is invoked either because of a timeout situation
in the DP11 driver's clocking mechanism (see dp.c/dptimeout) or because of
a change in the device's status that may affect data reliability (see
dp.c/dpxint). The driver's timer (dp_timer) is reset to five seconds and
the device's receive active bit is turned off (the ramifications of this
are described below). In addition, if the device was in the WRITE state
(dp_state), the state is changed to READ and any untransmitted characters
in the I/O buffer are discarded. Finally, those waiting to read or write to
the device are awakened.
.
.LP
The net effect of the above actions is that, insofar as reading from the
device is concerned, a resynchronization of the device (two consecutive
sync characters) is required before data may be received (i.e., reenable
the receive active bit). As far as writing goes, any characters written to
.bp
.1C
.CD
.I
(Page missing from the original material)
.DE
