.hpf hyphen.local
.P1
.de PT
.tl 'TRAP01 - TRAP HANDLER'\*[CH]'PD-1C301-01'
.tl 'File: trap.c''Section 23'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B nosys
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nosys()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A fatal system error is posted ("in u_error").
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
A placeholding entry in function tables which results in a fatal error
being posted.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The address of this function is placed in any table of functions (System
Entry Point Table, Block Device Switch Table, Character Device Switch
Table, etc.), where no entry is required and where calling the function
corresponding to that entry is an error. The fatal error code 100 is posted
in "u_error" so that the trap handler can properly notify the process which
originated the bad system call or table reference (i.e., terminate it or
allow it to handle the Bad System Call signal which is sent).
.sp 1m
.ne 10
.
.LP
.LG
.B nullsys
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nullsys()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
A system call that does nothing. It's address is used to fill in tables of
functions in the system where no error should be posted when the entry is
called.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This entry is used in any table of functions in the system (System Entry
Point Table, Block and Character Device Tables, etc.), where calling the
function corresponding to that entry should result in no action and no
error being posted. A deliberate use of the trap.c/nullsys entry is made as
the first entry in the System Entry Point Table. This prevents multiple
levels of indirect system calls (see trap.c/trap).
.sp 1m
.ne 10
.
.LP
.LG
.B trap
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
trap (dev,sp,r1,newps,r0,pc,oldps)
.br
char *sp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Any minor errors encountered in processing a system call are reported to
the user process and any major errors result in the process being signalled
(and usually terminated).
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The system trap handler.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
All system calls are made by trapping to the operating system using the
TRAP instruction. This is the most common trap generated. Hardware traps
are also generated for illegal instructions, addressing violations, etc.
UNIX can recover a user process from these errors either by terminating the
process or allowing the process itself to regain control and recover from
the error. The operating system does not, however, recover if any of these
traps are generated while system functions are executed. These result in a
system panic ("PANIC TRAP").
.
.LP
For every process in the system, UNIX maintains a set ("u_signal[]" in each
U block) of signal actions (20) that can be received by that process. A
signal may be sent to a process via the kill system call, however, within
the system, many of the signals correspond to specific hardware events
(traps) and result in a signal being sent to a process. The following is
the list of traps that can be generated by the PDP-1l hardware and the
signals that are sent (if any),
.
.LP
1. Bus error - signal 10 - SIGBUS.
.br
2. Illegal Instruction - signal 4 - SIGINS.
.br
3. Trace trap - signal 5 - SIGTRC.
.br
4. IOT instruction - signal 6 - SIGIOT.
.br
5. Power Fail,
.br
6. EMT instruction - signal 7 - SIGEMT.
.br
7. Trap instruction (i.e., system call).
.br
8. Programmed Interrupt.
.br
9. Floating Point Violation - signal 8 - SIGFP.
.br
10. Segmentation Violation - signal 11 - SIGSEG.
.
.LP
The remainder of the signals are reserved for user initiated or system
initiated communication with a process. As mentioned previously, signals
corresponding to hardware errors may be sent via the kill system call and a
process may choose to ignore or to handle any or all of these traps (by
using the signal system call). Only one signal cannot be caught or ignored
(the kill signal, SIGKIL = 9).
.
.LP
Like the clock interrupt handler, the trap handler performs a variety of
functions. The functions will be described in the order of their most
frequent use.
.
.LP
The trap handler is called to interface every system call to the operating
system. For the most part, a user program involks a library (C library or
assembly language library) routine to properly set up the arguments to the
system call, however, there is no reason why a program need involk the
library routines. There are two basic forms of system calls. The first form
is the direct system call:
.
.LP
	sys 22	/trap instruction
.br
	arg 1		/argument number 1
.br
	arg 2		/argument number 2
.
.LP
The SYS pseudo instruction is recognized by the UNIX assembler as the TRAP
instruction. The number (22 in this case) is an index into the System Entry
Point ("sysent[]"). This instruction is assembled as a one word instruction
with the lower 8 bits reserved for the trap number. UNIX has only 64 system
entry points at present, so only 6 bits of the trap number are recognized.
Immediately following this are the (one word) arguments to the system call.
Some system calls pass the first argument (as specified by the system call
descriptions in the UNIX Programmers Manual) in register R0. (The C
compiler recognizes the fact that registers R0 and R1 are scratch..)
Arguments assembled after the trap instruction are not necessarily in the
order specified by the format of the system call in the UNIX programmers
Manual. The number of arguments assembled after the trap instruction must
be the number expected by the system as the trap handler advances the
Program Counter to skip over these arguments.
.
.LP
Since some arguments are assembled after the trap instruction and these
arguments are typically not constant values, they must be set up just
before the system call is made. This, however, proves a problem for
reentrant programs as the text segment is write protected. Thus, for all
practical purposes, this form is useful only for system calls which have no
argument or one argument which is passed in R0.
.
.LP
The second form of system call is the indirect system call:
.
.LP
 .text
.br
	sys 0	/indirect system call
.br
	addr	/address of real
.br
		/system call
.br
 .data
.br
9:
.br
      sys 22	/system call
.br
      arg 1	/argument 1
.br
      arg 2	/argument 2
.
.LP
System call zero is reserved for the indirect system call. This system call
passes as its one and only (constant value) argument, the address of the
real system call. A template for the real systern call is assembled in the
data area just as it would have been if the first form bad been used. The
advantage is, however, that since the template is in the data area it may
be modified even if the program is reentrant. This is used for all multiple
argument system calls by the C library to insure that any program may be
made reentrant. The first entry in the System Entry Point Table is for the
trap.c/nullsys function.. This function does nothing and its presence as
the first entry in the table insures that multiple levels of indirect
system calls can not be done.
.
.LP
The System Entry Point Table is an array consisting of 64 two word entries.
The first word of each entry contains the number of arguments that must be
fetched from the user's virtual address space and the second is the address
of the function within the system which corresponds to the system call.
Once it has been ascertained that the trap is actually a system call, the
type (direct or indirect) of system call is determined by checking the trap
number.
.
.LP
For the direct systern calls, the number of arguments (specified in the
System Entry Point Table) are fetched from the user's virtual address
space. The Program Counter is saved automatically on the system's stack (U
block) by the hardware trap mechanism and is available as an argument to
trap.c/trap so that it can be found easily. Since the TRAP instruction is a
one word instruction, the PC was automatically advanced to the next
location when the trap occurred, so that it is only necessary to advance
the PC to skip over the arguments following the TRAP initruction. The per
process information in each U block can accomodate up to 5 arguments (in
the array "u_arg[]") making a total of 6 that may be passed. (R0 is usually
used to pass an argument by saving and restoring registers in the library
interface. More could be passed in registers and in any event, the Argument
Array "u_arg[]" could be enlarged.) Each argument fetched from the user's
address space is placed in the Argument Array.
.
.LP
For indirect system calls it is only necessary to step the PC by 2 to
bypass the one argument to the indirect system call. Arguments are loaded
into the Argument Array as with the direct system call.
.
.LP
Some system calls pass the address of a string as a file name or a path
name. Ultimately, the nami.c/nami function is called to do pattuaame
searches on these strings so that the variable "u_dirp" is set to
"u_arg[0]" . (the first argument fetched from the user's address space) as
a convenience. This means that a string argument for calls like open,
create, link, etc. follows the convention that a pointer to the string name
is setup as the first argument in the system call. Another convention used
is that for system calls that involve file descriptors, the descriptor is
passed in register R0.
.
.LP
Once all of the arguments have been set up, the system call can be made by
selecting its address from the System Entry Point Table. In order to allow
system calls to be prematurely terminated, as when a signal is sent to a
process, entry into the system must be made in a particular manner. The
function specified in the System Entry Table cannot be called directly.
Rather, a dummy routine (trap.c/trap1) must be used. This is done because
the execution of nonlocal goto's (mch.s/aretu) within the operating system
depend on a variation of the context saving and restoring method to
operate. Mch.s/aretu manipulates registers R5 and SP which are saved (by
trap.c/trap1) in "u_qsav". The manipulation makes the execution of
mch.s/aretu appear as if the function trap.c/trap1 returned (prematurely to
trap.c/trap). The two word array "u_qsav" in the U black is used to save
the stack position of the dummy function trap.c/trap1 and to restore it
when mch.s/aretu is called (by slp.c/sleep).
.
.LP
The chief use of this setup is to terminate system calls prematurely when
signals are caught. In particular, for processes that relinquish the
processor at low system priority (wait priorities, "p_pri" value is greater
than zero) a check is made before the processor is relinquished and after
it is regained to see whether there is a signal pending. If there is a
signal pending, then the Signal Processor sig.c/psig is called. The Signal
Processor determines whether signals are to have the standard system action
(see sig.c/psig) or are to be handled by the user process. If the signals
are to be handled by the user, then slp.c/sleep executes a non-local goto
to return to the trap handler so that the user's program is entered at the
proper point. No error is posted when the system call is aborted.
.
.LP
For processes that relinquish the processor at high priority, the system
does not have to worry about a long period of time that the process might
asleep, so that it is sufficient to allow the system call to complete and
to check in the trap handler to see if there are any signals pending.
Before making this check however, the trap handler checks to see if any
errors were posted (in "u_error") by the system call and if a fatal error
("u_error" > = 100) has been posted, a bad system call signal (signal 12 -
SIGSYS) is sent to the process. This will result in the process being
terminated if standard system action is in effect . When a minor error
occurs ("u_error" < 100) in processing a system call, the error number is
returned by the trap handler in register r0 and the C bit is set in the
Processor Status word so that it can be tested by the C library interface.
The library function can thus determine whether an actual value is being
returned or whether an error has occurred.
.
.LP
The second most frequent use of the trap handler is in resolving Stack
Violations, that is in allocating more stack space to a process. When the
Stack Violation occurs, the instruction that was executing aborts. The
abort only occurs at the end of a fetch cycle, so that it can be guaranteed
that at least part of the instruction was executed. The Program Counter
(PC) is updated before any fetches occur, so that it will indicate the next
location or next portion of the instruction after the abort. (The length of
art instruction depends on the addressing modes used and the type of
instruction; single operand, double operand, etc. Before each portion of an
instruction is fetched, the PC is incremented.). Determining what type of
instruction aborted and how much to adjust it is not an easy matter since
the PDP-11 possesses several addressing modes, autoincrement and
autodecrement, which cause automatic updating of registers.
.
.LP
Once it has been determined that the trap is a Segmentation Violation and
that the user's stack pointer is indeed beyond the area that has been
allocated to him, it is necessary to determine whether the PC can be backed
up so that the aborted instruction can be restarted. The mch.s/backup
function backs up instruction. This is easily done for 11/45 and 11/70
processor's, as they possess a hardware register (Memory Management Status
Register 2), which contains the amount by which any of the registers have
been autoincremented or autodecremerited. The registers can easily be
adjusted to their old values and the instruction restarted. On 11/40
processor's., this register is not present and the fetch cycles of the
instruction must be simulated to determine which fetch caused the abort.
The autoincrement, autodecrement addressing modes pose problems for
instruction backup on certain forms of instruction. In particular,
instructions of the form:
.CD
cmp -(sp),-(sp)
.DE
cannot be backed up (see mch.x/backup for details).
.
.LP
If the mch.s/backup routine indicates that the instruction can be (and has
been) backed up, a stack growth procedure may be started. The first step in
this procedure is to determine whether adding stack space to the user's
virtual address space will produce any address overlap or overflow the
virtual address space already allocated to the process. This is done by
calling main.c/estabur to make these checks and actually set up an image of
the new Memory Management registers in the U block.
.
.LP
The amount of stack space added each time a stack violation occurs is 20
memory blocks (1280 bytes). Once it has been determined that there is
enough user virtual space for the addition, the expansion can be done by
calling slp.c/expand. This function will copy the existing process
(in-cluding U block) to a new (larger by the increment) area of memory, or
if not enough memory is available, will swap the process out to an area
encompassing the new size. In either case, the copy results in the addition
of the new area to the end of the physical area occupied by the process.
Since stack segments grow downward in physical and virtual address space,
the added memory should be lower (in physical core) and contiguous to the
existing stack area. This is accomplished by simply copying the existing
stack to the added physical memory. (Effectively the stack is shifted down
by 1280 bytes in memory.)
.
.LP
The third most frequent use of the trap handler is for handling traps
generated by executing the SETD instruction on processor's that do not have
the Floating Point Processor option (all 11/40's). The start off function
(crt0.s) within every C language program issues the SETD instruction. This
instruction turns on double precision floating point mode. On processor's
not having Floating Point hardware this instruction generates an illegal
instruction trap, so it must be ignored. There is a Floating Point software
package (fp.s) which may be loaded with any program not possessing floating
point hardware to simulate the operation of floating point instructions. In
order to use this package the user program must use the signal system call
to direct any illegal instruction traps to the floating point package. The
trap handler sends an illegal instruction signal to the process and calls
the Signal Processor sigc/psig. every time a floating point instruction is
executed on a processor not having floating point hardware. The floating
point interpreter will execute a BPT (which produces a BPT trap)
instruction if any non-floating point illegal instructions are executed.
.
.LP
Execution of the IOT, EMT, and BPT instructions by user processes produce a
trap and a fatal error unless other arrangements have been made (via signal
system call). Similarly, all bus errors and unrecoverable Segmentation
Violations produce fatal errors.
.
.LP
All traps occurring while the processor is in Kernel mode result in a
system panic. It is assumed that the operating system is completely
debugged and cannot produce errors unless the hardware is in trouble. When
this occurs, the message
.CD
KA6 = num1
.br
APS = num2
.DE
is printed on the system console. The quantity numl is the contents of the
Memory Management Address Register that maps the system's stack (U block -
for non I & D space system Kernel Instruction Address Register 6 is
printed, while for I & D space systems Kernel Data Address Register 6 is
printed). This is the physical memory block (64 byte granularity), which
corresponds to the beginning of the U block (virtual address 0140000 or 24K
word). The second quantity,
.I num2 ,
is the virtual address within the U block of the stack frame built for the
trap ba.ndler. The stack frame is described under mch.s/call and contains
such things as the PC and PS at the time of the trap, the type of trap,
etc. The physical address of the start of the stack frame can be computed
as follows:
.CD
addr = KA6*0100 + APS - 0140000
.DE
The physical 18 bit address from this calculation may be used at the
processor console to examine the stack frame when the system crashes. The
stack frame is simply the arguments to the trap handler (see CALL above) in
order from right to left (oldps to dev).
.
.LP
Once this message is printed, the processor is placed in the WAIT state. If
the continue switch on the processor console is stepped, the message "PANIC
TRAP" is printed.
.
.LP
The last function performed by the trap handler is in conjunction with
penalizing processes that use too much system time. Processes that hog
system resources are divided into two categories; system bound and CPU
bound.
.
.LP
CPU bound processes are identified and penalized by the clock interrupt
handler. System bound processes spend most of their time executing system
calls. In order to prevent system bound processes from monopolizing the
processor, a scheme whereby the number of consecutive system calls made by
a process before it roadblocks is kept. If a process makes seventeen
consecutive system calls before being roadblocked, the process is preempted
and it's priority is lowered by one point. This is a one time penalty and
the next time the process has the opportunity to run, its priority is
restored to its normal value.
.
.LP
The trap handler insures that a process's priority is restored to it's user
mode priority when it returns to user mode execution. When a process is
awakened, it receives the (software) priority that it roadblocked at. It is
selected by the process Switcher (slp.c/swtch) on this basis and retains
that priority until it roadblocks again or until the process returns to
User mode execution. At this time, the priority is set to PUSER + u_nice.
FUSER is defined as a low value (100) and "u_nice" is any user specified
penalty or reward for the process (specified via the nice system call).
.sp 1m
.ne 10
.
.LP
.LG
.B trap1
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
trap1 (function)
.br
int (*function)();
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Calls the appropriate entry point in the system when a system call is made.
Necessary in order to terminate a system call to process a signal.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is a dummy system call made necessary by the way nonlocal goto's are
executed within the operating system. When a signal is caught before a
process roadblocks (slp.c/sleep) or just after if is awakened, the system
call is terminated prematurely by using the mch.s/aretu function. Execution
of this function by slp.c/sleep causes the trap.c/trap1 function to appear
to have returned. (That is, control is passed to trap.c/trap.) In order to
be able to execute the nonlocal goto, the stack position of trap.c/trap1
must be saved. R5 and SP are saved in the U block in "u_qsav". (See
trap.c/trapi for a more complete explanation.)
