.hpf hyphen.local
.P1
.de PT
.tl 'TEXT01 - SHARED PROGRAM'\*[CH]'PD-1C301-01'
.tl 'File: text.c''Section 22'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B xalloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
xalloc(ip)
.br
struct mode *ip;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is explicitly returned. It does, however, set a process's text
pointer ("p_textp").
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Creates a reentrant text segment in the system or finds the text if it is
already present.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Text.c/alloc is a subroutine of sys1.c/exec. It is used to create the Text
Table entry for a process that has reentrant text and to read the reentrant
text into memory. The Text Table contains the following entries for each
reentrant text segment.
.
.LP
"x_count" - This is a count of the number of processes using the text.
.
.LP
"x_ccount" - This is a count of the number of processes in memory that are
using a text.
.
.LP
"x_caddr" - This is the memory address (in memory blocks) of the text. This
entry is only valid if the memory usage count ("x_ccount") is nonzero.
.
.LP
"x_daddr" - This is the address (in 512 byte blocks) of the text on the
swap area. Since reentrant text is managed separately on the swap area from
the nonreentrant portion, it need never be swapped out. Thus, reentrant
text remains in the same position on the swap device until the last process
using it leaves the system at which time the text is destroyed.
.
.LP
"x_size" - This is the size in bytes of the text.
.
.LP
"x_iptr" - This is a pointer to the Inode Table entry containing the i-node
from which the text is to be read.
.
.LP
In setting up a reentrant text segment in the system, the following steps
are taken:
.IP 1. 4
The Text Table is scanned to see whether the reentrant text from i-node
"ip" has already been set up. If it has, then steps 2-6 are skipped. The
text pointer ("p_textp") in the Process Table is set up and the use count
"x_count" is incremented in this case. If the text is not already known to
the system, a Text Table entry is allocated. If there are too many entries
in the Text Table the system panics ("PANIC OUT OF TEXT").
.IP 2. 4
The Text Table entry is initialized by setting the use count ("x_count") to
one and the in-memory use count ("x_ccount") is zeroed since the text has
not been read into nemory as yet. Since text.c/xalloc is a subroutine of
the exec system call (sys1.c/exec), the size of the text is available in
"u_arg[]". (Sys1.c/exec has already read the 16 byte header of the object
file.) This byte value is rounded up to the nearest memory block, converted
to memory block granularity and placed in "x_size".
.IP 3. 4
Space is allocated on the swap device to hold the text. If there is no
space available, the system panics ("PANIC OUT OF SWAP SPACE"). The address
of the text ("x_daddr") on the swap area is set at this time.
.IP 4. 4
Before calling text.c/xalloc, sys1.c/exec freed all of the memory space
occupied by the overlaid process. Only the U block is retained so that the
overlaying process may inherit some of the characteristics of the parent.
This memory space is now expanded to encompass both the U block and the
space required for the text. In addition, the User Memory Management
registers are loaded so that a virtual address space that can be read or
written (equal to the size of the text) is set up in this area (directly
below the U block).
.IP 5. 4
The text is read into memory by setting up the "u_base", "u_count",
"u_segflg", and "u_offset[]" entries so that rdwr.c/readi can be called.
"u_segflg" has already been set by sys1.c/exec to indicate that the I/O
will be transfered to the user's virtual address space. The offset
("u_offset[]") is set so that the 16 byte header4is skipped and the
destination is set up so that the data is copied to virtual address 0 in
the user's address space.
.IP 6. 4
Once the reentrant text is in memory, a copy is made on the swap device of
the text (only). While this is being done the process must be locked in
memory.
.IP 7. 4
After the copy of the text is made on the swap device, the process doing
the exec is unlocked. The text pointer is set ("p_textp") and the -Inode
Table entry for the text is marked (ITEXT), so that the text cannot be
modified on the filesystem until the last process using the text leaves the
system.
.IP 8. 4
The process is now truncated to the size of the U block (that is, the text
in memory is discarded.)
.IP 9. 4
For text that must be created fresh or for existing text that must be read
in because it is not in memory, the following procedure is used:
.RS
.IP a. 4
The context of the process is saved (in "u_rsav" and "u_ssav") and the
process is swapped out. At this time, the process consists only of it's U
block.
.IP b. 4
The process is marked (SSWAP in "p_flag"), so that when the process resumes
it will return to sys1.c/exec and the processor is relinquished
(slp.c/swtch). Thus, the text is effectively abandoned until the process is
again brought into memory by the Scheduler.
.RE
.IP 10. 4
For processes which are executing a reentrant text that is already in
memory, none of the procedures 2-9 need be done. Only the in-memory count
"x_ccount" need be updated (incremented by 1).
.sp 1m
.ne 10
.
.LP
.LG
.B xccdec
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
xccdec(xp)
.br
struct text *xp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Decrements the in-memory usage count of a reentrant text.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Reentrant text is maintained as a separate entity on the swap device and
in-memory. It is therefore necessary to keep track of the number of
processes that are using the in-memory copy so that the memory can be freed
when all of the processes using it leave the system. Text.c/xccdec
decrements the in-memory usage count ("x_count") and if it becomes zero,
frees the memory occupied by that text.
.sp 1m
.ne 10
.
.LP
.LG
.B xfree
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
xfree()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Decrements the usage count of reentrant text and removes the text from the
system when the last process using that text leaves the system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function decrements the usage count of a reentrant text. It is the
complimentary function to text.c/xalloc. Associated with each reentrant
text in the system is a Text Table entry. (These are described under
text.c/xalloc) Text.c/xfree simply determines whether a process has a
reentrant text portion ("p_textp" is nonzero) and decrements both the
in-memory usage count ("x_count") and the usage count ("x_count"). The
in-memory usage count is decremented by calling text.c/xccdec. A check is
made by text.c/ifree to see if all of the processes using the reentrant
text have disappeared from the system. When this occurs, text.c/xfree
deallocates the space that was occupied by the text on the swap area
andreleases the i-node for that text. While a reentrant program is being
executed, it's i-node is kept in the mode Table. This is done to eliminate
the need to read that i-node if another instance of the program is invoked
and to prevent the reentrant text from being overwritten while there is a
copy of that text executing in the system.
.sp 1m
.ne 10
.
.LP
.LG
.B xswap
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
xswap(p,freeilag,oldsize)
.br
struct proc *p;
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs housekeeping required to swap a process out.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Two indicators are passed to text.c/xswap. The first ("freeflag") indicates
whether the memory occupied by the swapped process should be freed. The
only time that the memory occupied by a process is to be retained after a
swap is when a parent creates a child by forking. The second argument
("oldsize") tells text.c/xswap what the former size of the, rocess was.
This is necessary when swapping is used to grow the size of a process
(slp.c/expand) so that while a space large enough to hold the new size is
allocated on the swap area, only the former size will be placed in that
area. The steps in swapping a process out are,
.IP 1. 4
Space is allocated on the swap area to place the process. Since a copy -of
reentrant text remains on the swap area even when a reentrant process is
brotrght into memory, there is no need to swap it Out If there is no space
on the swap area for the process, the system panics ("PANIC OUT OF SWAP
SPACE").
.IP 2. 4
The memory usage count ("x_ccount") of any reentrant text for the process
is decremented and if there are no processes in memory using the text, the
memory occupied by the text is freed.
.IP 3. 4
The process is locked in memory ("p_flag" = SLOCK) until I/O for the swap
is completed.
.IP 4. 4
The swap function (bio.c/swap) is called to swap out the process and if any
errors occur, the system panics ("PANIC SWAP ERROR").
.IP
/TI -4 5.  The memory associated with the process (not including reentrant
text) is freed unless a swap to do a fork is occurring.
.IP 6. 4
The location of the process ("p_addr") is set to it's location on the swap
area and the process is marked as non-resident ("p_flag" = SLOAD) and is
unlocked.
.IP 7. 4
Since a process has moved to the swap device, the Scheduler is notified if
there were formerly no ready processes on the swap device.
