.hpf hyphen.local
.P1
.de PT
.tl 'SYS401 - SYSTEM CALL INTERFACE 4'\*[CH]'PD-1C301-01'
.tl 'File: sys4.c''Section 19'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B chdir
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
chdir()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes a process's current working directory.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Chdir is the system primitive that allows a process to change its working
directory. The new working directory must be a bona fide directory for
which the user has execute permission. The actual switching of directories
is easily accomplished by altering the U block's current directo ry pointer
(u_cdir) to the new directory's inode table entry.
.sp 1m
.ne 10
.
.LP
.LG
.B chmod
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
chmod()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Alters a file's mode (i.e., permissions).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Chmod is a system primitive that allows the mode of a file (i.e., its
permissions) to be restated. This may be done only by super-user or the
owner of the file (as determined by the effective userid). The actual mode
changing is completed by placing the new mode in the file's mode field
(i_mode).
.sp 1m
.ne 10
.
.LP
.LG
.B chown
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
chown()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the owner of a file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Chown is the system primitive that enables a user to change the ownership
of a file. Only the super-user or the file's owner may change the ownership
(that is, a file may only be given away, it cannot be taken). The userid of
the new owner is duly recorded in the file's ownership field (Luid). An
interesting side effect is that, unless done by super-user, changing file
ownership negates the set userid aspect of the file's mode.
.sp 1m
.ne 10
.
.LP
.LG
.B getgid
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getgid()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Enables a process to determine the real group id under which it is running.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Getgid is a system primitive that returns tb the user the real (as
distinguished from the effective) group id (u_rgid) under which the process
is running.
.sp 1m
.ne 10
.
.LP
.LG
.B getpid
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getpid()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Enables a process to determine its process id.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Getpid is a systim primitive that returns to an invoking process its
process id (p_pid).
.sp 1m
.ne 10
.
.LP
.LG
.B getswit
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getswit()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Reads the console switches.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Getswit is a system primitive that returns the contents of the console
switches to the user.
.sp 1m
.ne 10
.
.LP
.LG
.B getuid
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getuid()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Enables a process to determine the real userid under which it is running.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Getuid is a system primitive that returns to a process the real (as
distinguished from the effective) userid (u_ruid) under which it is
running.
.sp 1m
.ne 10
.
.LP
.LG
.B gtime
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
gtime()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Returns time of day to user.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Gtime is a system primitive that returns the time of day (time[]), in one
second granularity, to the user.
.sp 1m
.ne 10
.
.LP
.LG
.B kill
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
kill()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sends a specified signal to another process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Kill is the system primitive that enables one process to send a signal to
another. Before the signal is sent, verification is made that the sending
process is either the super-user or that both the sending and receiving
processes have the same (effective) userid.
.sp 1m
.ne 10
.
.LP
.LG
.B nice
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nice()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allows a process to alter its priority.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Nice is a system primitive that provides a process a limited amount of
flexibility in altering its priority. For a normal user, the argument to
nice must be a value between zero and twenty. This value (u_nice) is
ultimately added to the process's system determined priority value,
effectively lowering its priority. Super-user is allowed to specify, nice
values between -220 and 20; hence, a raising of priority, is possible.
.sp 1m
.ne 10
.
.LP
.LG
.B profil
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
profil()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Activates the execution profiling of a process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Profil is the system primitive that activates process execution profiling.
To do so, it records, for later system use (see mch.s/incupc), the values
(u_prof[]) used by the system in fulfilling the profiling request.
.sp 1m
.ne 10
.
.LP
.LG
.B setgid
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
setgid
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the effective, and possibly the real, group id of a user process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Setgid is a system primitive that enables a process to change the group id
under which it is executing. A normal user may change only the effective
group id (u_gid) of the process to whatever the real group id (u_rgid)
already is; superuser may change both the real and effective group id to
anything desired.
.sp 1m
.ne 10
.
.LP
.LG
.B setuid
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
setuid()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the effective, and possibly the real, userid of a user process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Setuid is a system primitive that enables a process to change the userid
under which it is executing. A normal user is only allowed to change the
effective userid (u_uid) of the process to whatever the real userid
(u_ruid) already is; super-user may change both the real and effective
userid to anything desired.
.sp 1m
.ne 10
.
.LP
.LG
.B smdate
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
smdate()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Alters the last modified time for a file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Smdate is a system primitive that enables a user to change a file's last
modified time (i_mtime) to any time desired. Only the super-user or the
file's owner may do this. This is done immediately to the i-node entry in
the file system and an interesting by-product is that it forces the incore
inode table entry for the file to be written to the file system.
.sp 1m
.ne 10
.
.LP
.LG
.B ssig
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
ssig()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Permits a process to specify the action to be taken when it is sent a
signal.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Ssig is a system primitive that allows a process to specify which of three
ways a particular signal sent to it should be handled: default system
action, ignored, or control be given to a user specified function (catch
the signal). This is accomplished by entering the necessary value (zero, an
odd integer, or the address of the function, respectively) in the proper
u_signal[] slot. The kill signal may not be caught or ignored, and if the
signal in question has already been sent to the process, but has not yet
been fielded by the system, it is thrown away.
.sp 1m
.ne 10
.
.LP
.LG
.B stime
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
stime()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sets the time of day.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Stime is a system primitive used to set the time of day (time[]). The
caller must be super-user. A secondary function performed is to wakeup all
processes sleeping on a time of day. This ensures that none oversleep.
.sp 1m
.ne 10
.
.LP
.LG
.B sync
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sync()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Syncs all mounted file systems.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Sync is a system primitive that syncs all mounted file systems. That is, it
causes all incore information about the file systems to be actually written
to their devices.
.sp 1m
.ne 10
.
.LP
.LG
.B times
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
times()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Provides execution time infoanation about a process and its children.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Times is a system primitive that provides to a process the user and system
CPU time used by itself and the cumulative user and system CPU time used by
all of its terminated child processes. All of the times returned have 1/60
second granularity.
.sp 1m
.ne 10
.
.LP
.LG
.B unlink
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
unlink()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Removes a link to a file from a directory.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Unlink is a system primitive that removes a directory entry to a file
(unlinks it). Super-user is the only person permitted to unlink a
directory. The process of unlinking involves zeroing the file's i-number in
its entry in its parent directory and decreasing its link count (i_nlink)
by one. The file is physically removed from the file system when its link
count becomes zero and all processes using it have closed it. There is no
verification that the user owns the file, but the user must have write
permission for the parent directory.
