.hpf hyphen.local
.P1
.de PT
.tl 'SLP01 - PROCESS SWITCHING'\*[CH]'PD-1C301-01'
.tl 'File: slp.c''Section 14'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B expand
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
expand(newsize)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Enlarges or contracts the size of an existing process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function is used to increase or decrease the area occupied by a
process. It knows nothing about the contents of this area except that it is
contiguous. As such the two functions (trap.c/trap and sys1.c/sbreak) which
use it for stack growth and dynamic storage allocation, respecitvely, must
do any shifting of parts of the program to adjust virtual addresses.
.
.LP
Since there may not always be enough memory available to grow a process in
core, several cases, similar to those of slp.c/newproc occur.
.
.LP
1. If a process's size is to be decreased ("newsize" is the new size of the
process including U block and it can be compared to the existing size
"p_addr") the extra memory is freed (by calling malloc.c/malloc). Memory is
freed from the high (physical address) end of the existing area.
.
.LP
2. If the process is to grow in size, physical memory must be added
contiguously to the end of the existing process. Instead of attempting to
add the increment of core to the existing area, a request is made
(malloc.c/malloc) for a new area of memory having size "newsize" (old plus
new). This is appropriate as the memory allocation scheme uses a First
Available Fit algorithm to allocate memory and the chances of an
incremental portion of core being available directly below a process are
slim. Since the memory may not be available, two procedures are used,
.
.LP
a. If memory is available, the process is simply copied into the new area.
The old image is abandoned (malloc.c/mfree) and the user's Memory
Management registers are reset (mch.s/sureg).
.
.LP
b. If memory is not available, then a scheme similar to that used by
slp.c/newproc is used. No tricks need by used in this case, since only one
process is involved. The process merely saves it's stack position (in
"u_ssavi, swaps itself out (text.c/xswap), marks itself (SSWAP in "p_flag")
so that its context will be restored from "u_ssav" and not wr_sav" and
calls the process Switcher (slp.c/swtch) to relinquish the processor. It
may seem strange that a process can continue execution after having swapped
itself, however, the processor is relinquished immediately after the swap
I/O is completed. (slp.c/swtch)so no problems occur. In preparing for the
swap, text.c/xswap frees the memory that was occupied by the swapped
process.
.sp 1m
.ne 10
.
.LP
.LG
.B newproc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
newproc()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A zero is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Spawns a new process in the system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is a subroutine used by sys1.c/fork to spawn a new process. It
provides for the inheritance of essential characteristics of the new
process. The new formed process is an image (exact copy) of the parent
(spawning) process. The chief features of the newly created process are:
.
.LP
It receives a new unique process ID ("p_pid").
.
.LP
It inherits the controlling teletype ("p_ttyp") of the parent.
.
.LP
It inherits any shared (reentrant) text. The use count "x_count" and memory
usage count "x_ccount" are increased for that text entry in the Text Table
("p_textp").
.
.LP
It inherits the User ID ("uuid").
.
.LP
It is marked to indicate the identity of it's parent (the parent's process
ID is kept in "p_ppid").
.
.LP
It's age is set to 0, as it is newly created.
.
.LP
It inherits all of the open files belonging to the parent process
("u_ofile[]") and the instance count ("f_count") of each file in the File
Table is incremented.
.
.LP
It inherits the context, working directory, signals, etc. of the parent. In
short, all information kept in the per process (U block) area is inherited.
.
.LP
A parent process creates the child as a result of executing the sys1.c/fork
system call, There may not be enough memory to replicate the process in
memory, so a procedure for replicating the process on the swap area must be
available. The steps in actually spawning the image once the Process Table
entry has been set up are:
.
.LP
1. The stack position of the parent is saved ("in "ursav"). This is done so
that when the child is created as an independent entity, it will resume
execution by executing a return from slp.c/newproc. The value returned by
the child will actually be a 1 (since even though the stack position is
restored by slp.c/swtch,the return that is executed is from slp.c/switch).
The significance of this is that the sys1.c/fork function calls
slp.c/newproc as a subroutine and uses the value returned to it to identify
the child so it can initialize the accumulated execution time of the child.
Thus, when a process makes a fork system call (sys1.c/fork), two processes
will return from the slp.c/newproc call. One of the processes (the parent)
will actually execute the return from slp.c/newproc, returning a zero. The
child process will appear to have returned from slp.c/newproc, but this
will seem this way because it's stack position was saved by the parent. It
will return a 1 since the process Switcher returns a 1.
.
.LP
2. A chunk of contiguous memory equal to the size of the parent process is
requested (malloc.c/malloc). There are two cases which may occur:
.RS
a. If memory is available, then a new image can be created simply by doing
an in core copy of the parent. The copy is done by copying memory blocks
(mch.s/copyseg) from the parent.
.
.LP
b. If a piece of contiguous memory is not available, the the image must be
made on the swap area. (It might be considered that the forking process
could be delayed until memory was available, however, for processes large
enough to fill user memory the copy would have to be made on the swap
device anyway.) The parent process is placed in an idle state ("p_stat" =-
SIDL) to insure that the Scheduler will not swap the process out. The
context is saved(mch.s/savu) again (in "u_ssav"). This is done becuase a
process is being swapped by a system function other than the Scheduler. A
swap out is requested (text.c/xswap) and the parent process is roadblocked
while this occurs. (It should be remembered that the parent is doing all of
the work associated with creating the child and therefore, incurs any delay
in accomplishing this. It should also be remembered that text.c/xswap
determines whether a process is reentrant and thereby need only swap out
the data and stack portions if the parent is reentrant.) When the swap is
completed and the parent is allowed to continue the creation process, it
marks the child process ("p_flag" = SSWAP), so that when the child is
restarted, it's stack position will be restored from "u_ssav" and not
"ursav". The parent is removed from the idle state and made ready ("p_stat"
= SRUN). In the process of creating the child a trick is used, so that the
child ends up in the proper state when the swap is completed. The child
process is made to assume the identity of the parent (by adjusting it's
process size "p_size" and address "p_addr" in the Process Table entry to
assume those of the parent). Thus the child will is roadblocked while the
swap occurs and consequently, the child is awakened ("p_stat" = SRUN) when
the swap is complete. After the swap is completed, the identities are
restored.
.
.LP
Once the image has been produced, the parent simply returns (a 0) to the
caller. The child will eventually be selected by the process Switcher to
run and will execute a return (returning a 1) from slp.c/newproc through
the process Switcher (slp.c/swtch).
.
.LP
If the Process Table is full when slp.c/newproc is called, the system
panics ("PANIC NO PROCS").
.
.LP
The slp.c/newproc function is also used at startup time (ruain.c/main) in
handcrafting the INIT process. Essentially, the operating system forks to
create a mirror image (of the system's U block) before the "icode[]"
program is installed in the child process (forerunner of INIT).
.RE
.sp 1m
.ne 10
.
.LP
.LG
.B sched
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sched()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The UNIX Scheduler.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The Scheduler is an endlessly looping process that runs entirely in Kernel
Address space. It is always process zero in the system, is always locked in
core, and does not receive any signals. The main.c/main function creates
and involks the Scheduler. No return to main/main.c ever occurs. The
Scheduler has it's own U block, which is borrowed by the process Switcher
when it changes execution- from one process to another. The Scheduler's
only function is to determine which processes are to be allowed into core
and which processes are to be swapped out.
.
.LP
The Scheduler uses the age of processes in determining which processes are
to be swapped into or out of memory. The age of a process is kept in
"p_time" and is updated by the clock interrupt handler once every second.
Since age changes once per second, the Scheduler will run approximately
once every second. The Scheduler runs in a piecemeal fashion, selecting a
process to swap in or out, roadblocking while the swap I/O occurs, then
rerunning. The amount of rearrangement done is limited by the amount of
physical memory available and by the Scheduling criteria. The Scheduler is
not the only function within the system which does swapping. Processes may
swap themselves out or create copies of themselves (via sys1.c/fork) on the
swap area however, the Scheduler is the only function that can bring a
process into memory.
.
.LP
The Scheduler will roadblock itself at three times
.
.LP
1. While swap I/O occurs, the Scheduler is roadblocked.
.
.LP
2. If there are no processes on the swap area in the ready state, the
Scheduler sets the "runout" flags and roadblocks itself. When any process
is awakened (by slp.c/wakeup) the Scheduler is awakened.
.
.LP
3. When there is not enough core available to bring a ready process on the
swap area into memory, the Scheduler sets the "runin" flag and roadblocks
itself. The first process that is willing to give up core (e.g., terminates
or goes into the WAIT state) causes the Scheduler to be awakened.
.
.LP
The algorithm used by the Scheduler in rearranging memory is:,
.
.LP
1. The oldest process on_the swap area that is in the ready state
("p_state" SRUN) is found. If there are no ready processes on the swap
area, the Scheduler sets the "runout" flag and roadblocks itself. When the
Scheduler is awakened, the algorithm is repeated.
.
.LP
2. The total size of the selected process is determined. If the process is
reentrant and the text is not already in core (core usage count "x_ccount"
is zero) this means that the size of the text ("x_size") must be added to
the memory requirements for the process ("p_size").
.
.LP
3. A check is made to see if there is enough available memory to bring the
process into memory without removing any process from memory. If memory is
available, the swap-in procedure is begun (see below) and the algorithm is
repeated (1).
.
.LP
4. If not enough memory is available, some process must be removed from
core. The following criteria are applied:
.RS
a. All of the processes in the Process Table are examined and the first
process that is in the WAIT state ("p_pri" = SWAIT), i.e., roadblocked at
low priority), or the first process that is in the stopped state ("p_stat"
= SSTOP), this is a new state for processes that are being examinedii_by
the interactive C debugger) is selected to be swapped out.
.
.LP
b. If the process selected in 1 as a candidate to be brought into memory
has been on the swap device for less than three seconds, the entire
procedure is dropped and the Scheduler roadblocks after setting the "runin"
flag. This essentially means that the Scheduler waits for core to willingly
become available or for the age of processes to change.
.
.LP
c. If the process selected in 1 has been on the swap area for longer than
three seconds, then all of the Process Table entries are examined again and
the oldest process in memory that is in the ready state ("p_stat" = SRUN)
or is in the sleep state ("p_stat" = SSLEEP) is found. No distinction is
made between the two. If the process selected by this criteria has been in
memory for more than 2 seconds, it is swapped out, otherwise the procedure
is dropped and the Scheduler roadblocks ("runin" is set) until core is
available or the age of processes change.
.RE
Swapping a process out is simply done by marking it as non-resident (SLOAD
flag is reset in "p_flags") and arranging for it to be swapped
(text.c/xswap).
.
.LP
Swapping a process in may require two swaps if the process is reentrant and
the reentrant text is not already in memory. Since reentrant text is
maintained on the swap area as a separate quantity, it need never be
swapped out. By checking the "p_textp" entry in the Process Table, it can
be determined whether reentrant text is associated with a process and it's
location and size can also be obtained ("x_caddr", "x_size"). The reentrant
text (if it is not already in core), is brought in first and the memory
usage count ("u_ccount") for that text is incremented. The remainder of the
process (data, bss and stack) is then brought in. When this portion is
brought into memory, the space that it occupied on the swap device is freed
(alloc.c/mfree). Any reentrant text is not freed as it cannot be modified
and leaving it there will save the trouble of swapping it out. When the
last process using the reentrant text leaves the system, the text is
destroyed (by text.c/xfree).
.
.LP
The Process Table entry for the swapped in process must be updated to
reflect the changed status of the process. In particular, the swapped in
process must be marked as loaded (SLOAD in "p_flag", its age ("p_time")
must be reset to zero and its address in physical memory ("p_addr") must be
set.
.
.LP
If any errors occur in attempting to swap a process in or out, the system
is halted. The device drivers usually make 10 retries when an error occurs,
so that any swap I/O that terminates abnormally for the Scheduler is
assumed to be an unrecoverable hardware error.
.
.LP
The Scheduler, having finished swapping a process in or out, cycles back to
begin its search (1) for processes to bring into memory. The age
requirements placed on processes that can be swapped in or out prevent the
Scheduler from thrashing.
.
.LP
In conjunction with the criteria established for swapping a process in or
out of memory, the Scheduler is always notified when an in core process
goes into the WAIT state . This is done only when the Scheduler cannot find
enough memory to bring a process on the swap device into memory. The
notification results in the Scheduler being the next process (the Scheduler
always has the highest priority) to run and the roadblocked process will
probably be swapped out. When searching the Process Table it is necessary
to raise the Processor's priority to 6 to prevent the status of the
processes being examined from changing.
.sp 1m
.ne 10
.
.LP
.LG
.B setrun
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
setrun(p)
.br
struct proc *p;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Awakens one process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This places the process "p" in the ready state ("p_stat" = SRUN). In
addition, it notifies the Scheduler if the process is not in core and the
Scheduler is waiting, for processes on the swap area to become ready. The
external varialbie "runout" is set when the Scheduler is in that state.
.sp 1m
.ne 10
.
.LP
.LG
.B sleep
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sleep(event, priority)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Roadblocks a process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is the complementary routine to slp.c/wakeup. It synchronizes the
roadblocking and unblocking of a process. When processes under UNIX
relinquish the processor, they post (in "p_wchan") an event whose
occurrence they are awaiting. This "event" is some mutually agreed upon
value (usually an address within the system) which is used to signify the
occurrence of an event. A process also specifies the software priority it
is to be assigned when the "event" occurs. Priorities are values (kept in
"p_pri") which range from a high of -100 to a low of +127, and are used by
the process Switcher in- selecting a process to use the CPU. A process
which relinquishes the CPU at high priority (negative priority) is put in
the sleep state ("p_stat" = SSLEEP), while processes that relinquish the
CPU at low priority (positive priority) are put in the wait state ("p_stat"
= SWAIT). Processes which roadblock at high priority (negative) are
guaranteed to be awakened in a short time (usually determined by device
speed and device queuing), while those that roadblock at a low priority are
not. As such, roadblocking is handled differently for the two cases of
priorities.
.
.LP
For processes that roadblock at high priority, no precautions need be
taken, so that the process Switcher (slp.c/swtch) is simply called. Before
doing this, however, the processor's priority is lowered to zero (the
processor's priority is saved first), so that all pending interrupts may be
processed. This is done because any pending inter-. rupt may awaken a
roadblocked process, thereby producing another candidate for the process
Switcher. It is assumed that the process will be blocked for only a short
period of time so that signal processing is delayed until the process is
awakened and the system call that the awakened process was making is
completed. (i.e., the trap handler checks for the presence of a signal).
.
.LP
Processes that roadblock at tow priority may be roadblocked for a long
period of time (e.g., wait-. ing for a child process to terminate, etc.),
so that it is necessary to check (sig.c/issig) whether any signals are
pending for the process before and after it is roadblocked. If a signal is
pending and is to be handled by the user process, then a nonlocal goto
(mch.s/aretu) is executed to abort the system call and return control to
the trap handler. As with the high priority case, the processor's priority
is lowered before the process Switcher is called to process all pending
interrupts.
.sp 1m
.ne 10
.
.LP
.LG
.B swtch
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
swtch()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A one is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The process Switcher.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Selection of a process to use the CPU is a distinct operation from that of
selecting a process to be brought into memory (slp.c/sched). The Scheduling
process uses the age ("p_time") of a process in determining whether a
process should be swapped in or out of memory. The process Switcher uses
the priority ("p_pri") of a process as its sole basis for selection. Of
course, it can only select from among processes that are already in core
and are ready to execute.
.
.LP
Since changing execution from one process to another entails changing U
blocks, and thereby changing system stacks, a problem arises in making the
transition from one U block to another. The dilemma Occurs because there
may occur a situation in which only one process can fit in core. There
would then be no place for the system's stack in the interim that when no
user process was in memory. Also, if the U block of the current process is
retained, even though there may be no other processes to run, all of the
system time during the idle period would be accrued to that process unless
special arrangements were made. Conceptually, it is also nicer to totally
disassociate the system from a process which is relinquishing the CPU. To
this end, when the slp.c/swtch function is executed, the Scheduler's U
block is grabbed and used until a new process is found. If none are
available, the processor is placed in the wait state (by the WAIT
instruction) until a process goes into the ready state. In this manner, all
processor idle time is accrued to the Scheduler.
.
.LP
The process Switcher must be made unbiased in the sense that it must not
give preference to one of several processes with the same priority
("p_pri") due to any positional advantage in the Process Table. To do this,
the identity of the process selected by the process Switcher is remembered
and the search for a new process to execute is started at this entry in the
Process Table. In this way, Round Robin service is given to processes with
the same priority.
.
.LP
The steps in the selection of a ready process are:
.
.LP
1. The context of the process relinquishing the CPU is saved (mch.s/savu)
in the appropriate place in the U block "u_rsav".
.
.LP
2. The U block belonging to the Scheduler is obtained (mch.s/retu) for use
as the system stack. As the Scheduler is simply another process to the
process Switcher and as the process Switcher must be executed before the
Scheduler runs, the Scheduler's stack is cleared off and is not affected by
the Switcher using it.
.
.LP
3. The Process Table is examined to find a process in memory ("p_flag" =
SLOAD) with the highest priority that is ready ("p_stat" = SRUN). The
search begins at the entry in the Process Table succeeding that of the
currently running process and continues (wrapping around the Process Table)
until the entry for the currently running process is reached. The highest
priority process (lowest value of "p_pri") is selected.
.
.LP
4. If there are no ready processes, then the processor is placed in the
wait state (by calling mch.s/idle). The processor will remain in this state
until the first interrupt occurs. Since interrupts usually awaken some
roadblocked process, there is a good chance that a process will become
ready after the interrupt is processed. When a return from the mch.s/idle
function occurs, the search is reinitiated and begins with the same Process
Table entry as before.
.
.LP
5. Once a process has been selected, it's U block is obtained (mch.s/retu)
for the system stack.
.
.LP
6. The User Memory Management registers for the selected process are loaded
from the prototype registers ("u_uisan", "u_uisdn").
.
.LP
7. In most cases the process being restarted was roadblocked by calling
slp.c/sleep, which caused the process's context to be saved (see I above).
To restart these processes, the context is restored from "u_rsav" and a
return from slp.c/swtch restarts it. Sonic processes, however, relinquish
the processor in order to swap themselves out (slp.c/expand), or to create
a new process (sys.c/fork). The functions that do this usually contain two
algorithms, one for use when there is enough available memory to perform
the operation and the second for use when the operation must be done on the
swap device. These processes need to regain control at a point other than
that specified by "u_rsav" so that a nonlocal goto (mch.s/aretu) is done if
the swap flag (SSWAP in "p_flag") is set. The return executed by
slp.c/swtch will not return to the caller of slp.c/swtch, but will return
from the function that last saved the context in the array "u_ssav". This
is extremely useful,in doing in memory expansions of a process and in
spawning and restarting new processes (sys1.c/fork).
.
.LP
A one is returned by the process Switcher to distinguish parent and child
processes (see slp.c/newproc)). The sys1.c/fork function will thus have a
one returned from the child process and zero returned by the parent (from
slp.c/newproc) and will use this in resetting accumulated execution times
for the child. The main.c/main function also uses this returned value in
the process of spawning the INIT process.
.sp 1m
.ne 10
.
.LP
.LG
.B wakeup
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
wakeup(event)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Awakens roadblocked processes.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is the complementary function to slp.c/sleep. It places processes that
are roadblocked waiting for "event" to occur in the ready state ("p_state"
SRUN). A simple scan of the Process Table checking the "p_wchan" entry
versus "event" shows which processes should be awakened. It is the
responsibility of the awakened process to insure that the event has
actually occurred. Slp.c/setrun is called to place an individual process in
the ready state ("p_pri" = SRUN). If any process is awakened, the "runrun"
flag is set. This is a flag checked by the interrupt and trap handlers.
Setting this flag allows the currently executing process to be preempted
once the interrupt or system call is completed. Since the operating system
is not reentrant, this scheme is necessary so that preemption may be done.
Preemption as the result of a wakeup (usually a wakeup is sent by an
interrupt handler) is only allowed at the end of an interrupt if the
interrupt occurred while the processor was in User mode. Preemption is also
allowed at the end of a system call.
