ul.o kill.o
	$(AR) r tmp.a ladd.o ldfps.o link.o locv.o longops.o ltod.o
	$(AR) r tmp.a makdir.o mcount.o mknod.o mktemp.o \
			mon.o mount.o nice.o nlist.o
	$(AR) r tmp.a perror.o pipe.o printf.o ptrace.o putc.o qsort.o reset.o
	$(AR) r tmp.a setgid.o setuid.o signal.o sleep.o snstat.o stime.o \
			stty.o sync.o time.o times.o
	$(AR) r tmp.a umount.o unlink.o wait.o close.o creat.o errlst.o \
			exit.o ffltpr.o getc.o getchr.o
	$(AR) r tmp.a getpid.o itol.o lseek.o nargs.o open.o prof.o \
			putchr.o read.o sbrk.o seek.o tell.o
	$(AR) r tmp.a stat.o write.o cerror.o csv.o ltoi.o setjmp.o _exit.o
	$(AR) r tmp.a acct.o cleanup.o setpgrp.o \
			strlen.o strcpy.o strcat.o strcmp.o
	-chmod 644 tmp.a
	mv tmp.a libc.a


#------
# in_libc.a: Create libc.a, if it isn't already, and move it to $(LIB)/libc.a.
#------
in_libc.a: libc.a
	-mv $(LIB)/libc.a $(LIB)/$(DD)libc.a
	mv libc.a $(LIB)/libc.a
	-chown bin $(LIB)/libc.a
	-rm -f $(LIB)/$(DD)libc.a
	ls -l $(LIB)/libc.a


#------
# in_crt0: Create & install crt0.o, fcrt0.o, mcrt0.o.
#------
in_crt0: crt0.o fcrt0.o mcrt0.o
	-chmod 644 crt0.o fcrt0.o mcrt0.o
	mv crt0.o $(LIB)/crt0.o
	mv fcrt0.o $(LIB)/fcrt0.o
	mv mcrt0.o $(LIB)/mcrt0.o
	-chown bin $(LIB)/crt0.o $(LIB)/fcrt0.o $(LIB)/mcrt0.o
	ls -l $(LIB)/crt0.o $(LIB)/fcrt0.o $(LIB)/mcrt0.o


#------
# clean: Remove all .o files.
#------
clean:
	-rm -f abort.o abs.o access.o alarm.o alloc.o area.o atof.o atoi.o atol.o
	-rm -f chdir.o chmod.o chown.o ctime.o dup.o execl.o execv.o exect.o rin.o
	-rm -f fltpr.o fork.o fstat.o getcsw.o getgid.o getpw.o \
			getuid.o gtty.o hmul.o kill.o
	-rm -f ladd.o ldfps.o link.o locv.o longops.o ltod.o
	-rm -f makdir.o malloc.o mcount.o mknod.o mktemp.o \
			mon.o mount.o nice.o nlist.o
	-rm -f perror.o pipe.o printf.o ptrace.o putc.o qsort.o reset.o
	-rm -f setgid.o setuid.o signal.o sleep.o snstat.o stime.o \
			stty.o sync.o time.o times.o
	-rm -f umount.o unlink.o wait.o close.o creat.o errlst.o \
			exit.o ffltpr.o getc.o getchr.o
	-rm -f getpid.o itol.o lseek.o nargs.o open.o prof.o \
			putchr.o read.o sbrk.o seek.o tell.o
	-rm -f stat.o write.o cerror.o csv.o ltoi.o setjmp.o _exit.o
	-rm -