/*
 *	This file contains all the definitions and declarations to be included
 *	with all the password management routines.
 */

#ifndef	TYPES_DEFINED
#include	<types.h>
#endif
#ifndef	AUSAM
#include	<local-system>
#endif
#include	<lnode.h>		/* definitions of limits structure */

/*
**	various file names
*/

#define	ETCPASSWD	"/etc/passwd"	/* the passwd file name */

/*
**	Various things to do with the passwd file
*/

/*	typedefs	*/
#ifdef	TTY_GROUPS
typedef unsigned short	tmask_t;
#endif	TTY_GROUPS
typedef unsigned short	pages_t;
typedef long		pwaddr_t;

/*	elements of the string array	*/
#define	LNAME		0	/* the login name element in "pw_strings" */
#define	DIRPATH		1	/* the initial directory path name in ditto */
#define	SHELLPATH	2	/* the initial shell pathname in ditto */
#define	FIRSTNAME	3	/* the users firstname element in ditto */
#define	LASTNAME	4	/* the users lastname element in ditto */
#define	OTHER		5	/* the other element in ditto */

/*	various handy values	*/
#define	PWTABENTLEN	(sizeof (pwaddr_t))	/* the size of a table entry */
#define PWSLENCNT	6	/* the number of var len string ptrs */
#define	PWTABSIZE	NUSERS	/* the total possible number of users */
#define	PWHASHSIZE	1009	/* the hashing function range */
#define	CRYPTLEN	13	/* bytes in encrypted password */
#define	PWTABLEN	((PWTABSIZE+PWHASHSIZE)*PWTABENTLEN)
#define	PWENTNULL	0L	/* password null entry signifier */
#define	PWERROR		(-1)	/* error return from passwd routines */
#define PWENTLEN	(sizeof (struct pwent))
#define	PWULIMIT	MAXULIM	/* max size in blocks of the passwd file ? */
#define	MINUSAGE	1e6			/* minimum meaningful usage */

/*
**	the actual shape of a passwd entry
*/

struct pwent
{
	pwaddr_t	pw_next;		/* seek address of next entry in list */
	pwaddr_t	pw_last;		/* seek address of previous entry in list */
	struct lnode	pw_limits;		/* memory resident limits */
	uid_t		pw_gid;			/* real group id */
#	ifdef	TTY_GROUPS
	tmask_t		pw_tmask;		/* user terminal group mask */
#	endif	TTY_GROUPS
	time_t		pw_age;			/* last time the password was changed */
	time_t		pw_contime;		/* total accumulated connect time */
	time_t		pw_cputime;		/* total accumulated cpu time */
	time_t		pw_extime;		/* time at which last limit struct freed */
						/* ie the last time the user did anything */
	pages_t		pw_pages;		/* line printer pages limit */
	pages_t		pw_pgused;		/* line printer pages used */
#	ifdef	TERMBOOK
	short		pw_tblim;		/* usage limit ,sets transient booking limit */
	short		pw_tbrate;		/* rate of penalty for booking */
#	define	TBCREDIT	2		/* credit for 1 period off , thank you ! */
#	endif	TERMBOOK
	short		pw_xflags;		/* extra flags (non-limits) */
	char		pw_reason;		/* reason for eviction */
	char		pw_warn;		/* number of warnings, eg re disc space */
	char		pw_pword[CRYPTLEN];	/* encrypted password */
	char		*pw_strings[PWSLENCNT];	/* variable length string pointers */
};

/*
**	some useful 'passwd' defines 
*/

#define	NDLIMWARN	3	/* max number of disk limit exceeded warnings before getting nasty */
#define	SSIZ		200	/* a goodly size string buffer for "getpwuid" & "getpwlog" */
#define	LOGLEN		100	/* max size of login name checked */
#define	PASSWDZ		133	/* max size of passwd for routines that do not alloc */

/*
**	Extra flags
*/

#define	NONEWGRP	01	/* user may not use 'newgrp' */
#define	NOPASSWD	02	/* user may not set password */
#define	USENET		04	/* permission to use Unix Net */

/*
**	some compatibility defines
*/

#define	pw_uid		pw_limits.l_uid
#define	pw_shares	pw_limits.l_shares
#define	pw_usage	pw_limits.l_usage
#define	pw_flags	pw_limits.l_flags
#define	pw_dlimit	pw_limits.l_dlimit
#define	pw_doverflw	pw_limits.l_doverflw
#define	pw_plimit	pw_limits.l_plimit
#define	pw_mlimit	pw_limits.l_mlimit
#define	pw_mplimit	pw_limits.l_mplimit
#define	pw_cmask	pw_limits.l_cmask
