/*
 * The I node is the focus of all
 * file activity in unix. There is a unique
 * inode allocated for each active file,
 * each current directory, each mounted-on
 * file, text file, and the root. An inode is 'named'
 * by its dev/inumber pair. (iget/iget.c)
 * Data, from mode on, is read in
 * from permanent inode on volume.
 * The block address coding is described in ino.h
 */

#define	NADDR	13		/* number of block addresses (each 3 bytes) */

struct	inode
{
	char	i_flag;
	char	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	unsigned short	i_mode;
	short	i_nlink;	/* directory entries */
	short	i_uid;		/* owner */
	short	i_gid;		/* group of owner */
	off_t	i_size;		/* size of file */
	char   i_addr[NADDR*3];	/* if normal file/directory */
	char	i_pad;		/* not used! */
	daddr_t	i_lastr;	/* last logical block read (for read-ahead) */
	char	i_lockf;	/* flags for locking */
	char	i_lockc;	/* count of active readers */
};


/* flags */
#define	ILOCK	01		/* inode is locked */
#define	IUPD	02		/* file has been modified */
#define	IACC	04		/* inode access time to be updated */
#define	IMOUNT	010		/* inode is mounted on */
#define	IWANT	020		/* some process waiting on lock */
#define	ITEXT	040		/* inode is pure text prototype */
#define	ICHG	0100		/* inode has been changed */

/* modes */
#define	IFMT	0170000		/* type of file */
#define		IFIFO	0010000	/* pipe */
#define		IFCHR	0020000	/* character special */
#define		IFDIR	0040000	/* directory */
#define		IFBLK	0060000	/* block special */
#define		IFREG	0100000	/* regular */
#define		IFLOK	0110000	/* locking protocol required */
#define		IFALK	0120000	/* locking protocol automatic on open */
#define	ISUID	04000		/* set user id on execution */
#define	ISGID	02000		/* set group id on execution */
#define ISVTX	01000		/* save swapped text even after use */
#define	IREAD	0400		/* read, write, execute permissions */
#define	IWRITE	0200
#define	IEXEC	0100

/* locking flags */
#define	L_RLOCK	01		/* locked by one or more readers */
#define	L_WLOCK	02		/* locked by a writer */
#define	L_WAIT	04		/* something waiting for write to finish */
#define	L_PHLOK	010		/* phony lock for non-owner */
