/ Startup code for two-stage bootstrap

/ non-UNIX instruction
trap	= 104400

.globl	_end
.globl	_main
start:
	reset
	mov	$340,PS		/ priority level 7
	mov	$140100,sp	/ max. size this pgm 0140000

/ set kernel I+D to physical 0 and IO page
	clr	r1
	mov	$77406,r2
	mov	$KISA0,r3
	mov	$KISD0,r4
	jsr	pc,setseg
	mov	$IO,-(r3)
	clr	r1
	mov	$KDSA0,r3
	mov	$KDSD0,r4
	jsr	pc,setseg
	mov	$IO,-(r3)

/ set user I+D to physical 64K (words) and IO page
	mov	$4000,r1	/ 2 address spaces
	mov	$UISA0,r3
	mov	$UISD0,r4
	jsr	pc,setseg
	mov	$IO,-(r3)
	mov	$4000,r1
	mov	$UDSA0,r3
	mov	$UDSD0,r4
	jsr	pc,setseg
	mov	$IO,-(r3)

/ set up unibus map
	mov	$UBMAP,r1
	clr	r2
	clr	r3
	mov	$31., r4
1:	mov	r2,(r1)+
	mov	r3,(r1)+
	add	$20000,r2
	adc	r3
	sob	r4,1b

/ enable maps
	mov	$65,SSR3	/ 22-bit, Unibus map, enable K+U D-spaces
	bit	$20,SSR3	/ only 11/70 has this bit
	beq	1f
	mov	$3,MSCR		/ disable Unibus + Non-fatal traps
1:
	mov	$30340,PS	/ previous mode User
	inc	SSR0		/ enable memory management


/ copy program to user I space
	mov	$_end,r0
	clc			/ clear c-bit
	ror	r0		/ halve unsigned size
	clr	r1
1:
	mov	(r1),-(sp)
	mtpi	(r1)+
	sob	r0,1b


/ continue execution in user space copy
	mov	$140004,sp
	clr	*$KDSA6		/ stack at abs. 0, 2
	mov	$140340,-(sp)	/ current User, previous Kernel
	mov	$user,-(sp)
	rtt
user:
	mov	$_end+512.,sp	/ initialise user sp
	mov	sp,r5

	jsr	pc,_main	/ enter main pgm at level 7

	trap

	br	user

setseg:
	mov	$8,r0
1:
	mov	r1,(r3)+
	add	$200,r1
	mov	r2,(r4)+
	sob	r0,1b
	rts	pc

/ setseg(addr)
.globl	_setseg
_setseg:
	mov	2(sp),r1
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	mov	$77406,r2
	mov	$KISA0,r3
	mov	$KISD0,r4
	jsr	pc,setseg
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc

/ clrseg(addr,count)
.globl	_clrseg
_clrseg:
	mov	4(sp),r0	/ count
	beq	2f
	clc
	ror	r0		/ halve unsigned count
	mov	2(sp),r1	/ addr
1:
	clr	-(sp)
	mtpi	(r1)+
	sob	r0,1b
2:
	rts	pc


/ mtpi(word,addr)
.globl	_mtpi
_mtpi:
	mov	4(sp),r0
	mov	2(sp),-(sp)
	mtpi	(r0)+
	rts	pc

.globl	__rtt
__rtt:
	halt

PS	= 177776
SSR0	= 177572
SSR3	= 172516
KISA0	= 172340
KISD0	= 172300
KDSA0	= 172360
KDSA6	= 172374
KDSD0	= 172320
UISA0	= 177640
UISD0	= 177600
UDSA0	= 177660
UDSD0	= 177620
MSCR	= 177746	/ 11/70 memory control register
IO	= 177600
UBMAP	= 170200

.data
