#include "cplot.h"

#ifdef	COARSE
#define	RSXMAX	(SXMAX)		/* receive screen x max. */
#define	RSYMAX	(SYMAX)		/* receive screen y max. */
#else
#define	RSXMAX	(SXMAX / 4)	/* receive screen x max. */
#define	RSYMAX	(SYMAX / 4)	/* receive screen y max. */
#endif

char ucursor(x,y)
float *x,*y;
{
	char g_buf[CURSBUFSIZE];

	register int i;
	g_alpha();

	g_ekoff();
	for( i=1; i<g_syncs; i++ )
		putc( SYNC, stdout );

	fputs( CURSREAD, stdout );
	fflush(stdout);
	fgets( g_buf, CURSBUFSIZE, stdin );	/* TERMINAL MUST SUPPLY CR AT END OF TRANSMISSION */

	if( feof(stdin) )
	{
		fgets( &g_buf[1], CURSBUFSIZE - 1, stdin );
		g_buf[0] = EOF;
	}
	/*  reconstruct x in user co-ords  */
	*x = (((g_buf[1]&MASK)<<5) | (g_buf[2]&MASK)) * (g_xhi - g_xlo) / RSXMAX  + g_xlo;

	/*  reconstruct y in user co-ords  */
	*y = (((g_buf[3]&MASK)<<5) | (g_buf[4]&MASK)) * (g_yhi - g_ylo) / RSYMAX + g_ylo;

	g_ekon();
	return(g_buf[0]);
}
