/*
 *	execlp(name, arg,...,0)	(like execl, but does path search)
 *	execvp(name, argv)	(like execv, but does path search)
 */
#include <errno.h>
#define	NULL	0

static	char shell[] =	"/bin/sh";
char	*execat(), *getenv();
extern	errno;

execlp(name, argv)
char *name, *argv;
{
	return(execvp(name, &argv));
}

execvp(name, argv)
char *name, **argv;
{
	char *pathstr;
	register char *cp;
	char fname[128];
	char *newargs[256];
	int i;
	register unsigned etxtbsy = 1;
	register eacces = 0;

	if ((pathstr = getenv("PATH")) == NULL)
		pathstr = geteuid()? ":/bin": "/etc/bin:/bin";
	cp = strchr(name, '/')? "": pathstr;

	do {
		cp = execat(cp, name, fname);
	retry:
		execv(fname, argv);
		switch(errno) {
		case ENOEXEC:
			pxobj(fname, argv);	/* could be a Pascal obj */
			newargs[0] = "sh";
			newargs[1] = fname;
			for (i=1; newargs[i+1]=argv[i]; i++) {
				if (i>=254) {
					errno = E2BIG;
					return(-1);
				}
			}
			execv(shell, newargs);
			return(-1);
		case ETXTBSY:
			if (++etxtbsy > 5)
				return(-1);
			sleep(etxtbsy);
			goto retry;
		case EACCES:
			eacces++;
			break;
		case ENOMEM:
		case E2BIG:
			return(-1);
		}
	} while (cp);
	if (eacces)
		errno = EACCES;
	return(-1);
}

static char *
execat(s1, s2, si)
register char *s1, *s2;
char *si;
{
	register char *s;

	s = si;
	while (*s1 && *s1 != ':' && *s1 != '-')
		*s++ = *s1++;
	if (si != s)
		*s++ = '/';
	while (*s2)
		*s++ = *s2++;
	*s = '\0';
	return(*s1? ++s1: 0);
}

#define	PASCOBJ	0404		/* Pascal interpreter required */
pxobj(p, t)
register char *p;
register char *t[];
{
	register fd, n;
	int magwd;
	char *arglst[50];	/* arbitrary I agree..... */

	if ((fd = open(p, 0)) == -1)
		return;
	n = read(fd, &magwd, 2);
	close(fd);
	if (n == 2 && magwd == PASCOBJ)
	{
		arglst[0] = "px";
		arglst[1] = p;
		for (n = 2; n < (sizeof(arglst)/(sizeof(char *))-1); n++)
			if ((arglst[n] = t[n-1]) == 0)
				break;
		arglst[n] = 0;
		execv("/bin/px", arglst);
		exit(-1);
	}
}
