#include	<param.h>	/* for NMOUNT */
#include	<stdio.h>
#include	<mtab.h>
#include	<errno.h>
#include	<stat.h>

struct	mtab mtab[NMOUNT];
char mtabf[] = MTABF;
char *devd =	"/dev/xxxxxxxxxxxxxx";
int errortotal;

main(argc, argv)
char **argv;
{
	register struct mtab *mp;
	register char *p1, *p2;
	int n, m, mf;
	extern int errno;
	struct stat sb;
	char outbuf[BUFSIZ];
	char *strcat();

	setbuf(stdout, outbuf);
	if (argc < 2)
	{
		fprintf(stderr, "Usage: umount devname|rootdir ...\n");
		exit(1);
	}
	if ((mf = open(mtabf, 0)) == -1)
	{
		perror(mtabf);
		exit(1);
	}
	n = read(mf, mtab, sizeof mtab);
	if (n % sizeof mtab[0])
	{
		fprintf(stderr, "%s: wrong format?\n", mtabf);
		exit(1);
	}
	close(mf);
	sync();		/* done by the system anyway... */
	m = 0;
	for (p2 = *++argv; --argc; p2 = *++argv)
	{
		if (stat(p2, &sb) == -1)
		{
			perror(p2);
			errortotal++;
			continue;
		}
		n = 0;
		switch(sb.st_mode & S_IFMT)
		{
	    case S_IFDIR:
			if (sb.st_ino != ROOTINO)
			{
				fprintf(stderr, "%s: not a filesystem rootdir\n", p2);
				errortotal++;
				continue;
			}
			devd[5] = 0;
			for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
				if (strcmp(p2, mp->m_file) == 0)
				{
					p1 = mp->m_spec;
					p2 = strcat(devd, p1);
					n++;
					break;
				}
			if (n == 0)
			{
				fprintf(stderr, "%s: not in mount table\n", p2);
				errortotal++;
				continue;
			}
			break;

	    case S_IFBLK:
			p1 = p2;
			while (*p1++);
			p1--;
			while (*--p1 == '/')
				*p1 = 0;
			while (p1 > p2 && *--p1 != '/');
			if (*p1 == '/')
				p1++;
			break;

	    default:
			fprintf(stderr, "%s: not a block device or filesystem root\n", p2);
			errortotal++;
			continue;
		}

		if (umount(p2))
		{
			if (errno == EINVAL)
				fprintf(stderr, "%s: Device not currently mounted\n", p2);
			else
			{
				perror(p2);
				errortotal++;
			}
			continue;
		}
		/*
		 * Scan through mount table for ALL entries that match
		 * (mount tables frequently contain junk)
		 */
		n = 0;
		for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
		{
			if (strcmp(p1, mp->m_spec) == 0)
			{
				mp->m_file[0] = 0;
				n++;
				m++;
			}
		}
		if (n == 0)		/* not found at all */
			fprintf(stderr, "%s: not in mount table\n", p2);
	}
	if (m != 0)			/* rewrite mount table */
	{
		if ((mf = creat(mtabf, 0644)) == -1)
		{
			perror(mtabf);
			exit(errortotal + 1);
		}
		for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
			if (*mp->m_file)
				write(mf, mp, sizeof mtab[0]);
	}
	exit(errortotal);
}
