/*
 *	core dumper for macro jobs
 */

#include <param.h>
#include <signal.h>
#include <dir.h>
#include <user.h>
#include <a.out.h>
#include <stdio.h>

#define	WDSPERLN	8	/* words per line of output */
#define	TLIMIT		15	/* time limit on student jobs */

struct exec hdr;

struct			/* layout of registers in top of core dump */
{
	unsigned r2;
	unsigned r3;
	unsigned r4;
	unsigned r5;
	unsigned pad0;		/* junk */
	unsigned pad1;		/* more junk */
	unsigned r6;
	unsigned r1;
	unsigned pad2;		/* still more junk */
	unsigned r0;
	unsigned r7;
	unsigned psw;
} regs;

unsigned *oregs[] =	/* ordered register table */
{
	&regs.r0,
	&regs.r1,
	&regs.r2,
	&regs.r3,
	&regs.r4,
	&regs.r5
};
#define	NREGS	(sizeof oregs / sizeof oregs[0])

int	cored;
int	aoutd;
unsigned address;
unsigned corrupt;

char	core[] = "core";
char	m_out[] = "m.out";

char	duplicated[] = "\t\t\t. . . DUPLICATED . . .\t\t\t. . . DUPLICATED . . .\n";
char	monitor[] =	"\t\t\t. . . MONITOR . . .\t\t\t. . . MONITOR . . .\n";


char	error[] =	"error$";	/* byte quantity */
char	*magics[] =
{
	"smon$",		/* must be first */
	"emon$",		/* must be second */
	"mn1$",
	"mn2$",
	"mn3$",
	"mn4$",
	"mn5$"
};
#define	NMAGIC	(sizeof magics / sizeof magics[0])

char	*errmsgs[NSIG] =
{
	"hangup",
	"interrupt",
	"quit",
	"illegal instruction",
	"bpt trap",
	"iot trap",
	"emt trap",
	"floating point error",
	"killed",
	"odd address for word",
	"address out of range",
	"trap trap",
	"bad sys call",
	"real time limit",
	"soft kill",
	"cpu time limit",
	"memory parity",
	0,
};


main(ac, av)
char **av;
{
	register status, cordmp;
	char	outbuf[BUFSIZ];		/* output buffer */
	struct user u;
	unsigned find();

	setbuf(stdout, outbuf);
	status = 0;
	cordmp = 0;
	if (ac >= 2)
	{
		status = (av[1][0] - '0') * 64;
		status += (av[1][1] - '0') * 8;
		status += (av[1][2] - '0');
	}
	if (status & 0200)
		cordmp++;
	status &= 0177;
	if (status == 0 || status > NSIG)
	{
		printf("Impossible error 0%o - show a guru\n", status);
		exit(1);
	}
	if (!cordmp)
	{
		printf("%s\n", errmsgs[status - 1]);
		exit(0);
	}
	if ((cored = open(core, 0)) == -1)
	{
		perror(core);
		exit(1);
	}
	if ((aoutd = open(m_out, 0)) == -1)
	{
		perror(m_out);
		exit(1);
	}
	read(cored, (char *)&u, sizeof u);
	/*
	 * extract registers from stack in core dump
	 */
	lseek(cored, (long)(ctob(USIZE) - sizeof regs), 0);
	read(cored, (char *)&regs, sizeof regs);
	read(aoutd, (char *)&hdr, sizeof hdr);
	dumpreason(status);
	dumpregs();
	lseek(cored, (long)(ctob(USIZE)), 0);	/* address of beginning of core image */
	printf("contents of core:\n======== == ====\n\n");
	address = 0;
	if (!corrupt)
	{
		dumpto(find(magics[0]) - ctob(USIZE));	/* first in magics must be start of mon */
		printf(monitor);	/* Do not dump the monitor core normally */
		address = find(magics[1]) - ctob(USIZE);	/* magics[1] defined as end of monitor */
		address &= ~(WDSPERLN * 2 - 1);
		lseek(cored, (long)address + (long)(ctob(USIZE)), 0);
	}
	dumpto(u.u_dsize<<6);
	printf("\ncontents of stack\n======== == =====\n\n");
	address = - u.u_ssize << 6;
	dumpto(0177777);	/* dump to top of stack */
	exit(0);
}

dumpreason(why)
{
	register int i;
	int word;
	unsigned find();

	corrupt = 0;
	for (i = 0; i < NMAGIC; i++)
	{
		lseek(cored, (long)find(magics[i]), 0);
		if ((read(cored, (char *)&word, sizeof word) != sizeof word) ||
		    ( word != A_MAGIC1))
			corrupt++;
	}
	if (corrupt)
		printf("\014monitor obliterated.");
	else
	{
		lseek(cored, (long)find(error), 0);
		read(cored, &word, sizeof word);
		word &= 0377;		/* it is only a byte */
		/*
		 * if word is non-zero, the core dump was deliberately
		 * generated - do not print out message
		 */
		if (word)
			printf("Deliberate monitor abort");
		else
			printf(errmsgs[why - 1]);
	}
	printf("\n\n\n");
}

dumpregs()
{
	register char rno;

	printf("contents of registers\n======== == =========\n\n");
	for (rno = 0; rno < NREGS; rno++)
	{
		printf("r%c\t%06o\t", rno + '0', *oregs[rno]);
		character(*oregs[rno]);
		putchar('\n');
	}
	printf("sp\t%06o\n", regs.r6);
	printf("pc\t%06o\n", regs.r7);
	printf("ps\t%06o\n\n", regs.psw);
}

dumpto(where)
unsigned where;
{
	int	inbuf[WDSPERLN];
	int	lastline[WDSPERLN];
	register int i, *j, *k;
	int dupcount;

	if (where <= address)
		return;
	dupcount = 0;
	read(cored, (char *)&inbuf[0], sizeof inbuf);
	k = inbuf;
	printf("%06o\t\t", address);
	for (k = lastline, j = inbuf; j < &inbuf[WDSPERLN]; j++ , k++)
	{
		printf("%06o\t", *j);
		*k = *j;	/* initialises the lastline. */
	}
	putchar('\t');
	for (k = inbuf; k < &inbuf[WDSPERLN]; k++)
		character(*k);
	address += sizeof inbuf;	/* bytes */
	putchar('\n');
	/*
	 *	first line done. now dump the rest...
	 */
	while (address < where)
	{
		read(cored, (char *)&inbuf[0], sizeof inbuf);
		/*
		 * check for the line being the same
		 */
		i = 0;
		k = inbuf;
		j = lastline;
		while (*k++ == *j++ && i < WDSPERLN)
			i++;
		if (i == WDSPERLN)
			dupcount++;
		else
			dupcount = 0;
		if (dupcount == 1)
			printf(duplicated);
		else if (dupcount == 0)
		{
			printf("%06o\t\t", address);
			for (k = lastline, j = inbuf; j < &inbuf[WDSPERLN]; j++ , k++)
			{
				*k = *j;	/* reinitialise lastline */
				printf("%06o\t", *j);
			}
			putchar('\t');
			for (j = inbuf; j < &inbuf[WDSPERLN]; j++)
				character(*j);
			putchar('\n');
		}
		address += sizeof inbuf;
		if (address == 0)		/* wrapped around */
			break;
	}
}

unsigned
find(s)
char	*s;
/*
 *	finds a symbol in the a.out file, and returns its
 *	address relative to the start of the core image
 */
{
	struct nlist sym;
	register char *cp1, *cp2;
	long offset;

	offset = (long)hdr.a_data + (long)hdr.a_text;
	if (hdr.a_flag == 0)
		offset <<= 1;
	offset += (long)(sizeof(struct exec));
	lseek(aoutd, offset, 0);
	/*
	 * now at start of symbol table
	 */
	while (read(aoutd, (char *)&sym, sizeof sym))
	{
		cp1 = s;
		cp2 = &sym.n_name[0];
		while (*cp1 == *cp2)
			if (*cp1)
			{
				cp1++;
				cp2++;
			}
			else
				return(sym.n_value + ctob(USIZE));
	}
	printf("%s: symbol not found in symbol table\n", s);
	exit(1);
}

character(w)
unsigned w;
{
	register char c;
	register int i;

	i = w;
	for (w = 0; w < 2; w++)
	{
		c = i;
		if (c >= 040 && c < 0177)
			putchar(c);
		else if (c == '\n')
		{
			putchar('\\');
			putchar('n');
		}
		else
			putchar('?');
		i >>= 8;		/* shift to upper byte */
	}
}
