h00963
s 00171/00000/00000
d D 1.1 81/03/03 09:42:58 root 1 0
e
u
U
t
T
I 1
#
/*
 *	This prints info on those people whose class is the 1st arg
 *	As well though, it outputs the people in a for suitable for
 *	UNSW type class rolls.
 *	Output is for a Qume Sprint 5/55, in 12 pitch mode.
 *
 *		printc class
 */

#include	<local-system>
#include	<stdio.h>
#include	<passwd.h>
#include	<class.h>

/*	global vars	*/

struct pwent	pe;

main(argc, argv)
int	argc;
char	**argv;
{
	extern char	*malloc();
	extern unsigned	*match();

	register int	rn, rm;
	register unsigned	rsum;
	char	*area;



	if(argc-- != 2)
	{
		printf("printc classname\n");
		fflush(stdout);
		exit(0);
	}
	argv++;

	if((match(*argv)) == 0)
	{
		printf("no such class\n");
		fflush(stdout);
		exit(0);
	}

	for(rm=0; rm<PWTABSIZE; rm++)
	{
		/* now for all the people, check the bits........ */
		pe.pw_uid = rm;

		if(( getpwlog(&pe, (char *)0, 0) < 0) || !maskcomp())
		{
			continue;
		}

		area=(char *)0;
		rsum=0;
		for(rn=0; rn<PWSLENCNT; rn++)
		{
			rsum += (unsigned)(pe.pw_strings[rn]);
		}

		if((area = malloc(rsum)) == 0)
		{
			printf("no more core\n");
			fflush(stdout);
			exit(1);
		}

		if(getpwlog(&pe, area, (int)rsum) <= 0)
		{
			printf("password file corrupted\n");
			fflush(stdout);
			exit(1);
		}
		else
		{
			output();
		}

		free(area);
	}
}

/*****************************************************************************/


unsigned	cm[CLASSMASKSIZE];

unsigned *match(c)
char	*c;
{
	/*
	 * pattern match the classes, and return composite mask
	 */

	register char	*rc, *rcm;
	register int	rn;
	int	miss;
	int	hit;

	/* have we a null class to look up ? */
	if(*c == '\0') return(0);

	/* clear the global mask */
	for(rn=0; rn<CLASSMASKSIZE; cm[rn++] = 0);

	hit=0;

	for(rn=0; rn<CLASSMASKSIZE*BITSINMASK; rn++)
	{
		/*
			 *	scan down classes
			 *
	 *	ignore the null ones
			 */

		if(classes[rn].c_name[0] == '\0')
			miss = 1;
		else
			miss = 0;

		for(rc=c, rcm=classes[rn].c_name;
		(miss == 0) && (*rc != '\0');
			rc++, rcm++)
		    {
			if(*rc != *rcm) miss++;
		}

		if(miss == 0)
		{
			cm[classes[rn].c_index] |= classes[rn].c_mask;
			hit++;
		}
	}

	if(hit) return(cm);
	return(0);
}
/*****************************************************************************/

maskcomp()
{
	register int	rn;

	for(rn=0; rn<CLASSMASKSIZE; rn++)
		if(pe.pw_cmask[rn] & cm[rn])
			return(1);

	return(0);
}

/*****************************************************************************/

output()
{
	register char	*rc;
	/*	output the buggers	*/

	for(rc=pe.pw_strings[OTHER]; *rc != '\0'; rc++)
		if(*rc == '\n') *rc=',';
	/* output the data correctly */
	printf("%-16.16s%-22.22s%-s\n",
	pe.pw_strings[LASTNAME],
	pe.pw_strings[FIRSTNAME],
	pe.pw_strings[LNAME]
	    );
	fflush(stdout);
}
E 1
