h24875
s 00001/00003/01042
d D 1.2 81/07/24 18:33:38 root 2 1
c miscellaneous
e
s 01045/00000/00000
d D 1.1 81/01/18 12:34:41 root 1 0
e
u
U
t
T
I 1
/*
**	Change limits command.
**
**	Bugs and comments to:	Piers Lauder
**				Dept of Comp Sci
**				Sydney University
**	June '80.
*/

char	limusage[]	= "{action}{+|-|=}{string[,string ...]} {name|uid-uid} ...";


#include	<local-system>
D 2
#include	<sys/param.h>
E 2
I 2
#include	<param.h>
E 2
#include	<passwd.h>
#include	<ttygroup.h>
#include	<class.h>
#include	<stdio.h>
#include	<ctype.h>


#define		RESTRICTED	(ADMIN|GROUPACC)	/* restricted flags */
#define		XRESTRICTED	USENET
#define		RSFLAGS		"Admin, Groupaccount, Usenet"

#define		MINARGS		1
#define		NUMBER		0
#define		CLASSES		1
#define		FLAGS		2
#define		TERMINALS	3
#define		STRING		4
#define		GROUPS		5

#define		STREQUAL	0
#define		NULLSTR		(char *)0
D 2
#define		SSIZ		1024
E 2
#define		MAXNEWGRPS	10
#define		MAXGRPS		100

/*
**	Argument interpretation
*/
char *		name;		/* argument 0 */
int		(*action)();	/* which limit is being changed */
short		mode;		/* increment(+), decrement(-), or set */
char		cmask[CLASSMASKSIZE]; /* the string interpreted as classes */
ushort		flags;		/* the string interpreted as flags */
ushort		xflags;		/* the string interpreted as flags */
tmask_t		tmask;		/* the string interpreted as terminal groups */
char *		string;		/* the string interpreted as a um yes well */
long		size,		/* the string interpreted as a decimal number */
		atol();

/*
**	Possible actions
*/
int
		 class()	/* class mask */
		,connect()	/* connectime */
		,cpu()		/* cputime */
		,dlimit()	/* disk quota */
		,doverflw()	/* disk overflow */
		,duse()		/* disk usage */
		,flag()		/* flags */
		,gid()		/* group id */
		,groups()	/* group membership */
		,home()		/* home directory */
		,mlimit()	/* max memory */
		,mplimit()	/* memory per process */
		,nice()		/* nice */
		,pages()	/* printer */
		,passwd()	/* password */
		,pgused()	/* printer pages used */
		,plimit()	/* max processes */
		,reason()	/* eviction reason */
		,shares()	/* shares */
		,shell()	/* initial shell */
		,terminals()	/* valid terminals groups */
		,tblim()	/* terminal booking limit */
		,tbrate()	/* terminal booking rate */
		,usage()	/* system use */
;

/*
**	Possible explanations
*/

int		 exnull()		/* no explanation available yet */
		,exclasses()		/* explain classes */
		,exflag()		/* explain flags */
		,exreason()		/* explain eviction reasons */
;

/*
**	Command list: search is for a minimum match, so order is important
*/

struct command
{
	char *	cm_name;
	int	(*cm_action)();
	int	(*cm_explain)();
	short	cm_type;
	short	cm_restricted;
}
	commands[] =
{
	 {"classes",	class,		exclasses,	CLASSES}
	,{"connect",	connect,	exnull,		NUMBER}
	,{"cputime",	cpu,		exnull,		NUMBER}
	,{"dlimit",	dlimit,		exnull,		NUMBER}
	,{"doverflw",	doverflw,	exnull,		NUMBER}
	,{"duse",	duse,		exnull,		NUMBER,	1}
	,{"flags",	flag,		exflag,		FLAGS}
	,{"gid",	gid,		exnull,		NUMBER,	1}
	,{"groupmem",	groups,		exnull,		GROUPS,	1}
	,{"home",	home,		exnull,		STRING,	1}
	,{"mlimit",	mlimit,		exnull,		NUMBER,	1}
	,{"mplimit",	mplimit,	exnull,		NUMBER,	1}
	,{"nice",	nice,		exnull,		NUMBER}
	,{"password",	passwd,		exnull,		STRING}
	,{"pgused",	pgused,		exnull,		NUMBER}
	,{"plimit",	plimit,		exnull,		NUMBER,	1}
	,{"printer",	pages,		exnull,		NUMBER}
	,{"reason",	reason,		exreason,	NUMBER}
	,{"shares",	shares,		exnull,		NUMBER,	1}
	,{"shell",	shell,		exnull,		STRING}
	,{"terminals",	terminals,	exnull,		TERMINALS}
	,{"tblim",	tblim,		exnull,		NUMBER}
	,{"tbrate",	tbrate,		exnull,		NUMBER}
	,{"usage",	usage,		exnull,		NUMBER,	1}
};
#define	NCOM	((sizeof commands)/(sizeof commands[0]))

/*
**	Flags
*/

struct Flags
{
	char *	fl_name;
	ushort	fl_val;
	ushort *fl_flgp;
}
	sflags[] =
{
	 {"Admin",		ADMIN,		&flags}
	,{"Classaccount",	CLASSACC,	&flags}
	,{"Dlimit",		DLIMIT,		&flags}
	,{"Groupaccount",	GROUPACC,	&flags}
	,{"asyncKill",		ASYNCKILL,	&flags}
	,{"useLog",		USELOG,		&flags}
	,{"connectliM",		CONNECTLIM,	&flags}
	,{"Nologin",		NOLOGIN,	&flags}
	,{"Oncelogin",		ONCELOGIN,	&flags}
	,{"newPassword",	NEWPASSWD,	&flags}
	,{"Tutor",		TUTOR,		&flags}
	,{"noeVict",		NOEVICT,	&flags}
	,{"daWarn",		DAWARN,		&flags}
	,{"nonewgrp",		NONEWGRP,	&xflags}
	,{"nopassword",		NOPASSWD,	&xflags}
	,{"usenet",		USENET,		&xflags}
D 2
	,{"oldpassword",	OLDPASSWD,	&xflags}
E 2
};
#define		NFLAGS		((sizeof sflags)/(sizeof sflags[0]))

struct pwent	p;
uid_t		myuid;

char *		sbuf;
ushort		sbufsize	= SSIZ;
char *		work;		/* work area pointer */

struct sgrp
{
	char *	grp_s;		/* pointer to group */
	char	grp_m;		/* group membership */
}
		newgroups[MAXNEWGRPS];

short		ngrps;
ushort		groupsize;

extern char *	strchr();
extern unsigned	strlen();
extern char *	realloc();
extern char *	malloc();




main( argc, argv )
	register int	argc;
	register char *	argv[];
{
	register char *	arg;
	register int	i;
	register	c;
	register char *	cp;
	int		type;

	if ( limits(&p.pw_limits, L_MYLIM) == SYSERROR )
	{
		perror("limits");
		return 3;
	}

	myuid = p.pw_uid;

	if ( myuid && !(p.pw_flags&ADMIN) )
	{
		fprintf( stderr, "No permission\n" );
		return 2;
	}

	name = *argv++;
	argc--;

	if ( argc < MINARGS )
	{
		usagerr( (char *)0 );
argerr:
		fprintf(stderr, "Actions:-");
		for ( i = 0 ; i < NCOM ; i++ )
			fprintf(stderr, "%s%s", i%9 ? "," : "\n\t", commands[i].cm_name);
		fprintf(stderr, "\n");
		return 1;
	}

	cp = arg = *argv++;
	argc--;

	for ( i = 0 ; (c = *arg) && i == 0 ; arg++ )
		switch ( c )
		{
		 case '+':	mode = 1;	i = 1;	break;
		 case '-':	mode = -1;	i = 1;	break;
		 case '=':	mode = 0;	i = 1;	break;
		}

	if ( !i )
		exit( usagerr("require {+|-|=}") );

	arg[-1] = '\0';

	for ( i = 0 ; i < NCOM ; i++ )
		if ( compare(cp, commands[i].cm_name) )
		{
			if ( commands[i].cm_restricted && myuid )
			{
				fprintf(stderr, "No permission\n");
				return 1;
			}

			if ( *arg == '?' )
			{
				(*commands[i].cm_explain)(commands[i].cm_name, commands[i].cm_type);
				return 1;
			}

			type = commands[i].cm_type;
			action = commands[i].cm_action;
			break;
		}

	if ( i == NCOM )
		goto argerr;

	switch ( type )
	{
	 case NUMBER:
		if ( !isdigit( *arg ) )
			return usagerr( "number expected after action \"%s\"", commands[i].cm_name );
		size = atol( arg );
		if ( mode < 0 )
			size = -size;
		break;

	 case CLASSES:
		setclasses(arg);
		break;

	 case FLAGS:
		setflags(arg);
		break;

	 case TERMINALS:
		setterms(arg);
		break;

	 case GROUPS:
		setgroups(arg);
	 case STRING:
		string = arg;
		sbuf = malloc(sbufsize);
		work = malloc(strlen(arg));
		break;
	}

	if ( argc == 0 )
		return usagerr("missing user list");

	arg = *argv++;
	argc--;

	do
	{
		if ( isdigit(*arg) && (cp = strchr(arg, '-')) && isdigit(*++cp) )
		{
			register int	u, e;
			extern char *	itoa();

			for ( u = atoi(arg), e = atoi(cp) ; u <= e ; u++ )
				if ( getn( u ) && (*action)() )
					put( itoa(u) );
		}
		else
		{
			if ( getu( arg ) && (*action)() )
				put( arg );
		}
	}
	while
		( argc-- && (arg = *argv++) );

	return 0;
}




/*VARARGS*/
int
usagerr( s, a )
	char *		s;
	char *		a;
{
	if ( s != NULLSTR )
		error(s, a);

	fprintf( stderr, "Usage: %s %s\n", name, limusage );

	return 1;
}




error( s, a )
	char *	s;
	char *	a;
{
	fprintf( stderr, "%s: ", name );
	fprintf( stderr, s, a );
	fprintf( stderr, "\n" );
}




int
compare(arg, match)
	register char	*arg, *match;
{
	while ( *arg )
		if ( (*arg++|040) != (*match++|040) )
			return 0;

	return 1;
}




setclasses( c )
	register char		*c;
{
	register char		*sp;
	register int		i;
	register int		j;
	register struct centry	*cp;
	char			*sclass[NCLASS];
	int			hit = 0;

	for ( sp = c, i = 0 ; ; sp++ )
		if ( *sp == ',' || *sp == 0 )
		{
			if ( i == NCLASS )
			{
				exit( usagerr("too many classes") );
				return;
			}
			sclass[i++] = c;
			c = sp+1;
			if ( *sp == 0 )
				break;
			*sp = '\0';
		}

	if ( i == 0 )
	{
		if ( mode )
			exit( usagerr("class?") );
		return;
	}

	for ( j = 0 ; j < i ; j++ )
	{
		for ( cp = classes ; cp < &classes[NCLASS] && (sp = cp->c_name) != NULLSTR ; cp++ )
			if ( strcmp(sp, sclass[j]) == STREQUAL )
			{
				cmask[cp->c_index] |= cp->c_mask;
				hit++;
				goto contin;
			}

		error("unrecognised class \"%s\"", sclass[j]);

	contin:;
	}

	if ( !hit )
		exit( usagerr("class?") );
}




setflags( f )
	register char	*f;
{
	register	c;
	register char *	nf;

	while ( c = *f++ )
	{
		switch ( c )
		{
		 case ',':	continue;
		 case 'A':	flags |= ADMIN;		break;
		 case 'C':	flags |= CLASSACC;	break;
		 case 'D':	flags |= DLIMIT;	break;
		 case 'G':	flags |= GROUPACC;	break;
		 case 'K':	flags |= ASYNCKILL;	break;
		 case 'L':	flags |= USELOG;	break;
		 case 'M':	flags |= CONNECTLIM;	break;
		 case 'N':	flags |= NOLOGIN;	break;
		 case 'O':	flags |= ONCELOGIN;	break;
		 case 'P':	flags |= NEWPASSWD;	break;
		 case 'T':	flags |= TUTOR;		break;
		 case 'V':	flags |= NOEVICT;	break;
		 case 'W':	flags |= DAWARN;	break;

		 default:
			f--;
			if ( (nf = strchr(f, ',')) != NULLSTR )
				*nf = '\0';

			for ( c = 0 ; c < NFLAGS ; c++ )
				if ( compare(f, sflags[c].fl_name) )
				{
					*sflags[c].fl_flgp |= sflags[c].fl_val;
					if ( nf != NULLSTR )
					{
						f = nf + 1;
						goto contin;
					}
					else
						goto found;
				}

			error("unrecognised flag %s", f);
			f++;
		}
	contin:;
	}

found:

	if ( myuid && ((flags & RESTRICTED) || (xflags & XRESTRICTED)) )
	{
		error("\"%s\" are restricted flags", RSFLAGS);
		flags &= ~RESTRICTED;
		xflags &= ~XRESTRICTED;
	}

	if ( (!flags && !xflags) && mode )
		exit( usagerr("flag?") );
}




exclasses()
{
	register struct centry *	cp;
	register char *			sp;
	register			i;

	fprintf(stderr, "Classes:-");
	for ( cp = classes, i = 0 ; cp < &classes[NCLASS] && (sp = cp->c_name) != NULLSTR ; cp++, i++ )
		fprintf(stderr, "%s%s", i%7?",":"\n\t", sp);
	fprintf(stderr, "\n");
}



exflag()
{
	register	i;

	fprintf(stderr, "Flags:-");
	for ( i = 0 ; i < NFLAGS ; i++ )
		fprintf(stderr, "%s%s", i%7?",":"\n\t", sflags[i].fl_name);
	fprintf(stderr, "\n");
}




setgroups( g )
	char *		g;
{
	register char	*cp1, *cp2;
	register char	c;
	register	i;

	for ( cp1 = cp2 = g ; ; cp1++ )
		if ( (c = *cp1) == '\0' || c == ':' || c == ',' )
		{
			*cp1 = '\0';
			if ( ngrps < MAXNEWGRPS )
			{
				if ( *cp2 )
					newgroups[ngrps++].grp_s = cp2;
			}
			else
				exit(usagerr("too many groups"));
			for ( i = 0 ; i < (ngrps-1) ; i++ )
				if ( strcmp(newgroups[i].grp_s, cp2) == STREQUAL )
				{
					error("duplicate group \"%s\" ignored", cp2);
					ngrps--;
					break;
				}

			if ( c == '\0' )
				break;

			cp2 = cp1 + 1;
		}

	groupsize = cp1 - g - 1;
}




setterms( t )
	register char	*t;
{
	register	c;
	register int	i;

	while ( c = *t++ )
		if ( c != ',' )
		{
			for ( i = 0 ; i < NTTYGROUPS ; i++ )
				if ( c == tty_group[i].tg_char )
				{
					tmask |= tty_group[i].tg_mask;
					goto contin;
				}

			error("unrecognised tty group '%c'", (char *)c);

		contin:;
		}

	if ( !tmask && mode )
		exit( usagerr("terminal group?") );
}



exnull(c, t)
	char *		c;
	int		t;
{
	register char *	sp;

	switch ( t )
	{
	 case GROUPS:	sp = "a comma separarted list of user names";	break;
	 case STRING:	sp = "just a string";	break;
	 case TERMINALS:
			sp = "a comma separated list of terminal groups\n(a letter in the range a-p)";
			break;
	 case NUMBER:	sp = "a number";	break;
	 default:	sp = "(no explanation available!)";	break;
	}

	fprintf(stderr, "\"%s\" requires %s\n", c, sp);
}



#define	EVR_DATA
#include	<evr.h>

exreason()
{
	register	i, col, s;

	fprintf(stderr, "Reasons:-");

	for ( i = 1, col = 9 ; i < EVR_N ; i++ )
	{
		if ( (col += (s = 6+strlen(evr[i]))) > 71 )
		{
			col = s;
			fprintf(stderr, "\n\t");
		}
		fprintf(stderr, "  %d: %s", i, evr[i]);
	}

	fprintf(stderr, "\n");
}




int
getn( uid )
	int		uid;
{
	register	s;

	p.pw_uid = uid;

	do
		if ( (s = getpwlog(&p, string?sbuf:(char *)0, string?sbufsize:0)) == PWERROR )
			return 0;
	while
		( string && s == sbufsize && (sbuf = realloc(sbuf, (sbufsize += SSIZ))) );

	return 1;
}




int
getu( lname )
	char		*lname;
{
	register	s;

	p.pw_strings[LNAME] = lname;

	do
		if ( (s = getpwuid(&p, string?sbuf:(char *)0, string?sbufsize:0)) == PWERROR )
		{
			error("%s does not exist", lname);
			return 0;
		}
	while
		( string && s == sbufsize && (sbuf = realloc(sbuf, (sbufsize += SSIZ))) );

	return 1;
}




put( arg )
	char *	arg;
{
	if ( myuid && (p.pw_uid <= COMMONUSERS || p.pw_uid == myuid || (p.pw_flags&ADMIN)) )
		error("%d - no permission", p.pw_uid);
	else
	{
		if ( string == NULLSTR )
			limits(&p.pw_limits, L_CHNGLIM);	/* will only work if user logged in */
		if ( (string ? chngpwent(&p) : updtpwent(&p)) == PWERROR )
			error("cannot change limits for %s", arg);
	}
}




char *
mvgrp(wcp, gcp)
	register char *	wcp;
	register char *	gcp;
{
	*wcp++ = ':';
	while ( *wcp++ = *gcp++ );
	return wcp-1;
}




/*
**	Actions
*/

connect()
{
	if ( mode )
		p.pw_contime += size;
	else
		p.pw_contime = size;
	return 1;
}

cpu()
{
	if ( mode )
		p.pw_cputime += size;
	else
		p.pw_cputime = size;
	return 1;
}

groups()
{
	register char *	wcp;
	register	ogrps;
	struct sgrp	oldgroups[MAXGRPS];

	if ( !(p.pw_flags & GROUPACC) )
	{
		error("%s is not a group a/c", p.pw_strings[LNAME]);
		return 0;
	}

	{
		register char *	cp1 = p.pw_strings[OTHER];
		register char *	cp2;
		register char	c;
		register	i;

		work = wcp = realloc(work, strlen(cp1)+groupsize+4);

		while ( (c = *cp1++) && c != ':' )
			*wcp++ = c;

		if ( wcp[-1] != ' ' )
			*wcp++ = ' ';

		ogrps = 0;

		if ( c == ':' )
			for ( cp2 = cp1 ; ; cp1++ )
				if ( (c = *cp1) == '\0' || c == ':' )
				{
					*cp1 = '\0';
					if ( ogrps < MAXGRPS )
					{
						if ( *cp2 )
							oldgroups[ogrps++].grp_s = cp2;
					}
					else
					{
						error("%s has too many groups", p.pw_strings[LNAME]);
						return 0;
					}
					for ( i = 0 ; i < (ogrps-1) ; i++ )
						if ( strcmp(oldgroups[i].grp_s, cp2) == STREQUAL )
						{
							error("duplicate group \"%s\" removed", cp2);
							ogrps--;
							break;
						}
					if ( c == '\0' )
						break;
					cp2 = cp1 + 1;
				}
	}

	if ( mode )
	{
		register	i;
		register	j;

		for ( i = 0 ; i < ogrps ; i++ )
			for ( j = 0 ; j < ngrps ; j++ )
				if ( !newgroups[j].grp_m && strcmp(oldgroups[i].grp_s, newgroups[j].grp_s) == STREQUAL )
				{
					oldgroups[i].grp_m++;
					newgroups[j].grp_m++;
					break;
				}

		if ( mode > 0 )
		{
			for ( i = 0 ; i < ogrps ; i++ )
				wcp = mvgrp(wcp, oldgroup[i].grp_s);
			for ( i = 0 ; i < ngrps ; i++ )
				if ( !newgroups[i].grp_m )
					wcp = mvgrp(wcp, newgroup[i].grp_s);
		}
		else
			for ( i = 0 ; i < ogrps ; i++ )
				if ( !oldgroups[i].grp_m )
					wcp = mvgrp(wcp, oldgroups[i].grp_s);
	}
	else
	{
		register	i;

		for ( i = 0 ; i < ngrps ; i++ )
			wcp = mvgrp(wcp, newgroups[i].grp_s);
	}

	while ( wcp[-1] == ' ' )
		if ( wcp > work )
			wcp--;

	*wcp = '\0';

	p.pw_strings[OTHER] = work;

	return 1;
}

mplimit()
{
	if ( mode )
		p.pw_limits.l_mplimit += size;
	else
		p.pw_limits.l_mplimit = size;
	return 1;
}

dlimit()
{
	if ( mode )
		p.pw_limits.l_dlimit += size;
	else
		p.pw_limits.l_dlimit = size;
	return 1;
}

mlimit()
{
	if ( mode )
		p.pw_limits.l_mlimit += size;
	else
		p.pw_limits.l_mlimit = size;
	return 1;
}

nice()
{
	if ( mode )
		p.pw_limits.l_nice += size;
	else
		p.pw_limits.l_nice = size;
	return 1;
}

doverflw()
{
	if ( mode )
		p.pw_limits.l_doverflw += size;
	else
		p.pw_limits.l_doverflw = size;
	return 1;
}

duse()
{
	if ( mode )
		p.pw_limits.l_duse += size;
	else
		p.pw_limits.l_duse = size;
	return 1;
}

plimit()
{
	if ( mode )
		p.pw_limits.l_plimit += size;
	else
		p.pw_limits.l_plimit = size;
	return 1;
}

pages()
{
	if ( mode )
		p.pw_pages += size;
	else
		p.pw_pages = size;
	return 1;
}

pgused()
{
	if ( mode )
		p.pw_pgused += size;
	else
		p.pw_pgused = size;
	return 1;
}

shares()
{
	if ( mode )
		p.pw_limits.l_shares += size;
	else
		p.pw_limits.l_shares = size;
	return 1;
}

home()
{
	if ( mode )
		exit(usagerr("can only SET home directory!"));
	else
		p.pw_strings[DIRPATH] = string;
	return 1;
}

shell()
{
	if ( mode )
		exit(usagerr("can only SET shell path!"));
	else
		p.pw_strings[SHELLPATH] = string;
	return 1;
}

passwd()
{
	if ( mode )
		exit(usagerr("can only SET password!"));
	else
		strncpy(p.pw_pword, string, sizeof p.pw_pword);
	return 1;
}

gid()
{
	if ( mode )
		exit( usagerr( "can only SET group id!" ) );
	else
		p.pw_gid = size;
	return 1;
}

class()
{
	register	i;

	if ( mode == 0 )
		for ( i = 0 ; i < CLASSMASKSIZE ; i++ )
			p.pw_limits.l_cmask[i] = 0;

	for ( i = 0 ; i < CLASSMASKSIZE ; i++ )
		if ( mode < 0 )
			p.pw_limits.l_cmask[i] &= ~cmask[i];
		else
			p.pw_limits.l_cmask[i] |= cmask[i];
	return 1;
}

flag()
{
	if ( mode == 0 )
		if ( myuid )
		{
			p.pw_flags &= RESTRICTED;
			p.pw_xflags &= XRESTRICTED;
		}
		else
		{
			p.pw_flags = 0;
			p.pw_xflags = 0;
		}

	if ( mode < 0 )
	{
		p.pw_flags &= ~flags;
		p.pw_xflags &= ~xflags;
	}
	else
	{
		p.pw_flags |= flags;
		p.pw_xflags |= xflags;
	}
	return 1;
}

terminals()
{
	if ( mode == 0 )
		p.pw_tmask = 0;

	if ( mode < 0 )
		p.pw_tmask &= ~tmask;
	else
		p.pw_tmask |= tmask;
	return 1;
}

tblim()
{
	if ( mode )
		p.pw_tblim += size;
	else
		p.pw_tblim = size;
	return 1;
}

tbrate()
{
	if ( mode )
		p.pw_tbrate += size;
	else
		p.pw_tbrate = size;
	return 1;
}

reason()
{
	if ( mode )
		exit(usagerr("can only SET reason!"));
	else
		p.pw_reason = size;
	return 1;
}

usage()
{
	if ( mode )
		p.pw_limits.l_usage += size;
	else
		p.pw_limits.l_usage = size;
	return 1;
}
E 1
