/*
 *	This program decodes the file built by "pac".
 *	The file is passed as the standard input.
 */

#include	<stdio.h>
#include	"pac.h"

char	ibuf[MAXNODE];	/* each node read into here for processing */
short	rflag;		/* if zero, descend directories */
short	sflag;		/* if non-zero, suppress "not found" message */
long	subdir;		/* the pointer to the subdirectory */
long	link;		/* the pointer to the next node on this level */
char	name[FSIZE + 1];	/* the name that was just read */
char	*prefix;	/* prefix to pathbuf for full name */
char	null[] = "";
char	obuf[BUFSIZ];	/* buffer the output */


main(argc, argv)
int argc;
char **argv;
{
	register int count;

	count = 1;
	setbuf(stdout, obuf);
	while (count < argc && argv[count][0] == '-')
	{
		if (strcmp(argv[count], "-r") == 0)
		{
			count++;
			rflag++;
			continue;
		}
		if (strcmp(argv[count], "-s") == 0)
		{
			count++;
			sflag++;
			continue;
		}
		fprintf("Usage: upac [-r] [-s]\n");
		exit(1);
	}
	read(0, &rootaddr, sizeof rootaddr);
	if (rootaddr.hi_word.hi_byte)
	{
		fromslash++;
		rootaddr.hi_word.hi_byte = 0;
	}
	prefix = null;
	if (count == argc)
		scan(rootaddr, 0);
	else
		while (count < argc)
		{
			if (strcmp("/", prefix = argv[count]) == 0 && fromslash)
			{
				prefix = null;
				scan(rootaddr, 0);
			}
			else if (fromslash == (*prefix == '/') && find(prefix))
			{
				if (link == 0L || rflag)
					printf("%s\n", prefix);
				else
					scan(link, 0);
			}
			else if (sflag == 0)
				fprintf(stderr, "%s not found\n", prefix);
			count++;
		}
	exit(0);
}

find(nme)
register char *nme;
{
	register char *tail;
	register i;
	char searchname[FSIZE + 1];	/* room for a unix filename */

	link = rootaddr;
	do
	{
		while (*nme == '/')
			nme++;
		tail = searchname;
		while (*nme != '/' && *nme != 0 &&
		    ((tail - searchname) < FSIZE))
			*tail++ = *nme++;
		if (*nme && *nme != '/')
			quit(prefix, ": Filename longer than 14 chars");
		*tail = 0;
		do
			getnode(link);
		while ((i = (strcmp(name, searchname) != 0)) && link != 0L);
		if (i)
			return(0);		/* can't find file */
		link = subdir;
	} while (*nme);
	return(1);			/* file found */
}

getnode(addr)
long addr;
{
	register char flag;
	register char *p, *q;

	lseek(0, addr, 0);
	if (read(0, p = ibuf, sizeof ibuf) <= 0)
		quit("Corrupted file", null);
	flag = *p++;
	subdir = link = 0L;
	if (flag & LONGLST)
		link.hi_word.lo_byte = *p++;
	if (flag & LSTNODE)
	{
		link.lo_word.hi_byte = *p++;
		link.lo_word.lo_byte = *p++;
	}
	if (flag & LONGDIR)
		subdir.hi_word.lo_byte = *p++;
	if (flag & DIRNODE)
	{
		subdir.lo_word.hi_byte = *p++;
		subdir.lo_word.lo_byte = *p++;
	}
	q = name;
	flag &= SIZE;
	while (flag--)
		*q++ = *p++;
	*q = 0;
}

scan(addr, counter)
long addr;
register short counter;
{
	register short nextcounter;

	do
	{
		getnode(addr);
		addr = link;
		nextcounter = addname(counter);
		if (subdir != 0L)
			scan(subdir, nextcounter);
		else if (prefix == null && fromslash == 0)
			fprintf(stdout, "%s\n", &pathbuf[1]);
		else
			fprintf(stdout, "%s%s\n", prefix, pathbuf);
	} while (addr != 0L);
}

addname(place)
register short place;
{
	register char *p;

	pathbuf[place++] = '/';
	p = name;
	while ((pathbuf[place] = *p++) != 0)
		if (++place >= (MAXPATH - 1))
			quit("Pathlength too long, increase MAXPATH", null);
	return(place);
}

quit(s1, s2)
register char *s1, *s2;
{
	fprintf(stderr, "%s%s\n", s1, s2);
	exit(1);
}
