/*
 *	'od'  -  display file contents in octal,  decimal,  hexadecimal,
 *		 ascii or radix 50, on a per-byte, word, or long basis.
 *
 *	If PDP11 is defined, it will decompose into pdp11 instructions,
 *	but assumes they are all one word long!
 */

char usage[] "Usage: od [-odhcbDOrsw] [file] [[+]offset]\n";

/*
 *	The offset given above has default base 10, unless it starts
 *	with a zero which indicates octal.
 */

#include	<stdio.h>

#define OCTW	0001		/* OCTal Words */
#define DECW	0002		/* DECimal Words */
#define HEXW	0004		/* HEXadecimal Words */
#define CHAR	0010		/* ascii CHARacters */
#define OCTB	0020		/* OCTal Bytes */
#define	DECL	0040		/* decimal longs */
#define	OCTL	0100		/* octal longs */
#define RAD50	0200		/* RADix 50 conversion */

/*
 * define if you want instructions decoded
 */
/* #define PDP11	0400		/* PDP-11 instruction */


int	word[16];	/* max. 16 words per line */

char	gbuf[512],		/* input buffer - size MUST be 512! */
	*pnt;

int	fi,		/* input file desc. - default is 0 */
	count,
	conv,
	max,
	eof,
	key,
	flag,
	nword = 8,		/* 8 words per line default */
	swap_flag = 0;		/* Used to control input byte sequence */

long	addr,
	from;


main(argc, argv)
char **argv;
{
	long  a;
	int f, k, w, i;
	char *p;
	char outbuf[BUFSIZ];

	argv++;
	argc--;		/* skip name */
	f = 0;		/* size of a word in output chars */
	setbuf(stdout, outbuf);
	if (argc > 0)	/* now skip flags */
	{
		p = *argv;
		if (*p == '-')
		{
			while ((i = *++p) != '\0')
			{
				switch(i)
				{
				case 'o':
					conv =| OCTW;
					f = 6;
					break;
				case 'd':
					conv =| DECW;
					f = 5;
					break;
#ifdef	PDP11
				case 'a':
					conv =| PDP11;
					f = 4;
					break;
#endif
				case 'x':
				case 'h':
					conv =| HEXW;
					f = 4;
					break;
				case 'c':
					conv =| CHAR;
					f = 7;
					break;
				case 'b':
					conv =| OCTB;
					f = 7;
					break;
				case 'r':
					conv =| RAD50;
					f = 3;
					break;
				case 'D':
					conv =| DECL;
					f = 6;
					break;
				case 'O':
					conv =| OCTL;
					f = 6;
					break;
				case 's':
					swap_flag = 1;
					break;
				case 'w':
					nword = 16;	/* wide output */
					break;
				default:
					printf(usage);
					exit(1);
				}
				if (f > max)
					max = f;
			}
			argc--;
			argv++;
		}
	}
	if (conv == 0)
	{
		conv = OCTW;	/* default is octal words */
		max = 6;
	}
	if (argc > 0 && **argv != '+')	/* arg not starting with '+' - assume file name */
	{
		if ((fi = open(*argv, 0)) == -1)
		{
			perror(*argv);
			exit(1);
		}
		argv++;
		argc--;
	}
	if (argc > 0)	/* still more args - assume offset */
		offset(*argv);

	if (swap_flag && (conv & (OCTW | DECW | HEXW) == 0))
	{
		printf("Illegal use of -s ignored\n");
		swap_flag = 0;
	}

	eof = 0;
	while (!eof)
	{
		f = 1;
		a = addr;
		for (i = 0; i < nword; i++)
		{
			word[i] = w = getw();
			if (eof)
				break;
			if (i == 0)
				k = w;
			else if (w != k)	/* not dup - must print */
				f = 0;
		}
		if (i)
			if (f && !eof)	/* dup line - not eof */
			{
				if (flag == 0 || k != key)
				{
					dupl();
					key = k;
					from = a;
				}
				flag++;	/* suppress printout (this line) */
			}
			else
			{
				dupl();
				line(a, word, i);
			}
	}
	dupl();
	printf("%07lo ", addr);
	putchar('\n');
	exit(0);
}

dupl()
{
	if (flag)
	{
		flag = 0;
		line(from, &key, 1);
		printf("*\n");
	}
}

line(a, w, n)
long   a;
int w[];
{
	register int	i, f, bit;

	f = 1;
	for (bit = 1; bit; bit =<< 1)
	{
		if ((conv & bit) == 0)
			continue;
		if (f)
		{
			printf("%07lo ", a);
			f = 0;
		}
		else
			putchar('\t');		/* print address first time only */
		for (i = 0; i < n; i++)
		{
			if (bit & (OCTL | DECL))	/* long? */
			{
				if ((i | count) & 01)
				{
					struct grot
					{
						int g_lo;
						int g_hi;
					};
					long gg;

					pre(6);
					pre(6);
					if (count & 01)
						putchar(' ');
					gg.g_lo = w[i - 1];
					gg.g_hi = w[i];
					if (bit == OCTL)
						printf(" %11lo", gg);
					else
						printf("%12ld", gg);
				}
			}
			else
				putx(w[i], bit);
			if (i == n-1)
				putchar('\n');
			else
				putchar(' ');
		}
	}
}

putx(n, c)
{
	struct fudge
	{
		char f_lo;
		char f_hi;
	};

	if (swap_flag)		/* Swap the bytes? */
	{
		char temp;

		temp = n.f_lo;
		n.f_lo = n.f_hi;
		n.f_hi = temp;
	}
	switch(c)
	{
	case OCTW:
		pre(6);
		printf("%06o", n);
		break;

	case DECW:
		pre(5);
		printf("%5u", n);
		break;

	case HEXW:
		pre(4);
		printf("%04x", n);
		break;

#ifdef	PDP11
	case PDP11:
		pre(4);
		putop(n);
		break;
#endif

	case CHAR:
		pre(7);
		putch(n.f_lo);
		putchar(' ');
		putch(n.f_hi);
		break;

	case OCTB:
		pre(7);
		printf("%03o", n.f_lo & 0377);
		putchar(' ');
		printf("%03o", n.f_hi & 0377);
		break;

	case RAD50:
		pre(3);
		rad50(n);
		break;
	}
}

/*
 *	Get the next input word,  even if it is offset in bytes.
 */
getw()
{
	register n;

	if (--count < 0)
	{
		if ((count = read(fi, gbuf, sizeof gbuf)) <= 0)
		{
			eof = 1;
			return(0);
		}
		--count;
		pnt = gbuf;
	}
	addr++;
	n = *pnt++;

	if (--count < 0)
	{
		if ((count = read(fi, gbuf, sizeof gbuf)) <= 0)
			gbuf[0] = 0;
		--count;
		pnt = gbuf;
	}
	else
		addr++;

	return (*pnt++ << 8) | (n & 0377);
}

putch(c)
register  char  c;
{
	if (c > 037 && c < 0177 && c != '\\')
	{
		printf("  ");
		putchar(c);
		return;
	}
	switch(c)
	{
	case '\0':
		printf(" \\0");
		break;
	case '\n':
		printf(" \\n");
		break;
	case '\\':
		printf(" \\\\");
		break;
	case '\t':
		printf(" \\t");
		break;
	case '\r':
		printf(" \\r");
		break;
	case '\f':
		printf(" \\f");
		break;
	case '\b':
		printf(" \\b");
		break;
	default:
		printf("%03o", c & 0377);
	}
}

/*
 *	Program to convert the data in 'input' from radix 50
 *	to 3 ASCII characters
 */
rad50(input)
int    input;
{
	register  int    i;
	register  char   temp, *cp;
	long  l;
	char stack[4];

	cp = &stack[2];
	l = input & 0177777L;
	for (i = 0; i < 3; i++)
	{
		switch(temp = l % 050)
		{

		case  0:
			*cp = ' ';
			break;

		case 033:
			*cp = '$';
			break;

		case 034:
			*cp = '.';
			break;

		case 035:
			*cp = '_';
			break;

		default:
			if (temp >= 036)
				*cp = temp - 036 + '0';
			else
				*cp = temp - 01 + 'A';
			break;
		}
		--cp;
		l =/050;
	}
	stack[3] = 0;
	printf(stack);
}

pre(n)
{
	register  int  i;

	for (i = n; i < max; i++)
		putchar(' ');
}

offset(s)
char s[];
{
	register  char *p;
	register  int  i, b;
	int base, blk;
	long   a;

	base = 10;
	p = s;
	while (*p++);
	i = p-s-1;	/* nr. of digits */
	blk = 0;
	if (i > 0)
		if (p[-2] == 'b')
		{
			i--;
			blk++;
			p--;
		}
	if (i > 0)
		if (p[-2] == '.')
			i--;
	addr = 0;
	p = s;
	if (*p == '+')
	{
		p++;
		i--;
	}
	if (*p == '0')
	{
		base = 8;
		p++;
		i--;
	}
	while (i--)
	{
		b = *p - '0';
		if (b < 0 || b >= base)
		{
			printf("%s: illegal\n", s);
			exit(1);
		}
		addr = addr * base + b;
		p++;
	}
	if (blk)
		addr =* 512;		/* Block offset */

	a = addr & ~0777L;
	if (lseek(fi, a, 0) < 0)
	{
		perror(s);
		exit(1);
	}
	i = addr - a;
	if ((count = read(fi, gbuf, sizeof gbuf)) < 0)
	{
		perror(s);
		exit(1);
	}
	pnt = &gbuf[i];
	count =- i;	/* if this now negative, getw will return eof */
}

#ifdef	PDP11
putop(n)
{
	char *p;
	register i, c;

	p = getop(n);
	for (i = 0; c = *p++;  i++)
		putchar(c);
	while (i++ < 4)
		putchar(' ');
}

getop(n)
{
	switch(n&0170000)
	{
	case 0000000:
		switch(n&0177000)
		{
		case 0004000:
			return("jsr");
		case 0077000:
			return("sob");
		}
		switch(n&0177400)
		{
		case 0000400:
			return("br");
		case 0001000:
			return("bne");
		case 0001400:
			return("beq");
		case 0002000:
			return("bge");
		case 0002400:
			return("blt");
		case 0003000:
			return("bgt");
		case 0003400:
			return("ble");
		}
		switch(n&0177700)
		{
		case 0000100:
			return("jmp");
		case 0000300:
			return("swab");
		case 0005000:
			return("clr");
		case 0005100:
			return("com");
		case 0005200:
			return("inc");
		case 0005300:
			return("dec");
		case 0005400:
			return("neg");
		case 0005500:
			return("adc");
		case 0005600:
			return("sbc");
		case 0005700:
			return("tst");
		case 0006000:
			return("ror");
		case 0006100:
			return("rol");
		case 0006200:
			return("asr");
		case 0006300:
			return("asl");
		case 0006400:
			return("mark");
		case 0006500:
			return("mfpi");
		case 0006600:
			return("mtpi");
		case 0006700:
			return("sxt");
		}
		switch(n&0177740)
		{
		case 0000240:
			return("flag");
		}
		switch(n&0177770)
		{
		case 0000200:
			return("rts");
		case 0000230:
			return("spl");
		}
		switch(n&0177777)
		{
		case 0000000:
			return("halt");
		case 0000001:
			return("wait");
		case 0000002:
			return("rti");
		case 0000003:
			return("bpt");
		case 0000004:
			return("iot");
		case 0000005:
			return("rset");
		case 0000006:
			return("rtt");
		}
		break;
	case 0010000:
		return("mov ");
	case 0020000:
		return("cmp");
	case 0030000:
		return("bit");
	case 0040000:
		return("bic");
	case 0050000:
		return("bis");
	case 0060000:
		return("add");
	case 0070000:
		switch(n&0177000)
		{
		case 0070000:
			return("mul");
		case 0071000:
			return("div");
		case 0072000:
			return("ash");
		case 0073000:
			return("ashc");
		case 0074000:
			return("xor");
		case 0075000:
			switch(n & 0177770)
			{
			case 0075000:
				return("fadd");
			case 0075010:
				return("fsub");
			case 0075020:
				return("fmul");
			case 0075030:
				return("fdiv");
			}
		}
		break;
	case 0100000:
		switch(n&0177400)
		{
		case 0100000:
			return("bpl");
		case 0100400:
			return("bmi");
		case 0101000:
			return("bhi");
		case 0101400:
			return("blos");
		case 0102000:
			return("bvc");
		case 0102400:
			return("bvs");
		case 0103000:
			return("bhis");
		case 0103400:
			return("blo");
		case 0104000:
			return("emt");
		case 0104400:
			return("sys");
		}
		switch(n&0177700)
		{
		case 0105000:
			return("clrb");
		case 0105100:
			return("comb");
		case 0105200:
			return("incb");
		case 0105300:
			return("decb");
		case 0105400:
			return("negb");
		case 0105500:
			return("adcb");
		case 0105600:
			return("sbcb");
		case 0105700:
			return("tstb");
		case 0106000:
			return("rorb");
		case 0106100:
			return("rolb");
		case 0106200:
			return("asrb");
		case 0106300:
			return("aslb");
		case 0106400:
			return("mtps");		/* 11/34 */
		case 0106500:
			return("mfpd");
		case 0106600:
			return("mtpd");
		case 0106700:
			return("mfps");		/* 11/34 */
		}
		break;
	case 0110000:
		return("movb");
	case 0120000:
		return("cmpb");
	case 0130000:
		return("bitb");
	case 0140000:
		return("bicb");
	case 0150000:
		return("bisb");
	case 0160000:
		return("sub");
	case 0170000:
		switch (n & 0177000)
		{
		case 0170000:
			switch (n & 0177700)
			{
			case 0170000:
				switch (n)
				{
				case 0170000:
					return("cfcc");
				case 0170001:
					return("setf");
				case 0170002:
					return("seti");
				case 0170011:
					return("setd");
				case 0170012:
					return("setl");
				}
				break;
			case 0170100:
				return("lfps");
			case 0170200:
				return("sfps");
			case 0170300:
				return("stst");
			case 0170400:
				return("clrf");
			case 0170500:
				return("tstf");
			case 0170600:
				return("absf");
			case 0170700:
				return("negf");
			}
			break;
		default:
			switch (n & 0177400)
			{
			case 0171000:
				return("mulf");
			case 0171400:
				return("modf");
			case 0172000:
				return("addf");
			case 0172400:
				return("ldf");
			case 0173000:
				return("subf");
			case 0173400:
				return("cmpf");
			case 0174000:
				return("stf");
			case 0174400:
				return("divf");
			case 0175000:
				return("stxp");
			case 0175400:
				return("stfi");
			case 0176000:
				return("stfd");
			case 0176400:
				return("ldxp");
			case 0177000:
				return("ldif");
			case 0177400:
				return("lddf");
			}
		}
		break;
	}
	return("???");
}
#endif
