#include	<sys/types.h>
#include	<sys/stat.h>
#include	<signal.h>

char buf[256];

main(ac, av)
char **av;
{
	register char *p, *q;
	register short flag;
	char *par1(), *par2();

	flag = 0;
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	if (ac != 3)
	{
		printf("Usage: mvdir old_dir_name new_dir_name\n");
		exit(1);
	}
	if (stat(av[1], buf) == -1)
		eek(av[1]);
	if ((((struct stat *)buf)->st_mode & S_IFMT) != S_IFDIR)
	{
		printf("%s: not a directory\n", av[1]);
		exit(1);
	}
	if (link(av[1], av[2]))
		eek(av[2]);
	if (unlink(av[1]) == -1)
		eek(av[1]);
	q = par1(av[2]);
	if (unlink(q) == -1)
		eek(q);
	p = par2(av[2]);
	if (link(p, q))
		eek(q);
	exit(0);
}

char *
par1(s)		/* finds parent of s by bunging on "/.." */
char *s;
{
	register char *p, *q;

	p = buf;
	q = s;
	while ((*p++ = *q++) && p < &buf[sizeof buf] - 3);
	if (*--p)
	{
		printf("%s: too long\n", s);
		exit(1);
	}
	*p++ = '/'; *p++ = '.'; *p++ = '.'; *p = 0;
	return(buf);
}

char *
par2(s)		/* finds parent of s - not good enough to bung on "/.." here */
char *s;
{
	register char *p, *q;

	p = s;
	q = 0;
	while (*p)
		if (*p++ == '/')
			q = p;
	if (q)
	{
		*--q = 0;
		return(s);
	}
	return(".");
}

eek(s)
char *s;
{
	perror(s);
	exit(1);
}
