#include "draw.h"

FILE *tempfile;

writeout(sp)
struct symbol *sp;
{

	int	(*sfp)();

	protect(&sfp);
	fseek(tempfile, 0L, 2);	/* all writes to end of file */
	sp->discaddr = ftell(tempfile);	/* address in file */
	binwrite(sp, tempfile);
	unprotect(&sfp);
}

readin(sp)
struct symbol *sp;
{
	int	(*sfp)();

	if(sp->list != NULL)
		return;
	protect(&sfp);
	fseek(tempfile, sp->discaddr, 0);	 /* got to start of module */
	binread(sp, tempfile);
	unprotect(&sfp);
}

int incore;

tempreadin(sp)
struct symbol *sp;
{
	if(sp->list != NULL)
		return;		/* incore */
	if(incore > MAXINCORE)
		deleteincore(0);

	readin(sp);

	sp->def |= TEMP;
	incore ++;
}

deleteincore(t, sp)
struct symbol *sp;
{
	register struct symbol *rsp;
	static scanp;
	int p;
	int	(*sfp)();

	register union unit *up, *eup;
	rsp = sp;

	protect(&sfp);
	if(t == 0)
	{
		p = scanp;
		for(;;)
		{
			if(++p >= NSYMS)
				p = 0;
			if((symtab[p].def & (TEMP | PRINT | EDIT)) == TEMP)
				break;
			if(p == scanp)
			{
				alpha();
				printf("nesting level too deep increase MAXINCORE\n");
				longjmp(env, 0);
			}
		}
		scanp = p;
		incore--;
		rsp = &symtab[p];
	}
	else
		if(rsp->list == NULL)
			goto out;
	rsp->def &= ~ TEMP;

	for(up = rsp->list->mod.up; up != NULL;)
	{
		if(up->mod.op == LINE)
			free((char *)up->l.ls);
		else if(up->mod.op == STRING)
		{
			free(up->str.sp);
		}
		up = (eup = up)->mod.up;
		free(eup);
	}
	free((char *)rsp->list);
	rsp->list = NULL;
    out:
	unprotect(&sfp);
}
cleanout()
{
	register struct symbol *sp;

	for(sp = symtab; sp < &symtab[nsyms]; sp++)
	{
		if((sp->list == NULL) || ((sp->def & (EDIT | PRINT)) != 0))
			continue;
		deleteincore(1, sp);
		incore--;
	}
}
