#include "draw.h"

int currrotation;
int currscale;
ed(arg1)
char * arg1;
{
	register struct symbol *p;
	register union unit *q, *q1, *l;
	register struct symbol *r;
	register char *n, *m;
	register unsigned i;
	register char c;
	char buf[BUFSZ];
	float x, y;
	short xi, yi;
	short xbase, ybase;
	float x1, y1;
	float x2, y2;
	float x3, y3;
	float cx, cy;
	float zscale;
	unsigned level = 1;
	struct smod temp;
	short modified = 0;	/* flag to indicate modification */
	int sfp;

	currscale = 1000;
	currrotation = 0;
	/* edit a module */
	if((p = lookup(arg1)) == NULL)
	{
		modified = 1;
		newline();
		fprintf(stderr, "adding new module %s\n", arg1);
		oldline();
		strncpy(symtab[nsyms].name, arg1, NAMESIZ);
		symtab[nsyms].list = (union unit *)mmalloc(sizeof (struct smod));
		p = &symtab[nsyms++];
		p->list->mod.up = NULL;
		p->def = DEF;
		p->size = 0;
	}
	if(p->list == NULL)
		readin(p);

	p->def |= EDIT;
	for(;;)
	{
		c = ucursor(&x, &y);
		round(&x);
		round(&y);
		xi = conv(x);
		yi = conv(y);

		switch(c)
		{
		case '.':	upointa(x, y);
				continue;
		case '0':
			level = 0;
			continue;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			level |= 1 << (c - '0'-1);
			continue;
/* escape to command level */
		case '!':
			newline();
			gets(buf);
			cmd(buf, 1);
			oldline();
			continue;
/* set character size */
		case 'C':
			fflush(stdout);
			gets(buf);
			size(buf);
			break;

/* add a circle */
		case 'c':
			fflush(stdout);
			gets(buf);
			if(sscanf(buf, "%f", &x1) != 1)
			{
				error("radius required\n");
				continue;
			}

			protect(&sfp);
			modified = 1;
			l = (union unit *) mmalloc(sizeof (struct scir));
			l->cir.op = CIRCLE;
			l->cir.rad = conv(x1) * 10;
			goto common;
/* add a line */
		case 'l':
			protect(&sfp);
			modified = 1;
			l = (union unit *) mmalloc(sizeof (struct line));
			l->l.up = NULL;
			p->size ++;
			l->l.x = conv(x);
			l->l.y = conv(y);
			l->l.op = LINE;
			l->l.level = level;
			l->l.ls = (union lineseg*) mmalloc(sizeof l->l.ls[0]);
			l->l.nsegs = 0;
			insert(p->list, l);
			unprotect(&sfp);
			umovea(x, y);
			do 
			{
				x1 = x; y1 = y;
				while((c = ucursor(&x, &y)) == '.')
				{
					round(&x);
					round(&y);
					upointa(x, y);
					umovea(x1, y1);
				}
				round(&x);
				round(&y);
				udrawa(x, y);
				xi = conv(x);
				yi = conv(y);
				xbase = conv(x1);
				ybase = conv(y1);
				protect(&sfp);
			loop:
				l->l.ls = (union lineseg*) mrealloc((char *)l->l.ls, sizeof l->l.ls[0] * (l->l.nsegs + 1));
				l->l.nsegs++;
				if(yi-ybase == 0)/* deltax */
				{
					int deltax = xi - xbase;

					l->l.ls[l->l.nsegs - 1].a.dmode = DELTAX;
					if((-8096 <= deltax) && ( deltax <= 8095))
					{
						l->l.ls[l->l.nsegs - 1].a.delta = deltax;
					}
					else
					{
						l->l.ls[l->l.nsegs -1].a.delta = deltax < 0 ? -8096 : 8095;
						xbase += deltax <0 ? -8096 : 8095;
						goto loop;
					}
				}
				else if(xi-xbase == 0)/* deltay */
				{
					int deltay = yi - ybase;
					l->l.ls[l->l.nsegs - 1].a.dmode = DELTAY;
					if((-8096 <= deltay) && ( deltay <= 8095))
					{
						l->l.ls[l->l.nsegs - 1].a.delta = deltay;
					}
					else
					{
						l->l.ls[l->l.nsegs -1].a.delta = deltay < 0 ? -8096 : 8095;
						ybase += deltay <0 ? -8096 : 8095;
						goto loop;
					}
				}
				else	/* delta x, y */
				{
					int deltax, deltay;
					deltax = xi - xbase;
					deltay = yi - ybase;
					if((-64 <= deltax) &&(deltax <= 63)
						&& (-64 <= deltay) && (deltay <= 63))
					{
						l->l.ls[l->l.nsegs - 1].c.dmode = SDELTAXY;
						l->l.ls[l->l.nsegs - 1].c.deltax1 = deltax;
						l->l.ls[l->l.nsegs - 1].c.deltay1 = deltay;
					}
					else
					{
						/* assume it fits */
						l->l.ls[l->l.nsegs - 1].a.dmode = DELTAXY;
						l->l.ls[l->l.nsegs - 1].a.delta = deltay;
						l->l.ls = (union unit *) mrealloc(
							(char *)l->l.ls, sizeof (union unit) * (l->l.nsegs + 1));
						l->l.nsegs++;
						l->l.ls[l->l.nsegs -1].b.delta1 = deltax;
					}
				}
				unprotect(&sfp);
			}
			while( c == 'l');
			break;
/* move an item */
		case 'M':
			for(l = p->list, q = p->list->mod.up;;l = q, q = q->mod.up)
			{
				if(q == NULL)
				{
					putc(BELL, stderr);
					break;
				}
				if(q->mod.x == xi && q->mod.y == yi)
				{
					mark(q);
					while(ucursor( &x, &y) == '.')
					{
						round( &x);
						round( &y);
						upointa(x, y);
					}
					round( &x);
					round( &y);
					protect(&sfp);
					modified = 1;
					l->mod.up = q->mod.up;
					q->mod.up = NULL;
					q->mod.x = conv(x);
					q->mod.y = conv(y);
					draw(0.0, 0.0, q);
					insert(p->list, q);
					unprotect(&sfp);
					break;
				}
			}
			break;
/* add a module */
		case 'm':
			fflush(stdout);
			gets(buf);
			n = buf;
			while((*n == ' ') || (*n == '\t'))
				n++;
			m = n;
			if(*n == '\0')
			{
				error("missing module name\n");
				continue;
			}
			while((*m != ' ') && (*m != '\t') && (*m != '\0'))
				m++;
			*m = 0;
			if((r = lookup(n)) == NULL)
			{
				error("unknown module\n");
				continue;
			}
			protect(&sfp);
			modified = 1;
			l = (union unit *) mmalloc(sizeof (struct smod));
			l->mod.op = MODULE;
			l->mod.mrot = currrotation;
			l->mod.mscale = currscale;
			l->mod.modnum = r - symtab;
			goto common;
/* draw a module but do not add it */
		case 'd':
			fflush(stdout);
			gets(buf);
			n = buf;
			while((*n == ' ') || (*n == '\t'))
				n++;
			if(*n == 0)
			{
				error("missing module name\n");
				continue;
			}
			m = n;
			while((*m != ' ') && (*m != '\t') && (*m != 0))
				m++;
			*m = 0;
			if((r = lookup(n)) == NULL)
			{
				error("unknown module\n");
				continue;
			}
			temp.mscale = currscale;
			temp.mrot = currrotation;
			temp.x = conv(x);
			temp.y = conv(y);
			temp.modnum = r - symtab;
			temp.op = MODULE;
			temp.up = NULL;
			draw(0.0, 0.0, &temp);
			continue;
/* mark entries */
		case 'x':	/* mark the start of each entry (for deleting) */
			for(q = p->list->mod.up;q != NULL;q = q->mod.up)
			{
				mark(q);
			}
			break;
/* delete an entry */
		case 'z':
			for(q = (q1 = p->list)->mod.up;;)
			{
				if(q == NULL)
				{
					putc(BELL, stderr);
					break;
				}
				if((q->mod.x == xi) && (q->mod.y == yi))
				{
					mark(q);
					protect(&sfp);
					modified = 1;
					if(q->mod.op == LINE)
						free((char *)(q->l.ls));
					else if(q->mod.op == STRING)
						free(q->str.sp);
					q1->mod.up = q->mod.up;
					p->size --;
					free(q);
					unprotect(&sfp);
					break;
				}
				q1 = q;
				q = q->mod.up;
			}
			break;
/* window current picture */
		case 'w':
			if((i = getnum(&zscale)) == EOF || i == 0)
				zscale = 1.0;
			alpha();
			fflush(stdout);
			zscale *= 2.0;
			x1 = (xtop - xbottom) / zscale;
			y1 = (ytop - ybottom) / zscale;

			protect(&sfp);
			xbottom = x - x1;
			xtop = x + x1;
			ybottom = y - y1;
			ytop = y + y1;

			uwindow(xbottom, xtop, ybottom, ytop);
			unprotect(&sfp);

			print(arg1);
			break;
/* add an arc */
		case 'a':
			x1 = x; y1 = y;
			do {
				c = ucursor(&x2, &y2);
				round(&x2);
				round(&y2);
				upointa(x2, y2);
			}
			while(c == '.');
			do {
				c = ucursor(&x3, &y3);
				round(&x3);
				round(&y3);
				upointa(x3, y3);
			}
			while(c == '.');
			if(arccent(x1, y1, x2, y2, x3, y3, &cx, &cy) < 0)
			{
				alpha();
				error("the three points define a line\n");
				break;
			}
			protect(&sfp);
			modified = 1;
			l = (union unit *) mmalloc(sizeof (struct sarc));
			l->arc.x1 = conv(x3); l->arc.y1 = conv(y3);
			l->arc.cx = conv(cx); l->arc.cy = conv(cy);
			l->arc.op = ARC;
			upointa(cx, cy);
			goto common;
/* set module and string rotation */
		case 'R':
			fflush(stdout);
			gets(buf);
			protect(&sfp);
			if(sscanf( buf, "%d", &currrotation) != 1)
				currrotation = 0;
			currrotation %= 360;
			if(currrotation < 0)
				currrotation += 360;
			unprotect(&sfp);
			break;
/* Roam about the drawing */
/* set module sacle */
		case 'S':
			fflush(stdout);
			gets(buf);
			if(sscanf( buf, "%f", &x) != 1)
				x = 1.0;
			currscale = (int)(x * 1000.0);
			break;
/* add a string */
		case 's':
			fflush(stdout);
			fgets(buf, BUFSIZ, stdin);
			for(n = buf; (*n != '\0') && (*n != '\n');n++);
			if(*n != '\n')
				while(getchar() != '\n');

			*n = 0;
			i = strlen(buf) + 1;
			protect(&sfp);
			modified = 1;
			l = (union unit *) mmalloc(sizeof (struct sstr));
			l->str.op = STRING;
			l->str.cnt = i - 1;
			l->str.sscale = charscale;
			l->str.srot = currrotation;
			l->str.sp = (char *) malloc(i);
			strcpy(l->str.sp, buf);
		common:
			l->mod.x = conv(x);
			l->mod.y = conv(y);
			if(l->mod.op != MODULE)
				l->l.level = level;
			p->size++;
			l->mod.up = NULL;
			draw(0.0, 0.0, l);
			insert(p->list, l);
			unprotect(&sfp);
			break;
/* quit */
		case 'q':
			goto out;
/* reprint module */
		case 'p':
			print(arg1);
			break;
/* draw grid */
		case 'g':
			grid();
			break;
		default:
			putc(BELL, stderr);
			break;
		}
	}
	out:;
	protect(&sfp);
	p->def &= ~EDIT;
	if(modified)
	{
		CHANGED = 1;
		writeout(p);
	}
	else
		deleteincore(1, p);
	unprotect(&sfp);
}
mark(q)
union unit *q;
{
	umovea((q->x)/100.0-0.05, (q->y)/100.0+0.05);
	udrawr(0.1, -0.1);
	umover(-0.1, 0.0);
	udrawr(0.1, 0.1);
}

arccent(x1, y1, x2, y2, x3, y3, pcx, pcy)
float x1, y1, x2, y2, x3, y3;
float *pcx, *pcy;
{
	float px, py;
	float qx, qy;
	float m1, m2;


	px = (x1 + x2)/2.0;
	py = (y1 + y2)/2.0;

	qx = (x2 + x3)/2.0;
	qy = (y2 + y3)/2.0;

	if(((x2 - x1) == 0.0) && ((x3 - x2) == 0.0))
	{
		return -1;
	}
	else if(((x2 - x1) != 0.0) && ((x3 - x2) != 0.0))
	{
		m1 = (y2 - y1)/(x2 - x1);
		m2 = (y3 - y2)/(x3 - x2);
	
		if(m1 == m2)
		{
			return -1;
		}
		else if(m1 != 0.0 && m2 != 0.0)
		{
			*pcx = -((qy + qx/m2) - (py + px/m1))/(1.0/m1 - 1.0/m2);
			*pcy = (px - *pcx)/m1 + py;
		}
		else if(m1 == 0.0)
		{
			*pcx = px;
			*pcy = (qx - px)/m2 + qy;
		}
		else
		{
			*pcx = qx;
			*pcy = (px - qx)/m1 + py;
		}
	}
	else if((x2 - x1) == 0.0)
	{
		*pcy = py;
		*pcx = (-(py - qy) * ((y3 -y2)/(x3 - x2)) + qx);
	}
	else
	{
		*pcy = qy;
		*pcx = (-(qy - py) * ((y2 -y1)/(x2 - x1)) + px);
	}
	return 0;
}
getnum(f)
float *f;
{
	char buf[20];
	fflush(stdout);
	gets(buf);
	return sscanf(buf, "%f", f);
}
conv(x)
float x;
{
	if(x < 0)
		return (((int)(x * 100.0 - 2.5))/5) * 5;
	else
		return (((int)(x * 100.0 + 2.5))/5) * 5;
}
