/*
**	This program is used to remove ungracefully a group of persons
**	from the system.
**	Used by terminal booking system. Can also be used directly.
**	Syntax:
**		evict ttys lname
**
**		'ttys' are a list of terminal names as printed by 'who'.
**		'lname' is the person (or class) who has the right to remain.
**
**		Modified on the 26 February 1980 to work with Vax Unix TBS
**							Chris M.
*/ 


#include	<local-system>
#include	<sys/types.h>
#include	<passwd.h>
#include	<signal.h>
#include	<stdio.h>
#include	<class.h>
#include	<utmp.h>
#include	<evr.h>


#define	NVIC		70
#define NASTY		-20
#define	EVICTLOG	"/usr/adm/evictlog"


#define	DIETIME		5
#define	EVICTTIME	(2*HZ)

char		m0[] =	"\nThis terminal is booked for ";
char		m1[] =	"\nYou have 2 minutes to log off or your account\nwill be removed from the system.\n\tBe warned\n";
char		m2[] =	"account ";
char		m3[] =	"members of class(es) ";

struct	pwent	pe;	/* the pwent of he who may stay */ 
struct	pwent	ve;	/* the pwent of the current victim */

struct utmp	uu;	/* utmp buffer */

short		nvic;	/* number of terminals evicted */

struct victim
{
	uid_t	v_uid;
	short	v_pgrp;
	char	v_name[UTNAMESIZE];
	char	v_zapped;
}
		victim[NVIC];

char		trycnt;		/* A KLUDGE SO THAT EVICT DOES NOT STAY AROUND TO LONG */
char		class;		/* set when a class eviction in progress */

char *		name;
extern time_t	time();
extern char *	ctime();
short		thispid;
uid_t		thisuid;
short		warned;

main(argc, argv)
	int		argc;
	char **		argv;
{
	register char **s;
	register FILE *	utf;

	nice(NASTY);
	name = argv[argc-1];
	argv[argc-1] = 0;

	thispid = getpid();
	thisuid = getuid();

	if(argc < 3)
		err("Usage : evict ttys... lname\n");

	pe.pw_strings[LNAME] = name;
	if(getpwuid(&pe, (char *)0, 0) == PWERROR)
		err("Who ?\n");

	if(pe.pw_limits.l_flags & CLASSACC)
		class++;

	if(chdir("/dev") == SYSERROR)
		err("chdir /dev failed\n");

	if((utf = fopen(UTMPF, "r")) == NULL)
		err("Can't open utmp\n");

	for(;;)
	{
		warned = 0;
		while(fread(&uu, sizeof uu, 1, utf) == 1)
		{
			for(s = argv+1; *s; s++)
			{
				if(strncmp(*s, uu.ut_line, LINESIZ) == 0)
					warn(*s);
			}
		}
		rewind(utf);

		/* The Kludge so that evict will go away */
		if (warned == 0 || trycnt++ == 3)
			break;
		sleep(EVICTTIME);
	}

	/*
	 * get the processes which did not submit to a SIGTERM
	 */
	if(nvic)
		finalzap();
	else
		fprintf(stderr, "No evictions performed\n");
	return 0;
}

err(string)
	char *	string;
{
	fprintf(stderr, string);
	exit(1);
}

warn(s)
	char *	s;
{
	register FILE *	f;
	register int	i;

	for(i = 0; i < nvic; i++)
	{
		if(victim[i].v_uid == uu.ut_uid
		   && victim[i].v_pgrp == uu.ut_pgrp)
		{
			if(victim[i].v_zapped == 0)
			{
				if(uu.ut_pgrp && uu.ut_pgrp != 1)
					kill(-uu.ut_pgrp, SIGTERM);
				victim[i].v_zapped++;
			}
			return;
		}
	}

	if((ve.pw_limits.l_uid = uu.ut_uid) == 0)
		return;

	if(getpwlog(&ve, (char *)0, 0) == PWERROR)
		return;

	if((ve.pw_limits.l_flags & NOEVICT) || chkclass())
		return;

	if((f = fopen(s, "w")) != NULL)
	{
		victim[i].v_uid = uu.ut_uid;
		victim[i].v_pgrp = uu.ut_pgrp;
		strncpy(victim[i].v_name, uu.ut_name, UTNAMESIZE);
		victim[i].v_zapped = 0;

		if(class)
		{
			fprintf(f, m0);
			fprintf(f, m3);
			for(i = 0; i < NCLASS; i++)
			{
				if(pe.pw_limits.l_cmask[classes[i].c_index]&classes[i].c_mask)
				{
					fprintf(f, classes[i].c_name);
					putc(' ', f);
				}
			}
		}
		else
		{
			fprintf(f, m0);
			fprintf(f, m2);
			fprintf(f, name);
		}
		fprintf(f, m1);
		fclose(f);

		if ( (f = fopen(EVICTLOG, "af")) != NULL )
		{
			time_t	t;

			time(&t);

			fprintf(f, "%.15s  pid=%6d, uid=%6d,%8.*s warned\n"
				,ctime(t)+4
				,thispid
				,thisuid
				,UTNAMESIZE
				,uu.ut_name
				);

			fclose(f);
		}

		nvic++;
		warned++;
	}
	else
		perror(s);

	return;
}

chkclass()
{
	register 	i;

	if(class == 0)
		return ve.pw_limits.l_uid == pe.pw_limits.l_uid;

	for(i = 0; i < CLASSMASKSIZE; i++)
	{
		if(pe.pw_limits.l_cmask[i] & ve.pw_limits.l_cmask[i])
			return 1;
	}

	return 0;
}

finalzap()
{
	register struct victim *	v;
	register FILE *			logf;

	sleep(DIETIME);

	logf = fopen(EVICTLOG, "af");

	for(v = victim; v < victim+nvic; v++)
	{
		if(v->v_zapped)
		{
			ve.pw_limits.l_uid = v->v_uid;
			if(getpwlog(&ve, (char *)0, 0) != PWERROR)
			{
				ve.pw_limits.l_flags |= NOLOGIN;
				ve.pw_reason = EVR_BOOK;
				updtpwent(&ve);

				if ( limits(&ve.pw_limits, L_OTHLIM) != SYSERROR )
				{
					ve.pw_limits.l_flags |= NOLOGIN;
					limits(&ve.pw_limits, L_CHNGLIM);
				}
			}

			kill(-(v->v_pgrp), SIGKILL);

			if ( logf != NULL )
			{
				time_t	t;

				time(&t);

				fprintf(logf, "%.15s: pid=%6d, uid=%6d,%8.*s EVICTED\n"
					,ctime(t)+4
					,thispid
					,thisuid
					,sizeof v->v_name
					,v->v_name
					);
			}
		}
	}

	if ( logf != NULL )
		fclose(logf);
}
