#include	"defines.h"

lab()
{
	format( labs[nlabels++] );
	if( nlabels == nlabs )
	{
		print_labs();
		nlabels = 0;
	}
}

format( lab )
struct label	*lab;
{
	register char	*p, *s, *lp;
	char		*b, *e, buf[1024];
	int		n, i, j, maxlen, maxhite;
	int		xoffset, yoffset;
	char		*copy();

	blankout( lab );

	maxlen = 0;
	maxhite = 0;			/* for the centering		*/
	p = buf;			/* buffer to store the fields	*/
					/* as they will be printed	*/

	for( i = 0; fields[i][0]; i++ )
	{
		for( s = fields[i]; *s; maxlen = ( maxlen < n ? n : maxlen ) )
		{
			maxhite++;
			n = 0;
			b = p;
			e = b + WRAP_WIDTH;
			if( *s == ' ' )
				s++;
			while( ( p < e ) && *s )
				*p++ = *s++, n++;
			if( !*s )
			{
				*p++ = 0;
				continue;
			}
			while( ( *s != ' ' ) && ( p > b ) )
				p--, s--, n--;
			if( p != b )
				*p++ = 0;
			else
			{
				run_err( "field to large for label" );
				break;
			}
		}
	}

	/* now to copy the fields across into the label			*/

	if( maxhite > ( MAXLINES - 1 ) )
	{
		run_err( "to many lines for label" );
		return;
	}
	xoffset = ( lab_width - 1 - maxlen ) / 2;
	yoffset = ( lab_hight - 1 - maxhite ) / 2;
	p = buf;
	for( i = yoffset; i < ( yoffset + maxhite ); i++ )
	{
		lp = &lab->lab_lines[i][xoffset];
		while( *p )
			*lp++ = *p++;
		p++;
	}

	if(Iflag)
		copy(labhead, &lab->lab_lines[0][lab_width-init_len]);
}

print_labs()
{
	register	i, j;
	register char	*p;
	int		n;

	for( i = 0; i < lab_hight; i++ )
	{
		for( j = 0; j != nlabs; j++ )
		{
			p = labs[j]->lab_lines[i];
			while( *p )
				putc_labs( *p++ );
			putc_labs( ' ' );
		}
		putc_labs( '\n' );
	}
}

blankout( lab )
struct	label	*lab;
{
	register	i, j;

	for( i = 0; i < lab_hight; i++ )
	{
		for( j = 0; j < lab_width; j++ )
			lab->lab_lines[i][j] = ' ';
		lab->lab_lines[i][j] = 0;/* null terminate the string	*/
	}
}

dummy_labs()
{
	register	i, j;
	static char	stars[]	"**************************************************";
	static char	sblks[]	"*                                                 ";
	static char	*strings[2] =
			{
				"*   for %s                                        ",
				"*   %d cpi  %d lpi                                "
			};
	char	buf1[64];
	char	buf2[64];

	stars[lab_width+1] = sblks[lab_width+1] = 0;
	stars[lab_width] = ' ';
	sblks[lab_width-1] = '*';

	sprintf(buf1, strings[0], devices[dest]);
	sprintf(buf2, strings[1], pitch, lines);
	buf1[lab_width+1] = buf2[lab_width+1] = 0;
	buf1[lab_width] = buf2[lab_width] = ' ';
	buf1[lab_width-1] = buf2[lab_width-1] = '*';
	
	j = a_dlabs[dest];
	while( j-- )
	{
		putout(stars);
		for( i = 0; i < ( lab_hight - 3 ); i++ )
			if(i == 1)
				putout(buf1);
			else
			if(i == 2)
				putout(buf2);
			else
				putout(sblks);
		putout(stars);
		putc( '\n', outp_L );
	}

	/*
	 *	The following just allocates the space for
	 *	all of the labels necessary
	 */

	for(i = 0; i != nlabs; i++)
		if((labs[i] = malloc(sizeof labs[0][0])) == -1)
		{
			fprintf(stderr, "error: cant alloc enough core\n");
			exit(1);
		}
}

putout(s)
char	*s;
{
	int	x;

	for(x = 0; x != nlabs; x++)
		fprintf(outp_L, s);
	putc('\n', outp_L);
}
