/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		NOBKPT[];
char		SZBKPT[];
char		EXBKPT[];
char		NOPCS[];
char		BADMOD[];

/*
 * breakpoints
 */
struct bkpt	*bkpthead;

char		*lp;
char		lastc;
unsigned	corhdr[512];
unsigned	*endhdr;

int		signo;
long int	dot;
int		pid;
long int	cntval;
long int	loopcnt;



/*
 * sub process control
 */
subpcs(modif)
{
	register int check;
	int execsig;
	int runmode;
	register struct bkpt *bkptr;
	char *comptr;

	execsig = 0;
	loopcnt = cntval;
	switch(modif)
	{
    case 'd':		/* delete breakpoint */
    case 'D':
		if ((bkptr = scanbkpt(shorten(dot))))
		{
			bkptr->flag = 0;
			return;
		}
		else
			error(NOBKPT);

    case 'b':		/* set breakpoint */
    case 'B':
		if ((bkptr = scanbkpt(shorten(dot))))
			bkptr->flag = 0;
		for (bkptr = bkpthead; bkptr; bkptr = bkptr->nxtbkpt)
			if (bkptr->flag == 0)
				break;
		if (bkptr == 0)
		{
			if ((bkptr = sbrk(sizeof *bkptr)) == -1)
				error(SZBKPT);
			else
			{
				bkptr->nxtbkpt = bkpthead;
				bkpthead = bkptr;
			}
		}
		bkptr->loc = dot;
		bkptr->initcnt = bkptr->count = cntval;
		bkptr->flag = BKPTSET;
		check = MAXCOM-1;
		comptr = bkptr->comm;
		rdc();
		lp--;
		do
		{
			*comptr++ = readchar();
		} while (check-- && lastc != EOR);
		*comptr = 0;
		lp--;
		if (check)
			return;
		else
			error(EXBKPT);

    case 'k':		/* exit */
    case 'K':
		if (pid)
		{
			printf("%d: killed", pid);
			endpcs();
			return;
		}
		error(NOPCS);

    case 'r':		/* run program */
    case 'R':
		endpcs();
		setup();
		runmode = CONTIN;
		break;

    case 's':		/* single step */
    case 'S':
		runmode = SINGLE;
		if (pid)
			execsig = getsig(signo);
		else
		{
			setup();
			loopcnt--;
		}
		break;

    case 'c':		/* continue with optional signal */
    case 'C':
    case 0:
		if (pid == 0)
			error(NOPCS);
		runmode = CONTIN;
		execsig = getsig(signo);
		break;

    default:
		error(BADMOD);
	}

	if (loopcnt > 0 && runpcs(runmode, execsig))
		printf("breakpoint%16t");
	else
		printf("stopped at%16t");
	delbp();
	printpc();
}
