/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		BADSYM[];
char		BADVAR[];
char		BADKET[];
char		BADSYN[];
char		NOCFN[];
char		NOADR[];
char		BADLOC[];

struct symtab	symbol;
int		lastframe;
int		savlastf;
long int	savframe;
int		savpc;
int		callpc;


char		*lp;
int		octal;
char		*errflg;
long int	localval;
char		isymbol[8];

char		lastc;
unsigned	*endhdr;

long int	dot;
long int	ditto;
int		dotinc;
long int	var[];
long int	expv;


expr(a)		/* term | term dyadic expr |  */
{
	int rc;
	long int lhs;

	rdc();
	lp--;
	rc = term(a);
	while (rc)
	{
		lhs = expv;
		switch (readchar())
		{
	    case '+':
			term(a | 1);
			expv += lhs;
			break;

	    case '-':
			term(a | 1);
			expv = lhs - expv;
			break;

	    case '#':
			term(a | 1);
			expv = round(lhs, expv);
			break;

	    case '*':
			term(a | 1);
			expv *= lhs;
			break;

	    case '%':
			term(a | 1);
			expv = lhs / expv;
			break;

	    case '&':
			term(a | 1);
			expv &= lhs;
			break;

	    case '|':
			term(a | 1);
			expv |= lhs;
			break;

	    case ')':
			if ((a & 2) == 0)
				error(BADKET);
	    default:
			lp--;
			return(rc);
		}
	}
	return(rc);
}

term(a)		/* item | monadic item | (expr) | */
{
	switch (readchar())
	{
    case '*':
		term(a | 1);
		expv = chkget(expv, DSP);
		return(1);

    case '@':
		term(a | 1);
		expv = chkget(expv, ISP);
		return(1);

    case '-':
		term(a | 1);
		expv = -expv;
		return(1);

    case '~':
		term(a | 1);
		expv = ~expv;
		return(1);

    case '(':
		expr(2);
		if (*lp != ')')
			error(BADSYN);
		else
		{
			lp++;
			return(1);
		}

    default:
		lp--;
		return(item(a));
	}
}

item(a)	/* name [ . local ] | number | . | ^ | <var | <register | 'x | | */
{
	int base, d, frpt, regptr;
	char savc;
	char hex;
	long int frame;
	union
	{
		float r;
		long int i;
	} real;
	struct symtab *symp;

	hex = FALSE;
	readchar();
	if (symchar(0))
	{
		readsym();
		if (lastc == '.')
		{
			frame = endhdr[r5] & EVEN;
			lastframe = 0;
			callpc = endhdr[pc];
			while (errflg == 0)
			{
				savpc = callpc;
				findroutine(frame);
				if (eqsym(symbol.symc, isymbol, '~'))
					break;
				lastframe = frame;
				frame = get(frame, DSP) & EVEN;
				if (frame == 0)
					error(NOCFN);
			}
			savlastf = lastframe;
			savframe = frame;
			readchar();
			if (symchar(0))
				chkloc(expv = frame);
		}
		else if ((symp = lookupsym(isymbol)) == 0)
			error(BADSYM);
		else
			expv = symp->symv;
		lp--;
	}
	else if (digit(lastc) || (hex = TRUE, lastc == '#' && hexdigit(readchar())))
	{
		expv = 0;
		base = (lastc == '0' || octal ? 8 : (hex ? 16 : 10));
		while ((hex ? hexdigit(lastc) : digit(lastc)))
		{
			expv *= base;
			if ((d = convdig(lastc)) >= base)
				error(BADSYN);
			expv += d;
			readchar();
			if (expv == 0 && (lastc == 'x' || lastc == 'X'))
			{
				hex = TRUE;
				base = 16;
				readchar();
			}
		}
		if (lastc == '.' && (base == 10 || expv == 0) && !hex)
		{
			real.r = expv;
			frpt = 0;
			base = 10;
			while (digit(readchar()))
			{
				real.r *= base;
				frpt++;
				real.r += lastc - '0';
			}
			while (frpt--)
				real.r /= base;
			expv = real.i;
		}
		lp--;
	}
	else if (lastc == '.')
	{
		readchar();
		if (symchar(0))
		{
			lastframe = savlastf;
			callpc = savpc;
			findroutine(savframe);
			chkloc(savframe);
		}
		else
			expv = dot;
		lp--;
	}
	else if (lastc == '"')
	{
		expv = ditto;
	}
	else if (lastc == '+')
	{
		expv = inkdot(dotinc);
	}
	else if (lastc == '^')
	{
		expv = inkdot(-dotinc);
	}
	else if (lastc == '<')
	{
		savc = rdc();
		if (regptr = getreg(savc))
			expv = endhdr[regptr];
		else if ((base = varchk(savc)) != -1)
			expv = var[base];
		else
			error(BADVAR);
	}
	else if (lastc == '\'')
	{
		d = 4;
		expv = 0;
		while (quotchar())
		{
			if (d--)
			{
				if (d == 1)
					expv =<< 16;
				expv |= ((d & 1) ? lastc : lastc << 8);
			}
			else
				error(BADSYN);
		}
	}
	else if (a)
		error(NOADR);
	else
	{
		lp--;
		return(0);
	}
	return(1);
}

/*
 * service routines for expression reading
 */
readsym()
{
	register char *p;

	p = isymbol;
	do
	{
		if (p < &isymbol[8])
			*p++ = lastc;
		readchar();
	} while (symchar(1));
	while (p < &isymbol[8])
		*p++ = 0;
}

struct symtab *
lookupsym(symstr)
char *symstr;
{
	struct symtab *symp;

	symset();
	while ((symp = symget()))
	{
		if ((symp->symf & SYMCHK) == symp->symf &&
		    eqsym(symp->symc, symstr, '_'))
			return(symp);
	}
	return(0);
}

hexdigit(c)
char c;
{
	return((c >= '0' && c <= '9') || (c >= 'a' && c <= 'f'));
}

convdig(c)
char c;
{
	if (digit(c))
		return(c - '0');
	else if (hexdigit(c))
		return(c - 'a' + 10);
	else
		return(17);
}

digit(c)
char c;
{
	return(c >= '0' && c <= '9');
}

letter(c)
char c;
{
	return(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
}

symchar(dig)
{
	if (lastc == '\\')
	{
		readchar();
		return(TRUE);
	}
	return(letter(lastc) || lastc == '_' || dig && digit(lastc));
}

varchk(name)
{
	if (digit(name))
		return(name - '0');
	if (letter(name))
		return((name & 037) - 1 + 10);
	return(-1);
}

chkloc(frame)
long int frame;
{
	readsym();
	do
	{
		if (localsym(frame) == 0)
			error(BADLOC);
		expv = localval;
	} while (!eqsym(symbol.symc, isymbol, '~'));
}

eqsym(s1, s2, c)
register char *s1, *s2;
char c;
{
	if (eqstr(s1, s2))
		return(TRUE);
	else if (*s1 == c)
	{
		char s3[8];
		register int i;

		s3[0] = c;
		for (i = 1; i < 8; i++)
			s3[i] = *s2++;
		return(eqstr(s1, s3));
	}
}
