#include	<local-system>
#include	<types.h>
#include	<stat.h>
#include	<passwd.h>
#include	<signal.h>
#include	<sgtty.h>
#include	<printers.h>
#include	<fcntl.h>
#include	<stdio.h>

struct dirent
{
	short d_inum;
	char d_name[14];
};

struct lpdrec
{
	char l_cntrl;
	char l_data[39];
};

struct dirent *dtab, *dtabend;
struct stat sb;
struct pwent pe;
char lpddir[] = "0";
struct printer *prp;
#define	LPOSN	0
char *banner, *tty, *mesg, *time, buf[SSIZ];
char aflg;
char nxtch = '\n';
char pagef;		/* set to indicate "pages" is correct */
short lcount, uid, pages, iown, maxdf;

comp(a, b)
struct dirent *a, *b;
{
	register c, ret;

	if (a->d_inum == 0 || b->d_inum == 0)
		return(b->d_inum - a->d_inum);
	ret = 0;
	c = 0;
	while (c < 14 && (ret = a->d_name[c] - b->d_name[c]) == 0)
		c++;
	return(ret);
}

main(ac, av)
register char **av;
{
	register char *arg;
	int i;
	char rflg = 0;
	char *tmp;
	char pflag = 0;
	char outbuf[BUFSIZ];
	extern char *sbrk();

	signal(SIGQUIT, SIG_IGN);
	uid = getuid();
	setbuf(stdout, outbuf);
	while (ac > 1 && (arg = av[1])[0] == '-')
	{
		while (*++arg)
			switch(*arg)
			{
		    case '0':
		    case '1':
		    case '2':
		    case '3':
		    case '4':
		    case '5':
		    case '6':
		    case '7':
		    case '8':
		    case '9':	{

					for (prp = printer; prp < &printer[NPRINTERS]; prp++)
						if (prp->ident == *arg)
							break;
					if (prp == &printer[NPRINTERS])
					{
						fprintf(stderr, "Illegal printer number\n");
						exit(1);
					}
					lpddir[LPOSN] = *arg;
					pflag++;
					break;
				}

		    case 'a':	aflg++;
				break;

		    case 'r':	rflg++;
				break;

		    default:	fprintf(stderr, "Usage: lpq [-a][-r][-0..9]\n");
				exit(1);
			}
		av++;
		ac--;
	}
#ifndef	PR_DFLT
	if (pflag == 0)
	{
		fprintf(stderr, "No printer number specified\n");
		exit(1);
	}
#endif
	if (chdir(LPDDIR) == -1 || chdir(lpddir) == -1)
	{
		fprintf(stderr, "Can't chdir to %s/%s\n", LPDDIR, lpddir);
		exit(1);
	}
	stat(".", &sb);
	if (sb.st_size >= 0100000L)
	{
		fprintf(stderr, "Directory too large\n");
		exit(1);
	}
	sb.st_size -= 32;
	if ((i = open(".", 0)) == -1 || lseek(i, 32L, 0) == -1 ||
		(tmp = sbrk((short)sb.st_size)) == (char *)-1 ||
		read(i, tmp, (short)sb.st_size) != (short)sb.st_size)
	{
		fprintf(stderr, "lpd directory unreadable\n");
		exit(1);
	}
	close(i);
	dtab = (struct dirent *)tmp;
	i = (short)sb.st_size / sizeof *dtab;		/* number of slots */
	/*
	 * Sort the directory entries to print out in printing order.
	 * The empty slots sort to the high end.
	 */
	qsort(dtab, i, sizeof *dtab, comp);
	tmp += (short)sb.st_size;

	{
		register struct dirent *dp;

		for (lcount = 0, dp = dtab; lcount < i && dp->d_inum; lcount++, dp++);
		dtabend = dp;
		i = (int)dp;
		maxdf = tmp - (char *)i;	/* free core occupied by empty slots */

		for (i = 0, dp = dtab; i < lcount; i++, dp++)
			process(i, dp);

	}

	fflush(stdout);
	if (iown == 0 && aflg == 0)
		printf("No jobs found\n");
	else if (rflg)
	{
		while (iown && (rflg = input()) != EOF)
			if (rflg != ',' && rflg != '\n')
			{
				while ((nxtch = getchar()) != '\n');
				printf("Syntax\n");
			}
		if (iown)
			printf("\n");
	}
	exit(0);
}

process(n, dp)
register struct dirent *dp;
{
	static bflg;

	if (getdf(dp->d_name))
	{
		dp->d_inum = 0;
		return;
	}
	if (pe.pw_limits.l_uid == uid || uid == 0)
		iown++;
	else
		dp->d_inum = 0;
	if (aflg || pe.pw_limits.l_uid == uid)
	{
		if (bflg == 0)
		{
			printf(" No  Date  Time      Owner     Banner  Pages  tty  Message\n");
			bflg++;
		}
		if (getpwlog(&pe, buf, sizeof buf) == -1)
			pe.pw_strings[LNAME] = "";
		printf("%3d%12s%11.11s%11.11s",
			n, &time[8], pe.pw_strings[LNAME], banner);
		if (pagef)
		{
			printf("%7d", pages);
			if (tty)
				printf("   ");
			pagef = 0;
		}
		else if (tty)
			printf("          ");
		if (tty)
		{
			printf("%s", tty);
			if (mesg)
				printf("  %s", mesg);
		}
		printf("\n");
	}
}

mint(p)
struct lpdrec *p;
{
	return((p->l_data[1] << 8) | (p->l_data[0] & 0377));
}

input()
{
	register top, bot;

	if (nxtch == '\n')
	{
		printf("Delete: ");
		fflush(stdout);
	}
	bot = top = readnum();
	if (nxtch == '-')
		bot = readnum();
	if (nxtch != EOF)
		if (0 <= top && bot < lcount)
			while (top <= bot)
			{
				delete(top, &dtab[top]);
				top++;
			}
		else
			printf("Line number?\n");
	return(nxtch);
}

readnum()
{
	register i, cr;

	i = cr = 0;
	while ((nxtch = getchar()) == ' ');
	while (nxtch >= '0' && nxtch <= '9')
	{
		i = i * 10 + nxtch - '0';
		nxtch = getchar();
		cr++;
	}
	while (nxtch == ' ')
		nxtch = getchar();
	if (cr == 0)
		i = -1;
	return(i);
}

delete(n, dp)
register struct dirent *dp;
{
	register i;
	register struct lpdrec *p;
	int nred;

	if (dp->d_inum == 0)
	{
		printf("%d: permission denied\n", n);
		return;
	}
	iown--;
	if ((i = open(dp->d_name, 0)) == -1)
		return;
	p = (struct lpdrec *)dtabend;
	nred = read(i, p, maxdf) / sizeof *p;
	close(i);
	for (i = 0; i < nred; i++)
	{
		if (p->l_cntrl == LP_RM)
			unlink(p->l_data);
		else if (p->l_cntrl == LP_PAGES)
		{
			static int	lockfd;
			static char	lfn[] = "../lock0";
			static char	initdone;
			struct lpdlock	lpdlock;

			if (! initdone)
			{
				initdone++;
				lfn[7] = prp->ident;
				if ((lockfd = open(lfn, O_RDWR)) == -1)
				{
					fprintf(stderr, "cannot read lock file\n");
					exit(1);
				}
			} else
				writelock(lockfd);
			lseek(lockfd, 0L, 0);
			read(lockfd, &lpdlock, sizeof lpdlock);
			lpdlock.lpd_pages -= (p->l_data[1] << 8) | (p->l_data[0] & 0377);
			lseek(lockfd, 0L, 0);
			write(lockfd, &lpdlock, sizeof lpdlock);
			unlock();
		}
		p++;
	}
	unlink(dp->d_name);
}

getdf(name)
char *name;
{
	register i;
	register struct lpdrec *p;
	char *t;
	int nred, ncpy;
	extern char *ctime();

	banner = "";
	tty = 0;
	mesg = 0;
	pages = 0;
	pe.pw_limits.l_uid = -1;
	ncpy = 1;

	if (stat(name, &sb) == -1)
		return(1);
	if (sb.st_size > 0100000L ||
	  ((short)sb.st_size > maxdf &&
	    (t = sbrk((short)sb.st_size - maxdf)) == (char *)-1))
	{
		printf("Out of core\n");
		exit(1);
	}
	if (maxdf < (short)sb.st_size)
		maxdf = (short)sb.st_size;
	if ((i = open(name, 0)) == -1)
		return(1);
	time = ctime(sb.st_mtime);
	time[16] = 0;
	p = (struct lpdrec *)dtabend;
	nred = read(i, p, maxdf) / sizeof *p;
	close(i);
	for (i = 0; i < nred; i++)
	{
		switch(p->l_cntrl)
		{
	    case LP_BANNER:
			banner = p->l_data;
			break;

	    case LP_UID:
			pe.pw_limits.l_uid = mint(p);
			break;

	    case LP_PAGES:
			pages = mint(p);
			pagef++;	/* pages valid */
			break;

	    case LP_TTY:
			if (strcmp(p->l_data, "console") == 0)
				tty = "co";
			else
				tty = &p->l_data[8];
			break;

	    case LP_MESG:
			mesg = p->l_data;
			break;

	    case LP_COPIES:
			ncpy = atoi(p->l_data);
			break;
		}
		p++;
	}
	pages *= ncpy;
	return(0);
}
