/*
**	Read a block from line
*/

#include	"log.h"
#include	"proto.h"
#include	"bytes.h"
#include	"rep.h"
#include	"err.h"
#include	"timeouts.h"


enum get_st
{
	newbl_st, seq_st, siz1_st, siz2_st
};


getblk(remote, sizea)
	int *			sizea;
{
	register enum get_st	state;
	register		seq;
	register		x;

	state = newbl_st;

	for(;;)
	{
		if ( tread(remote, &c, 1, rtimeout) )
		{
			errs[E_TIMEOUT].e_count++;
			return R_TIMEOUT;
		}

		x = c & 0xff;

		switch ( state )
		{
		 case newbl_st:	if ( x == STX )
				{
					starting = 0;
					state = seq_st;
				}
				else
					if ( !starting )
						errs[E_SYNC].e_count++;
				continue;
		 case seq_st:	if ( x <= MAXSEQ )
				{
					seq = x;
					state = siz1_st;
					continue;
				}
				errs[E_BADSEQ].e_count++;
				break;
		 case siz1_st:	if ( (*sizea = x) <= DATAZ )
				{
					state = siz2_st;
					continue;
				}
				errs[E_OUTSIZ].e_count++;
				break;
		 case siz2_st:	if ( x == ((~(*sizea))&0xff) )
				{
					if ( *sizea == 0 )
					{
						ack(seq, remote);
						return R_EOF;
					}
					if ( tread(remote, (char *)buf+HEADER, *sizea+TRAILER, inrtimeout) )
					{
						errs[E_TIMEOUT].e_count++;
						return R_TIMEOUT;
					}
					return (int)seq;
				}
				errs[E_BADSIZ].e_count++;
		}

		state = newbl_st;
	}
}
