.text
/
/	the following section contains procedures which are
/	used for various purposes throughout the system.
/
/	each procedure is preceded by a description of the
/	calling sequence. usually the arguments are in registers
/	but arguments can also occur on the stack and as
/	parameters assembled after the jsr instruction.
/
/	the following considerations apply to these descriptions.
/
/	1)   the stack pointer (sp) is not changed unless the
/	change is explicitly documented in the call.
/
/	2)   registers whose entry values are not mentioned
/	may contain any value except that xl,xr may only
/	contain proper (collectable) pointer values.
/
/	3)   registers not mentioned on exit contain the same
/	values as they did on entry except that values in
/	xr,xl may have been relocated by the collector.
/
/	4)   registers which are destroyed on exit may contain
/	any value except that values in xl,xr are proper
/	(collectable) pointers.
/
/	5)   the code pointer register points to the current
/	code location on entry and is unchanged on exit.
/
/	in the above description, a collectable pointer is one
/	which either points outside the dynamic region or
/	points to the start of a block in the dynamic region.
/
/	in those cases where the calling sequence contains
/	parameters which are used as alternate return points,
/	these parameters may be replaced by error codes
/	assembled with the err instruction. this will result
/	in the posting of the error if the return is taken.
/
/	the procedures all have names consisting of five letters
/	and are in alphabetical order by their names.
/
/	acess - access variable value with trace/input checks
/
/	acess loads the value of a variable. trace and input
/	associations are tested for and executed as required.
/	acess also handles the special cases of pseudo-variables.
/
/	(xl)		variable name base
/	(wa)		variable name offset
/	jsr	pc,acess      call to access value
/	.word	loc	transfer loc if access failure
/	(xr)		variable value
/	(wa,wb,wc)	destroyed
/	(xl,ra)		destroyed
/
/	failure can occur if an input association causes an end
/	of file condition or if the evaluation of an expression
/	associated with an expression variable fails.
/
acess:	/prc	r,1		/ entry point (recursive)
/
/	merge back here after getting name from expression var
/
acs01:	mov	xl,xr		/ copy name base
	add	wa,xr		/ point to variable location
	mov	(xr),xr		/ load variable value
/
/	loop here to check for successive trblks
/
acs02:	cmp	(xr),$bztrt	/ jump if not trapped
	bne	acs18
/
/	here if trapped
/
	cmp	xr,$trbkv	/ jump if keyword variable
	beq	acs12
	cmp	xr,$trbev	/ jump if not expression variable
	bne	acs05
/
/	here for expression variable, evaluate variable
/
	mov	evexp*2(xl),xr	/ load expression pointer
	mov	$1,wb		/ set for evaluation by name
	jsr	pc,evalx	/ evaluate expression
		acs04		/ jump if evaluation failure
	br	acs01		/ else loop back to get value
/
/	acess (continued)
/
/	here on reading end of file
/
acs03:	add	$3*2,sp		/ pop trblk ptr, name base and offset
/
/	merge here when evaluation of expression fails
/
acs04:	mov	*(sp)+,pc	/ take alternate (failure) return
/
/	here if not keyword or expression variable
/
acs05:	mov	trtyp*2(xr),wb	/ load trap type code
	tst	wb		/ jump if not input association
	bne	acs10
	tst	kvinp		/ ignore input assoc if input is off
	beq	acs09
/
/	here for input association
/
	mov	xl,-(sp)	/ stack name base
	mov	wa,-(sp)	/ stack name offset
	mov	xr,-(sp)	/ stack trblk pointer
	mov	trfpt*2(xr),xl	/ get file ctrl blk ptr or zero
	tst	xl		/ jump if not standard input file
	bne	acs06
/
/	here to read from standard input file
/
	mov	cswin,wa	/ xxx from last -inxxx card
	jsr	pc,sysrl	/ get max input buffer length
	jsr	pc,alocs	/ build string of appropriate length
	jsr	pc,sysrd	/ read next standard input image
		acs03		/ jump to fail exit if end of file
	br	acs07		/ else merge with other file case
/
/	here for input from other than standard input file
/
acs06:	mov	xl,wa		/ fcblk ptr
	jsr	pc,sysil	/ get input record max length (to wa)
	jsr	pc,alocs	/ allocate string of correct size
	mov	xl,wa		/ fcblk ptr
	jsr	pc,sysin	/ call system input routine
		acs03		/ jump to fail exit if end of file
		421.		/ input from file caused non-recoverabl
		423.		/ input file record has incorrect forma
/
/	acess (continued)
/
/	merge here after obtaining input record
/
acs07:	mov	kvtrm,wb	/ load trim indicator
	jsr	pc,trimr	/ trim record as required
	mov	xr,wb		/ copy result pointer
	mov	(sp),xr		/ reload pointer to trblk
/
/	loop to chase to end of trblk chain and store value
/
acs08:	mov	xr,xl		/ save pointer to this trblk
	mov	trnxt*2(xr),xr	/ load forward pointer
	cmp	(xr),$bztrt	/ loop if this is another trblk
	beq	acs08
	mov	wb,trnxt*2(xl)	/ else store result at end of chain
	mov	(sp)+,xr	/ restore initial trblk pointer
	mov	(sp)+,wa	/ restore name offset
	mov	(sp)+,xl	/ restore name base pointer
/
/	come here to move to next trblk
/
acs09:	mov	trnxt*2(xr),xr	/ load forward ptr to next value
	br	acs02		/ back to check if trapped
/
/	here to check for access trace trblk
/
acs10:	cmp	wb,$1		/ loop back if not access trace
	bne	acs09
	tst	kvtra		/ ignore access trace if trace off
	beq	acs09
	dec	kvtra		/ else decrement trace count
	tst	trfnc*2(xr)	/ jump if print trace
	beq	acs11
/
/	acess (continued)
/
/	here for full function trace
/
	jsr	pc,trxeq	/ call routine to execute trace
	br	acs09		/ jump for next trblk
/
/	here for case of print trace
/
acs11:	jsr	pc,prtsn	/ print statement number
	jsr	pc,prtnv	/ print name = value
	br	acs09		/ jump back for next trblk
/
/	here for keyword variable
/
acs12:	mov	kvnum*2(xl),xr	/ load keyword number
	cmp	xr,$kzvzz	/ jump if not one word value
	bhis	acs14
	mov	kvabe(xr),ia	/ else load value as integer
/
/	common exit with keyword value as integer in (ia)
/
acs13:	jsr	pc,icbld	/ build icblk
	br	acs18		/ jump to exit
/
/	here if not one word keyword value
/
acs14:	cmp	xr,$kzszz	/ jump if special case
	bhis	acs15
	sub	$kzvzz,xr	/ else get offset
	add	$ndabo,xr	/ point to pattern value
	br	acs18		/ jump to exit
/
/	here if special keyword case
/
acs15:	mov	kvrtn,xl	/ load rtntype in case
	mov	kvstl,ia	/ load stlimit in case
	sub	$kzszz,xr	/ get case number
	asl	xr		/ switch on keyword number
	mov	.+4(xr),pc
		acs16		/ jump if alphabet
		acs17		/ rtntype
		acs19		/ stcount
		acs20		/ errtext
		acs13		/ stlimit
/
/	acess (continued)
/
/	alphabet
/
acs16:	mov	kvalp,xl	/ load pointer to alphabet string
/
/	rtntype merges here
/
acs17:	mov	xl,xr		/ copy string ptr to proper reg
/
/	common return point
/
acs18:	add	$1*2,(sp)	/ return to acess caller
	rts	pc
/
/	here for stcount (ia has stlimit)
/
acs19:	sub	kvstc,ia	/ stcount = limit - left
	br	acs13		/ merge back with integer result
/
/	errtext
/
acs20:	mov	rzetx,xr	/ get errtext string
	br	acs18		/ merge with result
	/enp			/ end procedure acess
/
/	acomp -- compare two arithmetic values
/
/	1(sp)		first argument
/	0(sp)		second argument
/	jsr	pc,acomp      call to compare values
/	.word	loc	transfer loc if arg1 is non-numeric
/	.word	loc	transfer loc if arg2 is non-numeric
/	.word	loc	transfer loc for arg1 lt arg2
/	.word	loc	transfer loc for arg1 eq arg2
/	.word	loc	transfer loc for arg1 gt arg2
/	(normal return is never given)
/	(wa,wb,wc,ia,ra)      destroyed
/	(xl,xr)		destroyed
/
.bss
acompret:	.=.+2
.text
acomp:	/prc	n,5		/ entry point
	mov	(sp)+,acompret
	jsr	pc,arith	/ load arithmetic operands
		acmp7		/ jump if first arg non-numeric
		acmp8		/ jump if second arg non-numeric
		acmp4		/ jump if real arguments
/
/	here for integer arguments
/
	sub	icval*2(xl),ia	/ subtract to compare
	bvs	acmp3
	tst	ia		/ else jump if arg1 lt arg2
	blt	acmp5
	tst	ia		/ jump if arg1 eq arg2
	beq	acmp2
/
/	here if arg1 gt arg2
/
acmp1:	add	$4*2,acompret	/ take gt exit
	mov	*acompret,pc
/
/	here if arg1 eq arg2
/
acmp2:	add	$3*2,acompret	/ take eq exit
	mov	*acompret,pc
/
/	acomp (continued)
/
/	here for integer overflow on subtract
/
acmp3:	mov	icval*2(xl),ia	/ load second argument
	tst	ia		/ gt if negative
	blt	acmp1
	br	acmp5		/ else lt
/
/	here for real operands
/
acmp4:	mov	xl,-(sp)	/ subtract to compare
	add	$rcval*2,(sp)
	jsr	pc,sbr
	bvs	acmp6
	jsr	pc,fts		/ else jump if arg1 gt
	bgt	acmp1
	jsr	pc,fts		/ jump if arg1 eq arg2
	beq	acmp2
/
/	here if arg1 lt arg2
/
acmp5:	add	$2*2,acompret	/ take lt exit
	mov	*acompret,pc
/
/	here if overflow on real subtraction
/
acmp6:	mov	xl,-(sp)	/ reload arg2
	add	$rcval*2,(sp)
	jsr	pc,ldr
	jsr	pc,fts		/ gt if negative
	blt	acmp1
	br	acmp5		/ else lt
/
/	here if arg1 non-numeric
/
acmp7:	mov	*acompret,pc	/ take error exit
/
/	here if arg2 non-numeric
/
acmp8:	add	$1*2,acompret	/ take error exit
	mov	*acompret,pc
	/enp			/ end procedure acomp
/
/	alloc		allocate block of dynamic storage
/
/	(wa)		length required in bytes
/	jsr	pc,alloc      call to allocate block
/	(xr)		pointer to allocated block
/
alloc:	/prc	e,0		/ entry point
/
/	common exit point
/
aloc1:	mov	dnamp,xr	/ point to next available loc
	add	wa,xr		/ point past allocated block
	bcs	aloc2		/ jump if address overflow *f013*
	cmp	xr,dname	/ jump if not enough room
	bhi	aloc2
	mov	xr,dnamp	/ store new pointer
	sub	wa,xr		/ point back to start of allocated bk
	rts	pc		/ return to caller
/
/	here if insufficient room, try a garbage collection
/
aloc2:	mov	wb,allsv	/ save wb
	clr	wb		/ set no upward move for gbcol
	jsr	pc,gbcol	/ garbage collect
/
/	see if room after gbcol or sysmm call
/
aloc3:	mov	dnamp,xr	/ point to first available loc
	add	wa,xr		/ point past new block
	cmp	xr,dname	/ jump if there is room now
	blos	aloc4
/
/	failed again, see if we can get more core
/
	jsr	pc,sysmm	/ try to get more memory
	add	xr,dname	/ bump ptr by amount obtained
	tst	xr		/ jump if got more core
	bne	aloc3
	add	rsmem,dname	/ get the reserve memory
	clr	rsmem		/ only permissible once
	inc	errft		/ fatal error
	mov	$425.,pc	/ memory overflow
/
/	here after successful garbage collection
/
aloc4:	mov	ia,allia	/ save ia
	mov	dname,wb	/ get dynamic end adrs
	sub	dnamp,wb	/ compute free store
	clc			/ convert bytes to words
	ror	wb
	mov	wb,ia		/ put free store in ia
	mul	alfsf,ia	/ multiply by free store factor
	bcs	aloc5
	mov	dname,wb	/ dynamic end adrs
	sub	dnamb,wb	/ compute total amount of dynamic
	clc			/ convert to words
	ror	wb
	mov	wb,aldyn	/ store it
	sub	aldyn,ia	/ subtract from scaled up free store
	tst	ia		/ jump if sufficient free store
	bgt	aloc5
	jsr	pc,sysmm	/ try to get more store
	add	xr,dname	/ adjust dynamic end adrs
/
/	merge to restore ia and wa
/
aloc5:	mov	allia,ia	/ recover ia
	mov	allsv,wb	/ restore wb
	br	aloc1		/ jump back to exit
	/enp			/ end procedure alloc
/
/	alocs -- allocate string block
/
/	alocs is used to build a frame for a string block into
/	which the actual characters are placed by the caller.
/	all strings are created with a call to alocs (the
/	exceptions occur in trimr and szrpl procedures).
/
/	(wa)		length of string to be allocated
/	jsr	pc,alocs      call to allocate scblk
/	(xr)		pointer to resulting scblk
/	(wa)		destroyed
/	(wc)		character count (entry value of wa)
/
/	the resulting scblk has the type word and the length
/	filled in and the last word is cleared to zero characters
/	to ensure correct right padding of the final word.
/
alocs:	/prc	e,0		/ entry point
	cmp	wa,kvmxl	/ jump if length exceeeds maxlength
	bhi	alcs2
	mov	wa,wc		/ else copy length
	add	$5,wa		/ compute length of scblk in bytes
	bic	$1,wa
	mov	dnamp,xr	/ point to next available location
	add	wa,xr		/ point past block
	bcs	0f		/ jump if address overflow *f013*
	cmp	xr,dname	/ jump if there is room
	blos	alcs1
0:	clr	xr		/ else clear garbage xr value
	jsr	pc,alloc	/ and use standard allocator
	add	wa,xr		/ point past end of block to merge
/
/	merge here with xr pointing beyond new block
/
alcs1:	mov	xr,dnamp	/ set updated storage pointer
	clr	-(xr)		/ store zero chars in last word
	sub	$2,wa		/ decrement length
	sub	wa,xr		/ point back to start of block
	mov	$bzscl,(xr)	/ set type word
	mov	wc,sclen*2(xr)	/ store length in chars
	rts	pc		/ return to alocs caller
/
/	come here if string is too long
/
alcs2:	mov	$427.,pc	/ string length exceeds value of maxlen
	/enp			/ end procedure alocs
/
/	alost -- allocate space in static region
/
/	(wa)		length required in bytes
/	jsr	pc,alost      call to allocate space
/	(xr)		pointer to allocated block
/	(wb)		destroyed
/
/	note that the coding ensures that the resulting value
/	of state is always less than dnamb. this fact is used
/	in testing a variable name for being in the static region
/
alost:	/prc	e,0		/ entry point
/
/	merge back here after allocating new chunk
/
alst1:	mov	state,xr	/ point to current end of area
	add	wa,xr		/ point beyond proposed block
	cmp	xr,dnamb	/ jump if overlap with dynamic area
	bhis	alst2
	mov	xr,state	/ else store new pointer
	sub	wa,xr		/ point back to start of block
	rts	pc		/ return to alost caller
/
/	here if no room, prepare to move dynamic storage up
/
alst2:	mov	wa,alsta	/ save wa
	cmp	wa,$ezsts*2	/ skip if requested chunk is large
	bhis	alst3
	mov	$ezsts*2,wa	/ else set to get large enough chunk
/
/	here with amount to move up in wa
/
alst3:	jsr	pc,alloc	/ allocate block to ensure room
	mov	xr,dnamp	/ and delete it
	mov	wa,wb		/ copy move up amount
	jsr	pc,gbcol	/ call gbcol to move dynamic area up
	mov	alsta,wa	/ restore wa
	br	alst1		/ loop back to try again
	/enp			/ end procedure alost
/
/	arith -- fetch arithmetic operands
/
/	arith is used by functions and operators which expect
/	two numeric arguments (operands) which must both be
/	integer or both be real. arith fetches two arguments from
/	the stack and performs any necessary conversions.
/
/	1(sp)		first argument (left operand)
/	0(sp)		second argument (right operand)
/	jsr	pc,arith      call to fetch numeric arguments
/	.word	loc	transfer loc for opnd 1 non-numeric
/	.word	loc	transfer loc for opnd 2 non-numeric
/	.word	loc	transfer loc for real operands
/
/	for integer args, control returns past the parameters
/
/	(ia)		left operand value
/	(xr)		ptr to icblk for left operand
/	(xl)		ptr to icblk for right operand
/	(sp)		popped twice
/	(wa,wb,ra)	destroyed
/
/	for real arguments, control returns to the location
/	specified by the third parameter.
/
/	(ra)		left operand value
/	(xr)		ptr to rcblk for left operand
/	(xl)		ptr to rcblk for right operand
/	(wa,wb,wc)	destroyed
/	(sp)		popped twice
/
/	arith (continued)
/
/	entry point
/
.bss
arithret:	.=.+2
.text
arith:	/prc	n,3		/ entry point
	mov	(sp)+,arithret
	mov	(sp)+,xl	/ load right operand
	mov	(sp)+,xr	/ load left operand
	mov	(xl),wa		/ get right operand type word
	cmp	wa,$bzicl	/ jump if integer
	beq	arth1
	cmp	wa,$bzrcl	/ jump if real
	beq	arth4
	mov	xr,-(sp)	/ else replace left arg on stack
	mov	xl,xr		/ copy left arg pointer
	jsr	pc,gtnum	/ convert to numeric
		arth6		/ jump if unconvertible
	mov	xr,xl		/ else copy converted result
	mov	(xl),wa		/ get right operand type word
	mov	(sp)+,xr	/ reload left argument
	cmp	wa,$bzrcl	/ jump if right arg is real
	beq	arth4
/
/	here if right arg is an integer
/
arth1:	cmp	(xr),$bzicl	/ jump if left arg not integer
	bne	arth3
/
/	exit for integer case
/
arth2:	mov	icval*2(xr),ia	/ load left operand value
	add	$3*2,arithret	/ return to arith caller
	mov	arithret,pc
/
/	here for right operand integer, left operand not
/
arth3:	jsr	pc,gtnum	/ convert left arg to numeric
		arth7		/ jump if not convertible
	cmp	wa,$bzicl	/ jump back if integer-integer
	beq	arth2
/
/	here we must convert real-integer to real-real
/
	mov	xr,-(sp)	/ put left arg back on stack
	mov	icval*2(xl),ia	/ load right argument value
	jsr	pc,itr		/ convert to real
	jsr	pc,rcbld	/ get real block for right arg, merge
	mov	xr,xl		/ copy right arg ptr
	mov	(sp)+,xr	/ load left argument
	br	arth5		/ merge for real-real case
/
/	arith (continued)
/
/	here if right argument is real
/
arth4:	cmp	(xr),$bzrcl	/ jump if left arg real
	beq	arth5
	jsr	pc,gtrea	/ else convert to real
		arth7		/ error if unconvertible
/
/	here for real-real
/
arth5:	mov	xr,-(sp)	/ load left operand value
	add	$rcval*2,(sp)
	jsr	pc,ldr
	add	$2*2,arithret	/ take real-real exit
	mov	*arithret,pc
/
/	here for error converting right argument
/
arth6:	add	$1*2,arithret	/ take appropriate error exit
	mov	*arithret,pc
/
/	here for error converting left operand
/
arth7:	mov	*arithret,pc	/ take appropriate error return
	/enp			/ end procedure arith
/
/	asign -- perform assignment
/
/	asign performs the assignment of a value to a variable
/	with appropriate checks for output associations and
/	value trace associations which are executed as required.
/	asign also handles the special cases of assignment to
/	pattern and expression variables.
/
/	(wb)		value to be assigned
/	(xl)		base pointer for variable
/	(wa)		offset for variable
/	jsr	pc,asign      call to assign value to variable
/	.word	loc	transfer loc for failure
/	(xr,xl,wa,wb,wc)      destroyed
/	(ra)		destroyed
/
/	failure occurs if the evaluation of an expression
/	associated with an expression variable fails.
/
asign:	/prc	r,1		/ entry point (recursive)
/
/	merge back here to assign result to expression variable.
/
asg01:	add	wa,xl		/ point to variable value
	mov	(xl),xr		/ load variable value
	cmp	(xr),$bztrt	/ jump if trapped
	beq	asg02
	mov	wb,(xl)		/ else perform assignment
	clr	xl		/ clear garbage value in xl
	add	$1*2,(sp)	/ and return to asign caller
	rts	pc
/
/	here if value is trapped
/
asg02:	sub	wa,xl		/ restore name base
	cmp	xr,$trbkv	/ jump if keyword variable
	beq	asg14
	cmp	xr,$trbev	/ jump if not expression variable
	bne	asg04
/
/	here for assignment to expression variable
/
	mov	evexp*2(xl),xr	/ point to expression
	mov	wb,-(sp)	/ store value to assign on stack
	mov	$1,wb		/ set for evaluation by name
	jsr	pc,evalx	/ evaluate expression by name
		asg03		/ jump if evaluation fails
	mov	(sp)+,wb	/ else reload value to assign
	br	asg01		/ loop back to perform assignment
/
/	asign (continued)
/
/	here for failure during expression evaluation
/
asg03:	add	$2,sp		/ remove stacked value entry
	mov	*(sp)+,pc	/ take failure exit
/
/	here if not keyword or expression variable
/
asg04:	mov	xr,-(sp)	/ save ptr to first trblk
/
/	loop to chase down trblk chain and assign value at end
/
asg05:	mov	xr,wc		/ save ptr to this trblk
	mov	trnxt*2(xr),xr	/ point to next trblk
	cmp	(xr),$bztrt	/ loop back if another trblk
	beq	asg05
	mov	wc,xr		/ else point back to last trblk
	mov	wb,trval*2(xr)	/ store value at end of chain
	mov	(sp)+,xr	/ restore ptr to first trblk
/
/	loop to process trblk entries on chain
/
asg06:	mov	trtyp*2(xr),wb	/ load type code of trblk
	cmp	wb,$2		/ jump if value trace
	beq	asg08
	cmp	wb,$3		/ jump if output association
	beq	asg10
/
/	here to move to next trblk on chain
/
asg07:	mov	trnxt*2(xr),xr	/ point to next trblk on chain
	cmp	(xr),$bztrt	/ loop back if another trblk
	beq	asg06
	add	$1*2,(sp)	/ else end of chain, return to caller
	rts	pc
/
/	here to process value trace
/
asg08:	tst	kvtra		/ ignore value trace if trace off
	beq	asg07
	dec	kvtra		/ else decrement trace count
	tst	trfnc*2(xr)	/ jump if print trace
	beq	asg09
	jsr	pc,trxeq	/ else execute function trace
	br	asg07		/ and loop back
/
/	asign (continued)
/
/	here for print trace
/
asg09:	jsr	pc,prtsn	/ print statement number
	jsr	pc,prtnv	/ print name = value
	br	asg07		/ loop back for next trblk
/
/	here for output association
/
asg10:	tst	kvoup		/ ignore output assoc if output off
	beq	asg07
	mov	xr,xl		/ else copy trblk pointer
	mov	trval*2(xl),-(sp) / stack value to output
	jsr	pc,gtstg	/ convert to string
		asg12		/ get datatype name if unconvertible
/
/	merge with string for output
/
asg11:	mov	trfpt*2(xl),wa	/ fcblk ptr
	tst	wa		/ jump if standard output file
	beq	asg13
/
/	here for output to non-standard output file
/
	jsr	pc,sysou	/ call system output routine
		429.		/ output caused file overflow
		431.		/ output caused non-recoverable error
	add	$1*2,(sp)	/ else all done, return to caller
	rts	pc
/
/	if not printable, get datatype name instead
/
asg12:	jsr	pc,dtype	/ call datatype routine
	br	asg11		/ merge
/
/	here to print a string on the printer
/
asg13:	jsr	pc,prtst	/ print string value
	jsr	pc,prtnl	/ end of line
	add	$1*2,(sp)	/ return to caller
	rts	pc
/
/	asign (continued)
/
/	here for keyword assignment
/
asg14:	mov	kvnum*2(xl),xl	/ load keyword number
	cmp	xl,$kzetx	/ jump if errtext
	beq	asg19
	mov	wb,xr		/ copy value to be assigned
	jsr	pc,gtint	/ convert to integer
		433.		/ keyword value assigned is not integer
	mov	icval*2(xr),ia	/ else load value
	cmp	xl,$kzstl	/ jump if special case of stlimit
	beq	asg16
	mov	ia,wa		/ else get addr integer, test ovflow
	cmp	wa,dnamx	/ fail if too large *f014*
	bhis	asg18
	cmp	xl,$kzert	/ jump if special case of errtype
	beq	asg17
	cmp	xl,$kzpzz	/ jump unless protected
	blo	asg15
	mov	$435.,pc	/ keyword in assignment is protected
/
/	here to do assignment if not protected
/
asg15:	mov	wa,kvabe(xl)	/ store new value
	add	$1*2,(sp)	/ return to asign caller
	rts	pc
/
/	here for special case of stlimit
/
/	since stcount is maintained as (stlimit-stcount)
/	it is also necessary to modify stcount appropriately.
/
asg16:	sub	kvstl,ia	/ subtract old limit
	add	kvstc,ia	/ add old counter
	mov	ia,kvstc	/ store new counter value
	mov	icval*2(xr),ia	/ reload new limit value
	mov	ia,kvstl	/ store new limit value
	add	$1*2,(sp)	/ return to asign caller
	rts	pc
/
/	here for special case of errtype
/
asg17:	cmp	wa,$999.	/ ok to signal if in range
	bhi	.+6
	jmp	error
/
/	here if value assigned is out of range
/
asg18:	mov	$437.,pc	/ keyword value assigned is negative or
/
/	here for special case of errtext
/
asg19:	mov	wb,-(sp)	/ stack value
	jsr	pc,gtstg	/ convert to string
		439.		/ value assigned to keyword errtext is
	mov	xr,rzetx	/ make assignment
	add	$1*2,(sp)	/ return to caller
	rts	pc
	/enp			/ end procedure asign
/
/	asinp -- assign during pattern match
/
/	asinp is like asign and has a similar calling sequence
/	and effect. the difference is that the global pattern
/	variables are saved and restored if required.
/
/	(xl)		base pointer for variable
/	(wa)		offset for variable
/	(wb)		value to be assigned
/	jsr	pc,asinp      call to assign value to variable
/	.word	loc	transfer loc if failure
/	(xr,xl)		destroyed
/	(wa,wb,wc,ra)	destroyed
/
asinp:	/prc	r,1		/ entry point, recursive
	add	wa,xl		/ point to variable
	mov	(xl),xr		/ load current contents
	cmp	(xr),$bztrt	/ jump if trapped
	beq	asnp1
	mov	wb,(xl)		/ else perform assignment
	clr	xl		/ clear garbage value in xl
	add	$1*2,(sp)	/ return to asinp caller
	rts	pc
/
/	here if variable is trapped
/
asnp1:	sub	wa,xl		/ restore base pointer
	mov	pmssl,-(sp)	/ stack subject string length
	mov	pmhbs,-(sp)	/ stack history stack base ptr
	mov	rzpms,-(sp)	/ stack subject string pointer
	mov	pmdfl,-(sp)	/ stack dot flag
	jsr	pc,asign	/ call full-blown assignment routine
		asnp2		/ jump if failure
	mov	(sp)+,pmdfl	/ restore dot flag
	mov	(sp)+,rzpms	/ restore subject string pointer
	mov	(sp)+,pmhbs	/ restore history stack base pointer
	mov	(sp)+,pmssl	/ restore subject string length
	add	$1*2,(sp)	/ return to asinp caller
	rts	pc
/
/	here if failure in asign call
/
asnp2:	mov	(sp)+,pmdfl	/ restore dot flag
	mov	(sp)+,rzpms	/ restore subject string pointer
	mov	(sp)+,pmhbs	/ restore history stack base pointer
	mov	(sp)+,pmssl	/ restore subject string length
	mov	*(sp)+,pc	/ take failure exit
	/enp			/ end procedure asinp
/
/	blkln -- determine length of block
/
/	blkln determines the length of a block in dynamic store.
/
/	(wa)		first word of block
/	(xr)		pointer to block
/	jsr	pc,blkln      call to get block length
/	(wa)		length of block in bytes
/	(xl)		destroyed
/
/	blkln is used by the garbage collector and is not
/	permitted to call gbcol directly or indirectly.
/
/	the first word stored in the block (i.e. at xr) may
/	be anything, but the contents of wa must be correct.
/
blkln:	/prc	e,0		/ entry point
	mov	wa,xl		/ copy first word
	mov	-2(xl),xl	/ get entry id (blzxx)
	asl	xl		/ switch on block type
	mov	.+4(xl),pc
		bln01		/ arblk
		bln01		/ cdblk
		bln01		/ exblk
		bln07		/ icblk
		bln03		/ nmblk
		bln02		/ p0blk
		bln03		/ p1blk
		bln04		/ p2blk
		bln09		/ rcblk
		bln10		/ scblk
		bln02		/ seblk
		bln01		/ tbblk
		bln01		/ vcblk
		bln00
		bln00
		bln08		/ pdblk
		bln05		/ trblk
		bln00
		bln00
		bln06		/ ctblk
		bln01		/ dfblk
		bln01		/ efblk
		bln03		/ evblk
		bln05		/ ffblk
		bln03		/ kvblk
		bln01		/ pfblk
		bln04		/ teblk
/
/	blkln (continued)
/
/	here for blocks with length in second word
/
bln00:	mov	1*2(xr),wa	/ load length
	rts	pc		/ return to blkln caller
/
/	here for length in third word (ar,cd,df,ef,ex,pf,tb,vc)
/
bln01:	mov	2*2(xr),wa	/ load length from third word
	rts	pc		/ return to blkln caller
/
/	here for two word blocks (p0,se)
/
bln02:	mov	$2*2,wa		/ load length (two words)
	rts	pc		/ return to blkln caller
/
/	here for three word blocks (nm,p1,ev,kv)
/
bln03:	mov	$3*2,wa		/ load length (three words)
	rts	pc		/ return to blkln caller
/
/	here for four word blocks (p2,te)
/
bln04:	mov	$4*2,wa		/ load length (four words)
	rts	pc		/ return to blkln caller
/
/	here for five word blocks (ff,tr)
/
bln05:	mov	$5*2,wa		/ load length
	rts	pc		/ return to blkln caller
/
/	blkln (continued)
/
/	here for ctblk
/
bln06:	mov	$ctsiz*2,wa	/ set size of ctblk
	rts	pc		/ return to blkln caller
/
/	here for icblk
/
bln07:	mov	$icsiz*2,wa	/ set size of icblk
	rts	pc		/ return to blkln caller
/
/	here for pdblk
/
bln08:	mov	pddfp*2(xr),xl	/ point to dfblk
	mov	dfpdl*2(xl),wa	/ load pdblk length from dfblk
	rts	pc		/ return to blkln caller
/
/	here for rcblk
/
bln09:	mov	$rcsiz*2,wa	/ set size of rcblk
	rts	pc		/ return to blkln caller
/
/	here for scblk
/
bln10:	mov	sclen*2(xr),wa	/ load length in characters
	add	$5,wa		/ calculate length in bytes
	bic	$1,wa
	rts	pc		/ return to blkln caller
	/enp			/ end procedure blkln
/
/	cdgcg -- generate code for complex goto
/
/	used by cmpil to process complex goto tree
/
/	(wb)		must be collectable
/	(xr)		expression pointer
/	jsr	pc,cdgcg      call to generate complex goto
/	(xl,xr,wa)	destroyed
/
cdgcg:	/prc	e,0		/ entry point
	mov	cmopn*2(xr),xl	/ get unary goto operator
	mov	cmrop*2(xr),xr	/ point to goto operand
	cmp	xl,$opdvd	/ jump if direct goto
	beq	cdgc2
	jsr	pc,cdgnm	/ generate opnd by name if not direct
/
/	return point
/
cdgc1:	mov	xl,wa		/ goto operator
	jsr	pc,cdwrd	/ generate it
	rts	pc		/ return to caller
/
/	direct goto
/
cdgc2:	jsr	pc,cdgvl	/ generate operand by value
	br	cdgc1		/ merge to return
	/enp			/ end procedure cdgcg
/
/	cdgex -- build expression block
/
/	cdgex is passed a pointer to an expression tree (see
/	expan) and returns an expression (seblk or exblk).
/
/	(wc)		some collectable value
/	(wb)		integer in range 0 le x le cfpzl
/	(xl)		ptr to expression tree
/	jsr	pc,cdgex      call to build expression
/	(xr)		ptr to seblk or exblk
/	(xl,wa,wb)	destroyed
/
cdgex:	/prc	r,0		/ entry point, recursive
	cmp	(xl),$bzvrz	/ jump if not variable
	blos	cdgx1
/
/	here for natural variable, build seblk
/
	mov	$sesiz*2,wa	/ set size of seblk
	jsr	pc,alloc	/ allocate space for seblk
	mov	$bzsel,(xr)	/ set type word
	mov	xl,sevar*2(xr)	/ store vrblk pointer
	rts	pc		/ return to cdgex caller
/
/	here if not variable, build exblk
/
cdgx1:	mov	xl,xr		/ copy tree pointer
	mov	wc,-(sp)	/ save wc
	mov	cwcof,xl	/ save current offset
	mov	(xr),wa		/ get type word
	cmp	wa,$bzcmt	/ call by value if not cmblk
	bne	cdgx2
	cmp	cmtyp*2(xr),$czznm / jump if cmblk only by value
	bhis	cdgx2
/
/	cdgex (continued)
/
/	here if expression can be evaluated by name
/
	jsr	pc,cdgnm	/ generate code by name
	mov	$ornmz,wa	/ load return by name word
	br	cdgx3		/ merge with value case
/
/	here if expression can only be evaluated by value
/
cdgx2:	jsr	pc,cdgvl	/ generate code by value
	mov	$orvlz,wa	/ load return by value word
/
/	merge here to construct exblk
/
cdgx3:	jsr	pc,cdwrd	/ generate return word
	jsr	pc,exbld	/ build exblk
	mov	(sp)+,wc	/ restore wc
	rts	pc		/ return to cdgex caller
	/enp			/ end procedure cdgex
/
/	cdgnm -- generate code by name
/
/	cdgnm is called during the compilation process to
/	generate code by name for an expression. see cdblk
/	description for details of code generated. the input
/	to cdgnm is an expression tree as generated by expan.
/
/	cdgnm is a recursive procedure which proceeds by making
/	recursive calls to generate code for operands.
/
/	(wb)		integer in range 0 le n le dnamb
/	(xr)		ptr to tree generated by expan
/	(wc)		constant flag (see below)
/	jsr	pc,cdgnm      call to generate code by name
/	(xr,wa)		destroyed
/	(wc)		set non-zero if non-constant
/
/	wc is set to a non-zero (collectable) value if the
/	expression for which code is generated cannot be
/	evaluated at compile time, otherwise wc is unchanged.
/
/	the code is generated in the current ccblk (see cdwrd).
/
cdgnm:	/prc	r,0		/ entry point, recursive
	mov	xl,-(sp)	/ save entry xl
	mov	wb,-(sp)	/ save entry wb
	jsr	pc,chk		/ check for stack overflow
	mov	(xr),wa		/ load type word
	cmp	wa,$bzcmt	/ jump if cmblk
	beq	cgn04
	cmp	wa,$bzvrz	/ jump if simple variable
	bhis	cgn02
/
/	merge here for operand yielding value (e.g. constant)
/
cgn01:	mov	$441.,pc	/ syntax error. value used where name i
/
/	here for natural variable reference
/
cgn02:	mov	$olvnz,wa	/ load variable load call
	jsr	pc,cdwrd	/ generate it
	mov	xr,wa		/ copy vrblk pointer
	jsr	pc,cdwrd	/ generate vrblk pointer
/
/	cdgnm (continued)
/
/	here to exit with wc set correctly
/
cgn03:	mov	(sp)+,wb	/ restore entry wb
	mov	(sp)+,xl	/ restore entry xl
	rts	pc		/ return to cdgnm caller
/
/	here for cmblk
/
cgn04:	mov	xr,xl		/ copy cmblk pointer
	mov	cmtyp*2(xr),xr	/ load cmblk type
	cmp	xr,$czznm	/ error if not name operand
	bhis	cgn01
	asl	xr		/ else switch on type
	mov	.+4(xr),pc
		cgn05		/ array reference
		cgn08		/ function call
		cgn09		/ deferred expression
		cgn10		/ indirect reference
		cgn11		/ keyword reference
		cgn08		/ undefined binary operator
		cgn08		/ undefined unary operator
/
/	here to generate code for array reference
/
cgn05:	mov	$cmopn*2,wb	/ point to array operand
/
/	loop to generate code for array operand and subscripts
/
cgn06:	jsr	pc,cmgen	/ generate code for next operand
	mov	cmlen*2(xl),wc	/ load length of cmblk
	cmp	wb,wc		/ loop till all generated
	blo	cgn06
/
/	generate appropriate array call
/
	mov	$oaonz,wa	/ load one-subscript case call
	cmp	wc,$cmar1*2	/ jump to exit if one subscript case
	beq	cgn07
	mov	$oamnz,wa	/ else load multi-subscript case call
	jsr	pc,cdwrd	/ generate call
	mov	wc,wa		/ copy cmblk length
	clc			/ convert to words
	ror	wa
	sub	$cmvls,wa	/ calculate number of subscripts
/
/	cdgnm (continued)
/
/	here to exit generating word (non-constant)
/
cgn07:	mov	sp,wc		/ set result non-constant
	jsr	pc,cdwrd	/ generate word
	br	cgn03		/ back to exit
/
/	here to generate code for functions and undefined ptrs
/
cgn08:	mov	xl,xr		/ copy cmblk pointer
	jsr	pc,cdgvl	/ gen code by value for call
	mov	$ofnez,wa	/ get extra call for by name
	br	cgn07		/ back to generate and exit
/
/	here to generate code for defered expression
/
cgn09:	mov	cmrop*2(xl),xr	/ check if variable
	cmp	(xr),$bzvrz	/ treat *variable as simple var
	bhis	cgn02
	mov	xr,xl		/ copy ptr to expression tree
	jsr	pc,cdgex	/ else build exblk
	mov	$olexz,wa	/ set call to load expr by name
	jsr	pc,cdwrd	/ generate it
	mov	xr,wa		/ copy exblk pointer
	jsr	pc,cdwrd	/ generate exblk pointer
	br	cgn03		/ back to exit
/
/	here to generate code for indirect reference
/
cgn10:	mov	cmrop*2(xl),xr	/ get operand
	jsr	pc,cdgvl	/ generate code by value for it
	mov	$oinnz,wa	/ load call for indirect by name
	br	cgn12		/ merge
/
/	here to generate code for keyword reference
/
cgn11:	mov	cmrop*2(xl),xr	/ get operand
	jsr	pc,cdgnm	/ generate code by name for it
	mov	$okwnz,wa	/ load call for keyword by name
/
/	keyword, indirect merge here
/
cgn12:	jsr	pc,cdwrd	/ generate code for operator
	br	cgn03		/ exit
	/enp			/ end procedure cdgnm
/
/	cdgvl -- generate code by value
/
/	cdgvl is called during the compilation process to
/	generate code by value for an expression. see cdblk
/	description for details of the code generated. the input
/	to cdgvl is an expression tree as generated by expan.
/
/	cdgvl is a recursive procedure which proceeds by making
/	recursive calls to generate code for operands.
/
/	(wb)		integer in range 0 le n le dnamb
/	(xr)		ptr to tree generated by expan
/	(wc)		constant flag (see below)
/	jsr	pc,cdgvl      call to generate code by value
/	(xr,wa)		destroyed
/	(wc)		set non-zero if non-constant
/
/	wc is set to a non-zero (collectable) value if the
/	expression for which code is generated cannot be
/	evaluated at compile time, otherwise wc is unchanged.
/
/	if wc is non-zero on entry, then preevaluation is not
/	allowed regardless of the nature of the operand.
/
/	the code is generated in the current ccblk (see cdwrd).
/
cdgvl:	/prc	r,0		/ entry point, recursive
	mov	(xr),wa		/ load type word
	cmp	wa,$bzcmt	/ jump if cmblk
	beq	cgv01
	cmp	wa,$bzvra	/ jump if icblk, rcblk, scblk
	blo	cgv00
	tst	vrlen*2(xr)	/ jump if not system variable
	bne	cgvl0
	mov	xr,-(sp)	/ stack xr
	mov	vrsvp*2(xr),xr	/ point to svblk
	mov	svbit*2(xr),wa	/ get svblk property bits
	mov	(sp)+,xr	/ recover xr
	mov	btckw,-(sp)	/ check if constant keyword
	com	(sp)
	bic	(sp)+,wa
	tst	wa		/ jump if constant keyword
	bne	cgv00
/
/	here for variable value reference
/
cgvl0:	mov	sp,wc		/ indicate non-constant value
/
/	merge here for simple constant (icblk,rcblk,scblk)
/	and for variables corresponding to constant keywords.
/
cgv00:	mov	xr,wa		/ copy ptr to var or constant
	jsr	pc,cdwrd	/ generate as code word
	rts	pc		/ return to caller
/
/	cdgvl (continued)
/
/	here for tree node (cmblk)
/
cgv01:	mov	wb,-(sp)	/ save entry wb
	mov	xl,-(sp)	/ save entry xl
	mov	wc,-(sp)	/ save entry constant flag
	mov	cwcof,-(sp)	/ save initial code offset
	jsr	pc,chk		/ check for stack overflow
/
/	prepare to generate code for cmblk. wc is set to the
/	value of cswno (zero if -optimise, 1 if -noopt) to
/	start with and is reset non-zero for any non-constant
/	code generated. if it is still zero after generating all
/	the cmblk code, then its value is computed as the result.
/
	mov	xr,xl		/ copy cmblk pointer
	mov	cmtyp*2(xr),xr	/ load cmblk type
	mov	cswno,wc	/ reset constant flag
	cmp	xr,$czprz	/ jump if not predicate value
	blos	cgv02
	mov	sp,wc		/ else force non-constant case
/
/	here with wc set appropriately
/
cgv02:	asl	xr		/ switch to appropriate generator
	mov	.+4(xr),pc
		cgv03		/ array reference
		cgv05		/ function call
		cgv14		/ deferred expression
		cgv31		/ indirect reference
		cgv27		/ keyword reference
		cgv29		/ undefined binop
		cgv30		/ undefined unop
		cgv18		/ binops with value operands
		cgv19		/ unops with value operand
		cgv18		/ alternation
		cgv24		/ concatenation
		cgv27		/ unops with name operand
		cgv26		/ binary z and binary .
		cgv21		/ assignment
		cgv31		/ interrogation
		cgv28		/ negation
		cgv15		/ selection
		cgv18		/ pattern match
/
/	cdgvl (continued)
/
/	here to generate code for array reference
/
cgv03:	mov	$cmopn*2,wb	/ set offset to array operand
/
/	loop to generate code for array operand and subscripts
/
cgv04:	jsr	pc,cmgen	/ gen value code for next operand
	mov	cmlen*2(xl),wc	/ load cmblk length
	cmp	wb,wc		/ loop back if more to go
	blo	cgv04
/
/	generate call to appropriate array reference routine
/
	mov	$oaovz,wa	/ set one subscript call in case
	cmp	wc,$cmar1*2	/ jump to exit if 1-sub case
	bne	.+6
	jmp	cgv32
	mov	$oamvz,wa	/ else set call for multi-subscripts
	jsr	pc,cdwrd	/ generate call
	mov	wc,wa		/ copy length of cmblk
	sub	$cmvls*2,wa	/ subtract standard length
	clc			/ get number of words
	ror	wa
	jmp	cgv32		/ jump to generate subscript count
/
/	here to generate code for function call
/
cgv05:	mov	$cmvls*2,wb	/ set offset to first argument
/
/	loop to generate code for arguments
/
cgv06:	cmp	wb,cmlen*2(xl)	/ jump if all generated
	beq	cgv07
	jsr	pc,cmgen	/ else gen value code for next arg
	br	cgv06		/ back to generate next argument
/
/	here to generate actual function call
/
cgv07:	sub	$cmvls*2,wb	/ get number of arg ptrs (bytes)
	clc			/ convert bytes to words
	ror	wb
	mov	cmopn*2(xl),xr	/ load function vrblk pointer
	tst	vrlen*2(xr)	/ jump if not system function
	bne	cgv12
	mov	vrsvp*2(xr),xl	/ load svblk ptr if system var
	mov	svbit*2(xl),wa	/ load bit mask
	mov	btffc,-(sp)	/ test for fast function call allowed
	com	(sp)
	bic	(sp)+,wa
	tst	wa		/ jump if not
	beq	cgv12
/
/	cdgvl (continued)
/
/	here if fast function call is allowed
/
	mov	svbit*2(xl),wa	/ reload bit indicators
	mov	btpre,-(sp)	/ test for preevaluation ok
	com	(sp)
	bic	(sp)+,wa
	tst	wa		/ jump if preevaluation permitted
	bne	cgv08
	mov	sp,wc		/ else set result non-constant
/
/	test for correct number of args for fast call
/
cgv08:	mov	vrfnc*2(xr),xl	/ load ptr to svfnc field
	mov	fargs*2(xl),wa	/ load svnar field value
	cmp	wa,wb		/ jump if argument count is correct
	beq	cgv11
	cmp	wa,wb		/ jump if too few arguments given
	bhis	cgv09
/
/	here if too many arguments, prepare to generate ozpops
/
	sub	wa,wb		/ get number of extra args
	mov	$opopz,wa	/ set pop call
	br	cgv10		/ jump to common loop
/
/	here if too few arguments, prepare to generate nulls
/
cgv09:	sub	wb,wa		/ get number of missing arguments
	mov	wa,wb		/ load as count to control loop
	mov	$nulls,wa	/ load ptr to null constant
/
/	loop to generate calls to fix argument count
/
cgv10:	jsr	pc,cdwrd	/ generate one call
	sob	wb,cgv10	/ loop till all generated
/
/	here after adjusting arg count as required
/
cgv11:	mov	xl,wa		/ copy pointer to svfnc field
	jmp	cgv36		/ jump to generate call
/
/	cdgvl (continued)
/
/	come here if fast call is not permitted
/
cgv12:	mov	$ofnsz,wa	/ set one arg call in case
	cmp	wb,$1		/ jump if one arg case
	beq	cgv13
	mov	$ofncz,wa	/ else load call for more than 1 arg
	jsr	pc,cdwrd	/ generate it
	mov	wb,wa		/ copy argument count
/
/	one arg case merges here
/
cgv13:	jsr	pc,cdwrd	/ generate =ozfns or arg count
	mov	xr,wa		/ copy vrblk pointer
	jmp	cgv32		/ jump to generate vrblk ptr
/
/	here for deferred expression
/
cgv14:	mov	cmrop*2(xl),xl	/ point to expression tree
	jsr	pc,cdgex	/ build exblk or seblk
	mov	xr,wa		/ copy block ptr
	jsr	pc,cdwrd	/ generate ptr to exblk or seblk
	jmp	cgv34		/ jump to exit, constant test
/
/	here to generate code for selection
/
cgv15:	clr	-(sp)		/ zero ptr to chain of forward jumps
	clr	-(sp)		/ zero ptr to prev ozslc forward ptr
	mov	$cmvls*2,wb	/ point to first alternative
	mov	$oslaz,wa	/ set initial code word
/
/	0(sp)		is the offset to the previous word
/			which requires filling in with an
/			offset to the following ozslc,ozsld
/
/	1(sp)		is the head of a chain of offset
/			pointers indicating those locations
/			to be filled with offsets past
/			the end of all the alternatives
/
cgv16:	jsr	pc,cdwrd	/ generate ozslc (ozsla first time)
	mov	cwcof,(sp)	/ set current loc as ptr to fill in
	jsr	pc,cdwrd	/ generate garbage word there for now
	jsr	pc,cmgen	/ gen value code for alternative
	mov	$oslbz,wa	/ load ozslb pointer
	jsr	pc,cdwrd	/ generate ozslb call
	mov	1*2(sp),wa	/ load old chain ptr
	mov	cwcof,1*2(sp)	/ set current loc as new chain head
	jsr	pc,cdwrd	/ generate forward chain link
/
/	cdgvl (continued)
/
/	now to fill in the skip offset to ozslc,ozsld
/
	mov	(sp),xr		/ load offset to word to plug
	add	rzccb,xr	/ point to actual location to plug
	mov	cwcof,(xr)	/ plug proper offset in
	mov	$oslcz,wa	/ load ozslc ptr for next alternative
	mov	wb,xr		/ copy offset (destroy garbage xr)
	add	$2,xr		/ bump extra time for test
	cmp	xr,cmlen*2(xl)	/ loop back if not last alternative
	blo	cgv16
/
/	here to generate code for last alternative
/
	mov	$osldz,wa	/ get header call
	jsr	pc,cdwrd	/ generate ozsld call
	jsr	pc,cmgen	/ generate code for last alternative
	add	$2,sp		/ pop offset ptr
	mov	(sp)+,xr	/ load chain ptr
/
/	loop to plug offsets past structure
/
cgv17:	add	rzccb,xr	/ make next ptr absolute
	mov	(xr),wa		/ load forward ptr
	mov	cwcof,(xr)	/ plug required offset
	mov	wa,xr		/ copy forward ptr
	tst	wa		/ loop back if more to go
	bne	cgv17
	jmp	cgv33		/ else jump to exit (not constant)
/
/	here for binary ops with value operands
/
cgv18:	mov	cmlop*2(xl),xr	/ load left operand pointer
	jsr	pc,cdgvl	/ gen value code for left operand
/
/	here for unary ops with value operand (binops merge)
/
cgv19:	mov	cmrop*2(xl),xr	/ load right (only) operand ptr
	jsr	pc,cdgvl	/ gen code by value
/
/	cdgvl (continued)
/
/	merge here to generate operator call from cmopn field
/
cgv20:	mov	cmopn*2(xl),wa	/ load operator call pointer
	jmp	cgv36		/ jump to generate it with cons test
/
/	here for assignment
/
cgv21:	mov	cmlop*2(xl),xr	/ load left operand pointer
	cmp	(xr),$bzvrz	/ jump if not variable
	blos	cgv22
/
/	here for assignment to simple variable
/
	mov	cmrop*2(xl),xr	/ load right operand ptr
	jsr	pc,cdgvl	/ generate code by value
	mov	cmlop*2(xl),wa	/ reload left operand vrblk ptr
	add	$vrsto*2,wa	/ point to vrsto field
	jmp	cgv32		/ jump to generate store ptr
/
/	here if not simple variable assignment
/
cgv22:	jsr	pc,expap	/ test for pattern match on left side
		cgv23		/ jump if not pattern match
/
/	here for pattern replacement
/
	mov	cmrop*2(xr),cmlop*2(xl) / save pattern ptr in safe place
	mov	cmlop*2(xr),xr	/ load subject ptr
	jsr	pc,cdgnm	/ gen code by name for subject
	mov	cmlop*2(xl),xr	/ load pattern ptr
	jsr	pc,cdgvl	/ gen code by value for pattern
	mov	$opmnz,wa	/ load match by name call
	jsr	pc,cdwrd	/ generate it
	mov	cmrop*2(xl),xr	/ load replacement value ptr
	jsr	pc,cdgvl	/ gen code by value
	mov	$orplz,wa	/ load replace call
	jmp	cgv32		/ jump to gen and exit (not constant)
/
/	here for assignment to complex variable
/
cgv23:	mov	sp,wc		/ inhibit pre-evaluation
	jsr	pc,cdgnm	/ gen code by name for left side
	br	cgv31		/ merge with unop circuit
/
/	cdgvl (continued)
/
/	here for concatenation
/
cgv24:	mov	cmlop*2(xl),xr	/ load left operand ptr
	cmp	(xr),$bzcmt	/ ordinary binop if not cmblk
	bne	cgv18
	mov	cmtyp*2(xr),wb	/ load cmblk type code
	cmp	wb,$czint	/ special case if interrogation
	beq	cgv25
	cmp	wb,$czneg	/ or negation
	beq	cgv25
	cmp	wb,$czfnc	/ else ordinary binop if not function
	bne	cgv18
	mov	cmopn*2(xr),xr	/ else load function vrblk ptr
	tst	vrlen*2(xr)	/ ordinary binop if not system var
	bne	cgv18
	mov	vrsvp*2(xr),xr	/ else point to svblk
	mov	svbit*2(xr),wa	/ load bit indicators
	mov	btprd,-(sp)	/ test for predicate function
	com	(sp)
	bic	(sp)+,wa
	tst	wa		/ ordinary binop if not
	beq	cgv18
/
/	here if left arg of concatenation is predicate function
/
cgv25:	mov	cmlop*2(xl),xr	/ reload left arg
	jsr	pc,cdgvl	/ gen code by value
	mov	$opopz,wa	/ load pop call
	jsr	pc,cdwrd	/ generate it
	mov	cmrop*2(xl),xr	/ load right operand
	jsr	pc,cdgvl	/ gen code by value as result code
	br	cgv33		/ exit (not constant)
/
/	here to generate code for pattern, immediate assignment
/
cgv26:	mov	cmlop*2(xl),xr	/ load left operand
	jsr	pc,cdgvl	/ gen code by value, merge
/
/	here for unops with arg by name (binary z . merge)
/
cgv27:	mov	cmrop*2(xl),xr	/ load right operand ptr
	jsr	pc,cdgnm	/ gen code by name for right arg
	mov	cmopn*2(xl),xr	/ get operator code word
	cmp	(xr),$ozkwv	/ gen call unless keyword value
	bne	cgv20
/
/	cdgvl (continued)
/
/	here for keyword by value. this is constant only if
/	the operand is one of the special system variables with
/	the svckw bit set to indicate a constant keyword value.
/	note that the only constant operand by name is a variable
/
	tst	wc		/ gen call if non-constant (not var)
	bne	cgv20
	mov	sp,wc		/ else set non-constant in case
	mov	cmrop*2(xl),xr	/ load ptr to operand vrblk
	tst	vrlen*2(xr)	/ gen (non-constant) if not sys var
	bne	cgv20
	mov	vrsvp*2(xr),xr	/ else load ptr to svblk
	mov	svbit*2(xr),wa	/ load bit mask
	mov	btckw,-(sp)	/ test for constant keyword
	com	(sp)
	bic	(sp)+,wa
	tst	wa		/ go gen if not constant
	beq	cgv20
	clr	wc		/ else set result constant
	br	cgv20		/ and jump back to generate call
/
/	here to generate code for negation
/
cgv28:	mov	$ontaz,wa	/ get initial word
	jsr	pc,cdwrd	/ generate it
	mov	cwcof,wb	/ save next offset
	jsr	pc,cdwrd	/ generate gunk word for now
	mov	cmrop*2(xl),xr	/ load right operand ptr
	jsr	pc,cdgvl	/ gen code by value
	mov	$ontbz,wa	/ load end of evaluation call
	jsr	pc,cdwrd	/ generate it
	mov	wb,xr		/ copy offset to word to plug
	add	rzccb,xr	/ point to actual word to plug
	mov	cwcof,(xr)	/ plug word with current offset
	mov	$ontcz,wa	/ load final call
	br	cgv32		/ jump to generate it (not constant)
/
/	here to generate code for undefined binary operator
/
cgv29:	mov	cmlop*2(xl),xr	/ load left operand ptr
	jsr	pc,cdgvl	/ generate code by value
/
/	cdgvl (continued)
/
/	here to generate code for undefined unary operator
/
cgv30:	mov	$czuoz,wb	/ set unop code + 1
	sub	cmtyp*2(xl),wb	/ set number of args (1 or 2)
/
/	merge here for undefined operators
/
	mov	cmrop*2(xl),xr	/ load right (only) operand pointer
	jsr	pc,cdgvl	/ gen value code for right operand
	mov	cmopn*2(xl),xr	/ load pointer to operator dv
	mov	dvopn*2(xr),xr	/ load pointer offset
	asl	xr		/ convert word offset to bytes
	add	$rzuba,xr	/ point to proper function ptr
	sub	$vrfnc*2,xr	/ set standard function offset
	jmp	cgv12		/ merge with function call circuit
/
/	here to generate code for interrogation, indirection
/
cgv31:	mov	sp,wc		/ set non constant
	jmp	cgv19		/ merge
/
/	here to exit generating a word, result not constant
/
cgv32:	jsr	pc,cdwrd	/ generate word, merge
/
/	here to exit with no word generated, not constant
/
cgv33:	mov	sp,wc		/ indicate result is not constant
/
/	common exit point
/
cgv34:	add	$2,sp		/ pop initial code offset
	mov	(sp)+,wa	/ restore old constant flag
	mov	(sp)+,xl	/ restore entry xl
	mov	(sp)+,wb	/ restore entry wb
	tst	wc		/ jump if not constant
	bne	cgv35
	mov	wa,wc		/ else restore entry constant flag
/
/	here to return after dealing with wc setting
/
cgv35:	rts	pc		/ return to cdgvl caller
/
/	exit here to generate word and test for constant
/
cgv36:	jsr	pc,cdwrd	/ generate word
	tst	wc		/ jump to exit if not constant
	bne	cgv34
/
/	cdgvl (continued)
/
/	here to preevaluate constant sub-expression
/
	mov	$orvlz,wa	/ load call to return value
	jsr	pc,cdwrd	/ generate it
	mov	(sp),xl		/ load initial code offset
	jsr	pc,exbld	/ build exblk for expression
	clr	wb		/ set to evaluate by value
	jsr	pc,evalx	/ evaluate expression
		0		/ should not fail
	mov	(xr),wa		/ load type word of result
	cmp	wa,$pzaaa	/ jump if not pattern
	blos	cgv37
	mov	$olptz,wa	/ else load special pattern load call
	jsr	pc,cdwrd	/ generate it
/
/	merge here to generate pointer to resulting constant
/
cgv37:	mov	xr,wa		/ copy constant pointer
	jsr	pc,cdwrd	/ generate ptr
	clr	wc		/ set result constant
	br	cgv34		/ jump back to exit
	/enp			/ end procedure cdgvl
/
/	cdwrd -- generate one word of code
/
/	cdwrd writes one word into the current code block under
/	construction. a new, larger, block is allocated if there
/	is insufficient room in the current block. cdwrd ensures
/	that there are at least three words left in the block
/	after entering the new word. this guarantees that any
/	extra space at the end can be split off as a ccblk.
/
/	(wa)		word to be generated
/	jsr	pc,cdwrd      call to generate word
/
cdwrd:	/prc	e,0		/ entry point
	mov	xr,-(sp)	/ save entry xr
	mov	wa,-(sp)	/ save code word to be generated
/
/	merge back here after allocating larger block
/
cdwd1:	mov	rzccb,xr	/ load ptr to ccblk being built
	tst	xr		/ jump if block allocated
	bne	cdwd2
/
/	here we allocate an entirely fresh block
/
	mov	$ezcbs*2,wa	/ load initial length
	jsr	pc,alloc	/ allocate ccblk
	mov	$bzcct,(xr)	/ store type word
	mov	$cccod*2,cwcof	/ set initial offset
	mov	wa,cclen*2(xr)	/ store block length
	mov	xr,rzccb	/ store ptr to new block
/
/	here we have a block we can use
/
cdwd2:	mov	cwcof,wa	/ load current offset
	add	$4*2,wa		/ adjust for test (four words)
	cmp	wa,cclen*2(xr)	/ jump if room in this block
	blos	cdwd4
/
/	here if no room in current block
/
	cmp	wa,dnamx	/ jump if already at max size *f014*
	bhis	cdwd5
	add	$ezcbs*2,wa	/ else get new size
	mov	xl,-(sp)	/ save entry xl
	mov	xr,xl		/ copy pointer
	cmp	wa,dnamx	/ jump if not too large *f014*
	blo	cdwd3
	mov	dnamx,wa	/ else reset to max allowed size *f014*
/
/	cdwrd (continued)
/
/	here with new block size in wa
/
cdwd3:	jsr	pc,alloc	/ allocate new block
	mov	xr,rzccb	/ store pointer to new block
	mov	$bzcct,(xr)+	/ store type word in new block
	mov	wa,(xr)+	/ store block length
	add	$ccuse*2,xl	/ point to ccuse,cccod fields in old
	mov	(xl),wa		/ load ccuse value
	asr	wa		/ copy useful words from old block
	mov	(xl)+,(xr)+
	sob	wa,.-2
	mov	(sp)+,xl	/ restore xl
	br	cdwd1		/ merge back to try again
/
/	here with room in current block
/
cdwd4:	mov	cwcof,wa	/ load current offset
	add	$2,wa		/ get new offset
	mov	wa,cwcof	/ store new offset
	mov	wa,ccuse*2(xr)	/ store in ccblk for gbcol
	sub	$2,wa		/ restore ptr to this word
	add	wa,xr		/ point to current entry
	mov	(sp)+,wa	/ reload word to generate
	mov	wa,(xr)		/ store word in block
	mov	(sp)+,xr	/ restore entry xr
	rts	pc		/ return to caller
/
/	here if compiled code is too long for cdblk
/
cdwd5:	mov	$443.,pc	/ syntax error. statement is too compli
	/enp			/ end procedure cdwrd
/
/	cmgen -- generate code for cmblk ptr
/
/	cmgen is a subsidiary procedure used to generate value
/	code for a cmblk ptr from the main code generators.
/
/	(xl)		cmblk pointer
/	(wb)		offset to pointer in cmblk
/	jsr	pc,cmgen      call to generate code
/	(xr,wa)		destroyed
/	(wb)		bumped by one word
/
cmgen:	/prc	r,0		/ entry point, recursive
	mov	xl,xr		/ copy cmblk pointer
	add	wb,xr		/ point to cmblk pointer
	mov	(xr),xr		/ load cmblk pointer
	jsr	pc,cdgvl	/ generate code by value
	add	$2,wb		/ bump offset
	rts	pc		/ return to caller
	/enp			/ end procedure cmgen
/
/	cmpil (compile source code)
/
/	cmpile is used to convert snobol4 source code to internal
/	form (see cdblk format). it is used both for the initial
/	compile and at run time by the code and convert functions
/
/	jsr	pc,cmpile     call to compile code
/	(xr)		ptr to cdblk for entry statement
/	(xl,wa,wb,wc,ra)      destroyed
/
/	the following global variables are referenced
/
/	cmstm		number of next statement
/			to be compiled.
/
/	cwcof		offset to next word in code block
/			being built (see cdwrd).
/
/	all control card switch values cswxx are also modified
/	when the associated control cards are encountered.
/
/	stmno		number of statement most recently
/			compiled (initially set to zero).
/
/	rzcim		current (initial) compiler image
/			(zero for initial compile call)
/
/	rzcni		used to point to following image.
/			(see readr procedure).
/
/	scngo		goto switch for scane procedure
/
/	scnil		length of current image excluding
/			characters removed by -input.
/
/	scnpt		current scan offset, see scane.
/
/	scnrs		rescan switch for scane procedure.
/
/	scnse		offset (in rzcim) of most recently
/			scanned element. set zero if not
/			currently scanning items
/
/	stage		0	initial compile in progress
/			1	code/convert compile
/			2	building exblk for eval
/			3	execute time (outside compile)
/			4	initial compile after end line
/			5	execute compile after end line
/
/	cmpil (continued)
/
/	cmpil also uses a fixed number of locations on the
/	main stack as follows. (the definitions of the actual
/	offsets are in the definitions section).
/
/	cmstm(sp)	pointer to expan tree for body of
/			statement (see expan procedure).
/
/	cmsgo(sp)	pointer to tree representation of
/			success goto (see procedure scngo)9
/			zero if no success goto is given
/
/	cmfgo(sp)	like cmsgo for failure goto.
/
/	cmcgo(sp)	set non-zero only if there is a
/			conditional goto. used for -fail,
/			-nofail code generation.
/
/	cmpcd(sp)	pointer to cdblk for previous
/			statement. zero for 1st statement.
/
/	cmffp(sp)	set non-zero if cdfal in previous
/			cdblk needs filling with forward
/			pointer, else set to zero.
/
/	cmffc(sp)	same as cmffp for current cdblk
/
/	cmsop(sp)	offset to word in previous cdblk
/			to be filled in with forward ptr
/			to next cdblk for success goto.
/			zero if no fill in is required.
/
/	cmsoc(sp)	same as cmsop for current cdblk.
/
/	cmlbl(sp)	pointer to vrblk for label of
/			current statement. zero if no label
/
/	cmtra(sp)	pointer to cdblk for entry stmnt.
/
/	cmpil (continued)
/
/	entry point
/
cmpil:	/prc	e,0		/ entry point
	mov	$cmnen,wb	/ set number of stack work locations
/
/	loop to initialize stack working locations
/
cmp01:	clr	-(sp)		/ store a zero, make one entry
	sob	wb,cmp01	/ loop back until all set
	mov	sp,cmpxs	/ save stack pointer for error sec
/
/	loop through statements
/
cmp02:	mov	scnpt,wb	/ set scan pointer offset
	mov	wb,scnse	/ set start of element location
	mov	$ocerz,wa	/ point to compile error call
	jsr	pc,cdwrd	/ generate as temporary cdfal
	cmp	wb,scnil	/ jump if chars left on this image
	blo	cmp04
/
/	loop here after comment or control card
/
cmp03:	clr	xr		/ clear possible garbage xr value
	jsr	pc,readr	/ read next input image
	tst	xr		/ jump if no input available
	beq	cmp09
	jsr	pc,nexts	/ acquire next source image
	mov	cmpsn,lstsn	/ store stmt no for use by listr
	clr	scnpt		/ reset scan pointer
/
/	cmpil (continued)
/
/	here with image available to scan. note that if the input
/	string is null, then everything is ok since null is
/	actually assembled as a word of blanks.
/
cmp04:	mov	rzcim,xr	/ point to current image
	mov	xr,xl		/ copy pointer for label sbstr call
	mov	scnpt,wb	/ load current offset
	mov	wb,wa		/ copy for label scan
	cmp	(xr)+,(xr)+	/ point to first character
	add	wb,xr
	clr	wc		/ load first character
	bisb	(xr)+,wc
	cmp	wc,$chzbl	/ jump if no label
	beq	cmp12
	cmp	wc,$chzas	/ loop back if comment card
	beq	cmp03
	cmp	wc,$chzmn	/ jump if control card
	bne	.+6
	jmp	cmp31
	cmp	wc,$chzht	/ jump if horizontal tab
	beq	cmp12
	cmp	wc,$chzpl	/ error if continuation char
	beq	cmp05
	cmp	wc,$chzdt	/ else jump for label scan
	bne	cmp06
/
/	here if continuation character detected at this stage
/
cmp05:	mov	$445.,pc	/ syntax error. misplaced continuation
/
/	loop to scan label
/
cmp06:	cmp	wc,$chzsm	/ skip if semicolon
	beq	cmp07
	inc	wa		/ bump offset
	cmp	wa,scnil	/ jump if end of image (label end)
	beq	cmp07
	clr	wc		/ else load next character
	bisb	(xr)+,wc
	cmp	wc,$chzht	/ jump if horizontal tab
	beq	cmp07
	cmp	wc,$chzbl	/ loop back if non-blank
	bne	cmp06
/
/	here after scanning out label
/
cmp07:	mov	wa,scnpt	/ save updated scan offset
	sub	wb,wa		/ get length of label
	tst	wa		/ skip if label length zero
	beq	cmp12
	clr	xr		/ clear garbage xr value
	jsr	pc,sbstr	/ build scblk for label name
	jsr	pc,gtnvr	/ locate/contruct vrblk
		0		/ dummy (impossible) error return
	mov	xr,cmlbl*2(sp)	/ store label pointer
	tst	vrlen*2(xr)	/ jump if not system label
	bne	cmp11
	cmp	vrsvp*2(xr),$vzend / jump if not end label
	bne	cmp11
/
/	cmpil (continued)
/
/	here for end label scanned out
/
	add	$stgnd,stage	/ adjust stage appropriately
	jsr	pc,scane	/ scan out next element
	cmp	xl,$tzsmc	/ jump if end of image
	beq	cmp10
	cmp	xl,$tzvar	/ else error if not variable
	bne	cmp08
/
/	here check for valid initial transfer
/
	cmp	vrlbl*2(xr),$stndl / jump if not defined (error)
	beq	cmp08
	mov	vrlbl*2(xr),cmtra*2(sp) / else set initial entry pointer
	jsr	pc,scane	/ scan next element
	cmp	xl,$tzsmc	/ jump if ok (end of image)
	beq	cmp10
/
/	here for bad transfer label
/
cmp08:	mov	$447.,pc	/ syntax error. undefined or erroneous
/
/	here for end of input (no end label detected)
/
cmp09:	add	$stgnd,stage	/ adjust stage appropriately
	cmp	stage,$stgxe	/ jump if code call (ok)
	beq	cmp10
	mov	$449.,pc	/ syntax error. missing end line
/
/	here after processing end line (merge here on end error)
/
cmp10:	mov	$ostpz,wa	/ set stop call pointer
	jsr	pc,cdwrd	/ generate as statement call
	jmp	cmp24		/ jump to generate as failure
/
/	here after processing label other than end
/
cmp11:	cmp	stage,$stgic	/ jump if code call - redef. ok
	bne	cmp12
	cmp	vrlbl*2(xr),$stndl / else check for redefinition
	beq	cmp12
	clr	cmlbl*2(sp)	/ leave first label decln undisturbed
	mov	$451.,pc	/ syntax error. duplicate label
/
/	cmpil (continued)
/
/	here after dealing with label
/
cmp12:	clr	wb		/ set flag for statement body
	jsr	pc,expan	/ get tree for statement body
	mov	xr,cmstm*2(sp)	/ store for later use
	clr	cmsgo*2(sp)	/ clear success goto pointer
	clr	cmfgo*2(sp)	/ clear failure goto pointer
	clr	cmcgo*2(sp)	/ clear conditional goto flag
	jsr	pc,scane	/ scan next element
	cmp	xl,$tzcol	/ jump it not colon (no goto)
	bne	cmp18
/
/	loop to process goto fields
/
cmp13:	mov	sp,scngo	/ set goto flag
	jsr	pc,scane	/ scan next element
	cmp	xl,$tzsmc	/ jump if no fields left
	bne	.+6
	jmp	cmp30
	cmp	xl,$tzsgo	/ jump if s fo