;;;	Warplan Problem Solver
;;;	Originally written by David H. D. Warren (Edinburgh)

;;;	Domain is a code generator for a single accumulator computer

;;;	The clauses commented out have been added to Prolog
;;;	as built-in predicates

;;;	[[preserved X V] [mkground [& X V] 0 N] [del X V] ! fail]
;;;	 [mkground [& C P] 0 N]
;;;	[[non_equiv X Y] [mkground [& X Y] 0 N] [equal X Y] ! fail]
;;;	[[mkground [qqq N1] N1 N2] ! [sum N1 1 N2]]
;;;	[[mkground [qqq N] N1 N1] !]
;;;	[[mkground X N1 N2] [univ X [. F L]] [mkgroundlist L N1 N2]]
;;;	[[mkgroundlist [. X L] N1 N3]
;;;	 [mkground X N1 N2]
;;;	 [mkgroundlist L N2 N3]]
;;;	[[mkgroundlist nil N1 N1]]

add;
	[[plan [& X C] P T T2] ! [solve X P T P1 T1] [plan C P1 T1 T2]]
	[[plan X P T T1] [solve X P T P1 T1]]
	[[solve X P T P T] [always X]]
	[[solve X P T P1 T] [holds X T] [and X P P1]]
	[[solve X P T [& X P] T1] [add X U] [achieve X U P T T1]]
	[[achieve X U P T [; T1 U]]
	 [preserves U P]
	 [can U C]
	 [consistent C P]
	 [plan C P T T1]
	 [preserves U P]]
	[[achieve X U P [; T V] [; T1 V]]
	 [preserves X V]
	 [retrace P V P1]
	 [achieve X U P1 T T1]
	 [preserved X V]]
	[[holds X [; T V]] !
	 [preserved X V]
	 [holds X T]
	 [preserved X V]]
	[[holds X T] [given T X]]
	[[preserved X V] [mkground [& X V]] [del X V] ! fail]
	[[preserved X V]]
	[[preserves U [& X C]] [preserved X U] [preserves U C]]
	[[preserves U true]]
	[[retrace P V P2]
	 [can V C]
	 [retrace P V C P1]
	 [append C P1 P2]]
	[[retrace1 [& X P] V C P1]
	 [add Y V]
	 [equiv X Y]
	 !
	 [retrace1 P V C P1]]
	[[retrace1 [& X P] V C P1]
	 [elem Y C]
	 [equiv X Y]
	 !
	 [retrace1 P V C P1]]
	[[retrace1 [& X P] V C [& X P1]] [retrace1 P V C P1]]
	[[retrace1 true V C true]]
	[[consistent C P]
	 [mkground [& C P]]
	 [imposs S]
	 [unless [unless [intersect C S]]]
	 [implied S [& C P]]
	 !
	 fail]
	[[consistent C P]]
	[[plans C T]
	 [unless [consistent C true]]
	 !
	 [output impossible]
	 newline]
	[[plans C T] [plan C true T T1] ! [output T1] [newline]]
	[[and X P P] [elem Y P] [equiv X Y] !]
	[[and X P [& X P]]]
	[[append [& X C] P [& X P1]] ! [append C P P1]]
	[[append X P [& X P]]]
	[[elem X [& Y C]] [elem X Y]]
	[[elem X [& Y C]] ! [elem X C]]
	[[elem X X]]
	[[intersect S1 S2] [elem X S1] [elem X S2]]
	[[implied [& S1 S2] C] ! [implied S1 C] [implied S2 C]]
	[[implied X C] [elem X C]]
	[[implied X C] X]
	[[equal X X]]
	[[not_equal X Y]
	 [unless [equal X Y]]
	 [unless [equal X [qqq N1]]]
	 [unless [equal Y [qqq N2]]]]
	[[equiv X Y] [unless [non_equiv X Y]]]
	[[non_equiv X Y] [mkground [& X Y]] [equal X Y] ! fail]
	[[non_equiv X Y]]
	[[unless X] X ! fail]
	[[unless X]]

	[[add [is acc [+ V1 V2]] [! [add R] [+ V1 V2]]]]
	[[add [is acc [- V1 V2]] [! [subtract R] [- V1 V2]]]]
	[[add [is acc V] [! [load R] V]]]
	[[add [is [reg R] V] [! [store R] V]]]
	[[del [is acc Z] U] [add [is acc V] U]]
	[[del [is [reg R] Z] U] [add [is [reg R] V] U]]
	[[can [! [load R] V] [is [reg R] V]]]
	[[can [! [store R] V] [is acc V]]]
	[[can [! [add R] [+ V1 V2]] [& [is [reg R] V2] [is acc V1]]]]
	[[can [! [subtract R] [- V1 V2]] [& [is [reg R] V2] [is acc V1]]]]
	[[given init [is [reg 1] c1]]]
	[[given init [is [reg 2] c2]]]
	[[given init [is [reg 3] c3]]]
	[[given init [is [reg 4] c4]]]

