;;;	/ p o p / l i b / h p t u r t l e . p
;;;	Sussex POP11 Turtle package
;;;	(for Hewlett Packard graph plotter)
;;;	Steven Hardy
;;;	4th November 1976

;;;	Variable declarations
vars xposition;	;;;	An integer representing the x-position of the turtle
vars xdelta;	;;;	An integer, between 0 and 99, representing the
		;;;	position of the turtle WITHIN a picture square
vars yposition ydelta;
vars heading;	;;;	The angle the turtle would have to turn, in a clockwise direction,
		;;;	to be facing along the x-axis, to the right.
;;;	Function definitions
vars costable;
	subscrc(%
		fill(	100, 100, 100, 100, 100,  99,  99,  99,  99,  98,
			 98,  98,  97,  97,  97,  96,  96,  95,  95,  94,
			 93,  93,  92,  91,  91,  90,  89,  88,  87,  87,
			 86,  85,  84,  83,  82,  81,  80,  79,  78,  77,
			 75,  74,  73,  72,  71,  69,  68,  67,  66,  64,
			 63,  62,  60,  59,  57,  56,  54,  53,  52,  50,
			 48,  47,  45,  44,  42,  41,  39,  37,  36,  34,
			 33,  31,  29,  28,  26,  24,  23,  21,  19,  17,
			 16,  14,  12,  10,   9,   7,   5,   3,   2,   0,
			initc(90))%)
	->costable;
;;;	costable(n)==100*cos(n) where 1<=n<=90 and n is in degrees

function cos(angle);
	abs(angle)->angle;
	if angle==0 then 100
	elseif angle<=90 then costable(angle)
	else -cos(angle-180)
	close
end;
function sin(angle);
	cos(angle-90)
end;


function newposition(amount) => newx newy;
	(100*xposition+xdelta+amount*cos(heading))//100
		->newx->xdelta;
	(100*yposition+ydelta+amount*sin(heading))//100
		->newy->ydelta;
end;
;;;	This function computes the new position after jumping amount
;;;	It alters xdelta and ydelta but returns the new x and y positions
;;;
function pr4(n,d);
	pr(pr(n//10));
	pr(pr(d//10));
end;

vars turtleout;
function moveturtle(pendown);
	vars tempout cucharout x y;
	cucharout -> tempout;
	turtleout -> cucharout;
	if	xposition > 99
	then	99
	elseif	xposition < 0
	then	0
	else	xposition
	close	-> x;
	if	yposition > 99
	then	99
	elseif	yposition < 0
	then	0
	else	yposition
	close	-> y;
	pr4(x,xdelta);
	cucharout(32);
	pr4(y,ydelta);
	unless	pendown
	then	cucharout(`^)
	close;
	cucharout(10);
	cucharout(13);
	unless	x == xposition
		and	y == yposition
	then	error(xposition, yposition, 2301)
	close
end;
;;;

function jump(amount);
	newposition(amount)->yposition->xposition;
	moveturtle(false);
end;

function jumpto(newx,newy);
	newx->xposition;
	newy->yposition;
	50->xdelta;
	50->ydelta;
	moveturtle(false);
end;

function jumpby(dx,dy);
	xposition+dx->xposition;
	yposition+dy->yposition;
	moveturtle(false);
end;

;;;	These function all move the turtle without altering the picture

function draw(amount);
	newposition(amount) -> yposition -> xposition;
	moveturtle(true);
end;

function drawby(dx,dy);
	xposition + dx -> xposition;
	yposition + dy -> yposition;
	moveturtle(true);
end;

function drawto(newx,newy);
	newx -> xposition;
	newy -> yposition;
	50 -> xdelta;
	50 -> ydelta;
	moveturtle(true);
end;
;;;	These function move the turtle altering the picture

function turn(angle);
	erase((angle+heading)//360)->heading;
end;
;;;	This function alters the turtles heading
;;;
function hpturtle();
;;;	vars mode;
;;;	initc(6) -> mode;
	discout('/dev/tty2') -> turtleout;
;;;	erase(popmess({32 mode turtleout }));
;;;	subscrc(5,mode) - 16 -> subscrc(5, mode);
;;;	erase(popmess({31 mode turtleout}));
	appdata('pltl',turtleout);
	turtleout(10);
	turtleout(13);
	jumpto(0,0);
	0 -> heading;
	drawto(0,99);
	drawto(99,99);
	drawto(99,0);
	drawto(0,0);
end;
;;;
;;;	the following function marks the current point
function grab();
	jump(0)
end;
