/	SUBTITLE	c-varlist.s	variable list read
/	Written by Steven Hardy on 23 April 1976
/	This function reads variable lists for vars and the like.
/	If called with a non zero argument it will
/	read two lists seperated by "=>". (If ";" is encountered first
/	the second list will be nil).
/
	ksfunction
fvarlist:
	br	svarlist
	false;	false
exit=.
	mov	(sp)+,pvar2
	mov	(sp)+,pvar1
	rts	pc
svarlist:
	mov	pvar1,-(sp)		/ save locals
	mov	pvar2,-(sp)
	mov	(r5)+,pvar1		/ pop to switch
	clr	pvar2			/ clear bracket count
1:
	mov	$cstack,-(r5)		/ push a stack mark
2:
	jsr	pc,srdmitem		/ read an item without expanding macros
	mov	(r5),r0			/ move it to r0
	bit	r4,r0			/ is it an integer?
	bne	8f			/ error if so
	cmp	okey(r0),$kword		/ is it a word?
	bne	8f			/ error if not
	cmp	r0,$wcomma		/ is it ","?
	beq	3f			/ ignore if so
	cmp	r0,$wrbra		/ is it "("
	bne	4f			/ br if not
	tst	pvar2			/ already in a bracket?
	bne	8f			/ br if so
	cmp	2(r5),$cstack		/ is this the first thing?
	bne	8f			/ br if not
	inc	pvar2			/ inc bra count
3:
	tst	(r5)+			/ ignore it
	br	2b			/ and loop back
4:
	cmp	r0,$wrket		/ is it ")"
	bne	3f			/ br if not
	dec	pvar2			/ decrement bracket count
	bne	8f			/ should now be zero
	tst	(r5)+			/ remove ")" from stack
	jsr	pc,srdmitem		/ get next item
	mov	(r5),r0			/ move item to r0
	cmp	r0,$wsmcln		/ is it ";"?
	beq	3f			/ br if so
	cmp	r0,$wprarrow		/ is it "=>"?
	bne	8f			/ br if not to error
3:
	cmp	r0,$wsmcln		/ is it ";"?
	beq	6f			/ br if so
	cmp	r0,$wprarrow		/ is it "=>"?
	beq	5f			/ br if so
	cmp	r0,$woprtn		/ is it "operation"?
	beq	4f			/ br if so
	cmp	r0,$wmacro		/ is it "macro"?
	beq	3f			/ br if so
	bit	$mfixed,oidentprops(r0)	/ is it a fixed word?
	bne	8f			/ error if so
	mov	r4,-(r5)		/ must be normal var, so identprops are pop11 zero
	mov	r0,-(r5)		/ push the word as well
	jsr	pc,uidprops		/ set its identprops
	br	2b			/ loop back for next
3:
	tst	(r5)+			/ remove "macro" from stack
	jsr	pc,srdmitem		/ read the word to be declared
	mov	$wmacro,-(r5)		/ push "macro"
	mov	2(r5),-(r5)		/ and the word
	jsr	pc,uidprops		/ set its identprops
	br	2b			/ loop back for next
4:
	tst	(r5)+			/ remove "operation" from stack
	mov	#4.,-(r5)		/ assume prec is 4
	jsr	pc,srdmitem		/ read name
	bit	r4,(r5)			/ is it a number?
	beq	4f			/ br if not
	mov	(r5)+,(r5)		/ must be prec, so replace 4
	jsr	pc,srdmitem		/ and read name
4:
	jsr	pc,sswap		/ swapname and prec
	mov	2(r5),-(r5)		/ push the word
	jsr	pc,uidprops		/ set its identprops
	br	2b			/ loop back for next
5:
	tst	pvar1			/ is a "=>" allowed?
	beq	8f			/ br if not
	tst	pvar2			/ any unmatched "("?
	bne	8f			/ br if so
	tst	(r5)+			/ remove "=>" from stack
	clr	pvar1			/ clear "=>" allowed flag
	jsr	pc,scnlist		/ build list
	br	1b			/ loop back to read next list
6:
	tst	pvar2			/ any unmatched "("?
	bne	8f			/ br on error
	tst	(r5)+			/ remove ";" from stack
	jsr	pc,scnlist		/ build list
	tst	pvar1			/ is "=>" allowable?
	beq	7f			/ br if not
	mov	$nil,-(r5)		/ if so push "nil" for second list
7:
	mov	$wsmcln,-(r5)		/ rdundo ";"
	jsr	pc,srdundo
	jbr	exit
8:
	mov	#1015.,-(r5)
	jsr	pc,serror
