/	SUBTITLE	c-trfn.s	tracing function
/	Written by Steven Hardy on 27 May 1976
/ This function takes as argument a function which it applies,
/ but first printing its arguments and, after the function exits, prints its results.
/
	ksfunction
ftrfn:
	br	strfn
	false; false
exit=.
	mov	(sp)+,ptrsp
	mov	(sp)+,pvar2
	mov	(sp)+,pvar1
	rts	pc
strfn:
	mov	pvar1,-(sp)		/ save locals
	mov	pvar2,-(sp)
	mov	ptrsp,-(sp)
	mov	(r5)+,r0		/ pop function to r0
	mov	r0,pvar1		/ move it to pvar1
	tst	okey(r0)		/ is it a system function?
	bne	1f			/ br if not
	clr	r1			/ if so clear count of inputs
	br	2f
1:
	mov	(r0),r1			/ get number of locals to r1
	bge	1f			/ br if positive
	clr	r1			/ none for a closure
1:
	beq	2f			/ br if none
	asl	r1			/ double r1
	add	r0,r1			/ make r1 a pointer into function
	mov	6(r1),r1		/ extract number of formals
2:
	mov	r5,r2			/ stack pointer to r2
	sub	br5hi,r2		/ minus size of stack t0 r2
	add	r1,r2			/ allow for formal parameters (nb r1 is +ve)
	add	r1,r2			/ r1 is not in words but bytes
	ble	1f			/ is it a negative amount?
	clr	r2			/ make it zero if not
1:
	mov	r2,pvar2		/ store in pvar2
	mov	#'>,-(r5)		/ push code for '>'
	jsr	pc,strpr		/ call trace print routine
	add	$2,ptrsp		/ increment trace depth
	mov	pvar1,-(r5)		/ push function
	jsr	pc,sapply		/ apply it
	sub	$2,ptrsp		/ decrement trace depth
	mov	#'<,-(r5)		/ push code for '<'
	jsr	pc,strpr		/ call trace print routine
	br	exit			/ done
