/	SUBTITLE	b-gcrecrd.s	scan all records in the heap
/	Written by Steven Hardy on 14 April 1976
/	This function applies the function in 'brecfn' to
/	every record in the heap. When brecfn is called it will find
/	r0 points to the record and r1 points to the next record to be scanned.
/	brecfn can affect the scan by altering r1 since this is where the
/	scan will be continued from. gcrecrd is called with r1 being the first
/	record of interest.
/
sgcrecrd:
	cmp	r1,bhphi		/ is the scan over?
	bhis	1f			/ br if so
	mov	r1,r0			/ set r0 to be next record scanned by brecfn
	mov	-(r1),r1		/ get key word of r1 to r1
	bic	$mbutsize,r1		/ clear all but size
	add	r0,r1			/ r1 now points to next record in the heap
	jsr	pc,*brecfn		/ call brecfn
	br	sgcrecrd		/ and loop
1:
	rts	pc
