#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * move : generate code to move one fake-frame to another
 */

move (f1,f2) fake_t *f1,*f2; {

	register fake_t *p1,*p2;
	register bool;
	int r1,r2;
	int mnem1,mnem2,flag;
	fake_t tmp;
	int conv;
	char sb1[MAXSTRL],sb2[MAXSTRL];
	char *s1,*s2,*s3,*s4;

	p1 = f1;
	p2 = f2;
	flag = 0;

#ifdef DUMPALL
	dump(p1);
	dump(p2);
#endif

	if (p2->flags & CONV)
		fatal("conversion in p2-frame");
	if (p1->flags & CONV)
		goto mov_with_fr;
		/* This goto statement avoids the necessity of testing more */

	if (p1->type == p2->type && p1->flags == p2->flags
	   && p1->offset == p2->offset && p1->index==p2->index
	   || p1->type == STK && p2->type == STK) {
#ifdef DUMPALL
		printf("The frames are identical\n");
#endif
		return;
	}

	if ((p1->flags & INT) && (p2->flags & INT)) {
#ifdef DUMPALL
		printf("Two integers\n");
#endif
		if (p1->type == ADDRLOCL)
			if (p2->type == STK) {
				gen2(MOV,LB,PSH);
				if (p1->offset)
					gen2(op_add,imm(p1->offset),TOP);
			} else {
				gen2(MOV,LB,str(p2));
				if (p1->offset) {
					if (p2->type==REG && p2->flags==INT
						&& p1->offset==2)
						gen1(TST,autinc(p2->index));
					else
						gen2(op_add,imm(p1->offset),str(p2));
				}
			}
		else {
			if (p1->type == STK)
				gen2(MOV,POP,str(p2));
			else if (p1->type == CONS && p1->offset==0) {
				if (p2->type==STK)
					gen1(op_zrl,PSH);
				else
					gen1(op_zrl,str(p2));
			} else {
				if (p2->type == STK)
					gen2(MOV,str(p1),PSH);
				else
					genf(MOV,p1,p2);
			}
		}
		coco = p1;
	} else if ((is_reg(p1)!=FREG) && (is_reg(p2)!=FREG)) {
#ifdef DUMPALL
		printf("No floating register\n");
#endif
		r2 = reg_avail(INT,(r1 = reg_avail(INT,ONLY_REG)));
		bool = (r2 != -1);
		/* two registers are available */
		if (!bool) bool = ((p1->flags&IND) &&
			   (r1 != -1 || p1->type==REG) &&
			   (!(p2->flags&IND) && p2->type!=REG));
		/* register available for ind p1 but not necessary for p2  */
		if (!bool) bool = ((p2->flags&IND) &&
			   ((r2=r1)!= -1 || p2->type==REG) &&
			   (!(p1->flags&IND) && p1->type != REG));
		/* register available for ind p2 but not necessary for p1 */
		if (!bool) bool = !((p1->flags&IND) || p2->flags&IND);
		/* no registers necessary */
		if (bool) {
#ifdef DUMPALL
		printf("If indirect : registers are available\n");
#endif
		if (p1->flags & IND){
			/* if offsets for doubles are remembered also,
			then test here also for OFF and think of a
			better solution below! */
#ifdef DUMPALL
			printf("Source is indirect\n");
#endif
			if (p1->type == REG && (p1->flags&OFF)==0)
				r1 = p1->index;
			else {
				p1->flags =& ~IND;
				tmp.type = REG;
				tmp.flags= INT;
				tmp.offset=0;
				if (p1->type==REG) r1=p1->index;
				tmp.index=r1;
#ifdef DUMPALL
				printf("move the address to a register\n");
#endif
				genf(MOV,p1,&tmp);
				p1->flags =| IND;
			}
		} else r1 = -1;
		if (p2->flags & IND) {
			/* see comment above */
#ifdef DUMPALL
			printf("Destination is indirect\n");
#endif
			if (p2->type == REG && (p2->flags&OFF)==0)
				r2 = p2->index;
			else {
				p2->flags =& ~IND;
				tmp.type = REG;
				tmp.flags= INT;
				tmp.offset=0;
				if (p2->type==REG)
					r2=p2->index;
				tmp.index=r2;
#ifdef DUMPALL
				printf("move the address to a register\n");
#endif
				genf(MOV,p2,&tmp);
				p2->flags =| IND;
			}
		} else r2 = -1;
#ifdef DUMPALL
		printf("now we do the move in two instructions\n");
#endif
		if (p1->type == STK) {
			/*
			** First we pop into the high word.
			** Next we pop into the low word !!
			*/
			s1 = s2 = POP;
			if (r2>=0) {
				strcpy(sb1,indreg(2,r2));
				s3 = sb1;
				s4 = indreg(0,r2);
			} else {
				s4 = str1(p2);
				p2->offset =+ 2;
				s3 = str(p2);
			}
		} else	{
			if (r1>=0) {
				strcpy(sb1,autinc(r1));
				s1 = s2 = sb1;
			} else {
				strcpy(sb1,str(p1)); s1 = sb1;
				p1->offset=+2;
				strcpy(sb2,str(p1)); s2 = sb2;
			}
			if (r2>=0)
				s3 = s4 = autinc(r2);
			else
				if (p2->type==STK)
					s3 = s4 = PSH;
				else {
					s3 = str1(p2);
					p2->offset=+2;
					s4 = str(p2);
				}
		}
		if (p1->type==CONS && p1->offset==2)
			gen1(CLR,s3);
		else
			gen2(MOV,s1,s3);
		if (p1->type==CONS)
			gen1(CLR,s4);
			/* a floating constant. The exponent resides in
			** the word with the low address */
		else
			gen2(MOV,s2,s4);
		coco = fake;
	}} else {
mov_with_fr:
#ifdef DUMPALL
		printf("Use floating registers\n");
#endif
		if ((conv=(p1->flags&CONV))==IFC || conv==DFC) {
			mnem1 = LDCIF;
			if (conv==DFC)
				gen0(SETL);
		} else if (is_reg(p1)==FREG)
			mnem1 = 0;
		else
			mnem1 = op_ldf;
		if (conv==FIC || conv==FDC) {
			mnem2 = STCFI;
			coco = p1;
			if (conv==FDC)
				gen0(SETL);
		} else if (is_reg(p2)==FREG && mnem1)
			mnem2 = 0;
		else
			mnem2 = op_stf;
		if (mnem1 && mnem2) {
			tmp.type = REG;
			tmp.flags = 0;
			tmp.offset=0;
			if ((r1 = reg_avail(0,ONLY_REG)) == -1) {
				flag++;
				tmp.index = 0;
				gen2(op_stf,FR0,FR4);
			} else
				tmp.index = r1;
			if (p1->type == STK)
				gen2(mnem1,POP,str(&tmp));
			else
				genf(mnem1,p1,&tmp);
			if (p2->type == STK)
				gen2(mnem2,str(&tmp),PSH);
			else
				genf(mnem2,&tmp,p2);
			if (flag)
				gen2(op_ldf,FR4,FR0);
		} else {
			if (p2->type==STK)
				s1 = PSH;
			else
				s1 = str1(p2);
			if (mnem1)
				gen2(mnem1,str(p1),s1);
			else
				gen2(mnem2,str(p1),s1);
		}
		if (conv==DFC || conv==FDC)
			gen0(SETI);
	}
	free_reg(p1);
	copyf(p2,p1);
	if (flag)
		coco = fregs[REG0];
	else
		coco = p1;
}
