#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * LOAD/STORE INDIRECT
 * SET GROUP
 * ARRAY GROUP
 *
 */

/*
 *  op_loi 1, 2, 4, 6, etc.
 */

gen_loi (op) int op; {
	register fake_t *ftop;
	register char *s;
	fake_t f;

	make_int(1,SAVE_FAKE);
	if (op==1) {
		gen_lib();
		return;
	}
	op =>> 1; /* bytes -> words */
	checkint(fsp,ANY,ANY);
	if (op == 1 || op == 2){
		if (fsp->flags & (IND))
			mv_to_reg(fsp,ANY);
		if (op == 2)
			fsp->flags =& OFF; /* save OFF bit */
		coco = fake;
		switch(fsp->type) {
		case ADDREXT:
			fsp->type = EXT;
			break;
		case ADDRLOCL:
			fsp->type = LOCL;
			break;
		case STK:
			reg_frame(&f);
			getreg(&f,ONLY_REG);
			gen2(MOV,POP,str(&f));
			fsp--;
			pshfk(&f);
			if (op==2)  fsp->flags = 0;
			coco = fsp;
		default:
			fsp->flags =| IND;
		}
	} else {
		ftop=fsp--;
		empty_fake(ALL);
		mv_to_reg(ftop,ANY); /* address to a register,
					if not already there  */
		if ((op==3)||(op==4)){
			do
				gen2(MOV,autinc(ftop->index),PSH);
			while (--op);
		} else {
			reg_frame(&f);
			getreg(&f,ONLY_REG);	/* sob register  */
			s = str(&f);
			gen2(MOV,imm(op),s);
			plabel(TMP1);
			gen2(MOV,autinc(ftop->index),PSH);
			gen2(SOB,s,B1);
		}
		iregs[ftop->index] = FREE;
		coco = fake;
	}
}

/*
 *  op_loi 1
 */

gen_lib() {
	register char *s;
	fake_t f;

	if (fsp->flags&(IND|CONV))
		mv_to_reg(fsp,ANY);
	switch(fsp->type) {
	case ADDREXT:
		fsp->type = EXT;
		s = str1(fsp);
		break;
	case ADDRLOCL:
		fsp->type =LOCL;
		s = str1(fsp);
		break;
	case STK:
		s = INDPOP;
		break;
	default:
		fsp->flags =| IND;
		s = str1(fsp);
	}
	coco = fsp;
	reg_frame(&f);
	if (fsp->type == REG && (f.index=reg_avail(INT,ANY)) == -1) {
		fsp->flags =& ~IND;
		gen2(MOVB,s,str(fsp));
		gen2(BIC,HIGHBYTE,str(fsp));
		coco = fake;
	} else {
		if (fsp->type != REG) {
			f.index = ANY;
			getreg(&f,ONLY_REG);
		} else
			iregs[fsp->index]=FREE; /* release src (address) reg  */
		fsp--;
		pshfk(&f); /* push dest reg frame  */
		gen1(CLR,str(&f));
		gen2(BISB,s,str(&f));
	}
}

/*
 *  op_sti 1, 2, 4, 6 etc.
 */

gen_sti (op) int op; {
	register fake_t *ftop;
	register nice,i;
	fake_t *lowestnice,tmp;
	int regnr,up,leftover;
	fake_t f;
	char *s;

	if (op==1) {
		gen_sib();
		return;
	}
	op =>> 1; /* bytes -> words */
	make_int(1,EMPTY_FAKE);	/* the address */
	if (op==1 || op==2) {
		if ((fsp->flags & (CONV|IND|OFF)) != 0)
			mv_to_reg(fsp,ANY);
		switch(fsp->type) {
		case ADDREXT:
			fsp->type = EXT;
			break;
		case ADDRLOCL:
			fsp->type = LOCL;
			break;
		case STK:
			reg_frame(&f);
			getreg(&f,ONLY_REG);
			move(fsp,&f);
		default:
			fsp->flags =| IND;
		}
		if (op == 2)
			fsp->flags =& ~INT;
		copyf(fsp--,&f);
		if (op == 1)
			make_int(1,EMPTY_FAKE);
		else
			make_dbl(1);
		if ((ftop=fsp)->type != STK)
			fsp--;
		empty_fake(ALL);
		move(ftop,&f);
	} else {
		copyf(fsp--,&f); /* save topframe (dest. addr)*/
		ftop = fsp;
		nice = 0;
		while (fsp>fake && nice<op) {
			if (fsp->type==STK || fsp->flags&CONV)
				break;
			if ((fsp->flags & ~IND)==INT) {
				fsp--;
				nice++;
			} else {
				if (is_reg(fsp)==FREG ||
					(fsp->flags & (IND|OFF)))
				/*float reg,or an indir. float frame*/
					break;
				fsp--;
				nice =+ 2;
			}
			if (nice>=MAXFAKE)
				break;
		}
		lowestnice = fsp+1;
		leftover = op - nice;	/* words still to store */
		if (leftover == -1) {
			fsp++;
			leftover=1;
			nice =- 2;
		}
		empty_fake(ALL);
		fsp = ftop;
		make_int(nice,SAVE_FAKE);
			/* now only 'nice' integer frames on fake */
		if (leftover>0) {
			/* then also some STK frames have to be
			 * stored; so move from 'top to bottom'.
			 */
			if (f.type == ADDREXT || f.type == ADDRLOCL) {
				f.offset =+ op*2;
				mv_to_reg(&f,ANY);
			} else {
				mv_to_reg(&f,ANY);
				gen2(op_add,imm(op*2),str(&f));
			} /* : address to a register */
			regnr = f.index;
			s = autdec(regnr);
			up=FALSE;
		} else { /* only 'nice' frames to store:
			  * do it from 'bottom to top'.
			  */
			mv_to_reg(&f,ANY);
			regnr = f.index;
			s = autinc(regnr);
			up=TRUE;
		}
		if (up)
			fsp = lowestnice;
		for (i = 1; i <= nice; i++,(up?fsp++:fsp--))
			if (fsp->type==CONS && fsp->offset==0)
				gen1(op_zrl,s);
			else if (fsp->type==ADDRLOCL)
				if (up) {
					if (fsp->offset) {
						gen2(MOV,LB,indreg(0,regnr));
						gen2(op_add,imm(fsp->offset),s);
					} else
						gen2(MOV,LB,s);
				} else {
					gen2(MOV,LB,s);
					if (fsp->offset)
						gen2(op_add,imm(fsp->offset),
							indreg(0,regnr));
				}
			else {
				gen2(MOV,str(fsp),s);
				free_reg(fsp);
			}
		if (leftover<=4) /* (sob-loop requires 4 words) */
			for(i=1;i<=leftover;i++)
				gen2(MOV,POP,s);
		else {	/* nb. here the whole STI operation is done
			 * from top to bottom.
			 */
			reg_frame(&f);
			getreg(&f,ONLY_REG);
			gen2(MOV,imm(leftover),str(&f));
			plabel(TMP1);
			gen2(MOV,POP,s); /* s = autdec(regnr) ! */
			gen2(SOB,str(&f),B1);
		}
	}
	clearegs();
	coco = fsp = fake;
}

/*
 *  op_sti 1
 */

gen_sib() {
	register fake_t *ftop;

	make_int(2,EMPTY_FAKE);
	ftop = fsp;
	if (fsp->type != STK)
		if ((--fsp)->type!=STK)
			fsp--;
	empty_fake(ALL);
	if (ftop->type==STK) {
		if ((--ftop)->type == STK) {
			gen2(MOVB,MIN4SPX,INDPOP);
			gen1(TST,POP);
		} else {
			checkint(ftop,ANY,ANY);
			gen2(MOVB,str(ftop),INDPOP);
		}
	} else {
		if (ftop->flags & (IND|OFF|CONV))
			mv_to_reg(ftop,ANY); /*! */
		checkint(ftop-1,ANY,ANY); /* conv's & addr's  */
		switch(ftop->type) {
		case ADDRLOCL:
			ftop->type = LOCL;
			break;
		case ADDREXT:
			ftop->type = EXT;
			break;
		default:
			ftop->flags =| IND;
		}
		if ((ftop-1)->type == STK) {
			gen1(TST,POP);
			gen2(MOVB,INDSPX,str(ftop));
		} else
			genf(MOVB,ftop-1,ftop);
	}
	clearegs();
	coco = fake;
}

/*
 *  op_inn, op_ins
 */

gen_inn (mn,fp,op) int mn,op; fake_t *fp; {
	fake_t f;

	reg_frame(&f);
	f.index=REG1;
	move(fp,&f);	/* bit-nr to r1  */
	extsubr(".inn");
	popfk(op);	/* remove set-info  */
	pshfk(&f);	/* r1 is result of INN or INS  */
	coco = fsp;	/* no 'TST' needed  */
}

/*
 *  op_aar, op_lar, op_sar, op_aas, op_las, op_sas,
 *  with operand not in rom
 */

gen_arr (mn,fp) int mn; fake_t *fp; {
	register char *s;

	iregs[REG0]=fp;	/* not free!: descr pntr already in r0  */
	mv_to_reg(fp--,REG1);	/* array index to r1  */
	mv_to_reg(fp,REG2);	/* base address to r2  */
	s = ".aar";
	if (mn==op_aar || mn==op_aas)
		pshfk(fp);
	else {
		iregs[REG2]=FREE;
		if (mn==op_lar || mn==op_las)
			s = ".lar";
		else
			s = ".sar";
	}
			/* r2 is result of AAR or AAS  */
	extsubr(s);
	iregs[REG0]=iregs[REG1]=FREE;
	coco = fake;
}

/*
 *  op_aar, op_lar, op_sar,
 *  with descriptor in rom
 */

arrspc(mnem,gbp) int mnem; glob_t *gbp; {
	register low,bytes,typ;
	char *s;

	low = gbp->g_rom[0];
	bytes = gbp->g_rom[2];
	make_int(2,SAVE_FAKE);
	if (bytes>=6)
		checkint(fsp,ODD_REG,ANY);
	else
		mv_to_reg(fsp,ANY);
	s = str(fsp);
	if( (typ=(fsp-1)->type)==ADDREXT || typ==ADDRLOCL)
		(fsp-1)->offset =- low*bytes;
	else
		switch (low) {
		case -2:
			gen1(op_inc,s);
		case -1:
			gen1(op_inc,s);
		case 0:
			break;
		case 2:
			gen1(op_dec,s);
		case 1:
			gen1(op_dec,s);
			break;
		default:
			gen2(op_sub,imm(low),s);
		}
	switch(bytes){
	case 0:
		fatal("arr.desc. 0 bytes per entry");
	case 4:
		gen1(ASL,s);
	case 2:
		gen1(ASL,s);
	case 1:
		break;
	default:
		gen2(op_mul,imm(bytes),s);
	}
	/* real offset(in bytes) is on top of fake;
	 * base address of array is below the top of the fake.
	 */
	add_sub(op_add);
	if (mnem == op_lar)
		gen_loi(bytes);
	else if (mnem == op_sar)
		gen_sti(bytes);
}
