#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * BOOLEAN GROUP
 * COMPARISON GROUP
 *
 */

/*
 *  op_and, op_xor
 */

and_xor(mnem) int mnem;{
	register fake_t *tp,*sp;
	register line_t *lp;

	make_int(2,SAVE_FAKE);
	tp = fsp--;
	sp = fsp;
	lp = forward();
	checkint(tp,ANY,ANY);
	checkint(sp,ANY,ANY);

	if (congr(sp,lp)){
		fsp--;
		empty_to(sp);
		mv_to_reg(tp,ANY);
		if (mnem==BIC)
			gen1(COM,str(tp));
		genf(mnem,tp,sp);
		free_reg(tp);
		coco = fake;
		nextline = lp;
	} else if (congr(tp,lp)) {
		fsp--;
		empty_to(tp);
		mv_to_reg(sp,ANY);
		if (mnem==BIC)
			gen1(COM,str(sp));
		genf(mnem,sp,tp);
		free_reg(sp);
		coco = fake;
		nextline = lp;
	} else {
		mv_to_reg(tp,ANY);
		mv_to_reg(sp,ANY);
		if (mnem==BIC)
			gen1(COM,str(tp));
		genf(mnem,tp,sp);
		free_reg(tp);
		coco = sp;
	}
}

/*
 *  op_and, op_ior, op_xor, op_ans, op_ios, op_xos,
 *  with operand = 4, 6, 8 etc.
 */

gen_boo (mn,op) int mn,op; {
	register char *ss;
	register fake_t *ftop;

	if (mn==op_and || mn==op_ior || mn==op_xor)
		ftop = to_reg0(0,op,imm(op));
	else
		ftop = to_reg0(1,ALL,0);
	switch (mn) {
	case op_and:
	case op_ans:
		ss = ".and";
		break;
	case op_ior:
	case op_ios:
		ss = ".ior";
		break;
	case op_xor:
	case op_xos:
		ss = ".xor";
	}
	extsubr(ss);
	popfk(op >> 1); /* pop n words from fake  */
	coco = fake;
}


/*
 *  op_cmi, op_cmu, op_cmf, op_cmp
 */

gen_cmp (mnem) int mnem;{
	register line_t *fwp;
	register fake_t *tp,*sp;
	fake_t tmp,f;
	int next_mnem,rev,branch;
	char sb1[MAXSTRL],sb2[MAXSTRL],lab[MAXSTRL];

	reg_frame(&tmp);
	branch=(mnemon[next_mnem=(fwp=forward())->instr_num&0377].m_flags
		& MNABCEM) == MNB;
	rev = FALSE;
	if (mnem == op_cmf) {
		make_dbl(2);
		checkflt(tp = fsp--);
		checkflt(sp = fsp--);
	} else {
		make_int(2,branch?EMPTY_FAKE:SAVE_FAKE);
		checkint(tp = fsp--,ANY,ANY);
		checkint(sp = fsp--,ANY,ANY);
	}
	if (branch) {	/* a conditional branch */
		empty_fake(ALL);
		strcpy(lab,locname(fwp->ad.ad_lp->l_val));
	} else {
		getreg(&tmp,ONLY_REG);
		iregs[tmp.index] = &tmp;
		gen1(CLR,str(&tmp));
		strcpy(lab,F1);
	}
	if (mnem == op_cmf) {
		if (is_reg(sp)==FREG)
			genf(op_cmf,tp,sp);
		else if (is_reg(tp)==FREG) {
			genf(op_cmf,sp,tp);
			rev = TRUE;
		} else {
			reg_frame(&f);
			f.flags=0;
			getreg(&f,ONLY_REG);
			strcpy(sb2,str(&f));
			if (tp->type==STK && sp->type==STK) {
				strcpy(sb1,POP);
				gen2(op_ldf,sb1,sb2);
				rev = TRUE;
				/* we pop in the wrong order  */
			} else {
				strcpy(sb1,str(tp));
				move(sp,&f);
			}
			gen2(op_cmf,sb1,sb2);
		}
		gen0(CFCC);
		free_reg(tp);
		free_reg(sp);
	} else
		bool_compare(mnem,tp,sp);
	if (!branch)
		pshfk(&tmp);
	else
		coco=fake;
	switch (next_mnem) {
	case op_zge:
	case op_tlt:
		if (mnem==op_cmu)
			mnem=BLOS;
		else if (rev)
			mnem=op_bge;
		else
			mnem=op_ble;
		nextline=fwp;
		gen1(mnem,lab);
		if (next_mnem==op_zge)
			return;
		else
			break;
	case op_zgt:
	case op_tle:
		if (mnem==op_cmu)
			mnem=BLO;
		else if (rev)
			mnem=op_bgt;
		else
			mnem=op_blt;
		nextline=fwp;
		gen1(mnem,lab);
		if (next_mnem==op_zgt)
			return;
		else
			break;
	case op_zle:
	case op_tgt:
		if (mnem==op_cmu)
			mnem=BHIS;
		else if (rev)
			mnem=op_ble;
		else
			mnem=op_bge;
		nextline=fwp;
		gen1(mnem,lab);
		if (next_mnem==op_zle)
			return;
		else
			break;
	case op_zlt:
	case op_tge:
		if (mnem==op_cmu)
			mnem=BHI;
		else if (rev)
			mnem=op_blt;
		else
			mnem=op_bgt;
		nextline=fwp;
		gen1(mnem,lab);
		if (next_mnem==op_zlt)
			return;
		else
			break;
	case op_zne:
	case op_teq:
		gen1(op_bne,lab);
		nextline=fwp;
		if (next_mnem==op_zne)
			return;
		else
			break;
	case op_zeq:
	case op_tne:
		gen1(op_beq,lab);
		nextline=fwp;
		if (next_mnem==op_zeq)
			return;
		else
			break;
	default:
		gen1(op_beq,F1);
		if (mnem==op_cmu)
			gen1(BLO,F2);
		else if (rev)
			gen1(op_bgt,F2);
		else
			gen1(op_blt,F2);
		gen1(op_dec,str(fsp));
		gen1(op_brf,F1);
		plabel(TMP2);
	}
	gen1(op_inc,str(fsp));
	plabel(TMP1);
}

/*
 *  op_tlt, op_tle, op_teq, op_tge, op_tgt, op_tne
 */

gen_tst(mnem) int mnem;{
	register fake_t *tp;
	fake_t tmp;

	reg_frame(&tmp);
	getreg(&tmp,ONLY_REG);
	gen1(CLR,str(&tmp));
	make_int(1,SAVE_FAKE);
	checkint((tp=fsp),ANY,ANY);
	gen1(TST,str(tp));
	if (tp->type==REG)
		iregs[tp->index] = FREE;
	copyf(&tmp,fsp);
	switch (mnem) {
	case op_tlt:
		mnem=op_bge;
		break;
	case op_tle:
		mnem=op_bgt;
		break;
	case op_tgt:
		mnem=op_ble;
		break;
	case op_tge:
		mnem=op_blt;
		break;
	case op_teq:
		mnem=op_bne;
		break;
	case op_tne:
		mnem=op_beq;
		break;
	}
	gen1(mnem,F1);
	gen1(op_inc,str(fsp));
	plabel(TMP1);
	coco = fake;
}

/*
 *  op_brf, op_brb, op_blt, op_ble, op_beq, op_bge, op_bgt,
 *  op_bne, op_zlt, op_zle, op_zeq, op_zge, op_zgt, op_zne
 */

gen_bra (mnem,br_add,test,tstmnm) int mnem,br_add,test,tstmnm;{
	register fake_t *lp,*rp;
	char lab[MAXSTRL];

	strcpy(lab,locname(br_add));
	if (test == 2) {
		make_int(2,SAVE_FAKE);
		checkint((rp=fsp--),ANY,ANY);
		checkint((lp=fsp--),ANY,ANY);
		empty_fake(ALL);
		bool_compare(tstmnm,rp,lp);
	} else if (test) {
		make_int(1,SAVE_FAKE);
		if ((lp=fsp)->type!=STK)
			fsp--;
		clr_fake_if_all_STKs();
		if (fsp != fake)
			empty_fake(ALL);
		if (lp->type==STK)
			gen1(TST,POP);
		else {
			if (coco != lp)
				gen1(TST,str(lp));
			else if (!(coco->flags & INT))
				gen0(CFCC);
			free_reg(lp);
		}
	} else
		empty_fake(ALL);
	switch(mnem){
	case op_beq:
	case op_zeq:
		mnem=op_beq;
		break;
	case op_bne:
	case op_zne:
		mnem=op_bne;
		break;
	case op_bgt:
	case op_zlt:
		mnem=op_blt;
		break;
	case op_blt:
	case op_zgt:
		mnem=op_bgt;
		break;
	case op_bge:
	case op_zle:
		mnem=op_ble;
		break;
	case op_ble:
	case op_zge:
		mnem=op_bge;
		break;
	default:
		mnem=op_brf;
	}
	gen1(mnem,lab);
	coco = fake;
}

bool_compare (mnem,top,sec) fake_t *top,*sec; {
	register fake_t *rp,*lp,*tp;

	rp=top;
	lp=sec;	/* Right operand is Top, Left is Second */
	if (mnem==op_ior) {
		if (lp->type==REG) {
			if (lp->flags&(IND|OFF))
				mv_to_reg(lp,ANY);
		} else if (rp->type==REG) {
			if (rp->flags&(IND|OFF))
				mv_to_reg(rp,ANY);
			tp = lp; lp = rp; rp = tp;
		} else
			checkint(lp,REG_or_STK,ANY);
		mnem = BIS;
	}
	genf(mnem,rp,lp);
	free_reg(rp);
	free_reg(lp);
}
