#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

/*
 * Collection of subroutines for manipulation of
 * pseudo instructions.
 */

/*
 * some structures only needed by this module.
 * they can not be declared in opt00.h because some buffer sizes
 * are computed by sizeof, which only works on already declared
 * objects in version 6. Declaration of objects in opt00.h
 * causes 'Multiple declared' errors in some other compilers
 */
struct	list {
	char	*l_remp;
	int	l_index;
	int	l_count;
};

list_t	*currl;
int	freel;

#define LIST_IN_REM	30
#define CHAR_IN_REM	((sizeof *currl) * LIST_IN_REM - 2)

struct	remem {
	char	r_cont[CHAR_IN_REM];
	remb_t	*r_next;
};

remb_t	*curem;
int	remindex;		/* index into curem->r_cont[] */
int	curcount;		/* number of characters in current list */

struct	block {
	char	b_cont[sizeof *curem];
	bloc_t	*b_next;
};

bloc_t	*firstb;		/* head of chain of blocks */
bloc_t	*currb;			/* next free one on chain */



/* The bytes (i.e. compact code) in the chain of rememberblocks
   have three main parts:
   first the bytes for a global label, if any;
   second the byte for the pseudo instruction;
   third the bytes for the operands of the pseudo, if any.
   In this way writing out compact code for a pseudo EM1-line is just
   copying all the bytes from the rememberblock-chain. (cf. pass_3)
   To be able to do this the compact representation
   of a global label must be the same as the representation
   of a global label occurring as an operand (of any EM1 instruction).
*/

bloc_t *alloc_block() {
	if (currb->b_next == NULL) {
		currb->b_next = blp_cast askmore(sizeof *currb);
		currb->b_next->b_next = NULL;
	}
	currb = currb->b_next;
	return(currb);
}

list_t *alloc_list() {
	if (freel == 0) {
		freel = LIST_IN_REM;
		currl = lsp_cast alloc_block();
	}
	freel--;
	return(currl);
}

#define	alloc_remem()	alloc_block();

mark_list(apl) list_t **apl; {
	register list_t *pl;

	/*
	 * This procedure has as a parameter a pointer to a listpointer.
	 * It will fill in the pointer with a pointer to a struct,
	 * will fill in the struct to point to current rememberblock
	 * and index and set curcount to 0
	 * It is called for each pseudo to initialise
	 * argument processing.
	 */
	*apl = pl = alloc_list();
	pl->l_remp = chp_cast curem;
	pl->l_index = remindex;
	curcount = 0;
	if (curglosym)	/* : a global label is present */
		put_glob_in_list(curglosym->g_name);
}

end_list() {
	/*
	 * This procedure fills in the count-field of the list-structure
	 */
	currl->l_count = curcount;
	currl++;
}

print_list(al) list_t *al; {
	register remb_t *rem;
	register index,count;

	/*
	 * This procedure will print the list pointed at by al.
	 */
	if (al == NULL)
		return;
	rem = rmp_cast al->l_remp;
	index=al->l_index;
	count=al->l_count;
	while (count--) {
		if (index >= CHAR_IN_REM) {
			index = 0;
			rem = rem->r_next;
		}
		outbyte(rem->r_cont[index++]);
	}
}

init_lists() {
	/*
	 * This procedure is called once, at start of assembly
	 */
	firstb = blp_cast askmore(sizeof *firstb);
	firstb->b_next = NULL;
	forget();
}

forget() {
	/*
	 * This procedure is called at the end of optimizing of
	 * each EM1-procedure. It returns all used list space
	 * to the free list and all things like that.
	 */
	currb = firstb;
	freel = 0;
	curem = rmp_cast alloc_remem();
	remindex = 0;
}

put_byte_in_list(byte) char byte; {

	/*
	 * this procedure will put it's argument at the end of the remember
	 * list. If there is no space a new remember-struct will be
	 * requested.
	 */
	if (remindex >= CHAR_IN_REM) {
		/*
		 * space exhausted, ask for more
		 */
		remindex = 0;
		curem->r_next = rmp_cast alloc_remem();
		curem = curem->r_next;
	}
	curem->r_cont[remindex++] = byte;
	curcount++;
}


pr_int (n,proc) int n; void (*proc)(); {
	/*
	 * This procedure will put the n integer in the list,
	 * or writes it out in compact code.
	 * Various possibilities exist, for details see em1-manual
	 */
	if(abs(n) > 255 || n == -32768) {
		(*proc)(sp_cst2);
		(*proc)(n);
		(*proc)(n>>8);
	} else
		if ( n >= 0 ) {
			if( n >= sp_fcst0+sp_ncst0 )
				(*proc)(sp_cst1);
			(*proc)(n);
		} else {
			(*proc)(sp_cstm);
			(*proc)(-n);
		}
}

pr_glo (str,proc) char *str; void (*proc)(); {
	register char *p;
	register n;

	/*
	 * This procedure will put the global label string at the end of
	 * the remember list. See em1-manual.
	 */
	p = str;
	if ( ((*p++)&0377) == 255) {
		n = *p++;
		n =& 0177;
		n =<< 8;
		n =| (*p++ & 0377);
		if (n >= 0 && n < 256) {
			(*proc)(sp_dlb1);
			(*proc)(n);
		} else {
			(*proc)(sp_dlb2);
			(*proc)(n&0377);
			(*proc)(n>>8);
		}
	} else
		pr_str(sp_dnam,str,proc);
}

pr_str (header,str,proc) int header; char *str; void (*proc)(); {
	register n;
	register char *p;

	/*
	 * This procedure will put the string str until the first null-byte
	 * (which is known to be the end of the string) at the end of
	 * the rememberlist,
	 * preceded by the byte header and the length of it.
	 */
	p = str; n = 0;
	while(*p++)
		n++;
	pr_crud(header,str,n,proc);
}

pr_crud (header,str,length,proc) int header,length; char *str;void (*proc)(); {
	register char *p;

	/*
	 * This procedure will put the length bytes pointed
	 * at by str at the end of the rememberlist,
	 * preceded by the byte header and the number of bytes.
	 */
	(*proc)(header);
	if (length<255)
		(*proc)(length);
	else {
		(*proc)(255);
		(*proc)(length);
		(*proc)(length>>8);
	}
	p = str;
	while(length--)
		(*proc)(*p++);
}

put_glob_in_list (str) char *str; {
	pr_glo(str,put_byte_in_list);
}

/* not used
put_locl_in_list(n) int n; {
	if ( (n & 0177400) == 0) {
		put_byte_in_list(sp_ilb1);
		put_byte_in_list(n);
	} else {
		put_byte_in_list(sp_ilb2);
		put_byte_in_list(n);
		put_byte_in_list(n>>8);
	}
}

put_int_in_list (n) int n; {
	pr_int(n,put_byte_in_list);
}

put_string_in_list (head,str) int head; char *str; {
	pr_str(head,str,put_byte_in_list);
}

put_crud_in_list (head,str,length) int head,length; char *str; {
	pr_crud(head,str,length,put_byte_in_list);
}
end of unused routines */

#ifdef DUMP
int pseunum (listptr) int *listptr; {
	register remb_t *r;
	register i,n;

	if(listptr==0) return(0);
	r = *listptr++;
	i = *listptr;
	switch (n = r->r_cont[i] & 0377) {
	case sp_dlb2:	i++;
	case sp_dlb1:	i++;
			break;
	case sp_dnam:	i++;
			i =+ r->r_cont[i];
			break;
	default:	return(n);
	}
	return(r->r_cont[i] & 0377);
}
#endif
