/*
 * This file should be preprocessed by the C preprocessor
 * to adapt to your PDP-11 processor. The next few lines
 * contain the define's appropriate for an 11/60.
 * The table just before the label 'backup:' gives the
 * setting of the switches for the other processors.
 */

/* #define CPU_SEPID		/* Separate I and D space */
#define CPU_HARDFP		/* 11/45 type hardware floating point */

#define BACK_FPPNOT		/* FP instructions fail in INITIAL state */
/* #define BACK_MODE2S		/* op (r)+,dd fails in INITIAL state */
/* #define BACK_MODE2D		/* op (r)+ fails in INITIAL state */
#define BACK_FIXSP		/* inclusive 'or' of three previous ones */

	/
	/ back up from a segmentation violation (called from trap.c)
	/   backup(u.u_ar0) == 0 if backup assumed to be successful
	/
	/ Almost all processors of the PDP-11 series behave differently
	/ with respect to segmentation violation backup.
	/ This backup routine can handle all these
	/ processors if the correct options are set.

	.globl	_backup
	.globl	_regloc

	_backup:

#ifndef CPU_SEPID
		mov	2(sp),ssr+2
		mov	r2,-(sp)
		jsr	pc,backup
		mov	r2,ssr+2
		mov	(sp)+,r2
		movb	jflg,r0
		bne	2f
#endif
		mov	2(sp),r0
		movb	ssr+2,r1
		jsr	pc,1f
		movb	ssr+3,r1
		jsr	pc,1f
		movb	_regloc+7,r1
		asl	r1
		add	r0,r1
		mov	ssr+4,(r1)
		clr	r0
	2:
		rts	pc
	1:
		mov	r1,-(sp)
		asr	(sp)
		asr	(sp)
		asr	(sp)
		bic	$!7,r1
		movb	_regloc(r1),r1
		asl	r1
		add	r0,r1
		sub	(sp)+,(r1)
		rts	pc

#ifndef CPU_SEPID
	/	Hard part - simulate the SSR1 register which DEC fail to
	/	provide on the /23, /34, /40 and /60. This version of
	/	"backup" was concocted from the V6 m40.s, the V7 m40.s,
	/	the Stanford m34.s, and the Edinburgh m60.s.
	/		D.S.H. Rosenthal	Dec '79
	/		EdCAAD Studies, Dept. of Architecture,
	/		22 Chambers St., Edinburgh.
	/	Some changes for the VU system by
	/		Johan Stevenson, Vrije Universiteit, Amsterdam.

	/	The basic cases are as follows:-

	/ 1.	op dd
	/	The fault happened on the dd.

	/ 2.	op ss,dd
	/	The fault may have happened on either the ss or dd. "backup"
	/	evaluates and fetches the ss. If this process faults, the
	/	adjustment of the dd register [delta(dd)] is zeroed. Things
	/	would be easier if the hardware recorded what it was fetching.

	/ 3.	mfp[id]	ss
	/	Handled like mov ss,-(sp).

	/ 4.	mtp[id] dd
	/	Handled like mov (sp)+,dd.

	/ 5.	jsr r,dd
	/	The hardware evaluates, but does not fetch, dd and then pushes
	/	the initial value of r onto the stack. "backup" assumes that the
	/	fault is in the stack push (you shouldn't be jsr-ing via non-
	/	existent locations!) and adjusts both the dd register and the sp.

	/ 6.	FP11 op
	/	The operands may be 2, 4 or 8 bytes long, depending upon the
	/	particular operation and the "floating double" and "long integer"
	/	bits.

	/ 7.	illegal stuff like "mark"

	/	There are also various special cases which depend upon the
	/	particular processor you're running, and how adventurous you feel.

	/* #define REGREG  1	/*  op ss,dd */

	/	If both the ss and dd refer to the same register, and if delta(dd)
	/	is non-zero, it is impossible to distinguish an ss from a dd fault.
	/	Define REGREG to assume:-
	/		If delta(ss) == 0 then dd fault else failure.
	/	This permits, for example, a push fault in mov (sp),-(sp) to be
	/	backed-up correctly. However, a source fault would be backed-up
	/	incorrectly, and without warning. Remove REGREG unless you are
	/	absolutely certain.

	/ BACK_MODE2D for op (r)+ set in param.h

	/	Remove BACK_MODE2D on machines which fault an op (r)+ with the
	/	register in its FINAL state. Define it on machines which fault an
	/	op (r)+ with the register in its INITIAL state.

	/ BACK_MODE2S for op (r)+,dd set in param.h

	/	Remove BACK_MODE2S on machines which fault an (r)+ source with the
	/	registers in their FINAL state. Define it on machines which fault an
	/	(r)+ source with the registers in their INITIAL state. On these
	/	machines there are 4 cases:-

	/	Case	Before		After	Faults
	/			------
	/	1.		//////	<- r
	/			------		none
	/		  r ->	/////
	/			------

	/			------
	/	2.			<- r
	/			------		r, not r-2
	/		  r ->	/////
	/			------

	/			------
	/	3.	  r ->		<- r
	/			------		r, not r-2
	/			/////
	/			------

	/			------
	/	4.	  r ->		<- r
	/			------		r and r-2
	/
	/			------

	/	Cases 2 and 3 are indistinguishable after the fact, and so a backup
	/	failure must be signalled if either is detected.

	/ BACK_FPPNOT for FP11 ops set in param.h

	/	Define BACK_FPPNOT on machines which fault FP11 ops with the registers
	/	in their INITIAL state if the operand was 4 or 8 bytes long. Remove it
	/	on machines which fault these operations with the registers in their
	/	FINAL state.

	/ BACK_FIXSP set in param.h

	/	If any operations are aborted with the registers in their INITIAL
	/	state, then BACK_FIXSP must be defined to include the code for "fix"-ing
	/	the stack in these cases.

	/	To the best of our knowledge, the settings should be:-
	/		(1 is defined, 0 is removed)

	/	Machine		FPPNOT	MODE2S	MODE2D	FIXSP
	/	/40		0	0	0	0
	/	/34+FP11A	0	1	1	1
	/	/60		1	0	0	1
	/	/60+FP11E	1	0	0	1
	/	/23+KEF11A	0	?	?	?

	/	Enter here with address of register save area in ssr+2.
	/	First sort out op-code.

	backup:
		clr	r2		/r2 stands for SSR1
		clr	bflg		/jflg = 0; bflg = 0 for byte op.
		mov	ssr+4,r0	/r0 = virtual pc.
		jsr	pc,fetch	/get instruction word.
		mov	r0,r1
		ash	$-11.,r0
		bic	$!36,r0
		mov	0f(r0),pc	/switch on xx----

	/	Note that DEC's frequency-driven micro-code design means that
	/	mov is usually faster than jmp, but it zaps the condition codes!

	0:	t00;	t01;	t02;	t03;	t04;	t05;	t06;	t07
		t10;	t11;	t12;	t13;	t14;	t15;	t16;	t17

	t00:
		incb	bflg		/bflg = 1 for 2 byte op.
	t10:
		mov	r1,r0
		swab	r0
		bic	$!16,r0
		mov	0f(r0),pc	/switch on 00x--- or 10x---

	0:	u0;	u1;	u2;	u3;	u4;	u5;	u6;	u7

	u6:
		mov	r1,r0
		ash	$-5,r0
		bic	$!16,r0
		mov	0f(r0),pc	/switch on 006x-- or 106x--

	u60 = u5	/ ror, rorb
	u61 = u5	/ rol, rolb
	u62 = u5	/ asr, asrb
	u63 = u5	/ asl, aslb
	u64 = u7	/ mark, mtps
	u67 = u5	/ sxt, mfps

	0:	u60;	u61;	u62;	u63;	u64;	u65;	u66;	u67

	u66:	/ simulate mtp[id] with mov (sp)+,dd
		bic	$4000,r1	/ make mode (sp)+
		br	1f

	u65:	/ simulate mfp[id] with mov ss,-(sp)
		ash	$6,r1		/ move dd to ss
		bis	$46,r1		/ make dd -(sp)
	1:	clrb	bflg		/ 2 byte ops - bflg ends up 1.
		br	t01		/ treat as mov

	u4:	/ jsr = x04---
		mov	r1,r0
		jsr	pc,setreg	/set up dd adjust
		bis	$173000,r2	/delta(sp) = 2
		rts	pc

	t07:	/ EIS = 07----
		incb	bflg		/bflg = 1 for 2 byte op

	u0:	/ swab, jmp = x00---
	u5:	/ single operand = x05-dd
#ifdef BACK_MODE2D
		mov	r1,r0		/ (r)+ faults to
		ash	$-3,r0		/ INITIAL state
		bic	$!7,r0
		cmp	r0,$2		/ mode 2?
		bne	1f
		mov	$fixstk,pc	/ yes - fix stack
	1:
#endif
		mov	r1,r0

	/	setreg - put reg + delta into low byte of r2

	setreg:
		mov	r0,-(sp)	/ mode+reg in r0
		bic	$!7,r0
		bis	r0,r2		/put reg in r2
		mov	(sp)+,r0
		ash	$-3,r0
		bic	$!7,r0		/mode in r0
		movb	adj(r0),r0	/adjust in r0
		movb	bflg,-(sp)	/push shift count
		bne	1f		/not byte operand - skip
		bit	$2,r2		/byte operand with
		beq	3f		/sp or pc
		bit	$4,r2		/is really word op
		beq	3f		/so drop thru
	1:
		bit	$10,r0		/length dependent?
		beq	3f		/no - dont shift
	2:
		asl	r0		/delta = 2**bflg
		decb	(sp)
		bgt	2b
	3:
		tst	(sp)+		/clean stack
		bisb	r0,r2		/put delta in r2
		rts	pc

	adj:	.byte	0, 0, 10, 20, -10, -20, 0, 0

	t01:	/ mov
	t02:	/ cmp
	t03:	/ bit
	t04:	/ bic
	t05:	/ bis
	t06:	/ add
	t16:	/ sub
		incb	bflg		/bflg = 1 for 2 byte op
	t11:	/ movb
	t12:	/ cmpb
	t13:	/ bitb
	t14:	/ bicb
	t15:	/ bisb
		mov	r1,r0		/ op ss,dd
		ash	$-6,r0
		jsr	pc,setreg	/ for ss
		swab	r2
		mov	r1,r0
		jsr	pc,setreg	/ for dd

	/	r2 now has delta(ss) in hi byte and delta(dd) in low byte.
	/	Evaluate and fetch ss, zeroing delta(dd) if a fault occurs.
	/	See fetch for details of how this happens.
	/ 1.	If delta(dd) == 0 dont bother.

		bit	$370,r2
		beq	1f

	/ 2.	If mode(ss) is R, it can't have faulted.

		bit	$7000,r1
		beq	1f

	/ 3.	register(ss) == register(dd)?

		mov	r2,-(sp)
		bic	$174370,(sp)
		cmpb	1(sp),(sp)+
		bne	3f

	/ 4.	Yes, but if delta(ss) == 0 we may assume a dd fault

#ifdef REGREG
		bit	$174000,r2
		beq	1f
#endif
		mov	$u7,pc
	1:
		rts	pc
	3:

#ifdef BACK_MODE2S
	/	Try to deal with problems caused by /34 etc. faulting op (r)+,dd
	/	source to INITIAL state.

		mov	r1,r0
		bic	$!7000,r0	/r0 = mode(ss)
		cmp	$2000,r0	/ (r)+?
		beq	4f		/yes - problems
		jsr	pc,1f		/no - get r
		jsr	pc,2f		/adjust for increment
		jsr	pc,3f		/fetch it
		rts	pc		/and quit
	4:

	/	Its an op (r)+,dd. If a fetch on r fails to fault, then it was
	/	a destination fault.

		mov	r2,-(sp)	/save SSR1
		jsr	pc,1f		/get r
					/NB - no adjust
		jsr	pc,3f		/fetch it
		tstb	r2		/did it fault?
		beq	4f		/yes - try r-2
		tst	(sp)+		/no - clean up
		rts	pc		/its a dd fault
	4:

	/	Fetch on r faults. If fetch on r-2 also faults, then its an ss fault.

		mov	(sp)+,r2	/restore SSR1
		jsr	pc,1f		/get r
		jsr	pc,2f		/adjust for increment
		jsr	pc,3f		/fetch it
		tstb	r2		/did it fault?
		bne	u7		/no - failure
		ash	$-6,r1		/yes - place ss
		br	fixstk		/and fix stack
	1:
#endif

	/	Zero delta(dd) if the ss faults (see fetch).
	/	Start ss cycle by picking up the register value.

		mov	r1,r0
		ash	$-6,r0
		bic	$!7,r0		/r0 = reg no.
		movb	_regloc(r0),r0
		asl	r0
		add	ssr+2,r0
		mov	(r0),r0		/r0 = contents reg(ss)
#ifdef BACK_MODE2S
		rts	pc
	2:
#endif

	/	If register incremented, must decrement before fetch. If register
	/	decremented, happened before fetch.

		bit	$174000,r2
		ble	4f
		dec	r0
		bit	$10000,r2
		beq	4f		/delta = 1
		dec	r0		/delta = 2
	4:
#ifdef BACK_MODE2S
		rts	pc
	3:
#endif

	/	If mode 6 or 7 fetch and add X(r)

		bit	$4000,r1
		beq	4f
		bit	$2000,r1
		beq	4f
		mov	r0,-(sp)	/mode 6 or 7
		mov	ssr+4,r0	/virtual pc
		add	$2,r0
		jsr	pc,fetch	/get X
		add	(sp)+,r0	/add it in
	4:

	/	Fetch operand

		jsr	pc,fetch

	/	If mode 3, 5 or 7 fetch *.

		bit	$1000,r1
		beq	4f
		bit	$6000,r1
		bne	fetch
	4:
		rts	pc


	t17:	/ FP11 op
#ifdef CPU_HARDFP
		incb	bflg		/assume 2 bytes
		mov	r1,r0
		ash	$-7,r0
		bic	$!36,r0
		mov	0f(r0),pc	/switch on 17x(x..)--

	fp50 = u5	/ stexp is 2 bytes
	fp64 = u5	/ ldexp is 2 bytes (Check this sometime!)

	0:	fp00;	fp04;	fp10;	fp14;	fp20;	fp24;	fp30;	fp34;
		fp40;	fp44;	fp50;	fp54;	fp60;	fp64;	fp70;	fp74;

	fp00:	/ ldfps, stfps, stst + others which can't fault.
		cmp	r1,$170300	/stst?
		bhis	1f		/stst is 4 bytes (for this purpose)
		mov	$u5,pc		/ldfps, stfps are 2 bytes.

	fp54:	/ stcfi
	fp70:	/ ldcif
		stfps	r0		/if long integer mode
		bit	$100,r0
		bne	1f		/its 4 bytes
		mov	$u5,pc		/else its really 2 bytes

	fp60:	/ stcfd
	fp74:	/ ldcfd
		incb	bflg		/assume 4 bytes
		stfps	r0
		tstb	r0		/if floating double
		bmi	0f		/its really is
		br	1f		/else its 8 bytes

	fp04:	/ clrf tstf, absf, negf
	fp10:	/ mulf
	fp14:	/ modf
	fp20:	/ addf
	fp24:	/ ldf
	fp30:	/ subf
	fp34:	/ cmpf
	fp40:	/ stf
	fp44:	/ divf
		incb	bflg		/assume 4 bytes
		stfps	r0
		tstb	r0		/if not floating double
		bpl	0f		/it really is
	1:	incb	bflg		/else its 8 bytes
	0:
#ifdef BACK_FPPNOT
		br	fixstk
#else
		mov	r1,r0
		mov	$setreg,pc
#endif BACK_FIXSP
#endif CPU_HARDFP
	u1:	/br
	u2:
	u3:
	u7:	/illegal
		incb	jflg
		rts	pc

#ifdef BACK_FIXSP
	/	Operation was aborted with registers in INITIAL state, so
	/	no backup is required (why don't they all work that way?).
	/	However, "grow()" examines the sp, and grows the stack iff it
	/	points outside the valid stack. If the sp is in its INITIAL
	/	state, it will point to a valid stack address, and SIGSEG will
	/	occur. To avoid this, the sp seen by "grow()" must be adjusted
	/	to its FINAL state. The sp seen by "grow()" is kept in the
	/	external variable _backsp during the call to _backup().

		.globl _backsp

	fixstk:
		mov	r1,r0
		bic	$!7,r0
		cmp	$6,r0		/affecting sp?
		bne	3f		/no - quit
		mov	r1,r0
		ash	$-3,r0
		bic	$!7,r0		/r0 = mode
		movb	adj(r0),r0	/get adjust
		tstb	bflg		/byte op?
		bne	0f		/no - skip
		incb	bflg		/yes - on sp is word op
	0:	ash	$-3,r0		/r0 = adjust proper
		bit	$1,r0		/1 or -1
		beq	2f		/no - deferred or zero
	1:	asl	r0		/exponentiate
		decb	bflg		/bflg times
		bgt	1b
	2:	add	r0,_backsp	/adjust the saved sp
	3:	clr	r2		/no register adjust
		rts	pc
#endif

	fetch:
		bic	$1,r0
		mov	nofault,-(sp)
		mov	$1f,nofault
		mfpi	(r0)
		mov	(sp)+,r0
		mov	(sp)+,nofault
		rts	pc

	1:
		mov	(sp)+,nofault
		clrb	r2			/ clear out dest on fault
		mov	$-1,r0
		rts	pc

	.bss
	bflg:	.=.+1
	jflg:	.=.+1
	.text
#endif
