#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"

/*
 * this file contains several library routines.
 * these routines are included to overcome the
 * incompatibilities between UNIX version 6 and 7.
 * not included are the system call routines and printf.
 */

zero(area,length) char *area; {
	register char *p;
	register n;
	/*
	 * Clear area of length bytes.
	 */
	if ((n=length)==0)
		return;
	p = area;
	do *p++=0; while (--n);
}

bmove(from,to,count) char *from,*to; {
	register char *p1,*p2;
	register n;
	/*
	 * Move count bytes from from to to 
	 */
	p1 = from; p2 = to; n = count;
	do
		*p2++ = *p1++;
	while (--n);
}

int strcmp(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * String compare.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ == *s2)
		if (*s2++ == 0)
			return(0);
	return( (*--s1 < *s2) ? -1 : 1);
}

strcpy(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * Fast string copy.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ = *s2++)
		;
}

int abs(i) {
	return((i < 0) ? -i : i);
}

error(string1,a1) char *string1,*a1; {
	/*
	 * diagnostic output
	 */
	printf("%s: ",progname);
	if (curfile) {
		printf("file %s",curfile);
		if (archmode)
			printf(" (%.8s)",archhdr.ar_name);
		printf(": ");
	}
	printf("proc %s,line %d: ",curproc,file_line+line_num);
	printf(string1,a1);
	printf("\n");
	nerrors++;
}

fatal(s) char *s; {
	/*
	 * handle fatal errors
	 */
	error("Fatal error: %s",s);
	exit(-1);
}

putchar(c) char c; {
	/*
	 * only used for diagnostic output by printf
	 */
	if (write(2,&c,1) < 0)
		;
}

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int ffill(af) FILE *af; {
	register FILE *f;
	/*
	 * read in next block
	 */
	f = af;
	f->nextp = f->buff;
	return(f->nleft = read(f->fd,f->buff,512) - 1);
}

pflush(af) FILE *af; {
	register FILE *f;
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	f = af;
	if (f->nextp)
		if (write(f->fd,f->buff,f->nextp - f->buff) < 0)
			fatal("write error");
	f->nextp = f->buff;
	f->nleft = 512;
}

frewind(af) FILE *af; {
	register FILE *f;
	/*
	 * rewind a file which is being written on
	 */
	f = af;
	pflush(f);
#ifdef V7
	if ((int_cast lseek(f->fd,0L,0)) < 0)
#endif
#ifndef V7
	if (seek(f->fd,0,0) < 0)
#endif
		;
	f->nleft = 0;
	f->nextp = 0;
}

int getc(af) FILE *af; {
	register FILE *f;
	/*
	 * read next character; return -1 on eof
	 */
	f = af;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			return(-1);
	return(*(f->nextp)++ & 0377);
}

int xgetc(af) FILE *af; {
	register FILE *f;
	/*
	 * read next character; fatal if there isn't one
	 */
	f = af;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			fatal("unexpected end of file");
	return(*(f->nextp)++ & 0377);
}

int xgetw(f) FILE *f; {
	register n;
	/*
	 * two times xgetc
	 */
	n = xgetc(f);
	return(n | (xgetc(f) << 8));
}

xputc(c,af) FILE *af; {
	register FILE *f;
	/*
	 * write next character
	 */
	f = af;
	if (--f->nleft < 0) {
		pflush(f);
		--f->nleft;
	}
	*(f->nextp)++ = c;
}

xputw(w,f) FILE *f; {
	/*
	 * two times xputc
	 */
	xputc(w,f);
	xputc(w>>8,f);
}

outbyte(n) {
	xputc(n,&tfile);
	textoff++;
}

outword(n) {
	/*
	 * note reversed order of bytes.
	 * this is done for faster interpretation.
	 */
	xputc(n>>8,&tfile);
	xputc(n&0377,&tfile);
	textoff =+ 2;
}

int readbyte() {
	register FILE *f;
	/*
	 * Read one byte from ifile.
	 */
	if (libeof && inpoff >= libeof)
		fatal("Tried to read past end of arentry\n");
	inpoff++;
	f = &ifile;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			fatal("end of file on input");
	return(*(f->nextp)++ & 0377);
}

int readword() {
	register n;
	/*
	 * get a word.
	 */
	n = readbyte();
	return(n | (readbyte() << 8));
}


extbyte(b) {
	/*
	 * Handle one byte of data.
	 */
	++dataoff;
	xputc(b,&dfile);
}

extword(w) {
	/*
	 * Assemble the word constant w.
	 * NOTE: The bytes of the word are written low to high.
	 *	 Word constants in text are vice-versa
	 */
	extbyte(w);
	extbyte(w>>8);
}

setmode(mode) {

	if (datamode==mode)	/* in right mode already */
		return;
	switch(datamode) {		/* terminate current mode */
	case DATA_NUL:
		break;			/* nothing to terminate */
	case DATA_BSS:
		if(odd(lastsize))
			fatal("Odd bss");
#ifdef C6
		extword(((lastsize>>1)&077777));
			/* The C6 compiler can't handle "| 0" !!!! */
#endif
#ifndef C6
		extword(((lastsize>>1)&077777)|HEADBSS);
#endif
		datablocks++;
		break;
	case DATA_CON:
		lastheader->r_val.rel_i=((dataoff-lastoff)>>1)&017777;
		lastheader->r_typ = RELCON;
		datablocks++;
		break;
	case DATA_POINTER:
		lastheader->r_val.rel_i=((dataoff-lastoff)>>1)&017777;
		lastheader->r_typ = RELCON;
		datablocks++;
		break;
	case DATA_LONG:
		lastheader->r_val.rel_i=((dataoff-lastoff)>>2)&017777;
		lastheader->r_typ = RELCON;
		datablocks++;
		break;
	case DATA_REAL:
		lastheader->r_val.rel_i=lastsize&017777;
		lastheader->r_typ = RELCON;
		datablocks++;
		break;
	}
	datamode=mode;
	lastsize=0;
	switch(datamode) {
	case DATA_NUL:
		break;
	case DATA_BSS:
		break;
	case DATA_CON:
		lastheader=data_reloc(0,dataoff,RELHEAD);
		extword(HEADCON);
		lastoff=dataoff;
		break;
	case DATA_POINTER:
		lastheader=data_reloc(0,dataoff,RELHEAD);
		extword(HEADPOINTER);
		lastoff=dataoff;
		break;
	case DATA_LONG:
		lastheader=data_reloc(0,dataoff,RELHEAD);
		extword(HEADLONG);
		lastoff=dataoff;
		break;
	case DATA_REAL:
		lastheader=data_reloc(0,dataoff,RELHEAD);
		extword(HEADREAL);
		break;
	}
}

int tmpfil() {
	register char *fname;
	char *sfname;
	register fildes,pid;
	int count;
	/*
	 * This procedure returns a file-descriptor of a temporary
	 * file valid for reading and writing.
	 * After closing the tmpfil-descriptor the file is lost
	 * Calling this routine frees the program from generating uniqe names.
	 */
	sfname = fname = "/usr/tmp/tmp.00000";
	count = 10;
	pid = getpid();
	fname =+ 13;
	while (pid!=0) {
		*fname++ = (pid&07) + '0';
		pid =>> 3;
	}
	*fname = 0;
	do {
		fname = sfname;
		if ((fildes = creat(fname, 0600)) < 0)
			if ((fildes = creat(fname=+4, 0600)) < 0)
				if ((fildes = creat(fname=+5, 0600)) < 0)
					return(-1);
		if (close(fildes) < 0)
			;
	} while((fildes = open(fname, 2)) < 0 && count--);
	if (unlink(fname) < 0)
		;
	return(fildes);
}

#ifdef V6
atol(ap,lp) char *ap; long *lp; {
	long n1,n2;
	register int f;
	register char *p;

	p = ap;
	n1 = 0;
	f = 0;
	for(;;p++) {
		switch(*p) {
		case ' ':
		case '\t':
			continue;
		case '-':
			f++;
		case '+':
			p++;
		}
		break;
	}
	while(*p >= '0' && *p <= '9') {
		n2 = n1 + n1;
		n2 = n2 + n2 + n1;
		n1 = n2 + n2 + (*p++ - '0');
	}
	if (f)
		n1 = 0 - n1;
	*lp = n1;
}
#endif
