program woops (input,output); 
(*$w-*) 
label 9999; 
const colon = ':';  (* pad char at end of names *)
      blank = ' ';
	delstudent   = 1;
	delfamily    = 2;
	printstudent = 3;
	printfamily  = 4;
type  classr = 1..6;   (* possible class numbers *) 
      ager   = 4..14;  (* age range of kids *)
      morf = (male,female); (* sex attribute *) 
      studentptr = ^studentrec; 
      studentrec = record surname,         (* family name *)
                          givenname : alfa;(* first name  *)
                          sex : morf;      (* sex attribute *)
                          age : ager; 
                          class : classr;  (* class kid is in *)
                          nextinclass,     (* ptr to next in class *) 
                          previnclass,     (* ptr to previous in class *) 
                          nextinfamily : studentptr;
                   end;  (* studentrec *) 
var   classhead : array[classr] of studentptr; (* class head ptrs *)
      prevstudent,             (* trailing search ptr *)
      thisstudent,             (* leading search ptr *) 
      instudent : studentptr;  (* space for input info *) 
      found,                   (* true = input student was found *) 
      fail  : boolean;         (* true = last command erroneous *)
      command : packed array[1..2] of char; 
procedure initialize; 
   var aclass : classr; 
       p : studentptr;
       lowname : alfa;
       i : integer; 
begin (* set low name value for initialization *) 
      for i := 1 to 10 do lowname[i] := colon;
      (* initialize class heads *)
      for aclass := 1 to 6 do 
      begin new(p);  (* get space *)
            with p^ do (* initialize components *)
            begin surname := lowname;   givenname := lowname; 
                  class := aclass;  nextinfamily := p;
                  previnclass := p; nextinclass := p; 
                  classhead[aclass] := p; 
            end (* with p^ *) 
      end; (* for aclass *) 
      new(instudent);  (* get space for input info *) 
      fail := false;
end;  (** initialize **)
procedure report (err : integer;  fatal : boolean); 
begin fail := fatal;  (* command has failed *)
      writeln; write(' report: ');
      case err of     (* print appropriate message *) 
    1 : write('name too long.');
    3 : write('illegal sex.');
    4 : write('age out of range.'); 
    5 : write('class out of range.'); 
    6 : write('name clash.'); 
    7 : write('no such student.');
    8 : write('no such family (at this school).');
    9 : write('illegal command.');
   11 : write('name expected on command, but not found.');
   12 : write('student, with this name, already enrolled.');
      end; (* case *) 
      writeln;
      if fail then writeln(' command ignored - retype');
end;  (** report **)
procedure readname (var name : alfa); 
   var ch : char; 
       i : integer; 
       noteol : boolean;
begin (* read a name from input, and  *)
      (* replace trailing blanks with colons. *)
      ch := blank;   i := 0;
      while ch = blank do read(ch); (* skip leading blanks *) 
      noteol := not eoln; 
      while (ch in ['a'..'z']) and noteol do (* read name *)
      begin i := i + 1; 
            if i <= 10 then name[i] := ch; (* insert char *)
            if eoln then noteol := false else read(ch); 
      end;
      if i = 0 then report(11,true) (* name not found *)
      else if i > 10 then report(1,true) (* name too long *)
      else for i := i+1 to 10 do name[i] := colon; (* pad out *)
end;  (** readname **)
procedure writename (name : alfa);
   var ch : char; 
       i : integer; 
begin (* write out a name, trailing blanks inserted *)
      ch := name[1];  i := 1; 
      while (ch<>colon) and (i<10) do (* print name *)
      begin write(ch);  i:=i+1;  ch:=name[i] end; 
      if ch <> colon then write(ch) else i := i - 1;
      (* insert trailing blanks, in place of colons *)
      write(blank:11-i);
end;  (** writename **) 
(* search routines:  these routines find the given name in the
 * ===============  appropriate list (class or family).  note that
 *     the class lists are two-way and the family lists are one-way.
 *     consequently, slightly different search loops are used for the 
 *     two kinds of search.  the routines are as follows: 
 *
 *     familysearch - find the student whose surname and given name 
 *                    are the same (as that in "student").  this
 *                    involves searching the family list pointed by 
 *                    "thisstudent" for the appropriate given name. 
 *                    returns: thisstudent --> appropriate student, 
 *                             prevstudent --> student before above in
 *                                             given family list. 
 *
 *     classsearch -  find a student, whose surname matches "student"s, 
 *                    in the given class; or failing the appropriate
 *                    position (alphabetically) for insertion.
 *                    returns: thisstudent --> appropriate student, or
 *                                             one after insertion point. 
 *                             prevstudent --> one before above in class list.
 *
 *     namesearch -  find a student, whose surname matches "student"s,
 *                   anywhere in the school (i.e. in any class).
 *                   returns: thisstudent --> appropriate student,
 *                            prevstudent --> one before student above in class list. 
 *
 *     note:  all the above also return the value "true" in the global
 *     ---- "found", if the name matches. 
 *) 
procedure familysearch (var student : studentptr);
   var start : studentptr;
begin (* at this point "thisstudent" points to the correct surname *) 
      start := thisstudent;   prevstudent := start; 
      thisstudent := start^.nextinfamily; 
      found := thisstudent^.givenname = student^.givenname; 
      while (thisstudent<>start) and not found do (* search family *) 
      begin prevstudent := thisstudent; 
            thisstudent := thisstudent^.nextinfamily; 
            found := thisstudent^.givenname = student^.givenname; 
      end;
end;  (** familysearch **)
procedure classsearch (var student : studentptr;
                       class : classr); 
begin thisstudent := classhead[class]^.nextinclass; (* first in class *)
      found := thisstudent^.surname >= student^.surname;
      while (thisstudent<>classhead[class]) and not found do (* search *) 
      begin thisstudent := thisstudent^.nextinclass;
            found := thisstudent^.surname >= student^.surname;
      end;
      prevstudent := thisstudent^.previnclass;
      if found then found := student^.surname = thisstudent^.surname
end;  (** classsearch **) 
procedure namesearch (var student : studentptr);
  var class : integer;
begin class := 0; 
      repeat class := class + 1; (* search each class until found *)
             classsearch(student,class);
      until  found or (class=6);
end;  (** namesearch **)
procedure orderfamily (var student : studentptr); 
begin found := false; 
      while (student^.surname = thisstudent^.surname) and 
            not found  do (* find order in family in class *) 
      begin found := thisstudent^.givenname >= student^.givenname;
            thisstudent := thisstudent^.nextinclass;
      end;
      if found then begin thisstudent := thisstudent^.previnclass;
                          found := student^.givenname = 
                                   thisstudent^.givenname;
                    end;
      prevstudent := thisstudent^.previnclass;
end;  (** orderfamily **) 
procedure insertstudent;
   var instudent : studentptr;
       insex : alfa;
       int : integer; 
   procedure byfamily;
   begin with thisstudent^ do 
         begin instudent^.nextinfamily := nextinfamily; 
               nextinfamily := instudent; 
         end; 
   end;  (** byfamily **) 
   procedure byclass; 
   begin prevstudent^.nextinclass := instudent; 
         thisstudent^.previnclass := instudent; 
          with instudent^ do (* insert *) 
          begin nextinclass := thisstudent; 
                previnclass := prevstudent; 
          end;
   end;  (** byclass **)
begin (* body of insertstudent *) 
end;
begin
end.
