	.title	ux.sml


;***************************

.macro	$param
	r0=%0
	r1=%1
	r2=%2
	r3=%3
	r4=%4
	r5=%5
	sp=%6
	pc=%7
.endm	$param

;***************************

.macro	$indir	here
	trap	0
	.if	nb	here
	.word	here
	.endc
.endm	$indir

;***************************

.macro	$exit	status
	.if	nb	status
	.ntype	......,	status
	.if	ne	......
	mov	status,r0
	.endc
	.endc
	trap	1
.endm	$exit

;***************************

.macro	$fork
	trap	2
.endm	$fork

;***************************

.macro	$read	buffer,nbytes
	trap	3
	.if	b	buffer
	.if	b	nbytes
	.mexit
	.endc
	.endc
	.if	nb	buffer
	.word	buffer
	.iff
	.word	0
	.endc
	.if	nb	nbytes
	.word	nbytes
	.iff
	.word	0
	.endc
.endm	$read

;***************************

.macro	$write	buffer,nbytes
	trap	4
	.if	b	buffer
	.if	b	nbytes
	.mexit
	.endc
	.endc
	.if	nb	buffer
	.word	buffer
	.iff
	.word	0
	.endc
	.if	nb	nbytes
	.word	nbytes
	.iff
	.word	0
	.endc
.endm	$write

;***************************

.macro	$open	name,mode
	trap	5
	.if	b	name
	.if	b	mode
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
.endm	$open

;***************************

.macro	$close	fildes
	.if	nb	fildes
	.ntype	......,	fildes
	.if	ne	......
	mov	fildes,r0
	.endc
	.endc
	trap	6
.endm	$close

;***************************

.macro	$wait
	trap	7
.endm	$wait

;***************************

.macro	$creat	name,mode
	trap	8.
	.if	b	name
	.if	b	mode
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
.endm	$creat


;***************************

.macro	$link	name1,name2
	trap	9.
	.if	b	name1
	.if	b	name2
	.mexit
	.endc
	.endc
	.if	nb	name1
	.word	name1
	.iff
	.word	0
	.endc
	.if	nb	name2
	.word	name2
	.iff
	.word	0
	.endc
.endm	$link


;***************************

.macro	$unlink	name
	trap	10.
	.if	nb	name
	.word	name
	.endc
.endm	$unlink

;******************************

.macro	$exec	name,args
	trap	11.
	.if	b	name
	.if	b	args
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	args
	.word	args
	.iff
	.word	0
	.endc
.endm	$exec

;***************************

.macro	$chdir	string
	trap	12.
	.if	nb	string
	.word	string
	.endc
.endm	$chdir


;****************************

.macro	$time
	trap	13.
.endm	$time

;****************************

.macro	$mknod	name,mode,addr
	trap	14.
	.if	b	name
	.if	b	mode
	.if	b	addr
	.mexit
	.endc
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
	.if	nb	addr
	.word	addr
	.iff
	.word	0
	.endc
.endm	$mknod

;****************************

.macro	$chmod	name,mode
	trap	15.
	.if	b	name
	.if	b	mode
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
.endm	$chmod

;***************************

.macro	$chown	name,owner,group
	trap	16.
	.if	b	name
	.if	b	owner
	.if	b	group
	.mexit
	.endc
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	owner
	.word	owner
	.iff
	.word	0
	.if	nb	group
	.word	group
	.iff
	.word	0
	.endc
	.endc
.endm	$chown

;***************************

.macro	$break	addr
	trap	17.
	.if	nb	addr
	.word	addr
	.endc
.endm	$break

;***************************

.macro	$stat	name,buf
	trap	18.
	.if	b	name
	.if	b	buf
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	buf
	.word	buf
	.iff
	.word	0
	.endc
.endm	$stat

;***************************

.macro	$lseek	hioff,lowoff,type
	trap	19.
	.if	b	hioff
	.if	b	lowoff
	.if	b	type
	.mexit
	.endc
	.endc
	.endc
	.if	nb	hioff
	.word	hioff
	.iff
	.word	0
	.endc
	.if	nb	lowoff
	.word	lowoff
	.iff
	.word	0
	.endc
	.if	nb	type
	.word	type
	.iff
	.word	0
	.endc
.endm	$lseek

;*************************

.macro	$getpid
	trap	20.
.endm	$getpid

;******************************

.macro	$mount	special,name,rwflag
	trap	21.
	.if	b	special
	.if	b	name
	.if	b	rwflag
	.mexit
	.endc
	.endc
	.endc
	.if	nb	special
	.word	special
	.iff
	.word	0
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	rwflag
	.word	rwflag
	.iff
	.word	0
	.endc
.endm	$mount

;*****************************

.macro	$umount	special
	trap	22.
	.if	nb	special
	.word	special
	.endc
.endm	$umount

;****************************

.macro	$setuid	uid
	.if	nb	uid
	.ntype	......,	uid
	.if	ne	......
	mov	uid,r0
	.endc
	.endc
	trap	23.
.endm	$setuid

;****************************

.macro	$getuid
	trap	24.
.endm	$getuid

;***************************

.macro	$stime
	trap	25.
.endm	$stime

;*******************************

.macro	$ptrace	pid,addr,req
	trap	26.
	.if	b	pid
	.if	b	addr
	.if	b	req
	.mexit
	.endc
	.endc
	.endc
	.if	nb	pid
	.word	pid
	.iff
	.word	0
	.endc
	.if	nb	addr
	.word	addr
	.iff
	.word	0
	.endc
	.if	nb	req
	.word	req
	.iff
	.word	0
	.endc
.endm	$ptrace

;******************************

.macro	$alarm	secs
	.if	nb	secs
	.ntype	......, secs
	.if	ne	......
	mov	secs,r0
	.endc
	.endc
	trap	27.
.endm	$alarm

;******************************

.macro	$fstat	buf
	trap	28.
	.if	nb	buf
	.word	buf
	.endc
.endm	$fstat

;*****************************

.macro	$pause
	trap	29.
.endm	$pause

;*****************************

.macro	$utime	name,timep
	trap	30.
	.if	b	name
	.if	b	timep
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	timep
	.word	timep
	.iff
	.word	0
	.endc
.endm	$utime

;*****************************

.macro	$stty	arg
	trap	31.
	.if	nb	arg
	.word	arg
	.endc
.endm	$stty

;****************************

.macro	$gtty	arg
	trap	32.
	.if	nb	arg
	.word	arg
	.endc
.endm	$gtty

;*****************************
	
.macro	$access	name,mode
	trap	33.
	.if	b	name
	.if	b	mode
	.mexit
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
.endm	$access

;****************************

.macro	$nice	pri
	.if	nb	pri
	.ntype	......,	pri
	.if	ne	......
	mov	pri,r0
	.endc
	.endc
	trap	34.
.endm	$nice

;****************************

.macro	$getaddr	addr
	trap	35.
	.if	nb	addr
	.word	addr
	.endc
.endm	$getaddr

;*****************************

.macro	$sync
	trap	36.
.endm	$sync

;*****************************

.macro	$kill	signo
	trap	37.
	.if	nb	signo
	.word	signo
	.endc
.endm	$kill

;*****************************

.macro	$tlimit
	trap	38.
.endm	$tlimit

;****************************

.macro	$setpgrp
	trap	39.
.endm	$setpgrp

;****************************

;	# 40 (spare)

;****************************

.macro	$dup	oldfil
	.if	nb	oldfil
	.ntype	......,	oldfil
	.if	ne	oldfil
	mov	oldfil,r0
	.endc
	.endc
	trap	41.
.endm	$dup

;*****************************

.macro	$pipe
	trap	42.
.endm	$pipe

;*****************************

.macro	$times	buffer
	trap	43.
	.if	nb	buffer
	.word	buffer
	.endc
.endm	$times

;****************************

.macro	$profil	buff,bufsiz,offset,scale
	trap	44.
	.if	b	buff
	.if	b	bufsiz
	.if	b	offset
	.if	b	scale
	.mexit
	.endc
	.endc
	.endc
	.endc
	.if	nb	buff
	.word	buff
	.iff
	.word	0
	.endc
	.if	nb	bufsiz
	.word	bufsiz
	.iff
	.word	0
	.endc
	.if	nb	offset
	.word	offset
	.iff
	.word	0
	.endc
	.if	nb	scale
	.word	scale
	.iff
	.word	0
	.endc
.endm	$profil

;*****************************

.macro	$limits	addr,sel
	trap	45.
	.if	b	addr
	.if	b	sel
	.mexit
	.endc
	.endc
	.if	nb	addr
	.word	addr
	.iff
	.word	0
	.endc
	.if	nb	sel
	.word	sel
	.iff
	.word	0
	.endc
.endm	$limits

;*****************************

.macro	$setgid
	trap	46.
.endm	$setgid

;****************************

.macro	$getgid
	trap	47.
.endm	$getgid

;****************************

.macro	$sig	signo,label
	trap	48.
	.if	b	signo
	.if	b	label
	.mexit
	.endc
	.endc
	.if	nb	signo
	.word	signo
	.iff
	.word	0
	.endc
	.if	nb	label
	.word	label
	.iff
	.word	0
	.endc
.endm	$sig

;******************************

;	# 49 (spare)

;******************************

;	# 50 (spare)

;******************************

.macro	$acct	name
	trap	51.
	.if	nb	name
	.word	name
	.endc
.endm	$acct

;******************************

;	# 52 (spare)

;******************************

;	# 53 (spare)

;******************************

.macro	$ioctl	fildes,cmd,argp
	trap	54.
	.if	b	fildes
	.if	b	cmd
	.if	b	argp
	.mexit
	.endc
	.endc
	.endc
	.if	nb	fildes
	.word	fildes
	.iff
	.word	0
	.endc
	.if	nb	cmd
	.word	cmd
	.iff
	.word	0
	.endc
	.if	nb	argp
	.word	argp
	.iff
	.word	0
	.endc
.endm	$ioctl

;*****************************

.macro	$fcntl	cmd,arg
	trap	55.
	.if	b	cmd
	.if	b	arg
	.mexit
	.endc
	.endc
	.if	nb	cmd
	.word	cmd
	.iff
	.word	0
	.endc
	.if	nb	arg
	.word	arg
	.iff
	.word	0
	.endc
.endm	$fcntl

;*****************************

;	# 56 (spare)

;*****************************

;	# 57 (spare)

;*****************************

;	# 58 (spare)

;*****************************

.macro	$exece	name,argv,envp
	trap	59.
	.if	b	name
	.if	b	argv
	.if	b	envp
	.mexit
	.endc
	.endc
	.endc
	.if	nb	name
	.word	name
	.iff
	.word	0
	.endc
	.if	nb	argv
	.word	argv
	.iff
	.word	0
	.endc
	.if	nb	envp
	.word	envp
	.iff
	.word	0
	.endc
.endm	$exece

;****************************

.macro	$umask	cmode
	trap	60.
	.if	nb	cmode
	.word	cmode
	.endc
.endm	$umask

;****************************

.macro	$chroot	name
	trap	61.
	.if	nb	name
	.word	name
	.endc
.endm	$chroot

;****************************

.macro	$connect	mode,cchar
	trap	62.
	.if	b	mode
	.if	b	cchar
	.mexit
	.endc
	.endc
	.if	nb	mode
	.word	mode
	.iff
	.word	0
	.endc
	.if	nb	cchar
	.word	cchar
	.iff
	.word	0
	.endc
.endm	$connect

;****************************

;	# 63 (spare)
