h16177
s 00003/00001/00380
d D 1.11 80/04/08 10:05:12 bin 11 10
c Convert to run under UNIX Edition 7.
e
s 00117/00008/00264
d D 1.10 79/07/20 15:58:59 sys 10 9
c Allow user programs to have overlay capability
e
s 00003/00000/00269
d D 1.9 79/07/20 15:45:59 sys 9 8
c Notify user when psects with the same name have different characteristics.
e
s 00000/00002/00269
d D 1.8 79/07/20 15:43:01 sys 8 7
c Get rid of some unused code occupying valuable memory.
e
s 00004/00000/00267
d D 1.7 79/07/20 08:26:50 sys 7 6
c Add '_' to the radix50 character set; allow entry of upper case
c alphabetics; do better checking for illegal characters.
e
s 00004/00000/00263
d D 1.6 79/07/20 08:23:17 sys 6 5
c Fix a bug in the handling of psects and the word boundary alignment problem.
e
s 00008/00000/00255
d D 1.5 79/07/20 08:19:15 sys 5 4
c Switches for debugger (odt & fdt) inclusion.
e
s 00006/00000/00249
d D 1.4 79/07/20 08:16:12 sys 4 3
c Allow non-zero start addresses
e
s 00003/00000/00246
d D 1.3 79/07/20 08:10:59 sys 3 2
c Addition of switch to allow library specification
c and change of suffix processing.
e
s 00037/00000/00209
d D 1.2 79/07/20 08:05:56 sys 2 1
c Provide information for future modifiers of link!
e
s 00209/00000/00000
d D 1.1 79/07/20 07:51:15 sys 1 0
e
u
U
t
T
I 1
/*
 * UNIX FORTRAN/MACRO linker
 *
 * J. N. Rottman, May 1975
 * Extensions and changes, J. Day,  July 1975
I 3
 * Peter Hewitt,	77/10
 *	Addition of switch to allow library specification
 *	and change of suffix processing.
I 4
 * Peter Hewitt,	76/11
 *	Allow non-zero start addresses.
I 5
 * Peter Hewitt,	76/11
 *	Switches for odt and fdt inclusion.
I 6
 * Peter Hewitt,	77/10/20
 *	Remove bug where psects with odd numbers of bytes
 *	caused odd alignment of following psects.
 *	Also take better notice of bad format object files.
I 7
 * Craig McGregor,	77/10/20
 *	Add '_' to the radix50 character set; allow entry
 *	of upper case alphabetic; do better checking for
 *	illegal characters.
I 9
 * Craig McGregor,	79/05/03
 *	Notify user when psects with same name have different
 *	characteristics.
I 10
 * Peter Hewitt,	77/09
 * Craig McGregor,	1979
 *	Allow simple overlay facility
E 10
E 9
E 7
E 6
E 5
E 4
E 3
 */
I 11

#include <stdio.h>

E 11
#define	BINSIZ	124
#define	GOBBLE	2048

/* flag definitions */

#define	SHR	01
#define	INS	02
#define	BSS	04
#define	DEF	010
#define	REL	040
#define	OVR	020
#define	GBL	0100
#define	COM	0200
#define	EXC	0400
D 8
#define	URF	01000
E 8
#define	CMX	02000
I 10
#define	OVLY	04000		/* in overlay segment */
#define	AUTO	010000		/* has autoload vector */
E 10

I 2
/*
 * Meaning of flags:
 * SHR	shareable region (read only)
 * INS	contains instructions
 * BSS	unitialised data area
 * DEF	definition (not reference)
 * REL	relocatable (as opposed to absolute)
 * OVR	overlaid psect (not concatenated)
 * GBL	common to all overlay segments (not just the current one)
 *	*** not implemented ***
 * COM	common area: if no matching symbol, set CMX and allocate
 *	space (see ".comm" in "as")
 * EXC	'except' symbol (-e:symbol)
D 8
 * URF	*** not implemented ***
E 8
 * CMX	common area (see COM)
I 10
 * OVLY	the psect is in an overlay region; for a symbol, it is
 *	referenced with an autoload vector
 * AUTO	the entry point is through an autoload vector
 *	unless in the same segment.
E 10
 */

/*
 * Layout of linker tables:
 *
D 10
 * 1.	Linked list of "module" structures linked with "mpnt" from "modhead"
E 10
I 10
 * 1.	"nseg" linked lists of "module" structures linked
 *	with "mpnt" from the segment'th entry in (*segwk)[].segmod
E 10
 *	Each contains: name in "mname"; version i.d. in "mversion";
 *	library flag in "mislib"
D 10
 * 2.	Linked list of "psect" structures linked with "ppnt" from "psecthead"
E 10
I 10
 * 2.	"nseg" linked lists of "psect" structures linked
 *	with "ppnt" from the segment'th entry in (*segwk)[].segpsect
E 10
 *	Each contains: name in "pname"; flags in "pflags"
 * 3.	Sorted tree of "global" structures linked with "gright" and "gleft"
 *	from "globalhead"
 *	Each contains: name in "gname"; flags in "gflags"; value in "gvalue";
 *	link to defining "psectl" structure in "gpsectl"
I 10
 *	;segment number in "gsegment"
E 10
 * 4.	Linked list of "psectl" structures linked with "pll" from the "mpsl"
 *	entry in the current "module" structure
 *	Each contains: link to "psect" structure in "plp"
 * 5.	Linked list of "globall" structures linked with "gglp" from the
 *	"plg" entry in the current "psectl" structure
 *	Each contains: link to "global" structure in "glp"
 */

E 2
/* dynamic structures */

struct	global	{
	char	*gname[2];
	int	gflags;
	char	*gvalue;
	struct	global	*gright;
	struct	global	*gleft;
	char	*gpsectl;
I 10
	unsigned gsegment;	/* defining segment */
E 10
};

struct	globall	{
	struct	global	*glp;
	struct	globall	*gglp;
};

struct	psect	{
	char	*pname[2];
	int	pflags;
	char	*plimlow;
	char	*plimhigh;
	struct	psect	*ppnt;
};

struct	psectl	{
	char	*llimlow;
	char	*llimhigh;
	struct	psect	*plp;
	struct	psectl	*pll;
	struct	globall	*plg;
};

struct	module	{
	char	*mname[2];
	char	*mversion[2];
	struct	psectl	*mpsl;
	struct	module	*mpnt;
	int	mislib;
};

struct	gsdent	{
	char	*nm[2];
	char	fbyte;
	char	gtype;
	int	val;
} gsdent;

D 10
char	*txtsize;
E 10
I 10
/*
 * Head of each segment
 */
struct	segwk {
	struct module	*segmod;	/* module chain */
	struct psect	*segpsect;	/* psect chain */
	unsigned int	segreg;		/* region number */
	};

/*
 * Autoload vectors
 */
struct	link {
	int		kjsr[2];	/* jsr r5,overlayhandler */
	char		*kregadr;	/* region address */
	struct segtable	*ksegptr;	/* segment table entry */
	char		*kentry;	/* subroutine start address */
	};

/*
 * runtime segment table
 */
struct	segtable {
	unsigned int	segfadr;	/* file address (<<ROUND) */
	unsigned int	segsiz;		/* segment size */
	};

unsigned txtsize;
E 10
char	*datstart;
D 10
char	*datsize;
E 10
I 10
unsigned datsize;
char	*ovrstart;
unsigned ovrsize;
E 10
char	*bssstart;
D 10
char	*bsssize;
E 10
I 10
unsigned bsssize;
E 10


D 10
#define	SGLOB	14
E 10
I 10
#define	SGLOB	16	/* warning: only usage in "get.s" */
E 10
#define	SGLOBL	4
#define	SPSECT	12
#define	SPSL	10
#define	SMOD	14
I 10
#define	SLINK	10		/* sizeof link structure */
#define	SREG	2		/* sizeof region structure */
#define	SSEG	4		/* sizeof segment structure */
E 10
#define	NIL	0


char	libuse[512];		/*number of library modules */
char	*libpnt;

/* module information */

struct	psectl	*pcorres[256];
struct	module	*curmod	;
struct	psectl	*cursec	;

/* list heads */

D 10
struct	module	*modhead	;
E 10
I 10
struct segwk	(*segwk)[];	/* [nseg] */
struct psect	*psecte;
struct psect	**psectq;
E 10
struct	psect	*psecthead	;
struct	psect	*psecttail	;
struct	global	*globalhead	;
I 10
struct link	(*autotab)[];	/* autoload vector table */
char		*(*psrtable)[];	/* region address table */
struct segtable	(*psstable)[];	/* runtime segment table */
struct globall	*autolist;	/* list of auto-load entry-points */
E 10

/* memory management */

char	*memlow;
char	*memhigh;

/* file stuff */

D 11
int	fout;			/*formatted output */
E 11
int	crfile;			/* global crossref descriptor */
int	errcnt	;

struct	buf	{
	int	fildes;	
	int	nonused;
	char	*nxtfree;
	char	buff[512];
};
int	filec;
char	**filev;

/* switch word and definitions */

int	flags	;
int	bytflg;
char	*mapyes;
char	*objyes;
char	*fortlib;
char	*firstfile;
char	*crefstr;

#define	LS	01
#define	NO	02
#define	P1	04
#define	NS	010
#define	GO	020
#define CR	040
#define	ID	0100
#define	NL	0200
#define	WR	0400
I 5
#define	OD	02000
I 10
#define	OV	01000
E 10
E 5

/* module types */

#define	GSD	01
#define	ESD	02
#define	TXT	03
#define	RLD	04
#define	ISD	05
#define	EMOD	06
#define	LMOD	07
#define	PSD	017
#define	SDR	022
#define	EDR	021


/* gsd types */

#define	MDN	0
#define	CSN	1
#define	ISN	2
#define	TRA	3
#define	GSN	4
#define	PSN	5
#define	PVI	6


struct	buf	objbuf;
int	wfile;
int	bcount;
char	binbuf[BINSIZ];
char	*bpoint;

/*	pass2 - produce UNIX load image from object files.
 */
I 4

char	*tradrs;		/* transfer address */
struct module	*trmod;
struct psect	*trpsect;
I 5

char	*odadrs;		/* odt address */
struct module	*odmod;
struct psect	*odpsect;
int	odtyes;			/* set when "/lib/odt.obj" is open */
E 5
E 4

int	objout;			/* file token*/
int	load_addr;		/* load address from TXT block */
int	rldcount;		/* number of bytes in TXT */
int	text_act;		/* flag that text buffer is full */
struct	psectl	*act_sec;	/* pointer to section where load is active */
int symovr;			/* symbol table has overflowed */

D 10
struct	module	*whmod;
E 10
I 10
struct module	*reroot;		/* ready to continue root segment */
E 10
char	rldbuf[BINSIZ];
int	symcount;



/* the following code is dedicated to harvard */

int	oprbuf[100];
struct	control	{
	struct	psectl	*consec;
	int	conloc;
	int	cnm[2];
} control;

struct	clcsym	{
	int	raw[2];
	int	symval;
} clcsym;

#define	CCOPR	040
#define	CCNAM	020
#define	CCSEC	010
#define	CCVAL	04
#define	CCDSP	02
#define	RBYTE	0200

I 10

/*
 * overlay information
 */

int	pass;		/* true if pass #2 */
unsigned region;	/* current region number */
unsigned segment;	/* current segment number */
int	odf;		/* overlay descriptor file filedescriptor */
char	peekc;		/* last character read from odf */
unsigned odfno;		/* position of odf in files list */
			/* must be 1st file in list!! */

unsigned nreg;		/* number of regions excluding root */
unsigned nseg;		/* number of segments excluding root */
unsigned nauto;		/* number of subroutines excluding root */
struct link	(*auttadr)[];	/* final core address of overlay tables */
struct segtable	(*segtadr)[];	/* final core address of segment table */
unsigned nsym;		/* number of global symbols - updated by getglo */
unsigned msym;		/* number of symbol positions to skip for overlays */

/*
 * The size of the load file is limited by the fact that an offset
 * from the start of the file to an overlay is stored in 1 word: this
 * gives a maximum unsigned offset of 177777 so that the absolute
 * maximum file size is
 *	177777 + 100000(largest possible overlay segment) = 277777.
 * This problem is overcome by rounding segment addresses up to a
 * 2**ROUND byte boundary and then dividing the offset by 2**ROUND:
 *	ROUND		Maximum		All segments rounded
 *	value		file size	to n byte boundary
 *			(octal bytes)	   where n =
 *	-----		-------------	--------------------
 *	  0		  277777		 1  (unsigned addressing)
 *	  1		  277776		 2
 *	  2		  477774		 4
 *	  3		 1077770		 8
 *	  4		 2077760		16
 *	  5		 4077740		32
 *
 * Because the offset is signed if the ROUND > 0, the maximum offset
 * becomes only 077777 which is why some of the maximum file sizes
 * seem a little small.
 */

#define	ROUND	2
#define	ROUNDX	((1<<ROUND)-1)	/* rounding factor for chunks */
unsigned flast;		/* last byte in file (force it out) */

/*
 * Overlay handler etc.
 */
extern char	ovscode[];	/* overlay shared */
extern unsigned	ovslcode;	/* size of " */
extern char	ovpcode[];	/* overlay private */
extern unsigned	ovplcode;	/* size of " */
extern char	*ovlink;	/* $load entry point */
E 10
E 1
