#include "const.h"

overflow(x,y)
long	x,y;
/*
 *	Overflow takes two long integers and returns value true if their sum
 *	would overflow a long location. If they can be summed without
 *	overflow, value false is returned.
 */
{
	long	tmp;

	tmp = (x & SET16) + (y & SET16);	/* low - order part */

	x = (x >> 16) & SET16;			/* shift high order part */
	y = (y >> 16) & SET16;

	if( tmp > SET16 )	x++;		/* carry from low order part */

	return( (x + y) > SET16 );
}

extern	int	cond[];

long	adder(x,y,addop)
long	x,y;
char	addop;
/*
 *	Cases 0-15 are the operations with carries between bytes.
 *	Cases 16-31 are the same operations with carries inhibited.
 */
{
	long	adout,part;
	int	i;

	switch(addop)
	{
	case 17:
	case 1:
		y = ~y;					/* nor	*/
	case 18:
	case 2:
		x = ~x;					/* nri	*/
	case 27:
	case 11:
		return( x & y );			/* and	*/
	case 3:
		y++;					/* x+y+1 */
	case 0:
		if( overflow(x,y) )	AOV = 1;	/* x+y	*/
		return( x + y );
	case 20:
	case 4:
		y = ~y;					/* nan	*/
	case 24:
	case 8:
		x = ~x;					/* imp	*/
	case 30:
	case 14:
		return( x | y );			/* or	*/
	case 5:
		if( overflow(x,x | y) )	AOV = 1;	/* oad	*/
		return( x + (x | y) );
	case 22:
	case 6:
		return( x ^ y );			/* xor	*/
	case 23:
	case 7:
		return( x & ~y );			/* nim	*/
	case 25:
	case 9:
		return( ~(x ^ y) );			/* eqv	*/
	case 10:
		if( overflow(x,x & y) )	AOV = 1;	/* aad	*/
		return( x + (x & y) );
	case 29:
	case 13:
		return( x | ~y );			/* rim	*/
	case 12:
		y++;					/* x-y-1 */
	case 15:
		if( overflow(x,-y) )	AOV = 1;	/* x-y	*/
		return( x - y );
	case 19:
		y++;					/* x+y+1 */
	case 16:
		break;					/* x+y	*/
	case 21:
		y |= x;					/* oad	*/
		break;
	case 26:
		y &= x;					/* aad	*/
		break;
	case 28:
		y = ~y;
		break;
	case 31:
		y = (~y) + 1;				/* x-y	*/
	}
	adout = 0;

	for( i=0 ; i<4 ; i++ )
	{
		adout |= ( ( (x + y) & 0377 ) << (8 * i) );
		x >>= 8;
		y >>= 8;
	}
	return(adout);
}
