	.psect	.text.,con,shr
	.nlist	ttm
	.title	mcexec
	.ident	/d06/
;
;	unix implementation of dec macro-11
;		jonathan day
;		july    1975
;
	.macro	.page.
	.page
	.endm
	.macro	generm	messag
	.asciz	\messag\
	.endm
	.macro	prter	diag
	jsr	r5,error
	.word	diag
	.endm
mcexec=	0
;status bits
sb.ile=	001		;invalid line error
sb.cse=	002		;check sum error
sb.pfe=	004		;parity format error
sb.dpe=	040		;device parity error
sb.eof=	100		;eof
sb.eom=	100		;eom
;
; error messages
;
	.psect	dpure,prv,con
outm1:	generm	^\i/o error on output file\
outm2:	generm	^\too many output files\
outm3:	generm	^\switch syntax error\
inpm2:	generm	^\input file missing\
csim4:	generm	^\illegal switch\
csim5:	generm	^\open failure on output file\
csim6:	generm	^\open failure on input file\
cmlm2:	generm	^\command i/o error\
asmm1:	generm	^\insufficient memory to complete assembly\
	.even
	.psect	.text.,con,shr
	.page.
	.sbttl	table formats for the unix implementation
	.sbttl	-argtbl used to hold arguments & switches
	.sbttl	-filtbl	used to control file accesses
;
;
;
; (1) the table 'argtbl' consists of entries in the following
;     form:
;
;     'upnlen' bytes - unix path name for file
;     'swclen' bytes - concatenated switches (e.g. -ds:gbl-li:me)
;
;     entries in the table are accessed through the 'file' entry
;     for a channel - i.e. files[srcchn] is a pointer to the source
;     entry in the argtbl
;
;
; (2) the table 'filtbl' consists of entries in the following form:
;
;     'upnlen' bytes - path name
;        2     bytes - file descriptor
;        2     bytes - flags
;				1 = read access (u.read)
;				2 = write access (u.write)
;				4 = end of file (u.eof)
;
; (3) 'upnlen' is the maximum length of a unix path name
;     'swclen' is the maximum length of the concatenated switches
;     'morsrc' points to the next source file in the argtbl
;     'protct' is the protection given to all output files
;     'swit'   is what you wish to use for a switch (-,%,etc.)
;              warning - beware of the shell when selecting a
;              switch indicator!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	.page.
	.macro	procsi	file			; process file switches
	mov	#file'fil,r0
	call	procsi
	.endm	procsi
	.macro	findev	from,to		;fin devices
	jsr	r5,findev
	.if nb	<from>
	.byte	from'chn
	.iff
	.byte	0
	.endc
	.if nb	<to>
	.byte	to'chn
	.iff
	.byte	maxchn
	.endc
	.endm	findev
	.psect	mixed,prv,con
spsav:	.blkw	1
	.psect	.text.,con,shr
	.page.
; macro to perform unix-style 'indirect' sys calls
	.macro	sys	operator,arg1,arg2,arg3,arg4,arg5
	.nlist
	.if	nb arg1
	.list
	mov	arg1,syscb+2
	.nlist
	.endc
	.if	nb arg2
	.list
	mov	arg2,syscb+4
	.nlist
	.endc
	.if	nb arg3
	.list
	mov	arg3,syscb+6
	.nlist
	.endc
	.if	nb arg4
	.list
	mov	arg4,syscb+10
	.nlist
	.endc
	.if	nb arg5
	.list
	mov	arg5,syscb+12
	.nlist
	.endc
	.list
	mov	#operator,syscb
	indir.
	 +	syscb		; do the call
	.endm	sys
	.page.
; the unix sys calls defined
	.macro	$$$sys
	.macro	$$$def	name,operator
	.nlist
	.iif gt operator-377,.error	<bad 'sys' call format>
	.list
	name'.	=	104400+operator
	.endm	$$$def
	$$$def	break,17.
	$$$def	creat,8.
	$$$def	csw,38.
	$$$def	chdir,12.
	$$$def	chmod,15.
	$$$def	chmod,16.
	$$$def	close,6.
	$$$def	dup,41.
	$$$def	exec,11.
	$$$def	exit,1.
	$$$def	fork,2.
	$$$def	fstat,28.
	$$$def	getgid,47.
	$$$def	getuid,24.
	$$$def	gtty,32.
	$$$def	indir,0.
	$$$def	kill,37.
	$$$def	link,9.
	$$$def	mknod,14.
	$$$def	mount,21.
	$$$def	nice,34.
	$$$def	open,5.
	$$$def	pipe,42.
	$$$def	profil,44.
	$$$def	read,3.
	$$$def	seek,19.
	$$$def	setgid,46.
	$$$def	setuid,23.
	$$$def	signal,48.
	$$$def	sleep,35.
	$$$def	stat,18.
	$$$def	stime,25.
	$$$def	stty,31.
	$$$def	sync,36.
	$$$def	time,13.
	$$$def	times,43.
	$$$def	umount,22.
	$$$def	unlink,10.
	$$$def	wait,7.
	$$$def	write,4.
	.endm	$$$sys
	$$$sys				; define the calls
	.page.
	.sbttl		start of program
	.sbttl		-pick up unix arguments and switches
	.sbttl		-set up core, the stack, and the symbol table
	.sbttl		-zero the lnktbl (means no inited channels)
	.sbttl		-init 'cmo' for diagnostic messages
	.globl	cont,fin
start::
	mov	(sp)+,r3		;argument count
	dec	r3			;we dont care about
	bgt	1$			;is there really something to do?
	sys	exit.			;no - auf wiedersehn
1$:
	tst	(sp)+			;first argument
	mov	#argtbl,r1
loop:	mov	(sp)+,r0		;get next argument
	cmpb	(r0),#swit		;switch?
	beq	dosw			;yes, handle it
	mov	r1,lastfp
	mov	r1,r4			;no, file
	mov	#upnlen,r5		;max pathname length
	clr	casflg				;no upper case here
	jsr	pc,coparg		;stash the file name
	mov	r1,r2
	add	#upnlen+swclen,r1	;point to next file
	add	#swclen,r2
	inc	filcnt			;say 	$init	cmo
	br	next
;handle switches
dosw:
	tst	filcnt			;any files seen yet?
	bne	doswx			;yes - no problem
	prter	outm3			;that's a no-no!
doswx:
	mov	r2,r4
	mov	#swclen,r5
	mov	#1,casflg			;xlate to upper case
	jsr	pc,coparg
	mov	r4,r2
	br	next
;save switches or file names in a buffer
coparg:
	mov	#upnlen,r5
	mov	r4,-(sp)
	mov	r5,-(sp)
1$:	clrb	(r4)+
	sob	r5,1$
	mov	(sp)+,r5
	mov	(sp)+,r4
	mov	r3,-(sp)			;save r3 (temp)
coptst:	movb	(r0)+,r3			;pick up character
	tst	casflg				;translate?
	beq	copmov				;nope
	cmp	r3,#141				;lowercase 'a' = 141
	blo	copmov				;uppercase - leave alone
	sub	#40,r3				;make uppercase!
copmov:	movb	r3,(r4)+			;finally, save character
	tstb	(r0)
	beq	3$
	sob	r5,coptst
3$:
	mov	(sp)+,r3			;restore temp register
	rts	pc
next:
	dec	r3
	ble	noloop
	jmp	loop
noloop:
	mov	sp,spsav
	$init	cmo
	mov	#cmolnk,r0
	mov	#1,unxfd(r0)
	mov	#u.write,unxmod(r0)
	dec	filcnt
	.if	ndf	fixstk
	mov	sp,syttop
	.iff
	mov	#symbue,syttop
	.endc
	.page.
	.sbttl	re-enter point
cont::				;restart address
	cmp	filcnt,#1		;was there anything to do?
	bgt	cont1			;yep
	sys	exit.		 ;that was an easy assembly!
cont1:
	mov	filcnt,filsav		;make a second copy!
	mov	spsav,sp
	mov	sp,stksav
	call	assem		;set up symbol table
	mov	stksav,sp	;set stack
	mov	#ctltbl,r0	;set for master loop
2$:	mov	(r0)+,r1	;fetch next address
	mov	r0,-(sp)	;stack pointer
	call	(r1)		;call the routine
	mov	(sp)+,r0	;retrieve pointer
	br	2$		;loop 'till control is
				;taken away
	.psect	dpure,prv,con
ctltbl:				;table to associate assembler
				;and exec
;		exec	assembler
;		----	---------
	.word	iniof,	macp0	;output file processing
	.word	inip1,	macp1	;pass one
	.word	finp1,	endp1	;clean up
	.word	inip2,	macp2	;pass 2
	.word	finp2,	endp2
	.word	setdn		;finished, control not returned
	.psect	.text.,con,shr
	.page.
	.sbttl	output file initialization
iniof:
	procsi	obj		;process object first
	tst	r0
	bne	11$		;branch if empty
	mov	#dotobj,defext
	$init	rel
	mov	#dotobj,defext
	$init	bin
11$:
	procsi	lst	 ;file name
	tst	r0
	bne	23$		;  branch if null
	mov	#dotlst,defext
	$init	lst
23$:	return
inip1:
	mov	#lstchn,r0
	call	openo		;open listing file
inip2:
	mov	#srcfil,morsrc			;point to first file!
	mov	filsav,filcnt			;restore file counter!
	return
	.page.
	.sbttl	end of pass routines
finp1:				;finish of pass
	.if df	xbaw
	findev	src,src		;close source file
	.iff
1$:	call	getpli		;force eof
	tst	r0
	ble	1$
	.endc
	.if ndf	xrel
	mov	#relchn,r0	;assume relocatable
	.if ndf	xedabs
	bit	#ed.abs,edmask	;good guess?
	bne	3$		;  yes
	mov	#binchn,r0	;no, set for absolute
	.endc
	.iff
	mov	#binchn,r0	;set for binary
	.endc
3$:	call	openo		;open the file
	.if ndf	xcref
	tst	crflnk
	beq	5$		;  or if no cref initted
	mov	lstfil,crffil	;xfer list file name to cref file
	mov	lstfil+2,crffil+2
	mov	#crfchn,r0
	call	openo		;open cref file
	mov	#crfbuf,crfpnt	;init for cref
5$:	.endc
	return
finp2:				;end of pass 2
	.if ndf	xcref
	mov	crfpnt,r2	;any cref in progress?
	beq	5$		;  no
	call	crfdmp		;yes, dump and close buffer
9$:	.endc
	return
	.page.
	.sbttl	internal command string routines
	.sbttl	-entry: r0 = pointer to argtbl entry
	.sbttl	-exit:  r0 has status bits as follows:
	.sbttl	-	bit 0 - more to come if 0
	.sbttl	-	bit 1 - too many switches
procsi:
	cmpb	(r0),#'.			;no file desired?
	bne	docsi				;file was given
	tstb	1(r0)				;make sure only '.'
	bne	docsi
	mov	#1,r0				;return no file.
	br	procrt				;all done
docsi:
	call	savreg
	mov	r0,r1			;point to switches
	add	#upnlen,r1		;in 'argtbl' entry
	clr	r4			;say no switch seen yet
poloop:
	cmpb	(r1),#swit		;seen a switch?
	beq	doop			;yes...process
	cmpb	(r1),#':		;switch modifier?
	beq	domod			;yes - process modifier
	tstb	(r1)			;end of switches?
	beq	endsw			;yep
	prter	outm3			;'illegal switch' (no return)

doop:
	tst	r4			;already seen one switch
	bne	sendsw			;send to macro for processing
	mov	#linbuf,r2		;point to line buffer
	inc 	r1
	movb	(r1)+,linbuf		;get first switch character
	movb	(r1)+,linbuf+1		;and next switch character
	mov	linbuf,r0		;get switch (e.g. 'li' 'en')
	com	r4			;a switch has been seen
	br	poloop			;go try again...

sendsw:
	clrb	(r2)			;terminator flag
	call	prosw			;ask for switch processing
	bne	endsw1			; no error
	prter	csim4			;illegal switch
endsw1:
	clr	r4			;all done with this switch
	br	poloop

domod:
	mov	#linbuf,r2		;set up for unpacking
2$:	inc	r1			;get next character
	movb	#space,(r2)+		;unpack a space
3$:	cmpb	(r1),#':			;new modifier?
	beq	2$			;yep
	cmpb	(r1),#swit		;new switch?
	beq	doop			;yep
	tstb	(r1)			;end of switches?
	beq	sendsw			;yes.
	movb	(r1)+,(r2)+		;no specials, so stack the byte
	br	3$
endsw:
	tst	r4
	bne	sendsw
	clr	r0			; no errors were seen
procrt:
	return				; back to caller.....
	.psect	.text.,con,shr
openo:				;open an output file
	call	savreg
	bit	#io.nnu,ioftbl(r0)			;inited yet?
	beq	opnrtn					;nope
	mov	lnktbl(r0),r1	;point to file data
	cmpb	(r1),#'.		;want standard output
	bne	2$
	cmpb	1(r1),#'.		;check
	bne	2$
	cmpb	2(r1),#'.		;very
	bne	2$
	tstb	3(r1)			;carefully
	bne	2$
	mov	#1,r0			;standard output!
	br	1$			;bypass create
2$:	sys	creat.,r1,#protct	; try to create the file!
	bcc	1$			; no go
	prter	csim5			; 'output open errors'
1$:	mov	r0,unxfd(r1)		; save the file descriptor
	mov	#u.write,unxmod(r1)	; say write allowed.
opnrtn:
	return				; for future reference
	.page.
	.page.
	.sbttl	memory management
	.psect	enddat,gbl,bss	;this is the end of the data segment
dathgh::	.blkw
	.psect	.text.,shr,con	;back to text segment
	.globl	dathgh
tststk::			;test stack for overflow
	cmp	sp,#dathgh+100			;about to hit data seg?
	blo	2$		;  error
	return			;no error
	.if ndf	fixstk
	cmp	(sp),frecor	;ok, new record for low?
	bhis	1$		;  no
	mov	(sp),frecor	;yes, register it
	.iftf
1$:	tst	(sp)+		;remove work
	return
2$:	prter	asmm1		;no more memory
	.iff
tstsyt::				;test symtab overflow
	mov	rolbas,-(sp)	;current base of symtab
	sub	#symbuf+20.,(sp)	;bottom of table
	blo	2$
	cmp	(sp),frecor	;ok, new record for low?
	bhis	1$		;  no
	mov	(sp),frecor	;yes, register it
1$:	tst	(sp)+		;remove work
	return
2$:	prter	asmm1		;no more memory
	.iftf
	.psect	mixed,prv,con
stksav:	.blkw			;initial stack storage
monpnt:	.blkw			;pointer to top of monitor
	.ift
syttop==stksav			;top of symbol table
	.iff
syttop::	.blkw			;pntr to top of table
	.psect	symbuf,prv,con
symbuf:	.blkw	8000.
symbue:
	.endc
	.psect	impure,prv,con
frecor::.blkw			;core remaining
slot:	.blkw			;see 'read' code
				;byte read in dos i/o mode goes hwe
ckslot:	.blkw			;checksum goes here!
	.psect	.text.,con,shr
	.page.
getpli::			; get a line of input from the program
	bit	#io.nnu,ioftbl+srcchn		; inited yet?
	beq	3$		; no - do so
	$readw	src		; read some of his program
	clr	r0
	bit	#io.eof,ioftbl+srcchn	;eof on source ???
	beq	5$
	findev	src,src		; all done with this file
	mov	#1,r0
3$:	dec	filcnt
	beq	5$
	mov	r0,-(sp)		;protect r0 from getsrc
	call 	getsrc
	mov	(sp)+,r0
	mov	#-1,r0
5$:	return
	.psect	imppas,prv,gbl,con
getflg::	.blkw	1
	.psect	.text.,con,shr
	.page.
	.sbttl	source file handlers
getsrc:				;get the next source file
	call	savreg
	mov	morsrc,filtbl+srcchn
	add	#upnlen+swclen,morsrc
1$:	procsi	src		;process the source file
	.if ndf	xswit
	dec	passsw		;any pass switch?
	bmi	2$		;  no
	cmp	passsw,pass	;yes, this pass?
	bne	1$		;  no, ignore file
2$:	.endc
	ror	r0
	$init	src		;init it
	.if ndf	xbaw
	tst	srcfil+4	;explicit extension?
	bne	4$		;  yes, use it
	mov	#r50mac,r2	;no, try ".mac" and ".pal"
3$:	mov	#3$,srcfil-4
	mov	(r2)+,srcfil+4	;move in next default
	bne	5$		;branch if non-null
4$:	mov	#6$,srcfil-4	;no more errors allowed
5$:	.endc
	mov	#srclnk,r0
	sys	open.,r0,#0
	bcc	6$
	mov	#dotm,r1
	mov	#srclnk,r0
	jsr	pc,extend			;try with '.m'
	sys	open.,r0,#0			;reopen file
	bcc	6$				;with new extension
	prter	csim6				;still no go-you lose!
6$:	mov	#srclnk,r1
	mov	r0,unxfd(r1)
	return
	.if ndf	xbaw
	.psect	dpure,prv,con
r50mac:	.rad50	/mac/
r50pal:	.rad50	/pal/
	.rad50	/   /		;terminator
	.endc
	.psect	dpure,prv,con
	.enabl	lc
	.enabl	lc
dotm:	.asciz	/.m/
dotobj:	.asciz	/.obj/
dotlst:	.asciz	/.lst/
	.even
defext:	.blkw
lastfp:	.blkw
	.psect	.text.,shr,con
extend:	mov	r0,-(sp)
	mov	r1,-(sp)
1$:	tstb	(r0)+
	beq	2$
	cmpb	-1(r0),#'.
	bne	1$
2$:	dec	r0
3$:	movb	(r1)+,(r0)+
	bne	3$
	mov	(sp)+,r1
	mov	(sp)+,r0
	rts	pc
	.if ndf	xswit
	.psect	.text.,con,shr
passsp::call	absexp			;/pass, evaluate number
	mov	r0,passsw	;store result
	return
	.psect	impure,prv,con
passsw:	.blkw			;pass switch
	.psect	.text.,con,shr
	.endc
	.page.
	.sbttl	system macro handlers
	.if ndf	xsml
	.enabl	lsb		;following routines inter-related
inisml::			;init sml file
	tst	smllnk		;initted?
	bne	1$		;  yes
	.init	#smllnk		;no, do so
	clr	smlfil+6	;look locally first
	br	3$
1$:	tst	smlfil+6	;initted, last area local?
	bne	finsml		;  no, we're through
	.close	#smllnk		;yes, close it out
2$:	mov	#sysuic,smlfil+6	;point to system area
3$:	.open	#smllnk,#smlfil	;open 'er up
	mov	sp,r0		;flag good (non-zero) return
	return
finsml::			;close out sml file
	tst	smllnk		;initted?
	beq	12$		;  no, just exit
	.close	#smllnk		;yes, close it
11$:	.rlse	#smllnk		;  and release it
12$:	clr	r0		;signal that we're through
	return
smlerr:				;lookup error return
	tst	smlfil+6	;first try (local)?
	beq	2$		;  yes, try system area
	br	11$		;no, release and exit
	.dsabl	lsb
	.psect	mixed,prv,con
	.word	smlerr
	.byte	4,0
smlfil:	.rad50	/sysmac/
	.rad50	/sml/
	.word	0,0
	.psect	.text.,con,shr
	.endc			;xsml
	.page.
	.sbttl	cross reference handlers
	.if ndf	xcref
crfset::			;cref switch processor
	tst	cmdbuf		;input side?
	beq	8$		;  yes, error
	clr	r3
1$:	call	gsarg		;try for argument
	beq	5$		;  finished
	mov	#crftbl,r1	;set for arg scan
2$:	cmp	(r1)+,r0	;found?
	beq	3$		;  yes
	tst	(r1)		;no, end of list?
	bne	2$		;  no, cycle
8$:	prter	csim4		;illegal switch
	beq	5$		;  not there, error
3$:	sub	#crftbl+2,r1	;compute offset
	beq	4$		;special if "ng"
	bis	r1,r3		;ok, set offset
	br	1$
4$:	inc	crfngf		;set "no-go" flag
	br	1$
5$:	tst	r3		;any args?
	bne	6$		;  yes
	mov	#^c10,r3	;  no, all but "p"
6$:	mov	r3,crfflg	;save flag
	$init	crf		;init the file
	return
	.psect	dpure,prv,con
crftbl:
	.rad50	/ng/
	.irpc	x,smpce
	.rad50	/x/
	.endm
	.word	0
	.psect	.text.,con,shr
	.page.
crftst::			;test for room and store byte
	cmp	#crfbuf+crflen-12,r2	;room to store a few?
	bhi	1$		;  yes
	call	crfdmp		;no, dump current
	mov	#crfbuf,r2	;start new line
1$:	movb	r1,(r2)+	;store the byte
	return
crfdmp:				;dump cref buffer
	movb	#vt,(r2)+	;set end
	sub	buftbl+crfchn,r2	;compute length
	mov	r2,@cnttbl+crfchn	;set the count
	$writw	crf
	clr	crfpnt		;  and close
	return
	.psect	impure,prv,con
crfflg::.blkw
crfpnt::.blkw
crfngf::.blkw			;no-go flag
	.psect	.text.,con,shr
	.if ndf	xrun
	.psect	mixed,prv,con
runblk::.word	^b0100000000010011
	.word	runfil
	.word	runlnk
	.word	2
	.word	0
runlnk:	.word	0
	.rad50	/run/
	.word	1
	.rad50	/sy/
	.word	0
	.word	4
runfil:	.rad50	/cref  /
	.rad50	/   /
	.byte	0,0
	.word	0
	.endc			;xrun
	.psect	.text.,con,shr
	.endc			;xcref
	.page.
	.sbttl	init/read/write et cetera
$init:
	bis	#io.nnu,ioftbl(r0)
	mov	r1,-(sp)
	mov	r2,-(sp)
	mov	filtbl(r0),r1
	mov	lnktbl(r0),r0
	mov	#upnlen,r2
	tst	defext					;possible default?
	beq	1$					;no
	cmpb	(r1),#'.				;want default?
	bne	1$					;no
	cmpb	1(r1),#'.				;sure?
	bne	1$					;no
	tstb	2(r1)
	bne	1$					;no default for him
	mov	lastfp,r1
	mov	r0,-(sp)
99$:	movb	(r1)+,(r0)+
	sob	r2,99$
	mov	(sp)+,r0
	mov	defext,r1
	jsr	pc,extend
	br	100$
1$:	movb	(r1)+,(r0)+
	sob	r2,1$
100$:
	mov	(sp)+,r2
	mov	(sp)+,r1
	return
$write::
$writw::
	bis	#io.out,ioftbl(r0)
$read::
$readw::
	call	savreg				;save all registers
	mov	r5,-(sp)			;also save r5
	mov	r0,r2				;get channel index
	mov	lnktbl(r2),r1			;get systbl entry
	mov	unxfd(r1),r5			;whence comes file descr
	mov	buftbl(r2),r3			;get set to simulate
	mov	cnttbl(r2),r1			;a (yecchh) dos i/o call
	movb	ioltbl(r2),-4(r1)
	movb	ioltbl+1(r2),-2(r1)			;store mode
	bit	#io.out,ioftbl(r2)		;input or output?
	bne	writx				;go write
	mov	-4(r1),r1			;this is max count
	clr	r4				;our 'actual byte count'
readx:
	mov	r5,r0				;grab a file descriptor
	jsr	pc,gchar
	bcs	3$				;i/o error"
	tst	r0				;anything come in??
	beq	4$				;nope - means eof
	inc	r4				;another character in
	movb	slot,(r3)+			;no, so stuff character
	cmpb	slot,#12			;<nl>?????
	beq	3$				;yep. good show.
	cmpb	slot,#14			;fofmfeed == linefeed
	beq	3$
	sob	r1,readx			;nope, keep stuffin'
	bis	#io.err,ioftbl(r2)		;line too long.
	br	ioexit				;make a quick exit
4$:	bis	#io.eof,ioftbl(r2)		;that's all folks
	br	ioexit				;finished return
3$:	mov	r4,@cnttbl(r2)			;say how many we got
	bic	#io.eof!io.err,ioftbl(r2)	;no problems
	br	ioexit				;and leave now

writx:
	mov	r0,-(sp)			;first do funny formatted
	mov	r1,-(sp)			;binary output!
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	buftbl(r2),r1			;point to line buffer
	cmpb	-4(r1),#1			;formatted binary?
	bne	normal
	cmp	-(r1),-(r1)			;point to header
	add	#4,2(r1)			;adjust byte count
	mov	r5,r0				;do output
	sys	write.,r1,#4.			;output header data
	bcs	wterr				;error?
	sub	#4,2(r1)			;reduce count
	mov	@cnttbl(r2),r0			;pick up byte count
	add	#4,r0				;adjust for header output
	clr	r2				;checksum holder
	clr	r3
ckloop:	movb	(r1)+,r3			;grab a byte
	bic	#177400,r3			;clear garbage
	add	r3,r2				;add into checksum
	sob	r0,ckloop			;over and over again!
	add	#4,r2				;for byte count
	neg	r2				;make = to 2's complement
	bic	#177400,r2
	mov	r2,ckslot			;stash it away
normal:
	mov	(sp)+,r3			;restore
	mov	(sp)+,r2			;those
	mov	(sp)+,r1			;scratch
	mov	(sp)+,r0			;registers
	mov	r5,r0				;snag file descriptor
	sys	write.,buftbl(r2),@cnttbl(r2)	;that was easy.
	bcs	wterr				;output error
	mov	buftbl(r2),r0			;error?
	cmpb	-4(r0),#1			;formatted binary?
	bne	wtexit
	mov	r5,r0
	sys	write.,#ckslot,#2		;put out the checksum
	bcs	wterr				;error
	br	wtexit
wterr:	prter	outm1				;catchall output error
wtexit:
ioexit:	bic	#io.out,ioftbl(r2)		;clear output flag
	mov	(sp)+,r5			;unsave r5
	return					;return, unsave regs
$wait::
	return
gchar:
	cmp	iopnt,ioend			;buffered inputter
	blos	okchar
	sys	read.,#buffer,#512.		;read some characters
	bcs	erread
	tst	r0				;any come in?
	beq	eofread				;no - error
	mov	#buffer,iopnt			;say how many read
	mov	#buffer-1,ioend			;end of buffer
	add	r0,ioend			;+ character count
	br	gchar				;try for another!

erread:
	sec					;indicate error
	return

eofread:
	clr	r0				;indicate eof
	return

okchar:
	movb	@iopnt,slot			;save the character
	inc	iopnt				;point to the next one
	clc					;twas no error
	return					;all done
	.page.
findev::			;close devices
	movb	(r5)+,r1	;from
	movb	(r5)+,r2	;to
1$:	mov	lnktbl(r1),r0	;get pointer to link block
	tst	r0		;zero?
	beq	2$		;  yes, not initted
	clr	unxmod(r0)
	mov	unxfd(r0),r0
	sys	close.
2$:	clr	ioftbl(r1)	;clear device table
	add	#2,r1		;move up
	cmp	r1,r2		;finished?
	blo	1$		;  no
	rts	r5		;yes, exit
;+
; error processor
;
;	called using jsr r5,error with in-line parameter
;	pointing to error message address
;-
error:	mov	(r5)+,r0	;get address of message
	call	putkb		;and print it
	tst	(sp)+
	sys	exit.		;all done
	.page.
	.sbttl	messages
	.nlist	bex
	.psect	mixed,prv,con
hdrttl::
	.ascii	/JHU\ASM (MACRO) 6.05/
	.asciz	/ /
	.even
	.psect	.text.,con,shr
	.list	bex
	.page.
	.sbttl	i/o tables
	.list	meb
	.psect	dpure,prv,con
iopnt:	.word	buffer
ioend:	.word	0
buffer:	.=.+512.				;block i/o buffer
casflg:	.word	0				;flag for upper/lowe case
lnktbl:
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.word	zlnk'lnk
	.endm
	genchn
filtbl:
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.if nb	<zext>
	.word	zlnk'fil
	.iff
	.word	0
	.endc
	.endm
	genchn
	.if ndf	xbaw
exttbl:
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.if nb	<zext>
	.rad50	/zext/
	.iff
	.word	0
	.endc
	.endm
	genchn
	.endc
	.page.
				;i/o flags
io.nnu=000001			;non-null device
io.tty==000002			;device is tty
io.eof=000004			;eof seen
io.err==000010			;error encountered
io.opn=000020			;open flag
io$eof==io.eof
io.out=100000			;output device
	.psect	impure,prv,con
ioftbl::.blkw	maxchn/2	;i/o flag table
	.psect	dpure,prv,con
ioltbl:				;i/o length table
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.list
	.byte	zbuf'len,ztype
	.nlist
	.endm
	genchn
	.page.
cnttbl::			;pointer to counts
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.list
	.word	zbuf'buf-2
	.nlist
	.endm
	genchn
buftbl::			;pointers to buffers
	.macro	setchn	zchan,zlnk,zbuf,ztype,zlb,zfb,zext
	.list
	.word	zbuf'buf
	.nlist
	.endm
	genchn
	.page.
.sbttl	the systbl & argtbl for files and switches
systbl::
	.irp	p,<lst,obj,src,cmo>
p'lnk:	.blkb	upnlen+4
	.endr
argtbl::
	.irp	p,<lst,obj,src>
p'fil:	.blkb	upnlen+swclen
	.endr
	.rept	10			; allow for more files
	.blkb	upnlen+swclen
	.endr
	.irp	p,<src,lst,obj,rld>
p'buf:	.blkw	<p'len+1>/2
	.endr
morsrc:	.word	srcfil
syscb:	.blkw	10
filcnt:	.word	0
filsav:	.word	0				;save area for file count
	.end
